/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.nexrad2;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import ucar.nc2.iosp.nexrad2.Level2VolumeScan;
import ucar.nc2.util.TableParser;

public class NexradStationDB {
    private static boolean showStations = false;
    private static Map<String, Station> stationTableHash = null;
    private static Map<String, Station> stationTableHash1 = null;

    public static synchronized void init() throws IOException {
        if (stationTableHash == null) {
            NexradStationDB.readStationTableXML();
        }
    }

    public static Station get(String id) {
        return stationTableHash.get(id);
    }

    public static Station getByIdNumber(String idn) {
        return stationTableHash1.get(idn);
    }

    private static void readStationTableXML() throws IOException {
        Document doc;
        stationTableHash = new HashMap<String, Station>();
        stationTableHash1 = new HashMap<String, Station>();
        ClassLoader cl = Level2VolumeScan.class.getClassLoader();
        InputStream is = cl.getResourceAsStream("resources/nj22/tables/nexradstns.xml");
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setExpandEntities(false);
        try {
            doc = saxBuilder.build(is);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        Element root = doc.getRootElement();
        List<Element> children = root.getChildren("station");
        for (int i = 0; i < children.size(); ++i) {
            Element sElem = children.get(i);
            String idn = sElem.getAttributeValue("idn");
            String id = sElem.getAttributeValue("id");
            String name = sElem.getAttributeValue("name");
            String st = sElem.getAttributeValue("st");
            String co = sElem.getAttributeValue("co");
            String lat = sElem.getAttributeValue("lat");
            String lon = sElem.getAttributeValue("lon");
            String elev = sElem.getAttributeValue("elev");
            Station s2 = new Station();
            s2.id = "K" + id;
            s2.name = name + "," + st + "," + co;
            s2.lat = NexradStationDB.parseDegree(lat);
            s2.lon = NexradStationDB.parseDegree(lon);
            s2.elev = Double.parseDouble(elev);
            stationTableHash.put(s2.id, s2);
            stationTableHash1.put(idn, s2);
            if (!showStations) continue;
            System.out.println(" station= " + s2);
        }
    }

    private static double parseDegree(String s2) {
        StringTokenizer stoke = new StringTokenizer(s2, ":");
        String degS = stoke.nextToken();
        String minS = stoke.nextToken();
        String secS = stoke.nextToken();
        try {
            double deg = Double.parseDouble(degS);
            double min2 = Double.parseDouble(minS);
            double sec = Double.parseDouble(secS);
            if (deg < 0.0) {
                return deg - min2 / 60.0 - sec / 3600.0;
            }
            return deg + min2 / 60.0 + sec / 3600.0;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    private static void readStationTable() throws IOException {
        stationTableHash = new HashMap<String, Station>();
        ClassLoader cl = Level2VolumeScan.class.getClassLoader();
        InputStream is = cl.getResourceAsStream("resources/nj22/tables/nexrad.tbl");
        List<TableParser.Record> recs = TableParser.readTable(is, "3,15,46, 54,60d,67d,73d", 50000);
        for (TableParser.Record record : recs) {
            Station s2 = new Station();
            s2.id = "K" + record.get(0);
            s2.name = record.get(2) + " " + record.get(3);
            s2.lat = (Double)record.get(4) * 0.01;
            s2.lon = (Double)record.get(5) * 0.01;
            s2.elev = (Double)record.get(6);
            stationTableHash.put(s2.id, s2);
            if (!showStations) continue;
            System.out.println(" station= " + s2);
        }
    }

    public static class Station {
        public String id;
        public String name;
        public double lat;
        public double lon;
        public double elev;

        public String toString() {
            return this.id + " <" + this.name + ">   " + this.lat + " " + this.lon + " " + this.elev;
        }
    }
}

