/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.grid.GridHorizCoordSys;
import ucar.nc2.iosp.grid.GridIndex;
import ucar.nc2.iosp.grid.GridRecord;
import ucar.nc2.iosp.grid.GridVariable;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.unidata.io.RandomAccessFile;

public abstract class GridServiceProvider
extends AbstractIOServiceProvider {
    protected static IndexExtendMode indexFileModeOnOpen = IndexExtendMode.rewrite;
    protected static IndexExtendMode indexFileModeOnSync = IndexExtendMode.extendwrite;
    protected static boolean addLatLon = false;
    protected static boolean forceNewIndex = false;
    protected static boolean alwaysInCache = false;
    public static boolean debugOpen = false;
    public static boolean debugMissing = false;
    public static boolean debugMissingDetails = false;
    public static boolean debugProj = false;
    public static boolean debugTiming = false;
    public static boolean debugVert = false;

    public static void forceNewIndex(boolean b) {
        forceNewIndex = b;
    }

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugOpen = debugFlag.isSet("Grid/open");
        debugMissing = debugFlag.isSet("Grid/missing");
        debugMissingDetails = debugFlag.isSet("Grid/missingDetails");
        debugProj = debugFlag.isSet("Grid/projection");
        debugVert = debugFlag.isSet("Grid/vertical");
        debugTiming = debugFlag.isSet("Grid/timing");
    }

    public static void setIndexFileModeOnOpen(IndexExtendMode mode) {
        indexFileModeOnOpen = mode;
    }

    public static void setIndexFileModeOnSync(IndexExtendMode mode) {
        indexFileModeOnSync = mode;
    }

    public static void setExtendIndex(boolean b) {
        indexFileModeOnOpen = b ? IndexExtendMode.extendwrite : IndexExtendMode.readonly;
        indexFileModeOnSync = b ? IndexExtendMode.extendwrite : IndexExtendMode.readonly;
    }

    public static void setIndexAlwaysInCache(boolean b) {
        alwaysInCache = b;
    }

    protected abstract void open(GridIndex var1, CancelTask var2) throws IOException;

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        long start = System.currentTimeMillis();
        Array dataArray = Array.factory(DataType.FLOAT, section.getShape());
        GridVariable pv = (GridVariable)v2.getSPobject();
        int rangeIdx = 0;
        Range ensRange = pv.hasEnsemble() ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range timeRange = section.getRank() > 2 ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range levRange = pv.hasVert() ? section.getRange(rangeIdx++) : new Range(0, 0);
        Range yRange = section.getRange(rangeIdx++);
        Range xRange = section.getRange(rangeIdx);
        IndexIterator ii = dataArray.getIndexIterator();
        for (int ensIdx = ensRange.first(); ensIdx <= ensRange.last(); ensIdx += ensRange.stride()) {
            for (int timeIdx = timeRange.first(); timeIdx <= timeRange.last(); timeIdx += timeRange.stride()) {
                for (int levelIdx = levRange.first(); levelIdx <= levRange.last(); levelIdx += levRange.stride()) {
                    this.readXY(v2, ensIdx, timeIdx, levelIdx, yRange, xRange, ii);
                }
            }
        }
        if (debugTiming) {
            long took = System.currentTimeMillis() - start;
            System.out.println("  read data took=" + took + " msec ");
        }
        return dataArray;
    }

    private void readXY(Variable v2, int ensIdx, int timeIdx, int levIdx, Range yRange, Range xRange, IndexIterator ii) throws IOException, InvalidRangeException {
        GridVariable pv = (GridVariable)v2.getSPobject();
        GridHorizCoordSys hsys = pv.getHorizCoordSys();
        int nx = hsys.getNx();
        GridRecord record = pv.findRecord(ensIdx, timeIdx, levIdx);
        if (record == null) {
            Attribute att = v2.findAttribute("missing_value");
            float missing_value = att == null ? -9999.0f : att.getNumericValue().floatValue();
            int xyCount = yRange.length() * xRange.length();
            for (int j = 0; j < xyCount; ++j) {
                ii.setFloatNext(missing_value);
            }
            return;
        }
        float[] data = this._readData(record);
        if (data == null) {
            this._readData(record);
            return;
        }
        for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
            for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                int index = y * nx + x;
                ii.setFloatNext(data[index]);
            }
        }
    }

    public boolean isMissingXY(Variable v2, int timeIdx, int ensIdx, int levIdx) throws InvalidRangeException {
        GridVariable pv = (GridVariable)v2.getSPobject();
        if (timeIdx < 0 || timeIdx >= pv.getNTimes()) {
            throw new InvalidRangeException("timeIdx=" + timeIdx);
        }
        if (levIdx < 0 || levIdx >= pv.getVertNlevels()) {
            throw new InvalidRangeException("levIdx=" + levIdx);
        }
        if (ensIdx < 0 || ensIdx >= pv.getNEnsembles()) {
            throw new InvalidRangeException("ensIdx=" + ensIdx);
        }
        return null == pv.findRecord(ensIdx, timeIdx, levIdx);
    }

    protected abstract float[] _readData(GridRecord var1) throws IOException;

    public static enum IndexExtendMode {
        rewrite,
        extendwrite,
        readonly;

    }
}

