/*
 * Decompiled with CFR 0.152.
 */
package opendap.servlet;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import opendap.servlet.AbstractServlet;
import ucar.httpservices.HTTPUtil;
import ucar.unidata.util.StringUtil2;

public class ReqState {
    private static final String defaultSchemaName = "opendap-0.0.0.xsd";
    private static final String testdatasetspath = "/resources/testdatasets";
    private String defaultDDXcache;
    private String defaultDDScache;
    private String defaultDAScache;
    private String defaultINFOcache;
    private String defaultSchemaLocation;
    private String dataSetName;
    private String requestSuffix;
    private String CE;
    private Object obj;
    private String serverClassName;
    private String requestURL;
    private ServletConfig myServletConfig = null;
    private ServletContext myServletContext = null;
    private HttpServletRequest myHttpRequest;
    private HttpServletResponse response;
    private String rootpath;

    public ReqState(HttpServletRequest myRequest, HttpServletResponse response, String dataPath, String encodedurl, String encodedquery) {
        this.myHttpRequest = myRequest;
        this.response = response;
        this.dataSetName = dataPath;
        this.requestURL = encodedurl;
        this.CE = encodedquery != null ? encodedquery : "";
        int pos = dataPath.lastIndexOf(".");
        if (pos > 0) {
            int len = dataPath.length();
            this.requestSuffix = dataPath.substring(pos + 1, len);
            this.dataSetName = dataPath.substring(0, pos);
        } else {
            this.requestSuffix = "";
            this.dataSetName = dataPath;
        }
    }

    public ReqState(AbstractServlet sv, HttpServletRequest myRequest, HttpServletResponse response, String rootPath2, String encodedurl, String encodedquery) {
        this.myServletConfig = sv.getServletConfig();
        this.myServletContext = sv.getServletContext();
        this.myHttpRequest = myRequest;
        this.response = response;
        this.rootpath = StringUtil2.replace(rootPath2, "\\", "/");
        this.serverClassName = this.serverClassName;
        this.CE = encodedquery;
        if (this.CE == null) {
            this.CE = "";
        }
        this.processDodsURL();
        AbstractServlet.log.debug("datasetname=|" + this.dataSetName + "|");
        this.defaultDDXcache = this.rootpath + testdatasetspath + "/ddx";
        this.defaultDDScache = this.rootpath + testdatasetspath + "/dds";
        this.defaultDAScache = this.rootpath + testdatasetspath + "/das";
        this.defaultINFOcache = this.rootpath + testdatasetspath + "/info";
        StringBuffer url = this.myHttpRequest.getRequestURL();
        if (url == null || url.length() == 0) {
            AbstractServlet.log.error("ReqState: no url specified");
        } else {
            int index = url.lastIndexOf(this.myHttpRequest.getServletPath());
            if (index < 0) {
                index = url.length();
            }
            this.defaultSchemaLocation = url.substring(0, index) + "/schema/" + defaultSchemaName;
        }
        this.requestURL = encodedurl;
    }

    public String getDataSet() {
        return this.dataSetName;
    }

    public String getServerClassName() {
        return this.serverClassName;
    }

    public String getRequestSuffix() {
        return this.requestSuffix;
    }

    public String getConstraintExpression() {
        return this.CE;
    }

    public HttpServletRequest getRequest() {
        return this.myHttpRequest;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getRootPath() {
        return this.rootpath;
    }

    public String getDDXCache(String realpath) {
        return this.getCachedString(realpath, "DDXcache", this.defaultDDXcache);
    }

    public void setDefaultDDXCache(String cachedir) {
        this.defaultDDXcache = cachedir;
    }

    public String getDDSCache(String realpath) {
        return this.getCachedString(realpath, "DDScache", this.defaultDDScache);
    }

    public void setDefaultDDSCache(String cachedir) {
        this.defaultDDScache = cachedir;
    }

    public String getDASCache(String realpath) {
        return this.getCachedString(realpath, "DAScache", this.defaultDAScache);
    }

    public void setDefaultDASCache(String cachedir) {
        this.defaultDAScache = cachedir;
    }

    private String getCachedString(String realpath, String which, String dfalt) {
        String dir = this.getInitParameter(which);
        if (dir == null) {
            dir = dfalt;
        }
        dir = HTTPUtil.isAbsolutePath(dir) ? HTTPUtil.canonicalpath(dir) : HTTPUtil.relpath(dir);
        if (!(dir = HTTPUtil.canonjoin(realpath, dir)).endsWith("/")) {
            dir = dir + "/";
        }
        return dir;
    }

    public String getINFOCache(String realpath) {
        return this.getCachedString(realpath, "INFOcache", this.defaultINFOcache);
    }

    public void setDefaultINFOCache(String cachedir) {
        this.defaultINFOcache = cachedir;
    }

    public String getSchemaLocation() {
        return this.defaultSchemaLocation;
    }

    public void setDefaultSchemaLocation(String location) {
        this.defaultSchemaLocation = location;
    }

    private String prepCE(String ce) {
        if (ce == null) {
            ce = "";
        } else if (!ce.equals("")) {
            int index = ce.indexOf("%");
            if (index == -1) {
                return ce;
            }
            if (index > ce.length() - 3) {
                return null;
            }
            while (index >= 0) {
                String specChar = ce.substring(index + 1, index + 3);
                char val = (char)Byte.parseByte(specChar, 16);
                if ((index = (ce = ce.substring(0, index) + String.valueOf(val) + ce.substring(index + 3, ce.length())).indexOf("%")) <= ce.length() - 3) continue;
                return null;
            }
        }
        return ce;
    }

    protected void processDodsURL() {
        String servletpath;
        String cxtpath = HTTPUtil.canonicalpath(this.myHttpRequest.getContextPath());
        if (cxtpath != null && cxtpath.length() == 0) {
            cxtpath = null;
        }
        if (cxtpath == null) {
            cxtpath = "/";
        }
        if ((servletpath = HTTPUtil.canonicalpath(this.myHttpRequest.getServletPath())) != null && servletpath.length() == 0) {
            servletpath = null;
        }
        this.dataSetName = HTTPUtil.canonicalpath(this.myHttpRequest.getPathInfo());
        if (this.dataSetName != null && this.dataSetName.length() == 0) {
            this.dataSetName = null;
        }
        if (this.dataSetName == null) {
            if (servletpath != null) {
                this.dataSetName = cxtpath != null && servletpath.startsWith(cxtpath) ? servletpath.substring(cxtpath.length()) : servletpath;
            }
        } else if (this.dataSetName.startsWith("/dodsC")) {
            this.dataSetName = this.dataSetName.substring(6);
        }
        this.requestSuffix = null;
        if (this.dataSetName != null) {
            String[] pieces;
            String name = this.dataSetName;
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if ((pieces = name.split("/")).length == 0 || pieces[0].length() == 0) {
                this.requestSuffix = "";
                this.dataSetName = name;
            } else {
                String endOPath = pieces[pieces.length - 1];
                int index = endOPath.lastIndexOf(46);
                if (index > 0) {
                    this.requestSuffix = endOPath.substring(index + 1);
                    this.dataSetName = this.dataSetName.substring(1, this.dataSetName.lastIndexOf(46));
                } else {
                    this.requestSuffix = "";
                    this.dataSetName = name;
                }
            }
        }
    }

    public boolean getAcceptsCompressed() {
        boolean isTiny = false;
        String encoding = this.myHttpRequest.getHeader("Accept-Encoding");
        isTiny = encoding != null ? encoding.contains("deflate") : false;
        return isTiny;
    }

    public String getInitParameter(String name) {
        return this.myServletConfig.getInitParameter(name);
    }

    public String getDodsBlobURL_OLDANDBUSTED() {
        int lastDot = this.requestURL.lastIndexOf(46);
        String blobURL = this.requestURL.substring(0, lastDot) + ".blob";
        if (!this.CE.equals("")) {
            blobURL = blobURL + "?" + this.CE;
        }
        return blobURL;
    }

    public Object getUserObject() {
        return this.obj;
    }

    public void setUserObject(Object userObj) {
        this.obj = userObj;
    }

    public String toString() {
        StringBuilder ts = new StringBuilder();
        ts.append("ReqState:\n");
        ts.append("  serverClassName:    '");
        ts.append(this.serverClassName);
        ts.append("'\n");
        ts.append("  dataSet:            '");
        ts.append(this.dataSetName);
        ts.append("'\n");
        ts.append("  requestSuffix:      '");
        ts.append(this.requestSuffix);
        ts.append("'\n");
        ts.append("  CE:                 '");
        ts.append(this.CE);
        ts.append("'\n");
        ts.append("  compressOK:          ");
        ts.append(this.getAcceptsCompressed());
        ts.append("\n");
        ts.append("  InitParameters:\n");
        return ts.toString();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.requestURL);
    }
}

