/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.coord.GribRecordStats;
import ucar.nc2.util.Misc;

@Immutable
public class SparseArray<T> {
    private static final Logger logger = LoggerFactory.getLogger(SparseArray.class);
    private final int[] shape;
    private final int[] stride;
    private final int totalSize;
    private final int[] track;
    private final List<T> content;
    private final int ndups;

    public SparseArray(int[] shape, int[] track, List<T> content, int ndups) {
        this.shape = shape;
        this.totalSize = SparseArray.calcTotalSize(shape);
        this.stride = SparseArray.calcStrides(shape);
        this.track = track;
        this.content = Collections.unmodifiableList(content);
        this.ndups = ndups;
        if (track.length != this.totalSize) {
            throw new IllegalStateException("track len " + track.length + " != totalSize " + this.totalSize);
        }
    }

    static int calcTotalSize(int[] shape) {
        int total = 1;
        for (int aSize : shape) {
            total *= aSize;
        }
        return total;
    }

    private static int[] calcStrides(int[] shape) {
        int[] strides = new int[shape.length];
        int product = 1;
        for (int ii = shape.length - 1; ii >= 0; --ii) {
            int thisDim = shape[ii];
            strides[ii] = product;
            product *= thisDim;
        }
        return strides;
    }

    public int calcIndex(int ... index) {
        assert (index.length == this.shape.length);
        int result = 0;
        for (int ii = 0; ii < index.length; ++ii) {
            result += index[ii] * this.stride[ii];
        }
        return result;
    }

    public T getContent(int idx) {
        int contentIdx;
        if (idx >= this.track.length || idx < 0) {
            logger.error("BAD index get=" + idx + " max= " + this.track.length, new Throwable());
        }
        if ((contentIdx = this.track[idx] - 1) < 0) {
            return null;
        }
        return this.content.get(contentIdx);
    }

    public T getContent(int[] index) {
        int where = this.calcIndex(index);
        return this.getContent(where);
    }

    public int[] getShape() {
        return (int[])this.shape.clone();
    }

    public int getRank() {
        return this.shape.length;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int[] getTrack() {
        return this.track;
    }

    public int getTrack(int idx) {
        return this.track[idx];
    }

    public List<T> getContent() {
        return this.content;
    }

    public int countNotMissing() {
        int result = 0;
        for (int idx : this.track) {
            if (idx <= 0) continue;
            ++result;
        }
        return result;
    }

    public int countMissing() {
        int result = 0;
        for (int idx : this.track) {
            if (idx != 0) continue;
            ++result;
        }
        return result;
    }

    public float getDensity() {
        return (float)this.countNotMissing() / (float)this.totalSize;
    }

    public int getNdups() {
        return this.ndups;
    }

    public void showInfo(Formatter info, GribRecordStats all) {
        info.format("SparseArray shape=[%s] ", Misc.showInts(this.shape));
        info.format("ndups=%d, missing/total=%d/%d, density=%f%n", this.ndups, this.countMissing(), this.totalSize, Float.valueOf(this.getDensity()));
        if (all != null) {
            all.dups += this.ndups;
            all.recordsUnique += this.countNotMissing();
            all.recordsTotal += this.totalSize;
            ++all.vars;
        }
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        for (int s : this.shape) {
            if (s == 1) continue;
            sizes.add(s);
        }
        info.format("%n", new Object[0]);
        this.showMissingRecurse(0, sizes, info);
    }

    private int showMissingRecurse(int offset, List<Integer> sizes, Formatter f) {
        if (sizes.size() == 0) {
            return 0;
        }
        if (sizes.size() == 1) {
            int len = sizes.get(0);
            for (int i = 0; i < len; ++i) {
                boolean hasRecord;
                boolean bl = hasRecord = this.track[offset + i] > 0;
                if (hasRecord) {
                    f.format("X", new Object[0]);
                    continue;
                }
                f.format("-", new Object[0]);
            }
            f.format("%n", new Object[0]);
            return len;
        }
        int total = 0;
        int len = sizes.get(0);
        for (int i = 0; i < len; ++i) {
            int count = this.showMissingRecurse(offset, sizes.subList(1, sizes.size()), f);
            offset += count;
            total += count;
        }
        f.format("%n", new Object[0]);
        return total;
    }

    public void showContent(Formatter f) {
        int count = 0;
        f.format("Content%n", new Object[0]);
        for (T record : this.content) {
            f.format(" %d %s %n", count++, record);
        }
    }

    public void showTracks(Formatter f) {
        int count = 0;
        f.format("Track%n", new Object[0]);
        for (int t : this.track) {
            f.format(" %4d %5d %n", count++, t);
        }
    }

    public static class Builder<T> {
        private int[] shape;
        private int[] stride;
        private int totalSize;
        private int ndups = 0;
        private int[] track;
        private List<T> content;

        public Builder(int ... shape) {
            this.shape = shape;
            this.totalSize = SparseArray.calcTotalSize(shape);
            this.stride = SparseArray.calcStrides(shape);
            this.track = new int[this.totalSize];
            this.content = new ArrayList<T>(this.totalSize);
        }

        public void add(T thing, Formatter info, int ... index) {
            this.content.add(thing);
            int where = this.calcIndex(index);
            if (where < 0 || where >= this.track.length) {
                logger.error("BAD index add=" + Misc.showInts(index), new Throwable());
            }
            if (this.track[where] > 0) {
                ++this.ndups;
                if (info != null) {
                    info.format(" duplicate %s%n     with %s%n%n", thing, this.content.get(this.track[where] - 1));
                }
            }
            this.track[where] = this.content.size();
        }

        public int calcIndex(int ... index) {
            assert (index.length == this.shape.length);
            int result = 0;
            for (int ii = 0; ii < index.length; ++ii) {
                result += index[ii] * this.stride[ii];
            }
            return result;
        }

        public void setTrack(int[] track) {
            this.track = track;
        }

        public void setContent(List<T> content) {
            this.content = content;
        }

        public int getTotalSize() {
            return this.totalSize;
        }

        SparseArray<T> finish() {
            return new SparseArray<T>(this.shape, this.track, this.content, this.ndups);
        }
    }
}

