/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import ucar.httpservices.HTTPAuthUtil;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethodStream;
import ucar.httpservices.HTTPSession;
import ucar.httpservices.HTTPUtil;

@NotThreadSafe
public class HTTPMethod
implements Closeable,
Comparable<HTTPMethod> {
    static final boolean DEBUG = false;
    public static boolean TESTING = false;
    public static Executor MOCKEXECUTOR = null;
    protected HTTPSession session = null;
    protected boolean localsession = false;
    protected URI methodurl = null;
    protected String userinfo = null;
    protected HttpEntity content = null;
    protected HTTPSession.Methods methodkind = null;
    protected HTTPMethodStream methodstream = null;
    protected HttpRequestBase lastrequest = null;
    protected HttpResponse lastresponse = null;
    protected long[] range = null;
    protected boolean closed = false;
    protected boolean executed = false;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected Map<HTTPSession.Prop, Object> settings = null;
    protected RequestConfig debugconfig = null;

    protected HTTPMethod() throws HTTPException {
    }

    HTTPMethod(HTTPSession.Methods m, String url) throws HTTPException {
        this(m, null, url);
    }

    HTTPMethod(HTTPSession.Methods m, HTTPSession session) throws HTTPException {
        this(m, session, null);
    }

    HTTPMethod(HTTPSession.Methods m, HTTPSession session, String url) throws HTTPException {
        if (HTTPSession.TESTING) {
            TESTING = true;
        }
        if ((url = HTTPUtil.nullify(url)) == null && session != null) {
            url = session.getSessionURI();
        }
        if (url == null) {
            throw new HTTPException("HTTPMethod: cannot find usable url");
        }
        try {
            this.methodurl = HTTPUtil.parseToURI(url);
        }
        catch (URISyntaxException mue) {
            throw new HTTPException("Malformed URL: " + url, mue);
        }
        if (session == null) {
            session = HTTPFactory.newSession(url);
            this.localsession = true;
        }
        this.session = session;
        this.userinfo = HTTPUtil.nullify(this.methodurl.getUserInfo());
        if (this.userinfo != null) {
            if (!TESTING) {
                this.methodurl = HTTPUtil.uriExclude(this.methodurl, HTTPUtil.URIPart.USERINFO);
            }
            this.session.setCredentials(new UsernamePasswordCredentials(this.userinfo));
        }
        this.session.addMethod(this);
        this.methodkind = m;
    }

    @Override
    public int compareTo(HTTPMethod o) {
        if (o == this) {
            return 0;
        }
        if (o == null) {
            return -1;
        }
        return this.hashCode() - o.hashCode();
    }

    protected void setcontent(RequestBuilder rb) {
        switch (this.methodkind) {
            case Put: {
                if (this.content == null) break;
                rb.setEntity(this.content);
                break;
            }
            case Post: {
                if (this.content == null) break;
                rb.setEntity(this.content);
                break;
            }
        }
        this.content = null;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.methodstream != null) {
            try {
                this.methodstream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.methodstream = null;
        }
        if (this.lastresponse != null) {
            HttpClientUtils.closeQuietly(this.lastresponse);
            this.lastresponse = null;
        }
        if (this.session != null) {
            this.session.removeMethod(this);
            if (this.localsession) {
                this.session.close();
                this.session = null;
            }
        }
        this.lastrequest = null;
    }

    public int execute() throws HTTPException {
        HttpResponse res = this.executeRaw();
        if (res != null) {
            return res.getStatusLine().getStatusCode();
        }
        throw new HTTPException("HTTPMethod.execute: null response");
    }

    public HttpResponse executeRaw() throws HTTPException {
        if (this.closed) {
            throw new IllegalStateException("HTTPMethod: attempt to execute closed method");
        }
        if (this.executed) {
            throw new IllegalStateException("HTTPMethod: attempt to re-execute method");
        }
        this.executed = true;
        if (this.methodurl == null) {
            throw new HTTPException("HTTPMethod: no url specified");
        }
        if (!this.localsession && !this.sessionCompatible(this.methodurl)) {
            throw new HTTPException("HTTPMethod: session incompatible url: " + this.methodurl);
        }
        this.settings = this.session.mergedSettings();
        try {
            if (this.range != null) {
                this.headers.put("Range", "bytes=" + this.range[0] + "-" + this.range[1]);
                this.range = null;
            }
            RequestBuilder rb = this.getRequestBuilder();
            this.setcontent(rb);
            this.setheaders(rb, this.headers);
            this.lastrequest = this.buildRequest(rb, this.settings);
            AuthScope methodscope = HTTPAuthUtil.uriToAuthScope(this.methodurl);
            AuthScope target = HTTPAuthUtil.authscopeUpgrade(this.session.getSessionScope(), methodscope);
            HttpHost targethost = HTTPAuthUtil.authscopeToHost(target);
            HttpClientBuilder cb = HttpClients.custom();
            this.configClient(cb, this.settings);
            this.session.setAuthenticationAndProxy(cb);
            CloseableHttpClient httpclient = cb.build();
            if (MOCKEXECUTOR != null) {
                URI uri = this.lastrequest.getURI();
                this.lastresponse = MOCKEXECUTOR.execute(this.lastrequest);
            } else {
                this.lastresponse = httpclient.execute(targethost, (HttpRequest)this.lastrequest, (HttpContext)this.session.getContext());
            }
            if (this.lastresponse == null) {
                throw new HTTPException("HTTPMethod.execute: Response was null");
            }
            return this.lastresponse;
        }
        catch (IOException ioe) {
            throw new HTTPException(ioe);
        }
    }

    protected RequestConfig buildRequestConfig(Map<HTTPSession.Prop, Object> settings) throws HTTPException {
        RequestConfig.Builder rcb = RequestConfig.custom();
        for (HTTPSession.Prop key : settings.keySet()) {
            boolean tf;
            Object value = settings.get((Object)key);
            boolean bl = tf = value instanceof Boolean ? (Boolean)value : false;
            if (key == HTTPSession.Prop.ALLOW_CIRCULAR_REDIRECTS) {
                rcb.setCircularRedirectsAllowed(tf);
                continue;
            }
            if (key == HTTPSession.Prop.HANDLE_REDIRECTS) {
                rcb.setRedirectsEnabled(tf);
                rcb.setRelativeRedirectsAllowed(tf);
                continue;
            }
            if (key == HTTPSession.Prop.MAX_REDIRECTS) {
                rcb.setMaxRedirects((Integer)value);
                continue;
            }
            if (key == HTTPSession.Prop.SO_TIMEOUT) {
                rcb.setSocketTimeout((Integer)value);
                continue;
            }
            if (key == HTTPSession.Prop.CONN_TIMEOUT) {
                rcb.setConnectTimeout((Integer)value);
                continue;
            }
            if (key != HTTPSession.Prop.CONN_REQ_TIMEOUT) continue;
            rcb.setConnectionRequestTimeout((Integer)value);
        }
        RequestConfig cfg = rcb.build();
        if (TESTING) {
            this.debugconfig = cfg;
        }
        return cfg;
    }

    protected void configClient(HttpClientBuilder cb, Map<HTTPSession.Prop, Object> settings) throws HTTPException {
        cb.useSystemProperties();
        String agent = (String)settings.get((Object)HTTPSession.Prop.USER_AGENT);
        if (agent != null) {
            cb.setUserAgent(agent);
        }
        HTTPSession.setInterceptors(cb);
        this.session.setContentDecoderRegistry(cb);
        this.session.setClientManager(cb, this);
        this.session.setRetryHandler(cb);
    }

    protected void setheaders(RequestBuilder rb, Map<String, String> headers) {
        if (headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                rb.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    protected RequestBuilder getRequestBuilder() throws HTTPException {
        if (this.methodurl == null) {
            throw new HTTPException("Null url");
        }
        RequestBuilder rb = null;
        switch (this.methodkind) {
            case Put: {
                rb = RequestBuilder.put();
                break;
            }
            case Post: {
                rb = RequestBuilder.post();
                break;
            }
            case Head: {
                rb = RequestBuilder.head();
                break;
            }
            case Options: {
                rb = RequestBuilder.options();
                break;
            }
            default: {
                rb = RequestBuilder.get();
            }
        }
        rb.setUri(this.methodurl);
        return rb;
    }

    protected HttpRequestBase buildRequest(RequestBuilder rb, Map<HTTPSession.Prop, Object> settings) throws HTTPException {
        RequestConfig config = this.buildRequestConfig(settings);
        rb.setConfig(config);
        HttpRequestBase req = (HttpRequestBase)rb.build();
        if (req == null) {
            throw new HTTPException("HTTPMethod.buildrequest: requestbuilder failed");
        }
        return req;
    }

    public String getMethodKind() {
        return this.methodkind.name();
    }

    public int getStatusCode() {
        return this.lastresponse == null ? 0 : this.lastresponse.getStatusLine().getStatusCode();
    }

    public String getStatusLine() {
        return this.lastresponse == null ? null : this.lastresponse.getStatusLine().toString();
    }

    public String getRequestLine() {
        throw new UnsupportedOperationException("getrequestline not implemented");
    }

    public String getPath() {
        return this.methodurl.toString();
    }

    public boolean canHoldContent() {
        return this.methodkind == HTTPSession.Methods.Head;
    }

    public InputStream getResponseBodyAsStream() {
        return this.getResponseAsStream();
    }

    public InputStream getResponseAsStream() {
        if (this.closed) {
            throw new IllegalStateException("HTTPMethod: method is closed");
        }
        if (!this.executed) {
            throw new IllegalStateException("HTTPMethod: method has not been executed");
        }
        if (this.methodstream != null) {
            HTTPSession.log.warn("HTTPRequest.getResponseBodyAsStream: Getting method stream multiple times");
        } else {
            HTTPMethodStream stream = null;
            try {
                if (this.lastresponse == null) {
                    return null;
                }
                stream = new HTTPMethodStream(this.lastresponse.getEntity().getContent(), this);
            }
            catch (Exception e) {
                stream = null;
            }
            this.methodstream = stream;
        }
        return this.methodstream;
    }

    public byte[] getResponseAsBytes(int maxbytes) {
        byte[] contents = this.getResponseAsBytes();
        if (contents != null && contents.length > maxbytes) {
            byte[] result = new byte[maxbytes];
            System.arraycopy(contents, 0, result, 0, maxbytes);
            contents = result;
        }
        return contents;
    }

    public byte[] getResponseAsBytes() {
        if (this.closed) {
            throw new IllegalStateException("HTTPMethod: method is closed");
        }
        byte[] content = null;
        if (this.lastresponse != null) {
            try {
                content = EntityUtils.toByteArray(this.lastresponse.getEntity());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return content;
    }

    public String getResponseAsString(String charset) {
        if (this.closed) {
            throw new IllegalStateException("HTTPMethod: method is closed");
        }
        String content = null;
        if (this.lastresponse != null) {
            try {
                Charset cset = Charset.forName(charset);
                content = EntityUtils.toString(this.lastresponse.getEntity(), cset);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        this.close();
        return content;
    }

    public String getResponseAsString() {
        return this.getResponseAsString("UTF-8");
    }

    public Header getRequestHeader(String name) {
        Header[] hdrs = this.getRequestHeaders();
        if (hdrs != null) {
            for (Header h : hdrs) {
                if (!h.getName().equals(name)) continue;
                return h;
            }
        }
        return null;
    }

    public Header getResponseHeader(String name) {
        try {
            return this.lastresponse == null ? null : this.lastresponse.getFirstHeader(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Header[] getResponseHeaders() {
        try {
            if (this.lastresponse == null) {
                return null;
            }
            Header[] hs = this.lastresponse.getAllHeaders();
            return hs;
        }
        catch (Exception e) {
            return null;
        }
    }

    public HTTPMethod setRequestContent(HttpEntity content) {
        this.content = content;
        return this;
    }

    public String getCharSet() {
        return "UTF-8";
    }

    public URI getURI() {
        return this.methodurl;
    }

    public String getStatusText() {
        return this.getStatusLine();
    }

    public String getResponseCharSet() {
        return "UTF-8";
    }

    public HTTPSession getSession() {
        return this.session;
    }

    public boolean isSessionLocal() {
        return this.localsession;
    }

    public boolean hasStreamOpen() {
        return this.methodstream != null;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public HTTPMethod setRange(long lo, long hi) {
        this.range = new long[]{lo, hi};
        return this;
    }

    public Header[] getRequestHeaders() {
        return this.lastrequest == null ? null : this.lastrequest.getAllHeaders();
    }

    public HTTPMethod setCompression(String compressors) {
        HTTPSession.setGlobalCompression(compressors);
        return this;
    }

    public HTTPMethod setFollowRedirects(boolean tf) {
        this.session.setFollowRedirects(tf);
        return this;
    }

    public HTTPMethod setMaxRedirects(int n) {
        this.session.setMaxRedirects(n);
        return this;
    }

    public HTTPMethod setSOTimeout(int n) {
        this.session.setSoTimeout(n);
        return this;
    }

    public HTTPMethod setUserAgent(String agent) {
        this.session.setUserAgent(agent);
        return this;
    }

    public HTTPMethod setUseSessions(boolean tf) {
        this.session.setUseSessions(tf);
        return this;
    }

    public HTTPMethod setCredentials(Credentials creds) throws HTTPException {
        this.session.setCredentials(creds);
        return this;
    }

    public HTTPMethod setCredentials(Credentials creds, AuthScope scope) throws HTTPException {
        this.session.setCredentials(creds, scope);
        return this;
    }

    protected boolean sessionCompatible(AuthScope other) {
        return HTTPAuthUtil.authscopeCompatible(this.session.getAuthScope(), other);
    }

    protected boolean sessionCompatible(URI otheruri) {
        AuthScope other = HTTPAuthUtil.uriToAuthScope(otheruri);
        return this.sessionCompatible(other);
    }

    @Deprecated
    protected boolean sessionCompatible(HttpHost otherhost) {
        AuthScope other = HTTPAuthUtil.hostToAuthScope(otherhost);
        return this.sessionCompatible(other);
    }

    public RequestConfig getDebugConfig() {
        if (!TESTING) {
            throw new UnsupportedOperationException();
        }
        return this.debugconfig;
    }

    public HttpRequestBase debugRequest() {
        if (!TESTING) {
            throw new UnsupportedOperationException();
        }
        return this.lastrequest;
    }

    public HttpResponse debugResponse() {
        if (!TESTING) {
            throw new UnsupportedOperationException();
        }
        return this.lastresponse;
    }

    @Deprecated
    public String getName() {
        return this.getMethodKind();
    }

    @Deprecated
    public HTTPMethod setMethodHeaders(List<Header> headers) throws HTTPException {
        try {
            for (Header h : headers) {
                this.headers.put(h.getName(), h.getValue());
            }
        }
        catch (Exception e) {
            throw new HTTPException(e);
        }
        return this;
    }

    @Deprecated
    public HTTPMethod setRequestHeader(String name, String value) throws HTTPException {
        return this.setRequestHeader(new BasicHeader(name, value));
    }

    @Deprecated
    protected HTTPMethod setRequestHeader(Header h) throws HTTPException {
        try {
            this.headers.put(h.getName(), h.getValue());
        }
        catch (Exception e) {
            throw new HTTPException("cause", e);
        }
        return this;
    }

    public static interface Executor {
        public HttpResponse execute(HttpRequestBase var1) throws IOException;
    }
}

