/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.RangeIterator;
import ucar.nc2.ft2.coverage.CoordAxisHelper;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordAxisBuilder;
import ucar.nc2.ft2.coverage.CoverageTransform;
import ucar.nc2.ft2.coverage.HorizCoordSys2D;
import ucar.nc2.ft2.coverage.LatLonAxis2D;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.util.Optional;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;

@Immutable
public class HorizCoordSys {
    private static final Logger logger = LoggerFactory.getLogger(HorizCoordSys.class);
    private final CoverageCoordAxis1D xaxis;
    private final CoverageCoordAxis1D yaxis;
    private final CoverageCoordAxis1D lataxis;
    private final CoverageCoordAxis1D lonaxis;
    protected final LatLonAxis2D lataxis2D;
    protected final LatLonAxis2D lonaxis2D;
    private final CoverageTransform transform;
    private final boolean isProjection;
    private final boolean hasLatLon2D;

    public static HorizCoordSys factory(CoverageCoordAxis1D xaxis, CoverageCoordAxis1D yaxis, CoverageCoordAxis lataxis, CoverageCoordAxis lonaxis, CoverageTransform transform) {
        boolean has2DlatLon;
        boolean isProjection = xaxis != null && yaxis != null && transform != null;
        boolean hasLatLon = lataxis != null && lonaxis != null;
        boolean bl = has2DlatLon = lataxis instanceof LatLonAxis2D && lonaxis instanceof LatLonAxis2D;
        if (!isProjection && !hasLatLon) {
            throw new IllegalArgumentException("must have horiz coordinates (x,y,projection or lat,lon)");
        }
        if (!isProjection && has2DlatLon) {
            return new HorizCoordSys2D((LatLonAxis2D)lataxis, (LatLonAxis2D)lonaxis);
        }
        return new HorizCoordSys(xaxis, yaxis, lataxis, lonaxis, transform);
    }

    protected HorizCoordSys(CoverageCoordAxis1D xaxis, CoverageCoordAxis1D yaxis, CoverageCoordAxis lataxis, CoverageCoordAxis lonaxis, CoverageTransform transform) {
        boolean hasLatLon2D;
        this.xaxis = xaxis;
        this.yaxis = yaxis;
        this.transform = transform;
        this.isProjection = xaxis != null && yaxis != null && transform != null;
        boolean isLatLon1D = lataxis instanceof CoverageCoordAxis1D && lonaxis instanceof CoverageCoordAxis1D;
        boolean bl = hasLatLon2D = lataxis instanceof LatLonAxis2D && lonaxis instanceof LatLonAxis2D;
        assert (this.isProjection || isLatLon1D || hasLatLon2D) : "missing horiz coordinates (x,y,projection or lat,lon)";
        if (this.isProjection && hasLatLon2D) {
            String dependsOn;
            boolean ok = true;
            if (!lataxis.getDependsOn().equalsIgnoreCase(lonaxis.getDependsOn())) {
                ok = false;
            }
            if (lataxis.getDependenceType() != CoverageCoordAxis.DependenceType.twoD) {
                ok = false;
            }
            if (lonaxis.getDependenceType() != CoverageCoordAxis.DependenceType.twoD) {
                ok = false;
            }
            if (!(dependsOn = lataxis.getDependsOn()).contains(xaxis.getName())) {
                ok = false;
            }
            if (!dependsOn.contains(yaxis.getName())) {
                ok = false;
            }
            if (!ok) {
                hasLatLon2D = false;
            }
        }
        this.hasLatLon2D = hasLatLon2D;
        if (!this.isProjection && hasLatLon2D && !(this instanceof HorizCoordSys2D)) {
            System.out.printf("HEY Should be HorizCoordSys2D%n", new Object[0]);
        }
        if (isLatLon1D) {
            this.lataxis = (CoverageCoordAxis1D)lataxis;
            this.lonaxis = (CoverageCoordAxis1D)lonaxis;
        } else {
            this.lataxis = null;
            this.lonaxis = null;
        }
        if (hasLatLon2D) {
            this.lataxis2D = (LatLonAxis2D)lataxis;
            this.lonaxis2D = (LatLonAxis2D)lonaxis;
        } else {
            this.lataxis2D = null;
            this.lonaxis2D = null;
        }
    }

    public String getName() {
        if (this.isProjection) {
            return this.xaxis.getName() + " " + this.yaxis.getName() + " " + this.transform.getName();
        }
        return this.lataxis.getName() + " " + this.lonaxis.getName();
    }

    public boolean getIsProjection() {
        return this.isProjection;
    }

    public boolean isLatLon2D() {
        return false;
    }

    public List<CoverageCoordAxis> getCoordAxes() {
        ArrayList<CoverageCoordAxis> result = new ArrayList<CoverageCoordAxis>();
        if (this.xaxis != null) {
            result.add(this.xaxis);
        }
        if (this.yaxis != null) {
            result.add(this.yaxis);
        }
        if (this.lataxis != null) {
            result.add(this.lataxis);
        }
        if (this.lonaxis != null) {
            result.add(this.lonaxis);
        }
        return result;
    }

    public CoverageTransform getTransform() {
        return this.transform;
    }

    public Optional<HorizCoordSys> subset(SubsetParams params) {
        LatLonRect llbb = (LatLonRect)params.get("latlonBB");
        ProjectionRect projbb = (ProjectionRect)params.get("projBB");
        LatLonPoint latlon = (LatLonPoint)params.get("latlonPoint");
        Integer horizStride = (Integer)params.get("horizStride");
        if (horizStride == null || horizStride < 1) {
            horizStride = 1;
        }
        CoverageCoordAxis1D xaxisSubset = null;
        CoverageCoordAxis1D yaxisSubset = null;
        CoverageCoordAxis lataxisSubset = null;
        CoverageCoordAxis lonaxisSubset = null;
        Formatter errMessages = new Formatter();
        try {
            if (latlon != null) {
                CoordAxisHelper xhelper;
                if (this.isProjection) {
                    xhelper = new CoordAxisHelper(this.xaxis);
                    CoordAxisHelper yhelper = new CoordAxisHelper(this.yaxis);
                    ProjectionImpl proj = this.transform.getProjection();
                    ProjectionPoint pp = proj.latLonToProj(latlon);
                    Optional<CoverageCoordAxisBuilder> optb = xhelper.subsetContaining(pp.getX());
                    if (optb.isPresent()) {
                        xaxisSubset = new CoverageCoordAxis1D(optb.get());
                    } else {
                        errMessages.format("xaxis: %s;%n", optb.getErrorMessage());
                    }
                    optb = yhelper.subsetContaining(pp.getY());
                    if (optb.isPresent()) {
                        yaxisSubset = new CoverageCoordAxis1D(optb.get());
                    } else {
                        errMessages.format("yaxis: %s;%n", optb.getErrorMessage());
                    }
                } else {
                    xhelper = new CoordAxisHelper(this.lonaxis);
                    CoordAxisHelper yhelper = new CoordAxisHelper(this.lataxis);
                    double lonNormal = LatLonPointImpl.lonNormalFrom(latlon.getLongitude(), this.lonaxis.getStartValue());
                    Optional<CoverageCoordAxisBuilder> optb = xhelper.subsetContaining(lonNormal);
                    if (optb.isPresent()) {
                        lonaxisSubset = new CoverageCoordAxis1D(optb.get());
                    } else {
                        errMessages.format("lonaxis: %s;%n", optb.getErrorMessage());
                    }
                    optb = yhelper.subsetContaining(latlon.getLatitude());
                    if (optb.isPresent()) {
                        lataxisSubset = new CoverageCoordAxis1D(optb.get());
                    } else {
                        errMessages.format("lataxis: %s;%n", optb.getErrorMessage());
                    }
                }
            } else if (projbb != null) {
                if (this.isProjection) {
                    Optional<CoverageCoordAxis> opt = this.xaxis.subset(projbb.getMinX(), projbb.getMaxX(), horizStride);
                    if (opt.isPresent()) {
                        xaxisSubset = (CoverageCoordAxis1D)opt.get();
                    } else {
                        errMessages.format("xaxis: %s;%n", opt.getErrorMessage());
                    }
                    opt = this.yaxis.subset(projbb.getMinY(), projbb.getMaxY(), horizStride);
                    if (opt.isPresent()) {
                        yaxisSubset = (CoverageCoordAxis1D)opt.get();
                    } else {
                        errMessages.format("yaxis: %s;%n", opt.getErrorMessage());
                    }
                }
            } else if (llbb != null) {
                LatLonRect full = this.makeLatlonBB(null);
                assert (full != null);
                if (!full.containedIn(llbb)) {
                    if (this.isProjection) {
                        ProjectionImpl proj = this.transform.getProjection();
                        ProjectionRect prect = proj.latLonToProjBB(llbb);
                        Optional<CoverageCoordAxis> opt = this.xaxis.subset(prect.getMinX(), prect.getMaxX(), horizStride);
                        if (opt.isPresent()) {
                            xaxisSubset = (CoverageCoordAxis1D)opt.get();
                        } else {
                            errMessages.format("xaxis: %s;%n", opt.getErrorMessage());
                        }
                        opt = this.yaxis.subset(prect.getMinY(), prect.getMaxY(), horizStride);
                        if (opt.isPresent()) {
                            yaxisSubset = (CoverageCoordAxis1D)opt.get();
                        } else {
                            errMessages.format("yaxis: %s;%n", opt.getErrorMessage());
                        }
                    } else {
                        Optional<CoverageCoordAxis> opt = this.subsetLon(llbb, horizStride);
                        if (opt.isPresent()) {
                            lonaxisSubset = opt.get();
                        } else {
                            errMessages.format("lonaxis: %s;%n", opt.getErrorMessage());
                        }
                        opt = this.lataxis.subset(llbb.getLatMin(), llbb.getLatMax(), horizStride);
                        if (opt.isPresent()) {
                            lataxisSubset = opt.get();
                        } else {
                            errMessages.format("lataxis: %s;%n", opt.getErrorMessage());
                        }
                    }
                }
            } else if (horizStride > 1) {
                if (this.isProjection) {
                    Optional<CoverageCoordAxis> opt = this.xaxis.subsetByIndex(this.xaxis.getRange().setStride(horizStride));
                    if (opt.isPresent()) {
                        xaxisSubset = (CoverageCoordAxis1D)opt.get();
                    } else {
                        errMessages.format("xaxis: %s;%n", opt.getErrorMessage());
                    }
                    opt = this.yaxis.subsetByIndex(this.yaxis.getRange().setStride(horizStride));
                    if (opt.isPresent()) {
                        yaxisSubset = (CoverageCoordAxis1D)opt.get();
                    } else {
                        errMessages.format("yaxis: %s;%n", opt.getErrorMessage());
                    }
                } else {
                    Optional<CoverageCoordAxis> opt = this.lonaxis.subsetByIndex(this.lonaxis.getRange().setStride(horizStride));
                    if (opt.isPresent()) {
                        lonaxisSubset = opt.get();
                    } else {
                        errMessages.format("lonaxis: %s;%n", opt.getErrorMessage());
                    }
                    opt = this.lataxis.subsetByIndex(this.lataxis.getRange().setStride(horizStride));
                    if (opt.isPresent()) {
                        lataxisSubset = opt.get();
                    } else {
                        errMessages.format("lataxis: %s;%n", opt.getErrorMessage());
                    }
                }
            }
        }
        catch (InvalidRangeException e) {
            errMessages.format("%s;%n", e.getMessage());
        }
        String errs = errMessages.toString();
        if (errs.length() > 0) {
            return Optional.empty(errs);
        }
        if (xaxisSubset == null && this.xaxis != null) {
            xaxisSubset = (CoverageCoordAxis1D)this.xaxis.copy();
        }
        if (yaxisSubset == null && this.yaxis != null) {
            yaxisSubset = (CoverageCoordAxis1D)this.yaxis.copy();
        }
        if (lataxisSubset == null && this.lataxis != null) {
            lataxisSubset = this.lataxis.copy();
        }
        if (lonaxisSubset == null && this.lonaxis != null) {
            lonaxisSubset = this.lonaxis.copy();
        }
        return Optional.of(new HorizCoordSys(xaxisSubset, yaxisSubset, lataxisSubset, lonaxisSubset, this.transform));
    }

    public LatLonPoint getLatLon(int yindex, int xindex) {
        if (this.isProjection) {
            double x = this.xaxis.getCoordMidpoint(xindex);
            double y = this.yaxis.getCoordMidpoint(xindex);
            ProjectionImpl proj = this.transform.getProjection();
            return proj.projToLatLon(x, y);
        }
        double lat = this.lataxis.getCoordMidpoint(yindex);
        double lon = this.lonaxis.getCoordMidpoint(xindex);
        return new LatLonPointImpl(lat, lon);
    }

    private Optional<CoverageCoordAxis> subsetLon(LatLonRect llbb, int stride) throws InvalidRangeException {
        double end;
        double start;
        double wantMax;
        double wantMin = LatLonPointImpl.lonNormalFrom(llbb.getLonMin(), this.lonaxis.getStartValue());
        List<MAMath.MinMax> lonIntvs = this.subsetLonIntervals(wantMin, wantMax = LatLonPointImpl.lonNormalFrom(llbb.getLonMax(), this.lonaxis.getStartValue()), start = this.lonaxis.getStartValue(), end = this.lonaxis.getEndValue());
        if (lonIntvs.size() == 0) {
            return Optional.empty(String.format("longitude want [%f,%f] does not intersect lon axis [%f,%f]", wantMin, wantMax, start, end));
        }
        if (lonIntvs.size() == 1) {
            MAMath.MinMax lonIntv = lonIntvs.get(0);
            return this.lonaxis.subset(lonIntv.min, lonIntv.max, stride);
        }
        return this.lonaxis.subsetByIntervals(lonIntvs, stride);
    }

    private List<MAMath.MinMax> subsetLonIntervals(double wantMin, double wantMax, double start, double end) throws InvalidRangeException {
        if (wantMin <= wantMax) {
            if (wantMin > end && wantMax > end) {
                return Collections.EMPTY_LIST;
            }
            if (wantMin < end && wantMax < end) {
                return Lists.newArrayList(new MAMath.MinMax(wantMin, wantMax));
            }
            if (wantMin < end && wantMax > end) {
                return Lists.newArrayList(new MAMath.MinMax(wantMin, end));
            }
        } else {
            if (wantMin > end && wantMax > end) {
                return Lists.newArrayList(new MAMath.MinMax(start, end));
            }
            if (wantMin < end && wantMax < end) {
                return Lists.newArrayList(new MAMath.MinMax(wantMin, end), new MAMath.MinMax(start, wantMax));
            }
            if (wantMin < end && wantMax > end) {
                return Lists.newArrayList(new MAMath.MinMax(wantMin, end));
            }
        }
        logger.error("longitude want [%f,%f] does not intersect axis [%f,%f]", wantMin, wantMax, start, end);
        return Collections.EMPTY_LIST;
    }

    public ProjectionRect makeProjectionBB() {
        if (!this.isProjection) {
            return null;
        }
        double minX = Math.min(this.xaxis.getCoordEdge1(0), this.xaxis.getCoordEdgeLast());
        double minY = Math.min(this.yaxis.getCoordEdge1(0), this.yaxis.getCoordEdgeLast());
        double width = Math.abs(this.xaxis.getCoordEdgeLast() - this.xaxis.getCoordEdge1(0));
        double height = Math.abs(this.yaxis.getCoordEdgeLast() - this.yaxis.getCoordEdge1(0));
        return new ProjectionRect(new ProjectionPointImpl(minX, minY), width, height);
    }

    public LatLonRect makeLatlonBB(ProjectionRect projBB) {
        if (this.isProjection) {
            if (projBB == null) {
                projBB = this.makeProjectionBB();
            }
            return this.transform.getProjection().projToLatLonBB(projBB);
        }
        double minLon = Math.min(this.lonaxis.getCoordEdge1(0), this.lonaxis.getCoordEdgeLast());
        double minLat = Math.min(this.lataxis.getCoordEdge1(0), this.lataxis.getCoordEdgeLast());
        double deltaLon = Math.abs(this.lonaxis.getCoordEdgeLast() - this.lonaxis.getCoordEdge1(0));
        double deltaLat = Math.abs(this.lataxis.getCoordEdgeLast() - this.lataxis.getCoordEdge1(0));
        return new LatLonRect(new LatLonPointImpl(minLat, minLon), deltaLat, deltaLon);
    }

    public List<RangeIterator> getRanges() {
        ArrayList<RangeIterator> result = new ArrayList<RangeIterator>();
        result.add(this.getYAxis().getRange());
        RangeIterator lonRange = this.getXAxis().getRangeIterator();
        if (lonRange == null) {
            lonRange = this.getXAxis().getRange();
        }
        result.add(lonRange);
        return result;
    }

    public CoverageCoordAxis1D getXAxis() {
        return this.xaxis != null ? this.xaxis : this.lonaxis;
    }

    public CoverageCoordAxis1D getYAxis() {
        return this.yaxis != null ? this.yaxis : this.lataxis;
    }

    public LatLonAxis2D getLonAxis2D() {
        return this.lonaxis2D;
    }

    public LatLonAxis2D getLatAxis2D() {
        return this.lataxis2D;
    }

    public Optional<CoordReturn> findXYindexFromCoord(double x, double y) {
        CoordReturn result = new CoordReturn();
        if (this.isProjection) {
            CoordAxisHelper xhelper = new CoordAxisHelper(this.xaxis);
            CoordAxisHelper yhelper = new CoordAxisHelper(this.yaxis);
            result.x = xhelper.findCoordElement(x, false);
            result.y = yhelper.findCoordElement(y, false);
            if (result.x >= 0 && result.x < this.xaxis.getNcoords() && result.y >= 0 && result.y < this.yaxis.getNcoords()) {
                result.xcoord = this.xaxis.getCoordMidpoint(result.x);
                result.ycoord = this.yaxis.getCoordMidpoint(result.y);
                return Optional.of(result);
            }
            return Optional.empty("not in grid");
        }
        CoordAxisHelper xhelper = new CoordAxisHelper(this.lonaxis);
        CoordAxisHelper yhelper = new CoordAxisHelper(this.lataxis);
        double lon = LatLonPointImpl.lonNormalFrom(x, this.lonaxis.getStartValue());
        result.x = xhelper.findCoordElement(lon, false);
        result.y = yhelper.findCoordElement(y, false);
        if (result.x >= 0 && result.x < this.lonaxis.getNcoords() && result.y >= 0 && result.y < this.lataxis.getNcoords()) {
            result.xcoord = this.lonaxis.getCoordMidpoint(result.x);
            result.ycoord = this.lataxis.getCoordMidpoint(result.y);
            return Optional.of(result);
        }
        return Optional.empty("not in grid");
    }

    public static class CoordReturn {
        public int x;
        public int y;
        public double xcoord;
        public double ycoord;
    }
}

