/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.util.Formatter;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.util.Misc;

@Immutable
public class EnsCoord {
    private final List<Coord> coords;

    public EnsCoord(List<Coord> coords) {
        this.coords = coords;
    }

    public int getSize() {
        return this.coords.size();
    }

    public List<Coord> getCoords() {
        return this.coords;
    }

    public boolean equalsData(EnsCoord other) {
        if (this.coords.size() != other.coords.size()) {
            return false;
        }
        for (int i = 0; i < this.coords.size(); ++i) {
            if (this.coords.get(i).equals(other.coords.get(i))) continue;
            return false;
        }
        return true;
    }

    public int findIdx(Coord coord) {
        for (int i = 0; i < this.coords.size(); ++i) {
            if (!this.coords.get(i).equals(coord)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        Formatter out = new Formatter();
        for (Coord lev : this.coords) {
            out.format("%s, ", lev.toString());
        }
        return out.toString();
    }

    public static int findCoord(List<EnsCoord> ensCoords, EnsCoord want) {
        if (want == null) {
            return -1;
        }
        for (int i = 0; i < ensCoords.size(); ++i) {
            if (!want.equalsData(ensCoords.get(i))) continue;
            return i;
        }
        ensCoords.add(want);
        return ensCoords.size() - 1;
    }

    @Immutable
    public static class Coord
    implements Comparable<Coord> {
        final int code;
        final int ensMember;

        public Coord(int code, int ensMember) {
            this.code = code;
            this.ensMember = ensMember;
        }

        public int getCode() {
            return this.code;
        }

        public int getEnsMember() {
            return this.ensMember;
        }

        @Override
        public int compareTo(Coord o) {
            int r = Misc.compare(this.code, o.code);
            if (r != 0) {
                return r;
            }
            return Misc.compare(this.ensMember, o.ensMember);
        }

        public boolean equals(Object oo) {
            if (this == oo) {
                return true;
            }
            if (!(oo instanceof Coord)) {
                return false;
            }
            Coord other = (Coord)oo;
            return this.ensMember == other.ensMember && this.code == other.code;
        }

        public int hashCode() {
            int result = 17;
            result += 31 * this.ensMember;
            return result += 31 * this.code;
        }

        public String toString() {
            Formatter out = new Formatter();
            out.format("(%d %d)", this.code, this.ensMember);
            return out.toString();
        }
    }
}

