/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset.s3;

import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.crawlabledataset.s3.S3URI;
import thredds.crawlabledataset.s3.ThreddsS3Client;

public class CachingThreddsS3Client
implements ThreddsS3Client {
    private static final Logger logger = LoggerFactory.getLogger(CachingThreddsS3Client.class);
    private static final long ENTRY_EXPIRATION_TIME = 1L;
    private static final long MAX_METADATA_ENTRIES = 10000L;
    private static final long MAX_FILE_ENTRIES = 100L;
    private final ThreddsS3Client threddsS3Client;
    private final Cache<S3URI, Optional<ObjectMetadata>> objectMetadataCache;
    private final Cache<S3URI, Optional<ObjectListing>> objectListingCache;
    private final Cache<S3URI, Optional<File>> objectFileCache;

    public CachingThreddsS3Client(ThreddsS3Client threddsS3Client) {
        this(threddsS3Client, new ObjectFileCacheRemovalListener());
    }

    public CachingThreddsS3Client(ThreddsS3Client threddsS3Client, RemovalListener<S3URI, Optional<File>> removalListener) {
        this.threddsS3Client = threddsS3Client;
        this.objectMetadataCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).maximumSize(10000L).build();
        this.objectListingCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).maximumSize(10000L).build();
        this.objectFileCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).maximumSize(100L).removalListener(removalListener).build();
    }

    @Override
    public ObjectMetadata getObjectMetadata(S3URI s3uri) {
        Optional<ObjectMetadata> metadata = this.objectMetadataCache.getIfPresent(s3uri);
        if (metadata == null) {
            logger.debug(String.format("ObjectMetadata cache MISS: '%s'", s3uri));
            metadata = Optional.fromNullable(this.threddsS3Client.getObjectMetadata(s3uri));
            this.objectMetadataCache.put(s3uri, metadata);
        } else {
            logger.debug(String.format("ObjectMetadata cache hit: '%s'", s3uri));
        }
        return metadata.orNull();
    }

    @Override
    public ObjectListing listObjects(S3URI s3uri) {
        Optional<ObjectListing> objectListing = this.objectListingCache.getIfPresent(s3uri);
        if (objectListing == null) {
            logger.debug(String.format("ObjectListing cache MISS: '%s'", s3uri));
            objectListing = Optional.fromNullable(this.threddsS3Client.listObjects(s3uri));
            this.objectListingCache.put(s3uri, objectListing);
        } else {
            logger.debug(String.format("ObjectListing cache hit: '%s'", s3uri));
        }
        return objectListing.orNull();
    }

    @Override
    public File saveObjectToFile(S3URI s3uri, File file) throws IOException {
        Optional<File> cachedFile = this.objectFileCache.getIfPresent(s3uri);
        if (cachedFile == null) {
            logger.debug("Object cache MISS: '%s'", (Object)s3uri);
        } else {
            logger.debug("Object cache hit: '%s'", (Object)s3uri);
            if (!cachedFile.isPresent()) {
                return null;
            }
            if (!cachedFile.get().exists()) {
                logger.info(String.format("Found cache entry {'%s'-->'%s'}, but local file doesn't exist. Was it deleted? Re-downloading.", s3uri, cachedFile.get()));
                this.objectFileCache.invalidate(s3uri);
            } else {
                if (!cachedFile.get().equals(file)) {
                    Files.copy(cachedFile.get(), file);
                    this.objectFileCache.put(s3uri, Optional.of(file));
                    return file;
                }
                return file;
            }
        }
        cachedFile = Optional.fromNullable(this.threddsS3Client.saveObjectToFile(s3uri, file));
        this.objectFileCache.put(s3uri, cachedFile);
        return cachedFile.orNull();
    }

    public void clear() {
        this.objectMetadataCache.invalidateAll();
        this.objectListingCache.invalidateAll();
        this.objectFileCache.invalidateAll();
    }

    private static class ObjectFileCacheRemovalListener
    implements RemovalListener<S3URI, Optional<File>> {
        private ObjectFileCacheRemovalListener() {
        }

        @Override
        public void onRemoval(RemovalNotification<S3URI, Optional<File>> notification) {
            Optional<File> file = notification.getValue();
            assert (file != null) : "Silence a silly IntelliJ warning. Of course the Optional isn't null.";
            if (file.isPresent()) {
                file.get().delete();
            }
        }
    }
}

