/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureDataIteratorMediated;
import ucar.ma2.StructureDataMediator;
import ucar.ma2.StructureDataProxy;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleAdapter;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.VariableSimpleImpl;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.StructurePseudo2Dim;
import ucar.nc2.dataset.StructurePseudoDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ft.point.StructureDataIteratorIndexed;
import ucar.nc2.ft.point.StructureDataIteratorLinked;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.Join;
import ucar.nc2.ft.point.standard.TableConfig;

public abstract class Table {
    private static Logger log = LoggerFactory.getLogger(Table.class);
    String name;
    FeatureType featureType;
    Table parent;
    Table child;
    List<Join> extraJoins;
    String lat;
    String lon;
    String elev;
    String time;
    String timeNominal;
    String stnId;
    String stnDesc;
    String stnNpts;
    String stnWmoId;
    String stnAlt;
    String limit;
    String feature_id;
    String missingVar;
    Map<String, VariableSimpleIF> cols = new HashMap<String, VariableSimpleIF>();
    Set<String> nondataVars = new HashSet<String>();

    public static Table factory(NetcdfDataset ds, TableConfig config) {
        switch (config.type) {
            case ArrayStructure: {
                return new TableArrayStructure(ds, config);
            }
            case Construct: {
                return new TableConstruct(ds, config);
            }
            case Contiguous: {
                return new TableContiguous(ds, config);
            }
            case LinkedList: {
                return new TableLinkedList(ds, config);
            }
            case MultidimInner: {
                return new TableMultidimInner(ds, config);
            }
            case MultidimInner3D: {
                return new TableMultidimInner3D(ds, config);
            }
            case MultidimStructure: {
                return new TableMultidimStructure(ds, config);
            }
            case MultidimInnerPsuedo: {
                return new TableMultidimInnerPsuedo(ds, config);
            }
            case MultidimInnerPsuedo3D: {
                return new TableMultidimInnerPsuedo3D(ds, config);
            }
            case NestedStructure: {
                return new TableNestedStructure(ds, config);
            }
            case ParentId: {
                return new TableParentId(ds, config);
            }
            case ParentIndex: {
                return new TableParentIndex(ds, config);
            }
            case Singleton: {
                return new TableSingleton(ds, config);
            }
            case Structure: {
                return new TableStructure(ds, config);
            }
            case Top: {
                return new TableTop(ds, config);
            }
        }
        throw new IllegalStateException("Unimplemented Table type = " + (Object)((Object)config.type));
    }

    protected Table(NetcdfDataset ds, TableConfig config) {
        this.name = config.name;
        this.featureType = config.featureType;
        this.lat = config.lat;
        this.lon = config.lon;
        this.elev = config.elev;
        this.time = config.time;
        this.timeNominal = config.timeNominal;
        this.stnId = config.stnId;
        this.stnDesc = config.stnDesc;
        this.stnNpts = config.stnNpts;
        this.stnWmoId = config.stnWmoId;
        this.stnAlt = config.stnAlt;
        this.limit = config.limit;
        this.feature_id = config.feature_id;
        this.missingVar = config.missingVar;
        if (config.parent != null) {
            this.parent = Table.factory(ds, config.parent);
            this.parent.child = this;
        }
        this.extraJoins = config.extraJoin;
        this.addNonDataVariable(config.time);
        this.addNonDataVariable(config.lat);
        this.addNonDataVariable(config.lon);
        this.addNonDataVariable(config.elev);
        this.addNonDataVariable(config.timeNominal);
        this.addNonDataVariable(config.stnId);
        this.addNonDataVariable(config.stnDesc);
        this.addNonDataVariable(config.stnWmoId);
        this.addNonDataVariable(config.stnAlt);
        this.addNonDataVariable(config.stnNpts);
        this.addNonDataVariable(config.limit);
        this.addNonDataVariable(config.feature_id);
        this.addNonDataVariable(config.parentIndex);
        this.addNonDataVariable(config.start);
        this.addNonDataVariable(config.next);
        this.addNonDataVariable(config.numRecords);
    }

    protected void addNonDataVariable(String name) {
        if (name != null) {
            this.nondataVars.add(name);
        }
    }

    protected void replaceDataVars(StructureMembers sm) {
        for (StructureMembers.Member m : sm.getMembers()) {
            VariableSimpleIF org = this.cols.get(m.getName());
            int rank = org.getRank();
            List<Dimension> orgDims = org.getDimensions();
            int n = m.getShape().length;
            List<Dimension> dims = orgDims.subList(rank - n, rank);
            VariableSimpleImpl result = new VariableSimpleImpl(org.getShortName(), org.getDescription(), org.getUnitsString(), org.getDataType(), dims);
            for (Attribute att : org.getAttributes()) {
                result.add(att);
            }
            this.cols.put(m.getName(), result);
        }
    }

    public abstract StructureDataIterator getStructureDataIterator(Cursor var1) throws IOException;

    String findCoordinateVariableName(CoordName coordName) {
        switch (coordName) {
            case Elev: {
                return this.elev;
            }
            case Lat: {
                return this.lat;
            }
            case Lon: {
                return this.lon;
            }
            case Time: {
                return this.time;
            }
            case TimeNominal: {
                return this.timeNominal;
            }
            case StnId: {
                return this.stnId;
            }
            case StnDesc: {
                return this.stnDesc;
            }
            case WmoId: {
                return this.stnWmoId;
            }
            case StnAlt: {
                return this.stnAlt;
            }
            case FeatureId: {
                return this.feature_id;
            }
            case MissingVar: {
                return this.missingVar;
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public VariableDS findVariable(String axisName) {
        return null;
    }

    public String showDimension() {
        return "";
    }

    public String toString() {
        Formatter formatter = new Formatter();
        formatter.format(" Table %s on dimension %s type=%s%n", this.getName(), this.showDimension(), this.getClass().toString());
        formatter.format("  Coordinates=", new Object[0]);
        formatter.format("%n  Data Variables= %d%n", this.cols.size());
        formatter.format("  Parent= %s%n", this.parent == null ? "none" : this.parent.getName());
        return formatter.toString();
    }

    public int show(Formatter f, int indent) {
        if (this.parent != null) {
            indent = this.parent.show(f, indent);
        }
        String s = this.indent(indent);
        String ftDesc = this.featureType == null ? "" : "featureType=" + this.featureType.toString();
        f.format("%n%sTable %s: type=%s %s%n", s, this.getName(), this.getClass().toString(), ftDesc);
        if (this.extraJoins != null) {
            f.format("  %sExtraJoins:%n", s);
            for (Join j : this.extraJoins) {
                f.format("   %s  %s %n", s, j);
            }
        }
        this.showTableExtraInfo(this.indent(indent + 2), f);
        this.showCoords(s, f);
        f.format("  %sVariables:%n", s);
        for (String colName : this.cols.keySet()) {
            f.format("   %s  %s %s%n", s, colName, this.getKind(colName));
        }
        return indent + 2;
    }

    String indent(int n) {
        StringBuilder sbuff = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sbuff.append(' ');
        }
        return sbuff.toString();
    }

    protected abstract void showTableExtraInfo(String var1, Formatter var2);

    String getKind(String v) {
        if (v.equals(this.lat)) {
            return "[Lat]";
        }
        if (v.equals(this.lon)) {
            return "[Lon]";
        }
        if (v.equals(this.elev)) {
            return "[Elev]";
        }
        if (v.equals(this.time)) {
            return "[Time]";
        }
        if (v.equals(this.timeNominal)) {
            return "[timeNominal]";
        }
        if (v.equals(this.stnId)) {
            return "[stnId]";
        }
        if (v.equals(this.stnDesc)) {
            return "[stnDesc]";
        }
        if (v.equals(this.stnNpts)) {
            return "[stnNpts]";
        }
        if (v.equals(this.stnWmoId)) {
            return "[stnWmoId]";
        }
        if (v.equals(this.stnAlt)) {
            return "[stnAlt]";
        }
        if (v.equals(this.limit)) {
            return "[limit]";
        }
        return "";
    }

    private void showCoords(String indent, Formatter out) {
        boolean gotSome = false;
        for (CoordName coord : CoordName.values()) {
            String varName = this.findCoordinateVariableName(coord);
            if (varName == null) continue;
            gotSome = true;
            out.format(" %s Coord %s [%s]%n", new Object[]{indent, varName, coord});
        }
        if (gotSome) {
            out.format("%n", new Object[0]);
        }
    }

    private static class SingletonStructureDataIterator
    implements StructureDataIterator {
        private int count = 0;
        private StructureData sdata;

        SingletonStructureDataIterator(StructureData sdata) {
            this.sdata = sdata;
            assert (sdata != null);
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.count == 0;
        }

        @Override
        public StructureData next() throws IOException {
            ++this.count;
            return this.sdata;
        }

        @Override
        public StructureDataIterator reset() {
            this.count = 0;
            return this;
        }

        @Override
        public int getCurrentRecno() {
            return this.count - 1;
        }
    }

    private static class StructureDataTop
    extends StructureDataW {
        public StructureDataTop() {
            super(new StructureMembers("top"));
        }

        void addVariableAsMember(NetcdfDataset ds, String scalarVariableName) throws IOException {
            if (scalarVariableName == null) {
                return;
            }
            Variable v = ds.findVariable(scalarVariableName);
            if (v == null) {
                return;
            }
            StructureMembers.Member m = this.members.addMember(v.getFullName(), null, null, v.getDataType(), v.getShape());
            this.setMemberData(m, v.read());
        }
    }

    public static class TableTop
    extends Table {
        NetcdfDataset ds;
        StructureDataTop sdata;

        TableTop(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            this.ds = ds;
        }

        @Override
        protected void showTableExtraInfo(String indent, Formatter f) {
        }

        @Override
        public StructureDataIterator getStructureDataIterator(Cursor cursor) throws IOException {
            if (this.sdata == null) {
                this.sdata = new StructureDataTop();
                this.sdata.addVariableAsMember(this.ds, this.feature_id);
            }
            return new SingletonStructureDataIterator(this.sdata);
        }

        @Override
        public String getName() {
            return "TopScalars";
        }
    }

    public static class TableSingleton
    extends Table {
        StructureData sdata;

        TableSingleton(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            this.sdata = config.sdata;
            if (this.sdata == null) {
                this.sdata = StructureData.EMPTY;
            }
            for (StructureMembers.Member m : this.sdata.getStructureMembers().getMembers()) {
                this.cols.put(m.getName(), new VariableSimpleAdapter(m));
            }
        }

        @Override
        protected void showTableExtraInfo(String indent, Formatter f) {
            f.format("%sStructureData=%s%n", indent, this.sdata);
        }

        @Override
        public StructureDataIterator getStructureDataIterator(Cursor cursor) throws IOException {
            return new SingletonStructureDataIterator(this.sdata);
        }

        @Override
        public String getName() {
            return "Singleton";
        }
    }

    public static class TableNestedStructure
    extends Table {
        String nestedTableName;
        Structure struct;

        TableNestedStructure(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            this.nestedTableName = config.nestedTableName;
            this.struct = (Structure)ds.findVariable(config.structName);
            assert (this.struct != null) : config.structName;
            for (Variable v : this.struct.getVariables()) {
                this.cols.put(v.getShortName(), v);
            }
        }

        @Override
        protected void showTableExtraInfo(String indent, Formatter f) {
            f.format("%sstruct=%s, nestedTableName=%s%n", indent, this.struct.getNameAndDimensions(), this.nestedTableName);
        }

        @Override
        public VariableDS findVariable(String axisName) {
            return (VariableDS)this.struct.findVariable(axisName);
        }

        @Override
        public StructureDataIterator getStructureDataIterator(Cursor cursor) throws IOException {
            StructureData parentStruct = cursor.getParentStructure();
            StructureMembers members = parentStruct.getStructureMembers();
            StructureMembers.Member m = members.findMember(this.nestedTableName);
            if (m.getDataType() == DataType.SEQUENCE) {
                ArraySequence seq = parentStruct.getArraySequence(m);
                return seq.getStructureDataIterator();
            }
            if (m.getDataType() == DataType.STRUCTURE) {
                ArrayStructure as = parentStruct.getArrayStructure(m);
                return as.getStructureDataIterator();
            }
            throw new IllegalStateException("Cant find nested table member = " + this.nestedTableName);
        }

        @Override
        public String getName() {
            return "NestedStructure(" + this.nestedTableName + ")";
        }
    }

    public static class TableMultidimStructure
    extends TableStructure {
        TableMultidimStructure(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
        }

        @Override
        public StructureDataIterator getStructureDataIterator(Cursor cursor) throws IOException {
            int recnum = cursor.getParentRecnum();
            try {
                Section section = new Section().appendRange(recnum, recnum);
                int count = 1;
                while (count++ < this.struct.getRank()) {
                    section.appendRange(null);
                }
                ArrayStructure data = (ArrayStructure)this.struct.read(section);
                return data.getStructureDataIterator();
            }
            catch (InvalidRangeException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public String getName() {
            return "MultidimStructure(" + this.struct.getFullName() + ")";
        }
    }

    public static class TableMultidimInnerPsuedo3D
    extends TableStructure {
        Dimension middle;
        Dimension inner;
        StructureMembers sm;

        TableMultidimInnerPsuedo3D(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            assert (config.dimName != null);
            assert (config.outerName != null);
            assert (config.innerName != null);
            this.dim = ds.findDimension(config.dimName);
            this.middle = ds.findDimension(config.outerName);
            this.inner = ds.findDimension(config.innerName);
            this.sm = new StructureMembers(config.name);
            for (Variable v : this.struct.getVariables()) {
                int rank = v.getRank();
                int[] shape = new int[rank - 1];
                System.arraycopy(v.getShape(), 1, shape, 0, rank - 1);
                this.sm.addMember(v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType(), shape);
            }
            this.replaceDataVars(this.sm);
        }

        @Override
        public StructureDataIterator getStructureDataIterator(Cursor cursor) throws IOException {
            int outerIndex = cursor.recnum[2];
            int middleIndex = cursor.recnum[1];
            try {
                Section s = new Section().appendRange(outerIndex, outerIndex).appendRange(middleIndex, middleIndex);
                ArrayStructure result = (ArrayStructure)this.struct.read(s);
                assert (result.getSize() == 1L);
                StructureData sdata = result.getStructureData(0);
                ArrayStructureMA asma = new ArrayStructureMA(this.sm, new int[]{this.inner.getLength()});
                for (String colName : this.cols.keySet()) {
                    Array data = sdata.getArray(colName);
                    StructureMembers.Member childm = this.sm.findMember(colName);
                    childm.setDataArray(data);
                }
                return asma.getStructureDataIterator();
            }
            catch (InvalidRangeException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public String getName() {
            return "MultidimPsuedo(" + this.dim.getShortName() + "," + this.middle.getShortName() + "," + this.inner.getShortName() + ")";
        }
    }

    public static class TableMultidimInnerPsuedo
    extends TableStructure {
        Dimension inner;
        Dimension outer;
        StructureMembers sm;

        TableMultidimInnerPsuedo(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            assert (config.outerName != null);
            assert (config.innerName != null);
            this.inner = ds.findDimension(config.innerName);
            this.outer = ds.findDimension(config.outerName);
            this.sm = new StructureMembers(config.name);
            for (Variable v : this.struct.getVariables()) {
                int rank = v.getRank();
                int[] shape = new int[rank - 1];
                System.arraycopy(v.getShape(), 1, shape, 0, rank - 1);
                this.sm.addMember(v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType(), shape);
            }
            this.replaceDataVars(this.sm);
        }

        @Override
        public StructureDataIterator getStructureDataIterator(Cursor cursor) throws IOException {
            int recnum = cursor.recnum[cursor.currentIndex];
            try {
                StructureData parentStruct = this.struct.readStructure(recnum);
                ArrayStructureMA asma = new ArrayStructureMA(this.sm, new int[]{this.inner.getLength()});
                for (String colName : this.cols.keySet()) {
                    Array data = parentStruct.getArray(colName);
                    StructureMembers.Member childm = this.sm.findMember(colName);
                    childm.setDataArray(data);
                }
                return asma.getStructureDataIterator();
            }
            catch (InvalidRangeException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public String getName() {
            return "MultidimPseudo(" + this.outer.getShortName() + "," + this.inner.getShortName() + ")";
        }
    }

    public static class TableMultidimInner3D
    extends Table {
        StructureMembers sm;
        Dimension dim;
        Dimension inner;
        Dimension middle;
        NetcdfDataset ds;

        TableMultidimInner3D(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            this.ds = ds;
            assert (config.dimName != null);
            assert (config.outerName != null);
            assert (config.innerName != null);
            this.dim = ds.findDimension(config.dimName);
            this.inner = ds.findDimension(config.innerName);
            this.middle = ds.findDimension(config.outerName);
            this.sm = new StructureMembers(config.name);
            if (config.vars != null) {
                for (String name : config.vars) {
                    Variable v = ds.findVariable(name);
                    if (v == null) continue;
                    int rank = v.getRank();
                    int[] shape = new int[rank - 3];
                    System.arraycopy(v.getShape(), 3, shape, 0, rank - 3);
                    this.sm.addMember(v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType(), shape);
                    this.cols.put(v.getShortName(), v);
                }
            } else {
                for (Variable v : ds.getVariables()) {
                    if (v.getRank() < 3 || !v.getDimension(0).equals(this.dim) || !v.getDimension(1).equals(this.middle) || !v.getDimension(2).equals(this.inner)) continue;
                    int rank = v.getRank();
                    int[] shape = new int[rank - 3];
                    System.arraycopy(v.getShape(), 3, shape, 0, rank - 3);
                    this.sm.addMember(v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType(), shape);
                    this.cols.put(v.getShortName(), v);
                }
            }
            this.replaceDataVars(this.sm);
        }

        @Override
        protected void showTableExtraInfo(String indent, Formatter f) {
            f.format("%sStructureMembers=%s, dim=%s%n", indent, this.sm.getName(), this.dim.getShortName());
        }

        @Override
        public String showDimension() {
            return this.dim.getShortName();
        }

        @Override
        public VariableDS findVariable(String axisName) {
            return (VariableDS)this.ds.findVariable(axisName);
        }

        @Override
        public StructureDataIterator getStructureDataIterator(Cursor cursor) throws IOException {
            StructureData parentStruct = cursor.tableData[2];
            if (parentStruct instanceof StructureDataProxy) {
                parentStruct = ((StructureDataProxy)parentStruct).getOriginalStructureData();
            }
            int middleIndex = cursor.recnum[1];
            ArrayStructureMA asma = new ArrayStructureMA(this.sm, new int[]{this.inner.getLength()});
            for (String colName : this.cols.keySet()) {
                Array data = parentStruct.getArray(colName);
                Array myData = data.slice(0, middleIndex);
                StructureMembers.Member childm = this.sm.findMember(colName);
                childm.setDataArray(myData.copy());
            }
            return asma.getStructureDataIterator();
        }

        @Override
        public String getName() {
            return "Multidim(" + this.dim.getShortName() + "," + this.middle.getShortName() + "," + this.inner.getShortName() + ")";
        }
    }

    public static class TableMultidimInner
    extends Table {
        StructureMembers sm;
        Dimension inner;
        Dimension outer;
        NetcdfDataset ds;

        TableMultidimInner(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            this.ds = ds;
            assert (config.outerName != null);
            assert (config.innerName != null);
            this.inner = ds.findDimension(config.innerName);
            this.outer = ds.findDimension(config.outerName);
            assert (this.inner != null) : config.innerName;
            assert (this.outer != null) : config.outerName;
            this.sm = new StructureMembers(config.name);
            if (config.vars != null) {
                for (String name : config.vars) {
                    Variable v = ds.findVariable(name);
                    if (v == null) continue;
                    int rank = v.getRank();
                    int[] shape = new int[rank - 2];
                    System.arraycopy(v.getShape(), 2, shape, 0, rank - 2);
                    this.sm.addMember(v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType(), shape);
                    this.cols.put(v.getShortName(), v);
                }
            } else {
                for (Variable v : ds.getVariables()) {
                    if (v.getRank() < 2 || !v.getDimension(0).equals(this.outer) || !v.getDimension(1).equals(this.inner)) continue;
                    int rank = v.getRank();
                    int[] shape = new int[rank - 2];
                    System.arraycopy(v.getShape(), 2, shape, 0, rank - 2);
                    this.sm.addMember(v.getShortName(), v.getDescription(), v.getUnitsString(), v.getDataType(), shape);
                    this.cols.put(v.getShortName(), v);
                }
            }
            this.replaceDataVars(this.sm);
        }

        @Override
        protected void showTableExtraInfo(String indent, Formatter f) {
            f.format("%sStructureMembers=%s, dim=%s,%s%n", indent, this.sm.getName(), this.outer.getShortName(), this.inner.getShortName());
        }

        @Override
        public String showDimension() {
            return this.inner.getShortName();
        }

        @Override
        public VariableDS findVariable(String axisName) {
            return (VariableDS)this.ds.findVariable(axisName);
        }

        @Override
        public StructureDataIterator getStructureDataIterator(Cursor cursor) throws IOException {
            StructureData parentStruct = cursor.getParentStructure();
            if (parentStruct instanceof StructureDataProxy) {
                parentStruct = ((StructureDataProxy)parentStruct).getOriginalStructureData();
            }
            ArrayStructureMA asma = new ArrayStructureMA(this.sm, new int[]{this.inner.getLength()});
            for (String colName : this.cols.keySet()) {
                Array data = parentStruct.getArray(colName);
                StructureMembers.Member childm = this.sm.findMember(colName);
                childm.setDataArray(data);
            }
            return asma.getStructureDataIterator();
        }

        @Override
        public String getName() {
            return "Multidim(" + this.outer.getShortName() + "," + this.inner.getShortName() + ")";
        }
    }

    public static class TableLinkedList
    extends TableStructure {
        private String start;
        private String next;

        TableLinkedList(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            this.start = config.start;
            this.next = config.next;
            this.addNonDataVariable(config.start);
            this.addNonDataVariable(config.next);
        }

        @Override
        public StructureDataIterator getStructureDataIterator(Cursor cursor) throws IOException {
            StructureData parentStruct = cursor.getParentStructure();
            int firstRecno = parentStruct.getScalarInt(this.start);
            return new StructureDataIteratorLinked(this.struct, firstRecno, -1, this.next);
        }

        @Override
        public String getName() {
            return "Linked(" + this.start + "->" + this.next + ")";
        }
    }

    public static class TableParentId
    extends TableStructure {
        private ParentInfo[] indexMap;
        private String parentIdName;

        TableParentId(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            Object info;
            HashMap<Object, ParentInfo> parentHash;
            this.parentIdName = config.parentIndex;
            try {
                Array index;
                Variable rpIndex = ds.findVariable(this.parentIdName);
                if (rpIndex == null) {
                    rpIndex = this.struct.findVariable(this.parentIdName);
                }
                if ((index = rpIndex.read()) instanceof ArrayChar) {
                    index = ((ArrayChar)index).make1DStringArray();
                }
                parentHash = new HashMap<Object, ParentInfo>((int)(2L * index.getSize()));
                int childIndex = 0;
                while (index.hasNext()) {
                    Object parent = index.next();
                    info = (ParentInfo)parentHash.get(parent);
                    if (info == null) {
                        info = new ParentInfo();
                        parentHash.put(parent, (ParentInfo)info);
                    }
                    ((ParentInfo)info).add(childIndex);
                    ++childIndex;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Collection parents = parentHash.values();
            int n = parents.size();
            this.indexMap = new ParentInfo[n];
            StructureData[] parentData = new StructureData[n];
            int count = 0;
            info = parents.iterator();
            while (info.hasNext()) {
                ParentInfo info2;
                this.indexMap[count] = info2 = (ParentInfo)info.next();
                parentData[count++] = info2.sdata;
            }
            ArrayStructureW as = new ArrayStructureW(this.struct.makeStructureMembers(), new int[]{n}, parentData);
            Table t = this;
            while (t.parent != null) {
                t = t.parent;
                if (!(t instanceof TableConstruct)) continue;
                ((TableConstruct)t).as = as;
                break;
            }
            this.addNonDataVariable(this.parentIdName);
        }

        @Override
        protected void showTableExtraInfo(String indent, Formatter f) {
            f.format("%sparentIdName=%s, indexMap.size=%d%n", indent, this.parentIdName, this.indexMap.length);
        }

        @Override
        public StructureDataIterator getStructureDataIterator(Cursor cursor) throws IOException {
            int parentIndex = cursor.getParentRecnum();
            ParentInfo info = this.indexMap[parentIndex];
            ArrayList<Integer> index = info == null ? new ArrayList() : info.recnumList;
            return new StructureDataIteratorIndexed(this.struct, index);
        }

        @Override
        public String getName() {
            return "ParentId(" + this.parentIdName + ")";
        }

        private class ParentInfo {
            List<Integer> recnumList = new ArrayList<Integer>();
            StructureData sdata;

            private ParentInfo() {
            }

            void add(int recnum) throws IOException {
                this.recnumList.add(recnum);
                if (this.sdata != null) {
                    return;
                }
                try {
                    this.sdata = TableParentId.this.struct.readStructure(recnum);
                }
                catch (InvalidRangeException e) {
                    log.error("TableParentId read recno=" + recnum, e);
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
    }

    public static class TableParentIndex
    extends TableStructure {
        private Map<Integer, List<Integer>> indexMap;
        private String parentIndexName;

        TableParentIndex(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            this.parentIndexName = config.parentIndex;
            try {
                Variable rpIndex = ds.findVariable(config.parentIndex);
                Array index = rpIndex.read();
                int childIndex = 0;
                this.indexMap = new HashMap<Integer, List<Integer>>((int)(2L * index.getSize()));
                while (index.hasNext()) {
                    int parent = index.nextInt();
                    List<Integer> list = this.indexMap.get(parent);
                    if (list == null) {
                        list = new ArrayList<Integer>();
                        this.indexMap.put(parent, list);
                    }
                    list.add(childIndex);
                    ++childIndex;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.addNonDataVariable(config.parentIndex);
        }

        @Override
        protected void showTableExtraInfo(String indent, Formatter f) {
            f.format("%sparentIndexName=%s, indexMap.size=%d%n", indent, this.parentIndexName, this.indexMap.size());
        }

        @Override
        public StructureDataIterator getStructureDataIterator(Cursor cursor) throws IOException {
            int parentIndex = cursor.getParentRecnum();
            List<Integer> index = this.indexMap.get(parentIndex);
            if (index == null) {
                index = new ArrayList<Integer>();
            }
            return new StructureDataIteratorIndexed(this.struct, index);
        }

        @Override
        public String getName() {
            return "Indexed(" + this.parentIndexName + ")";
        }
    }

    public static class TableContiguous
    extends TableStructure {
        private String startVarName;
        private String numRecordsVarName;
        private int[] startIndex;
        private int[] numRecords;
        private NetcdfDataset ds;
        private boolean isInit;

        TableContiguous(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            this.ds = ds;
            this.startVarName = config.getStart();
            this.numRecordsVarName = config.getNumRecords();
            this.addNonDataVariable(this.startVarName);
            this.addNonDataVariable(this.numRecordsVarName);
        }

        private void init() {
            if (this.startVarName == null) {
                try {
                    Variable v = this.ds.findVariable(this.numRecordsVarName);
                    Array numRecords = v.read();
                    int n = (int)numRecords.getSize();
                    this.numRecords = new int[n];
                    this.startIndex = new int[n];
                    int i = 0;
                    int count = 0;
                    while (numRecords.hasNext()) {
                        this.startIndex[i] = count;
                        this.numRecords[i] = numRecords.nextInt();
                        count += this.numRecords[i];
                        ++i;
                    }
                    this.isInit = true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        protected void showTableExtraInfo(String indent, Formatter f) {
            f.format("%sstart=%s, numRecords=%s%n", indent, this.startVarName, this.numRecordsVarName);
        }

        @Override
        public StructureDataIterator getStructureDataIterator(Cursor cursor) throws IOException {
            int numrecs;
            int firstRecno;
            if (!this.isInit) {
                this.init();
            }
            StructureData parentStruct = cursor.getParentStructure();
            if (this.startIndex != null) {
                int parentIndex = cursor.getParentRecnum();
                firstRecno = this.startIndex[parentIndex];
                numrecs = this.numRecords[parentIndex];
            } else {
                firstRecno = parentStruct.getScalarInt(this.startVarName);
                numrecs = parentStruct.getScalarInt(this.numRecordsVarName);
            }
            return new StructureDataIteratorLinked(this.struct, firstRecno, numrecs, null);
        }

        @Override
        public String getName() {
            return "Contig(" + this.numRecordsVarName + ")";
        }
    }

    public static class TableConstruct
    extends Table {
        ArrayStructure as;

        TableConstruct(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
        }

        @Override
        protected void showTableExtraInfo(String indent, Formatter f) {
        }

        @Override
        public StructureDataIterator getStructureDataIterator(Cursor cursor) throws IOException {
            return this.as.getStructureDataIterator();
        }

        @Override
        public String getName() {
            return "Constructed";
        }
    }

    public static class TableArrayStructure
    extends Table {
        ArrayStructure as;
        Dimension dim;

        TableArrayStructure(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            assert (config.as != null);
            this.as = config.as;
            this.dim = new Dimension(config.structName, (int)config.as.getSize(), false);
            for (StructureMembers.Member m : config.as.getStructureMembers().getMembers()) {
                this.cols.put(m.getName(), new VariableSimpleAdapter(m));
            }
        }

        @Override
        protected void showTableExtraInfo(String indent, Formatter f) {
            f.format("%sArrayStruct=%s, dim=%s%n", indent, new Section(this.as.getShape()), this.dim.getShortName());
        }

        @Override
        public String showDimension() {
            return this.dim.getShortName();
        }

        @Override
        public StructureDataIterator getStructureDataIterator(Cursor cursor) throws IOException {
            return this.as.getStructureDataIterator();
        }

        @Override
        public String getName() {
            return "ArrayStructure(" + this.name + ")";
        }
    }

    private class RestrictToColumns
    implements StructureDataMediator {
        StructureMembers members;

        private RestrictToColumns() {
        }

        @Override
        public StructureData modify(StructureData sdata) {
            if (this.members == null) {
                StructureMembers orgMembers = sdata.getStructureMembers();
                this.members = new StructureMembers(orgMembers.getName() + "RestrictToColumns");
                for (String colName : Table.this.cols.keySet()) {
                    StructureMembers.Member m = orgMembers.findMember(colName);
                    if (m == null) {
                        throw new IllegalStateException("Cant find " + colName);
                    }
                    this.members.addMember(m);
                }
            }
            return new StructureDataProxy(this.members, sdata);
        }
    }

    public static class TableStructure
    extends Table {
        StructureDS struct;
        Dimension dim;
        Dimension outer;
        TableConfig.StructureType stype;

        TableStructure(NetcdfDataset ds, TableConfig config) {
            super(ds, config);
            this.stype = config.structureType;
            switch (config.structureType) {
                case Structure: {
                    this.struct = (StructureDS)ds.findVariable(config.structName);
                    if (this.struct == null) {
                        throw new IllegalStateException("Cant find Structure " + config.structName);
                    }
                    this.dim = this.struct.getDimension(0);
                    if (config.vars == null) break;
                    this.struct = (StructureDS)this.struct.select(config.vars);
                    break;
                }
                case PsuedoStructure: {
                    this.dim = ds.findDimension(config.dimName);
                    assert (this.dim != null);
                    String name = config.structName == null ? "anon" : config.structName;
                    this.struct = new StructurePseudoDS(ds, this.dim.getGroup(), name, config.vars, this.dim);
                    break;
                }
                case PsuedoStructure2D: {
                    this.dim = ds.findDimension(config.dimName);
                    this.outer = ds.findDimension(config.outerName);
                    assert (this.dim != null);
                    assert (config.outerName != null);
                    this.struct = new StructurePseudo2Dim(ds, this.dim.getGroup(), config.structName, config.vars, this.dim, this.outer);
                }
            }
            config.vars = new ArrayList<String>();
            for (Variable v : this.struct.getVariables()) {
                if (v.getDataType() == DataType.STRUCTURE) {
                    if (config.structureType != TableConfig.StructureType.PsuedoStructure) continue;
                    this.struct.removeMemberVariable(v);
                    continue;
                }
                this.cols.put(v.getShortName(), v);
                config.vars.add(v.getShortName());
            }
        }

        @Override
        protected void showTableExtraInfo(String indent, Formatter f) {
            f.format("%sstruct=%s, dim=%s type=%s%n", indent, this.struct.getNameAndDimensions(), this.dim.getShortName(), this.struct.getClass().getName());
        }

        @Override
        public VariableDS findVariable(String axisName) {
            String structPrefix = this.struct.getShortName() + ".";
            if (axisName.startsWith(structPrefix)) {
                axisName = axisName.substring(structPrefix.length());
            }
            return (VariableDS)this.struct.findVariable(axisName);
        }

        @Override
        public String showDimension() {
            return this.dim.getShortName();
        }

        @Override
        public StructureDataIterator getStructureDataIterator(Cursor cursor) throws IOException {
            return new StructureDataIteratorMediated(this.struct.getStructureIterator(), new RestrictToColumns());
        }

        @Override
        public String getName() {
            return this.stype.toString() + "(" + this.struct.getShortName() + ")";
        }
    }

    public static enum Type {
        ArrayStructure,
        Construct,
        Contiguous,
        LinkedList,
        MultidimInner,
        MultidimInner3D,
        MultidimInnerPsuedo,
        MultidimInnerPsuedo3D,
        MultidimStructure,
        NestedStructure,
        ParentId,
        ParentIndex,
        Singleton,
        Structure,
        Top;

    }

    public static enum CoordName {
        Lat,
        Lon,
        Elev,
        Time,
        TimeNominal,
        StnId,
        StnDesc,
        WmoId,
        StnAlt,
        FeatureId,
        MissingVar;

    }
}

