/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.DataView;
import com.sleepycat.collections.MyRangeCursor;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.JoinConfig;
import com.sleepycat.je.JoinCursor;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.util.keyrange.KeyRange;
import com.sleepycat.util.keyrange.RangeCursor;

final class DataCursor
implements Cloneable {
    static final int REPOS_EXACT = 0;
    static final int REPOS_NEXT = 1;
    static final int REPOS_EOF = 2;
    private RangeCursor cursor;
    private JoinCursor joinCursor;
    private DataView view;
    private KeyRange range;
    private boolean writeAllowed;
    private boolean readUncommitted;
    private DatabaseEntry keyThang;
    private DatabaseEntry valueThang;
    private DatabaseEntry primaryKeyThang;
    private DatabaseEntry otherThang;
    private DataCursor[] indexCursorsToClose;

    DataCursor(DataView view, boolean writeAllowed) throws DatabaseException {
        this.init(view, writeAllowed, null, null);
    }

    DataCursor(DataView view, boolean writeAllowed, CursorConfig config) throws DatabaseException {
        this.init(view, writeAllowed, config, null);
    }

    DataCursor(DataView view, boolean writeAllowed, Object singleKey) throws DatabaseException {
        this.init(view, writeAllowed, null, view.subRange(view.range, singleKey));
    }

    DataCursor(DataView view, boolean writeAllowed, Object beginKey, boolean beginInclusive, Object endKey, boolean endInclusive) throws DatabaseException {
        this.init(view, writeAllowed, null, view.subRange(view.range, beginKey, beginInclusive, endKey, endInclusive));
    }

    DataCursor(DataView view, DataCursor[] indexCursors, JoinConfig joinConfig, boolean closeIndexCursors) throws DatabaseException {
        if (view.isSecondary()) {
            throw new IllegalArgumentException("The primary collection in a join must not be a secondary database");
        }
        Cursor[] cursors = new Cursor[indexCursors.length];
        for (int i = 0; i < cursors.length; ++i) {
            cursors[i] = indexCursors[i].cursor.getCursor();
        }
        this.joinCursor = view.db.join(cursors, joinConfig);
        this.init(view, false, null, null);
        if (closeIndexCursors) {
            this.indexCursorsToClose = indexCursors;
        }
    }

    DataCursor cloneCursor() throws DatabaseException {
        DataCursor o;
        this.checkNoJoinCursor();
        try {
            o = (DataCursor)super.clone();
        }
        catch (CloneNotSupportedException neverHappens) {
            return null;
        }
        o.initThangs();
        KeyRange.copy(this.keyThang, o.keyThang);
        KeyRange.copy(this.valueThang, o.valueThang);
        if (this.primaryKeyThang != this.keyThang) {
            KeyRange.copy(this.primaryKeyThang, o.primaryKeyThang);
        }
        o.cursor = this.cursor.dup(true);
        return o;
    }

    RangeCursor getCursor() {
        return this.cursor;
    }

    private void init(DataView view, boolean writeAllowed, CursorConfig config, KeyRange range) throws DatabaseException {
        if (config == null) {
            config = view.cursorConfig;
        }
        this.view = view;
        this.writeAllowed = writeAllowed && view.writeAllowed;
        this.range = range != null ? range : view.range;
        this.readUncommitted = config.getReadUncommitted() || view.currentTxn.isReadUncommitted();
        this.initThangs();
        if (this.joinCursor == null) {
            this.cursor = new MyRangeCursor(this.range, config, view, this.writeAllowed);
        }
    }

    private void initThangs() {
        this.keyThang = new DatabaseEntry();
        this.primaryKeyThang = this.view.isSecondary() ? new DatabaseEntry() : this.keyThang;
        this.valueThang = new DatabaseEntry();
    }

    private void setThangs(byte[] keyBytes, byte[] priKeyBytes, byte[] valueBytes) {
        this.keyThang.setData(KeyRange.copyBytes(keyBytes));
        if (this.keyThang != this.primaryKeyThang) {
            this.primaryKeyThang.setData(KeyRange.copyBytes(priKeyBytes));
        }
        this.valueThang.setData(KeyRange.copyBytes(valueBytes));
    }

    void close() throws DatabaseException {
        DataCursor[] toClose;
        if (this.joinCursor != null) {
            toClose = this.joinCursor;
            this.joinCursor = null;
            toClose.close();
        }
        if (this.cursor != null) {
            toClose = this.cursor.getCursor();
            this.cursor = null;
            this.view.currentTxn.closeCursor((Cursor)toClose);
        }
        if (this.indexCursorsToClose != null) {
            toClose = this.indexCursorsToClose;
            this.indexCursorsToClose = null;
            for (int i = 0; i < toClose.length; ++i) {
                toClose[i].close();
            }
        }
    }

    int repositionRange(byte[] keyBytes, byte[] priKeyBytes, byte[] valueBytes, boolean lockForWrite) throws DatabaseException {
        LockMode lockMode = this.getLockMode(lockForWrite);
        OperationStatus status = null;
        this.setThangs(keyBytes, priKeyBytes, valueBytes);
        if (this.view.dupsAllowed) {
            status = this.cursor.getSearchBothRange(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
        }
        if (status != OperationStatus.SUCCESS) {
            status = this.cursor.getSearchKeyRange(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
        }
        if (status == OperationStatus.SUCCESS) {
            if (!KeyRange.equalBytes(keyBytes, 0, keyBytes.length, this.keyThang.getData(), this.keyThang.getOffset(), this.keyThang.getSize())) {
                return 1;
            }
            if (this.view.dupsAllowed) {
                byte[] bytes;
                DatabaseEntry thang = this.view.isSecondary() ? this.primaryKeyThang : this.valueThang;
                byte[] byArray = bytes = this.view.isSecondary() ? priKeyBytes : valueBytes;
                if (!KeyRange.equalBytes(bytes, 0, bytes.length, thang.getData(), thang.getOffset(), thang.getSize())) {
                    return 1;
                }
            }
            return 0;
        }
        return 2;
    }

    boolean repositionExact(byte[] keyBytes, byte[] priKeyBytes, byte[] valueBytes, boolean lockForWrite) throws DatabaseException {
        LockMode lockMode = this.getLockMode(lockForWrite);
        OperationStatus status = null;
        this.setThangs(keyBytes, priKeyBytes, valueBytes);
        status = this.view.recNumRenumber ? this.cursor.getSearchKey(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode) : this.cursor.getSearchBoth(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
        return status == OperationStatus.SUCCESS;
    }

    DataView getView() {
        return this.view;
    }

    KeyRange getRange() {
        return this.range;
    }

    boolean isWriteAllowed() {
        return this.writeAllowed;
    }

    Object getCurrentKey() {
        return this.view.makeKey(this.keyThang, this.primaryKeyThang);
    }

    Object getCurrentValue() {
        return this.view.makeValue(this.primaryKeyThang, this.valueThang);
    }

    DatabaseEntry getKeyThang() {
        return this.keyThang;
    }

    DatabaseEntry getPrimaryKeyThang() {
        return this.primaryKeyThang;
    }

    DatabaseEntry getValueThang() {
        return this.valueThang;
    }

    boolean hasRecNumAccess() {
        return this.view.recNumAccess;
    }

    int getCurrentRecordNumber() throws DatabaseException {
        if (this.view.btreeRecNumDb) {
            if (this.otherThang == null) {
                this.otherThang = new DatabaseEntry();
            }
            DbCompat.getCurrentRecordNumber(this.cursor.getCursor(), this.otherThang, this.getLockMode(false));
            return DbCompat.getRecordNumber(this.otherThang);
        }
        return DbCompat.getRecordNumber(this.keyThang);
    }

    OperationStatus getCurrent(boolean lockForWrite) throws DatabaseException {
        this.checkNoJoinCursor();
        return this.cursor.getCurrent(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(lockForWrite));
    }

    OperationStatus getFirst(boolean lockForWrite) throws DatabaseException {
        LockMode lockMode = this.getLockMode(lockForWrite);
        if (this.joinCursor != null) {
            return this.joinCursor.getNext(this.keyThang, this.valueThang, lockMode);
        }
        return this.cursor.getFirst(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
    }

    OperationStatus getNext(boolean lockForWrite) throws DatabaseException {
        LockMode lockMode = this.getLockMode(lockForWrite);
        if (this.joinCursor != null) {
            return this.joinCursor.getNext(this.keyThang, this.valueThang, lockMode);
        }
        return this.cursor.getNext(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
    }

    OperationStatus getNextNoDup(boolean lockForWrite) throws DatabaseException {
        LockMode lockMode = this.getLockMode(lockForWrite);
        if (this.joinCursor != null) {
            return this.joinCursor.getNext(this.keyThang, this.valueThang, lockMode);
        }
        if (this.view.dupsView) {
            return this.cursor.getNext(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
        }
        return this.cursor.getNextNoDup(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
    }

    OperationStatus getNextDup(boolean lockForWrite) throws DatabaseException {
        this.checkNoJoinCursor();
        if (this.view.dupsView) {
            return null;
        }
        return this.cursor.getNextDup(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(lockForWrite));
    }

    OperationStatus getLast(boolean lockForWrite) throws DatabaseException {
        this.checkNoJoinCursor();
        return this.cursor.getLast(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(lockForWrite));
    }

    OperationStatus getPrev(boolean lockForWrite) throws DatabaseException {
        this.checkNoJoinCursor();
        return this.cursor.getPrev(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(lockForWrite));
    }

    OperationStatus getPrevNoDup(boolean lockForWrite) throws DatabaseException {
        this.checkNoJoinCursor();
        LockMode lockMode = this.getLockMode(lockForWrite);
        if (this.view.dupsView) {
            return null;
        }
        if (this.view.dupsView) {
            return this.cursor.getPrev(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
        }
        return this.cursor.getPrevNoDup(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
    }

    OperationStatus getPrevDup(boolean lockForWrite) throws DatabaseException {
        this.checkNoJoinCursor();
        if (this.view.dupsView) {
            return null;
        }
        return this.cursor.getPrevDup(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(lockForWrite));
    }

    OperationStatus getSearchKey(Object key, Object value, boolean lockForWrite) throws DatabaseException {
        this.checkNoJoinCursor();
        if (this.view.dupsView) {
            if (this.view.useKey(key, value, this.primaryKeyThang, this.view.dupsRange)) {
                KeyRange.copy(this.view.dupsKey, this.keyThang);
                return this.cursor.getSearchBoth(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(lockForWrite));
            }
        } else if (this.view.useKey(key, value, this.keyThang, this.range)) {
            return this.doGetSearchKey(lockForWrite);
        }
        return OperationStatus.NOTFOUND;
    }

    private OperationStatus doGetSearchKey(boolean lockForWrite) throws DatabaseException {
        LockMode lockMode = this.getLockMode(lockForWrite);
        if (this.view.btreeRecNumAccess) {
            return this.cursor.getSearchRecordNumber(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
        }
        return this.cursor.getSearchKey(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
    }

    OperationStatus getSearchKeyRange(Object key, Object value, boolean lockForWrite) throws DatabaseException {
        this.checkNoJoinCursor();
        LockMode lockMode = this.getLockMode(lockForWrite);
        if (this.view.dupsView) {
            if (this.view.useKey(key, value, this.primaryKeyThang, this.view.dupsRange)) {
                KeyRange.copy(this.view.dupsKey, this.keyThang);
                return this.cursor.getSearchBothRange(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
            }
        } else if (this.view.useKey(key, value, this.keyThang, this.range)) {
            return this.cursor.getSearchKeyRange(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
        }
        return OperationStatus.NOTFOUND;
    }

    OperationStatus findBoth(Object key, Object value, boolean lockForWrite) throws DatabaseException {
        this.checkNoJoinCursor();
        LockMode lockMode = this.getLockMode(lockForWrite);
        this.view.useValue(value, this.valueThang, null);
        if (this.view.dupsView) {
            if (this.view.useKey(key, value, this.primaryKeyThang, this.view.dupsRange)) {
                OperationStatus status;
                KeyRange.copy(this.view.dupsKey, this.keyThang);
                if (this.otherThang == null) {
                    this.otherThang = new DatabaseEntry();
                }
                if ((status = this.cursor.getSearchBoth(this.keyThang, this.primaryKeyThang, this.otherThang, lockMode)) == OperationStatus.SUCCESS && KeyRange.equalBytes(this.otherThang, this.valueThang)) {
                    return status;
                }
            }
        } else if (this.view.useKey(key, value, this.keyThang, this.range)) {
            if (this.view.isSecondary()) {
                if (this.otherThang == null) {
                    this.otherThang = new DatabaseEntry();
                }
                OperationStatus status = this.cursor.getSearchKey(this.keyThang, this.primaryKeyThang, this.otherThang, lockMode);
                while (status == OperationStatus.SUCCESS) {
                    if (KeyRange.equalBytes(this.otherThang, this.valueThang)) {
                        return status;
                    }
                    status = this.cursor.getNextDup(this.keyThang, this.primaryKeyThang, this.otherThang, lockMode);
                }
            } else {
                return this.cursor.getSearchBoth(this.keyThang, null, this.valueThang, lockMode);
            }
        }
        return OperationStatus.NOTFOUND;
    }

    OperationStatus findValue(Object value, boolean findFirst) throws DatabaseException {
        OperationStatus status;
        this.checkNoJoinCursor();
        if (!(this.view.entityBinding == null || this.view.isSecondary() || !findFirst && this.view.dupsAllowed)) {
            return this.findBoth(null, value, false);
        }
        if (this.otherThang == null) {
            this.otherThang = new DatabaseEntry();
        }
        this.view.useValue(value, this.otherThang, null);
        OperationStatus operationStatus = status = findFirst ? this.getFirst(false) : this.getLast(false);
        while (status == OperationStatus.SUCCESS && !KeyRange.equalBytes(this.valueThang, this.otherThang)) {
            status = findFirst ? this.getNext(false) : this.getPrev(false);
        }
        return status;
    }

    int count() throws DatabaseException {
        this.checkNoJoinCursor();
        if (this.view.dupsView) {
            return 1;
        }
        return this.cursor.count();
    }

    OperationStatus putCurrent(Object value) throws DatabaseException {
        boolean hashWorkaround;
        this.checkWriteAllowed(false);
        this.view.useValue(value, this.valueThang, this.keyThang);
        boolean bl = hashWorkaround = this.view.dupsOrdered && !this.view.ordered;
        if (hashWorkaround) {
            if (this.otherThang == null) {
                this.otherThang = new DatabaseEntry();
            }
            this.cursor.getCurrent(this.keyThang, this.primaryKeyThang, this.otherThang, LockMode.DEFAULT);
            if (KeyRange.equalBytes(this.valueThang, this.otherThang)) {
                return OperationStatus.SUCCESS;
            }
            throw new IllegalArgumentException("Current data differs from put data with sorted duplicates");
        }
        return this.cursor.putCurrent(this.valueThang);
    }

    OperationStatus putAfter(Object value) throws DatabaseException {
        this.checkWriteAllowed(false);
        this.view.useValue(value, this.valueThang, null);
        return this.cursor.putAfter(this.keyThang, this.valueThang);
    }

    OperationStatus putBefore(Object value) throws DatabaseException {
        this.checkWriteAllowed(false);
        this.view.useValue(value, this.valueThang, this.keyThang);
        return this.cursor.putBefore(this.keyThang, this.valueThang);
    }

    OperationStatus put(Object key, Object value, Object[] oldValue, boolean useCurrentKey) throws DatabaseException {
        this.initForPut(key, value, oldValue, useCurrentKey);
        return this.cursor.put(this.keyThang, this.valueThang);
    }

    OperationStatus putNoOverwrite(Object key, Object value, boolean useCurrentKey) throws DatabaseException {
        this.initForPut(key, value, null, useCurrentKey);
        return this.cursor.putNoOverwrite(this.keyThang, this.valueThang);
    }

    OperationStatus putNoDupData(Object key, Object value, Object[] oldValue, boolean useCurrentKey) throws DatabaseException {
        this.initForPut(key, value, oldValue, useCurrentKey);
        if (this.view.dupsOrdered) {
            return this.cursor.putNoDupData(this.keyThang, this.valueThang);
        }
        if (this.view.dupsAllowed) {
            OperationStatus status = this.cursor.getSearchBoth(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(false));
            if (status == OperationStatus.SUCCESS) {
                return OperationStatus.KEYEXIST;
            }
            return this.cursor.put(this.keyThang, this.valueThang);
        }
        return this.cursor.putNoOverwrite(this.keyThang, this.valueThang);
    }

    private void initForPut(Object key, Object value, Object[] oldValue, boolean useCurrentKey) throws DatabaseException {
        this.checkWriteAllowed(false);
        if (!useCurrentKey && !this.view.useKey(key, value, this.keyThang, this.range)) {
            throw new IllegalArgumentException("key out of range");
        }
        if (oldValue != null) {
            OperationStatus status;
            oldValue[0] = null;
            if (!this.view.dupsAllowed && (status = this.doGetSearchKey(true)) == OperationStatus.SUCCESS) {
                oldValue[0] = this.getCurrentValue();
            }
        }
        this.view.useValue(value, this.valueThang, this.keyThang);
    }

    void useRangeKey() {
        if (!this.range.isSingleKey()) {
            throw DbCompat.unexpectedState();
        }
        KeyRange.copy(this.range.getSingleKey(), this.keyThang);
    }

    OperationStatus delete() throws DatabaseException {
        this.checkWriteAllowed(true);
        return this.cursor.delete();
    }

    LockMode getLockMode(boolean lockForWrite) {
        if (this.readUncommitted) {
            return LockMode.READ_UNCOMMITTED;
        }
        if (lockForWrite) {
            return this.view.currentTxn.getWriteLockMode();
        }
        return LockMode.DEFAULT;
    }

    private void checkNoJoinCursor() {
        if (this.joinCursor != null) {
            throw new UnsupportedOperationException("Not allowed with a join cursor");
        }
    }

    private void checkWriteAllowed(boolean allowSecondary) {
        this.checkNoJoinCursor();
        if (!this.writeAllowed || !allowSecondary && this.view.isSecondary()) {
            throw new UnsupportedOperationException("Writing is not allowed");
        }
    }
}

