/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateEns;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.CoordinateVert;
import ucar.coord.SparseArray;
import ucar.nc2.constants.CDM;
import ucar.nc2.grib.collection.GcMFile;
import ucar.nc2.grib.collection.Grib1CollectionBuilder;
import ucar.nc2.grib.collection.GribCollectionBuilder;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.collection.GribCollectionWriter;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.Grib1SectionIndicator;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.stream.NcStream;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.io.RandomAccessFile;

class Grib1CollectionWriter
extends GribCollectionWriter {
    public static final String MAGIC_START = "Grib1Collectio2Index";
    protected static final int minVersion = 1;
    protected static final int version = 3;

    protected Grib1CollectionWriter(MCollection dcm, Logger logger) {
        super(dcm, logger);
    }

    /*
     * Loose catch block
     */
    boolean writeIndex(String name, File idxFile, CoordinateRuntime masterRuntime, List<Group> groups, List<MFile> files, GribCollectionImmutable.Type type, CalendarDateRange dateRange) throws IOException {
        Grib1Record first = null;
        boolean deleteOnClose = false;
        if (idxFile.exists()) {
            RandomAccessFile.eject(idxFile.getPath());
            if (!idxFile.delete()) {
                this.logger.warn(" gc1 cant delete index file {}", (Object)idxFile.getPath());
            }
        }
        this.logger.debug(" createIndex for {}", (Object)idxFile.getPath());
        try {
            try (RandomAccessFile raf = new RandomAccessFile(idxFile.getPath(), "rw");){
                Object b;
                raf.order(0);
                raf.write(MAGIC_START.getBytes(CDM.utf8Charset));
                raf.writeInt(3);
                long lenPos = raf.getFilePointer();
                raf.writeLong(0L);
                long countBytes = 0L;
                int countRecords = 0;
                HashSet<Integer> allFileSet = new HashSet<Integer>();
                for (Group g : groups) {
                    g.fileSet = new HashSet<Integer>();
                    for (Grib1CollectionBuilder.VariableBag vb : g.gribVars) {
                        if (first == null) {
                            first = vb.first;
                        }
                        GribCollectionProto.SparseArray vr = this.writeSparseArray(vb, g.fileSet);
                        byte[] b2 = vr.toByteArray();
                        vb.pos = raf.getFilePointer();
                        vb.length = b2.length;
                        raf.write(b2);
                        countBytes += (long)b2.length;
                        countRecords += vb.coordND.getSparseArray().countNotMissing();
                    }
                    Iterator<Comparable<Grib1CollectionBuilder.VariableBag>> iterator = g.fileSet.iterator();
                    while (iterator.hasNext()) {
                        int index = (Integer)iterator.next();
                        allFileSet.add(index);
                    }
                }
                long bytesPerRecord = countBytes / (long)(countRecords == 0 ? 1 : countRecords);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("  write RecordMaps: bytes = {} records = {} bytesPerRecord={}", countBytes, countRecords, bytesPerRecord);
                }
                if (first == null) {
                    deleteOnClose = true;
                    throw new IOException("GribCollection " + name + " has no records");
                }
                long pos = raf.getFilePointer();
                raf.seek(lenPos);
                raf.writeLong(countBytes);
                raf.seek(pos);
                GribCollectionProto.GribCollection.Builder indexBuilder = GribCollectionProto.GribCollection.newBuilder();
                indexBuilder.setName(name);
                indexBuilder.setTopDir(this.dcm.getRoot());
                indexBuilder.setVersion(1);
                File directory = new File(this.dcm.getRoot());
                List<GcMFile> gcmfiles = GcMFile.makeFiles(directory, files, allFileSet);
                for (GcMFile gcmfile : gcmfiles) {
                    b = GribCollectionProto.MFile.newBuilder();
                    ((GribCollectionProto.MFile.Builder)b).setFilename(gcmfile.getName());
                    ((GribCollectionProto.MFile.Builder)b).setLastModified(gcmfile.getLastModified());
                    ((GribCollectionProto.MFile.Builder)b).setLength(gcmfile.getLength());
                    ((GribCollectionProto.MFile.Builder)b).setIndex(gcmfile.index);
                    indexBuilder.addMfiles(((GribCollectionProto.MFile.Builder)b).build());
                }
                indexBuilder.setMasterRuntime(this.writeCoordProto(masterRuntime));
                for (Group g : groups) {
                    indexBuilder.addGds(Grib1CollectionWriter.writeGdsProto(g.gdss.getRawBytes(), g.gdss.getPredefinedGridDefinition()));
                }
                indexBuilder.addDataset(this.writeDatasetProto(type, groups));
                Grib1SectionProductDefinition pds = first.getPDSsection();
                indexBuilder.setCenter(pds.getCenter());
                indexBuilder.setSubcenter(pds.getSubCenter());
                indexBuilder.setLocal(pds.getTableVersion());
                indexBuilder.setMaster(0);
                indexBuilder.setGenProcessId(pds.getGenProcess());
                indexBuilder.setStartTime(dateRange.getStart().getMillis());
                indexBuilder.setEndTime(dateRange.getEnd().getMillis());
                GribCollectionProto.GribCollection index = indexBuilder.build();
                b = index.toByteArray();
                NcStream.writeVInt(raf, ((Object)b).length);
                raf.write((byte[])b);
                this.logger.debug("  write GribCollectionIndex= {} bytes", (Object)((Object)b).length);
                this.logger.debug("  file size =  %d bytes", (Object)raf.length());
                boolean bl = true;
                return bl;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (deleteOnClose && !idxFile.delete()) {
                this.logger.error(" gc1 cant deleteOnClose index file {}", (Object)idxFile.getPath());
            }
        }
    }

    private GribCollectionProto.SparseArray writeSparseArray(Grib1CollectionBuilder.VariableBag vb, Set<Integer> fileSet) throws IOException {
        GribCollectionProto.SparseArray.Builder b = GribCollectionProto.SparseArray.newBuilder();
        SparseArray<Grib1Record> sa = vb.coordND.getSparseArray();
        for (int size : sa.getShape()) {
            b.addSize(size);
        }
        for (int track : sa.getTrack()) {
            b.addTrack(track);
        }
        Object object = sa.getContent().iterator();
        while (object.hasNext()) {
            Grib1Record gr = (Grib1Record)object.next();
            GribCollectionProto.Record.Builder br = GribCollectionProto.Record.newBuilder();
            br.setFileno(gr.getFile());
            fileSet.add(gr.getFile());
            Grib1SectionIndicator is = gr.getIs();
            br.setStartPos(is.getStartPos());
            b.addRecords(br);
        }
        b.setNdups(sa.getNdups());
        return b.build();
    }

    private GribCollectionProto.Dataset writeDatasetProto(GribCollectionImmutable.Type type, List<Group> groups) throws IOException {
        GribCollectionProto.Dataset.Builder b = GribCollectionProto.Dataset.newBuilder();
        GribCollectionProto.Dataset.Type ptype = GribCollectionProto.Dataset.Type.valueOf(type.toString());
        b.setType(ptype);
        for (Group group : groups) {
            b.addGroups(this.writeGroupProto(group));
        }
        return b.build();
    }

    protected GribCollectionProto.Group writeGroupProto(Group g) throws IOException {
        GribCollectionProto.Group.Builder b = GribCollectionProto.Group.newBuilder();
        b.setGds(Grib1CollectionWriter.writeGdsProto(g.gdss.getRawBytes(), g.gdss.getPredefinedGridDefinition()));
        for (Grib1CollectionBuilder.VariableBag vbag : g.gribVars) {
            b.addVariables(this.writeVariableProto(vbag));
        }
        for (Coordinate coord : g.coords) {
            switch (coord.getType()) {
                case runtime: {
                    b.addCoords(this.writeCoordProto((CoordinateRuntime)coord));
                    break;
                }
                case time: {
                    b.addCoords(this.writeCoordProto((CoordinateTime)coord));
                    break;
                }
                case timeIntv: {
                    b.addCoords(this.writeCoordProto((CoordinateTimeIntv)coord));
                    break;
                }
                case time2D: {
                    b.addCoords(this.writeCoordProto((CoordinateTime2D)coord));
                    break;
                }
                case vert: {
                    b.addCoords(this.writeCoordProto((CoordinateVert)coord));
                    break;
                }
                case ens: {
                    b.addCoords(this.writeCoordProto((CoordinateEns)coord));
                }
            }
        }
        for (Integer aFileSet : g.fileSet) {
            b.addFileno(aFileSet);
        }
        return b.build();
    }

    private GribCollectionProto.Variable writeVariableProto(Grib1CollectionBuilder.VariableBag vb) throws IOException {
        GribCollectionProto.Variable.Builder b = GribCollectionProto.Variable.newBuilder();
        b.setDiscipline(0);
        b.setPds(ByteString.copyFrom(vb.first.getPDSsection().getRawBytes()));
        b.setRecordsPos(vb.pos);
        b.setRecordsLen(vb.length);
        for (int idx : vb.coordIndex) {
            b.addCoordIdx(idx);
        }
        SparseArray<Grib1Record> sa = vb.coordND.getSparseArray();
        if (sa != null) {
            b.setNdups(sa.getNdups());
            b.setNrecords(sa.countNotMissing());
            b.setMissing(sa.countMissing());
        }
        return b.build();
    }

    static class Group
    implements GribCollectionBuilder.Group {
        final Grib1SectionGridDefinition gdss;
        final int hashCode;
        final CalendarDate runtime;
        public List<Grib1CollectionBuilder.VariableBag> gribVars;
        public List<Coordinate> coords;
        public Set<Long> runtimes = new HashSet<Long>();
        public List<Grib1Record> records = new ArrayList<Grib1Record>();
        public Set<Integer> fileSet;

        Group(Grib1SectionGridDefinition gdss, int hashCode, CalendarDate runtime) {
            this.gdss = gdss;
            this.hashCode = hashCode;
            this.runtime = runtime;
        }

        @Override
        public CalendarDate getRuntime() {
            return this.runtime;
        }

        @Override
        public List<Coordinate> getCoordinates() {
            return this.coords;
        }

        @Override
        public Set<Long> getCoordinateRuntimes() {
            return this.runtimes;
        }
    }
}

