/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.util.Arrays;
import java.util.Formatter;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.QuasiRegular;
import ucar.nc2.grib.grib2.GdsSpherical;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.EarthEllipsoid;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.geoloc.projection.RotatedPole;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.proj4.AlbersEqualAreaEllipse;
import ucar.unidata.geoloc.projection.proj4.LambertConformalConicEllipse;
import ucar.unidata.geoloc.projection.proj4.StereographicAzimuthalProjection;
import ucar.unidata.geoloc.projection.sat.MSGnavigation;

@Immutable
public abstract class Grib2Gds {
    private static final Logger log = LoggerFactory.getLogger(Grib2Gds.class);
    public static final double maxReletiveErrorPos = 0.01;
    private static final float scale3 = 0.001f;
    private static final float scale6 = 1.0E-6f;
    protected final byte[] data;
    public int template;
    public int center;
    public float earthRadius;
    public float majorAxis;
    public float minorAxis;
    protected int scanMode;
    public int earthShape;
    private int nx;
    private int ny;
    protected int[] nptsInLine;
    protected int lastOctet;
    protected int hashCode = 0;

    public static Grib2Gds factory(int template, byte[] data) {
        Grib2Gds result;
        switch (template) {
            case 0: {
                result = new LatLon(data);
                break;
            }
            case 1: {
                result = new RotatedLatLon(data);
                break;
            }
            case 10: {
                result = new Mercator(data);
                break;
            }
            case 20: {
                result = new PolarStereographic(data);
                break;
            }
            case 30: {
                result = new LambertConformal(data, 30);
                break;
            }
            case 31: {
                result = new AlbersEqualArea(data);
                break;
            }
            case 40: {
                result = new GaussLatLon(data);
                break;
            }
            case 50: {
                result = new GdsSpherical(data, template);
                break;
            }
            case 90: {
                result = new SpaceViewPerspective(data);
                break;
            }
            case 204: {
                result = new CurvilinearOrthogonal(data);
                break;
            }
            case 32769: {
                result = new RotatedLatLon32769(data);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported GDS type = " + template);
            }
        }
        result.finish();
        return result;
    }

    protected Grib2Gds(byte[] data) {
        this.data = data;
    }

    protected Grib2Gds(byte[] data, int template) {
        this.data = data;
        this.template = template;
        this.earthShape = this.getOctet(15);
        this.earthRadius = this.getScaledValue(16);
        this.majorAxis = this.getScaledValue(21);
        this.minorAxis = this.getScaledValue(26);
        this.nx = this.getOctet4(31);
        this.ny = this.getOctet4(35);
    }

    protected void finish() {
        if (this.isThin()) {
            this.readNptsInLine();
        }
    }

    public abstract GdsHorizCoordSys makeHorizCoordSys();

    public abstract void testHorizCoordSys(Formatter var1);

    public void testScanMode(Formatter f) {
    }

    public int getNx() {
        if (this.nptsInLine == null || this.nx > 0) {
            return this.nx;
        }
        return QuasiRegular.getMax(this.nptsInLine);
    }

    public int getNy() {
        if (this.nptsInLine == null || this.ny > 0) {
            return this.ny;
        }
        return QuasiRegular.getMax(this.nptsInLine);
    }

    public int getNxRaw() {
        return this.nx;
    }

    public int getNyRaw() {
        return this.ny;
    }

    public int[] getNptsInLine() {
        return this.nptsInLine;
    }

    public byte[] getRawBytes() {
        return this.data;
    }

    public int getScanMode() {
        return this.scanMode;
    }

    public void setCenter(int center) {
        this.center = center;
    }

    public boolean isLatLon() {
        return false;
    }

    public String getNameShort() {
        String className = this.getClass().getName();
        int pos = className.lastIndexOf("$");
        return className.substring(pos + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Grib2Gds grib2Gds = (Grib2Gds)o;
        if (this.nx != grib2Gds.nx) {
            return false;
        }
        if (this.ny != grib2Gds.ny) {
            return false;
        }
        if (this.template != grib2Gds.template) {
            return false;
        }
        return Arrays.equals(this.nptsInLine, grib2Gds.nptsInLine);
    }

    public int hashCode() {
        int result = this.template;
        result = 31 * result + this.nx;
        result = 31 * result + this.ny;
        if (this.nptsInLine != null) {
            result = 31 * result + Arrays.hashCode(this.nptsInLine);
        }
        return result;
    }

    public boolean isThin() {
        boolean isThin;
        boolean bl = isThin = this.getOctet(11) != 0;
        assert (!isThin || this.nx < 0 || this.ny < 0);
        return isThin;
    }

    protected void readNptsInLine() {
        int numOctetsPerNumber = this.getOctet(11);
        int octet12 = this.getOctet(12);
        if (octet12 != 1) {
            throw new IllegalArgumentException("Thin grid octet 12 =" + octet12);
        }
        int numPts = this.nx > 0 ? this.nx : this.ny;
        int[] parallels = new int[numPts];
        int offset = this.lastOctet;
        block5: for (int i = 0; i < numPts; ++i) {
            switch (numOctetsPerNumber) {
                case 1: {
                    parallels[i] = this.getOctet(offset++);
                    continue block5;
                }
                case 2: {
                    parallels[i] = GribNumbers.int2(this.getOctet(offset++), this.getOctet(offset++));
                    continue block5;
                }
                case 4: {
                    parallels[i] = this.getOctet4(offset);
                    offset += 4;
                }
                default: {
                    throw new IllegalArgumentException("Illegal numOctetsPerNumber in thin grid =" + numOctetsPerNumber);
                }
            }
        }
        this.nptsInLine = parallels;
    }

    protected int getOctet(int index) {
        return this.data[index - 1] & 0xFF;
    }

    protected int getOctetSigned(int index) {
        return GribNumbers.convertSignedByte(this.data[index - 1]);
    }

    protected int getOctet4(int start) {
        return GribNumbers.int4(this.getOctet(start), this.getOctet(start + 1), this.getOctet(start + 2), this.getOctet(start + 3));
    }

    protected float getScaledValue(int start) {
        int scaleFactor = this.getOctetSigned(start);
        int scaleValue = this.getOctet4(start + 1);
        if (scaleFactor != 0) {
            return (float)((double)scaleValue / Math.pow(10.0, scaleFactor));
        }
        return scaleValue;
    }

    protected Earth getEarth() {
        switch (this.earthShape) {
            case 0: {
                return new Earth(6367470.0);
            }
            case 1: {
                if (this.earthRadius < 6000000.0f) {
                    this.earthRadius = (float)((double)this.earthRadius * 1000.0);
                }
                return new Earth(this.earthRadius);
            }
            case 2: {
                return EarthEllipsoid.IAU;
            }
            case 3: {
                if (this.majorAxis < 6000000.0f) {
                    this.majorAxis = (float)((double)this.majorAxis * 1000.0);
                }
                if (this.minorAxis < 6000000.0f) {
                    this.minorAxis = (float)((double)this.minorAxis * 1000.0);
                }
                return new EarthEllipsoid("Grib2 Type 3", -1, this.majorAxis, this.minorAxis, 0.0);
            }
            case 4: {
                return EarthEllipsoid.IAG_GRS80;
            }
            case 5: {
                return EarthEllipsoid.WGS84;
            }
            case 6: {
                return new Earth(6371229.0);
            }
            case 7: {
                if (this.majorAxis < 6000000.0f) {
                    this.majorAxis = (float)((double)this.majorAxis * 1000.0);
                }
                if (this.minorAxis < 6000000.0f) {
                    this.minorAxis = (float)((double)this.minorAxis * 1000.0);
                }
                return new EarthEllipsoid("Grib2 Type 7", -1, this.majorAxis, this.minorAxis, 0.0);
            }
            case 8: {
                return new Earth(6371200.0);
            }
            case 9: {
                return EarthEllipsoid.Airy1830;
            }
        }
        return new Earth();
    }

    public static class CurvilinearOrthogonal
    extends Grib2Gds {
        public int flags = this.getOctet(55);

        CurvilinearOrthogonal(byte[] data) {
            super(data, 204);
            this.scanMode = this.getOctet(72);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CurvilinearOrthogonal that = (CurvilinearOrthogonal)o;
            return this.flags == that.flags;
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int result = super.hashCode();
                this.hashCode = result = 31 * result + this.flags;
            }
            return this.hashCode;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            LatLonProjection proj = new LatLonProjection();
            return new GdsHorizCoordSys(this.getNameShort(), this.template, this.getOctet4(7), this.scanMode, proj, 0.0, 1.0, 0.0, 1.0, this.getNxRaw(), this.getNyRaw(), this.getNptsInLine());
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
        }
    }

    public static class SpaceViewPerspective
    extends Grib2Gds {
        public float LaP = (float)this.getOctet4(39) * 1.0E-6f;
        public float LoP = (float)this.getOctet4(43) * 1.0E-6f;
        public float dX;
        public float dY;
        public float Xp;
        public float Yp;
        public float Nr;
        public float Xo;
        public float Yo;
        public int flags = this.getOctet(47);

        SpaceViewPerspective(byte[] data) {
            super(data, 90);
            this.dX = this.getOctet4(48);
            this.dY = this.getOctet4(52);
            this.Xp = (float)this.getOctet4(56) * 0.001f;
            this.Yp = (float)this.getOctet4(60) * 0.001f;
            this.scanMode = this.getOctet(64);
            this.Nr = (float)this.getOctet4(69) * 1.0E-6f;
            this.Xo = (float)this.getOctet4(73) * 1.0E-6f;
            this.Yo = (float)this.getOctet4(77) * 1.0E-6f;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SpaceViewPerspective that = (SpaceViewPerspective)o;
            if (Float.compare(that.LaP, this.LaP) != 0) {
                return false;
            }
            if (Float.compare(that.LoP, this.LoP) != 0) {
                return false;
            }
            if (Float.compare(that.Nr, this.Nr) != 0) {
                return false;
            }
            if (Float.compare(that.Xo, this.Xo) != 0) {
                return false;
            }
            if (Float.compare(that.Xp, this.Xp) != 0) {
                return false;
            }
            if (Float.compare(that.Yo, this.Yo) != 0) {
                return false;
            }
            if (Float.compare(that.Yp, this.Yp) != 0) {
                return false;
            }
            if (Float.compare(that.dX, this.dX) != 0) {
                return false;
            }
            if (Float.compare(that.dY, this.dY) != 0) {
                return false;
            }
            return this.flags == that.flags;
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int result = super.hashCode();
                result = 31 * result + (this.LaP != 0.0f ? Float.floatToIntBits(this.LaP) : 0);
                result = 31 * result + (this.LoP != 0.0f ? Float.floatToIntBits(this.LoP) : 0);
                result = 31 * result + (this.dX != 0.0f ? Float.floatToIntBits(this.dX) : 0);
                result = 31 * result + (this.dY != 0.0f ? Float.floatToIntBits(this.dY) : 0);
                result = 31 * result + (this.Xp != 0.0f ? Float.floatToIntBits(this.Xp) : 0);
                result = 31 * result + (this.Yp != 0.0f ? Float.floatToIntBits(this.Yp) : 0);
                result = 31 * result + (this.Nr != 0.0f ? Float.floatToIntBits(this.Nr) : 0);
                result = 31 * result + (this.Xo != 0.0f ? Float.floatToIntBits(this.Xo) : 0);
                result = 31 * result + (this.Yo != 0.0f ? Float.floatToIntBits(this.Yo) : 0);
                this.hashCode = result = 31 * result + this.flags;
            }
            return this.hashCode;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            double incry;
            double starty;
            double scale_factor;
            if (this.center == 254) {
                if (this.dY < 2100.0f) {
                    this.dX = 1207.0f;
                    this.dY = 1203.0f;
                } else {
                    this.dX = 3622.0f;
                    this.dY = 3610.0f;
                }
            }
            double as = 2.0 * Math.asin(1.0 / (double)this.Nr);
            double cfac = (double)this.dX / as;
            double lfac = (double)this.dY / as;
            this.getEarth();
            double scale_x = scale_factor = (double)((this.Nr - 1.0f) * this.majorAxis / 1000.0f);
            double scale_y = -scale_factor;
            double startx = scale_factor * (double)(1.0f - this.Xp) / cfac;
            double incrx = scale_factor / cfac;
            boolean yscanPositive = GribUtils.scanModeYisPositive(this.scanMode);
            if (yscanPositive) {
                starty = scale_factor * (double)(this.Yp - (float)this.getNy()) / lfac;
                incry = scale_factor / lfac;
            } else {
                incry = -(scale_factor / lfac);
                starty = scale_factor * (double)(this.Yp - (float)this.getNy()) / lfac - incry * (double)(this.getNy() - 1);
            }
            MSGnavigation proj = new MSGnavigation(this.LaP, this.LoP, this.majorAxis, this.minorAxis, this.Nr * this.majorAxis, scale_x, scale_y);
            return new GdsHorizCoordSys(this.getNameShort(), this.template, this.getOctet4(7), this.scanMode, proj, startx, incrx, starty, incry, this.getNxRaw(), this.getNyRaw(), this.getNptsInLine());
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            f.format("%s testProjection%n", this.getClass().getName());
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            double endx = cs.startx + (double)(this.getNx() - 1) * cs.dx;
            double endy = cs.starty + (double)(this.getNy() - 1) * cs.dy;
            ProjectionPointImpl endPP = new ProjectionPointImpl(endx, endy);
            f.format("   start at proj coord= %s%n", new ProjectionPointImpl(cs.startx, cs.starty));
            f.format("     end at proj coord= %s%n", endPP);
            LatLonPointImpl startLL = new LatLonPointImpl(this.LaP, this.LoP);
            LatLonPoint endLL = cs.proj.projToLatLon(endPP, new LatLonPointImpl());
            f.format("  start at latlon= %s%n", startLL);
            f.format("    end at latlon= %s%n", endLL);
        }
    }

    public static class GaussLatLon
    extends LatLon {
        public int Nparellels;

        GaussLatLon(byte[] data) {
            super(data);
            this.template = 40;
            this.Nparellels = this.getOctet4(68);
        }

        @Override
        protected void finish() {
            super.finish();
            this.deltaLon = (this.lo2 - this.lo1) / (float)(this.getNx() - 1);
            this.deltaLat = 0.1f;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            GaussLatLon that = (GaussLatLon)o;
            return this.Nparellels == that.Nparellels;
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int result = super.hashCode();
                this.hashCode = result = 31 * result + this.Nparellels;
            }
            return this.hashCode;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            GdsHorizCoordSys coordSys = new GdsHorizCoordSys(this.getNameShort(), this.template, this.getOctet4(7), this.scanMode, new LatLonProjection(), this.lo1, this.deltaLon, 0.0, 0.0, this.getNxRaw(), this.getNyRaw(), this.getNptsInLine());
            coordSys.setGaussianLats(this.Nparellels, this.la1, this.la2);
            return coordSys;
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            f.format("%s testProjection %s%n", this.getClass().getName(), cs.proj.getClass().getName());
        }
    }

    public static class AlbersEqualArea
    extends LambertConformal {
        AlbersEqualArea(byte[] data) {
            super(data, 31);
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            Earth earth = this.getEarth();
            ProjectionImpl proj = earth.isSpherical() ? new ucar.unidata.geoloc.projection.AlbersEqualArea(this.latin1, this.lov, this.latin1, this.latin2, 0.0, 0.0, earth.getEquatorRadius() * 0.001) : new AlbersEqualAreaEllipse(this.latin1, this.lov, this.latin1, this.latin2, 0.0, 0.0, earth);
            LatLonPointImpl startLL = new LatLonPointImpl(this.la1, this.lo1);
            ProjectionPointImpl start = (ProjectionPointImpl)proj.latLonToProj(startLL);
            return new GdsHorizCoordSys(this.getNameShort(), this.template, this.getOctet4(7), this.scanMode, proj, start.getX(), this.dX, start.getY(), this.dY, this.getNxRaw(), this.getNyRaw(), this.getNptsInLine());
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            f.format("%s testProjection %s%n", this.getClass().getName(), cs.proj.getClass().getName());
            double endx = cs.startx + (double)(this.getNx() - 1) * cs.dx;
            double endy = cs.starty + (double)(this.getNy() - 1) * cs.dy;
            ProjectionPointImpl endPP = new ProjectionPointImpl(endx, endy);
            f.format("   start at proj coord= %s%n", new ProjectionPointImpl(cs.startx, cs.starty));
            f.format("     end at proj coord= %s%n", endPP);
            LatLonPointImpl startLL = new LatLonPointImpl(this.la1, this.lo1);
            LatLonPoint endLL = cs.proj.projToLatLon(endPP, new LatLonPointImpl());
            f.format("  start at latlon= %s%n", startLL);
            f.format("    end at latlon= %s%n", endLL);
        }
    }

    public static class LambertConformal
    extends Grib2Gds {
        public float la1 = (float)this.getOctet4(39) * 1.0E-6f;
        public float lo1 = (float)this.getOctet4(43) * 1.0E-6f;
        public float lov;
        public float lad;
        public float dX;
        public float dY;
        public float latin1;
        public float latin2;
        public float latSouthPole;
        public float lonSouthPole;
        public int flags = this.getOctet(47);
        public int projCenterFlag;

        LambertConformal(byte[] data, int template) {
            super(data, template);
            this.lad = (float)this.getOctet4(48) * 1.0E-6f;
            this.lov = (float)this.getOctet4(52) * 1.0E-6f;
            this.dX = (float)this.getOctet4(56) * 1.0E-6f;
            this.dY = (float)this.getOctet4(60) * 1.0E-6f;
            this.projCenterFlag = this.getOctet(64);
            this.scanMode = this.getOctet(65);
            this.latin1 = (float)this.getOctet4(66) * 1.0E-6f;
            this.latin2 = (float)this.getOctet4(70) * 1.0E-6f;
            this.latSouthPole = (float)this.getOctet4(74) * 1.0E-6f;
            this.lonSouthPole = (float)this.getOctet4(78) * 1.0E-6f;
        }

        @Override
        public void testScanMode(Formatter f) {
            float scale = 1.0E-6f;
            float dY = (float)this.getOctet4(60) * scale;
            if (GribUtils.scanModeYisPositive(this.scanMode)) {
                if (dY < 0.0f) {
                    f.format("  **LC scan mode=%d dY=%f%n", this.scanMode, Float.valueOf(dY));
                }
            } else if (dY > 0.0f) {
                f.format("  **LC scan mode=%d dY=%f%n", this.scanMode, Float.valueOf(dY));
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambertConformal that = (LambertConformal)o;
            if (!Misc.nearlyEqualsAbs((double)this.la1, (double)that.la1, 0.01 * (double)this.dY)) {
                return false;
            }
            if (!Misc.nearlyEqualsAbs((double)this.lo1, (double)that.lo1, 0.01 * (double)this.dX)) {
                return false;
            }
            if (!Misc.nearlyEquals(this.lad, that.lad)) {
                return false;
            }
            if (!Misc.nearlyEquals(this.lov, that.lov)) {
                return false;
            }
            if (!Misc.nearlyEquals(this.dY, that.dY)) {
                return false;
            }
            if (!Misc.nearlyEquals(this.dX, that.dX)) {
                return false;
            }
            if (!Misc.nearlyEquals(this.latin1, that.latin1)) {
                return false;
            }
            return Misc.nearlyEquals(this.latin2, that.latin2);
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int useLat = (int)Math.round((double)this.la1 / (0.01 * (double)this.dY));
                int useLon = (int)Math.round((double)this.lo1 / (0.01 * (double)this.dX));
                int useLad = Math.round(this.lad / 1.0E-5f);
                int useLov = Math.round(this.lov / 1.0E-5f);
                int useDeltaLon = Math.round(this.dX / 1.0E-5f);
                int useDeltaLat = Math.round(this.dY / 1.0E-5f);
                int useLatin1 = Math.round(this.latin1 / 1.0E-5f);
                int useLatin2 = Math.round(this.latin2 / 1.0E-5f);
                int result = super.hashCode();
                result = 31 * result + useLat;
                result = 31 * result + useLon;
                result = 31 * result + useLad;
                result = 31 * result + useLov;
                result = 31 * result + useDeltaLon;
                result = 31 * result + useDeltaLat;
                result = 31 * result + useLatin1;
                result = 31 * result + useLatin2;
                this.hashCode = result = 31 * result + this.projCenterFlag;
            }
            return this.hashCode;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            Earth earth = this.getEarth();
            ProjectionImpl proj = earth.isSpherical() ? new ucar.unidata.geoloc.projection.LambertConformal(this.latin1, this.lov, this.latin1, this.latin2, 0.0, 0.0, earth.getEquatorRadius() * 0.001) : new LambertConformalConicEllipse(this.latin1, this.lov, this.latin1, this.latin2, 0.0, 0.0, earth);
            LatLonPointImpl startLL = new LatLonPointImpl(this.la1, this.lo1);
            ProjectionPointImpl start = (ProjectionPointImpl)proj.latLonToProj(startLL);
            return new GdsHorizCoordSys(this.getNameShort(), this.template, this.getOctet4(7), this.scanMode, proj, start.getX(), this.dX, start.getY(), this.dY, this.getNxRaw(), this.getNyRaw(), this.getNptsInLine());
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            f.format("%s testProjection %s%n", this.getClass().getName(), cs.proj.getClass().getName());
            double endx = cs.startx + (double)(this.getNx() - 1) * cs.dx;
            double endy = cs.starty + (double)(this.getNy() - 1) * cs.dy;
            ProjectionPointImpl endPP = new ProjectionPointImpl(endx, endy);
            f.format("   start at proj coord= %s%n", new ProjectionPointImpl(cs.startx, cs.starty));
            f.format("     end at proj coord= %s%n", endPP);
            LatLonPointImpl startLL = new LatLonPointImpl(this.la1, this.lo1);
            LatLonPoint endLL = cs.proj.projToLatLon(endPP, new LatLonPointImpl());
            f.format("  start at latlon= %s%n", startLL);
            f.format("    end at latlon= %s%n", endLL);
        }
    }

    public static class PolarStereographic
    extends Grib2Gds {
        public float la1 = (float)this.getOctet4(39) * 1.0E-6f;
        public float lo1 = (float)this.getOctet4(43) * 1.0E-6f;
        public float lov;
        public float lad;
        public float dX;
        public float dY;
        public int flags = this.getOctet(47);
        public int projCenterFlag;

        PolarStereographic(byte[] data) {
            super(data, 20);
            this.lad = (float)this.getOctet4(48) * 1.0E-6f;
            this.lov = (float)this.getOctet4(52) * 1.0E-6f;
            this.dX = (float)this.getOctet4(56) * 1.0E-6f;
            this.dY = (float)this.getOctet4(60) * 1.0E-6f;
            this.projCenterFlag = this.getOctet(64);
            this.scanMode = this.getOctet(65);
        }

        @Override
        public void testScanMode(Formatter f) {
            float scale = 1.0E-6f;
            float dY = (float)this.getOctet4(60) * scale;
            if (GribUtils.scanModeYisPositive(this.scanMode)) {
                if (dY < 0.0f) {
                    f.format("  **PS scan mode=%d dY=%f%n", this.scanMode, Float.valueOf(dY));
                }
            } else if (dY > 0.0f) {
                f.format("  **PS scan mode=%d dY=%f%n", this.scanMode, Float.valueOf(dY));
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PolarStereographic that = (PolarStereographic)o;
            if (!Misc.nearlyEqualsAbs((double)this.la1, (double)that.la1, 0.01 * (double)this.dY)) {
                return false;
            }
            if (!Misc.nearlyEqualsAbs((double)this.lo1, (double)that.lo1, 0.01 * (double)this.dX)) {
                return false;
            }
            if (!Misc.nearlyEquals(this.lad, that.lad)) {
                return false;
            }
            if (!Misc.nearlyEquals(this.lov, that.lov)) {
                return false;
            }
            if (!Misc.nearlyEquals(this.dY, that.dY)) {
                return false;
            }
            if (!Misc.nearlyEquals(this.dX, that.dX)) {
                return false;
            }
            return this.projCenterFlag == that.projCenterFlag;
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int useLat = (int)Math.round((double)this.la1 / (0.01 * (double)this.dY));
                int useLon = (int)Math.round((double)this.lo1 / (0.01 * (double)this.dX));
                int useLad = Math.round(this.lad / 1.0E-5f);
                int useLov = Math.round(this.lov / 1.0E-5f);
                int useDeltaLon = Math.round(this.dX / 1.0E-5f);
                int useDeltaLat = Math.round(this.dY / 1.0E-5f);
                int result = super.hashCode();
                result = 31 * result + useLat;
                result = 31 * result + useLon;
                result = 31 * result + useLad;
                result = 31 * result + useLov;
                result = 31 * result + useDeltaLon;
                result = 31 * result + useDeltaLat;
                this.hashCode = result = 31 * result + this.projCenterFlag;
            }
            return this.hashCode;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            boolean northPole = (this.projCenterFlag & 0x80) == 0;
            double latOrigin = northPole ? 90.0 : -90.0;
            double scale = GribNumbers.isUndefined(this.lad) ? 0.9330127018922193 : (1.0 + Math.sin(Math.toRadians(Math.abs(Math.abs(this.lad))))) / 2.0;
            Earth earth = this.getEarth();
            ProjectionImpl proj = earth.isSpherical() ? new Stereographic(latOrigin, this.lov, scale) : new StereographicAzimuthalProjection(latOrigin, this.lov, scale, this.lad, 0.0, 0.0, earth);
            ProjectionPointImpl start = (ProjectionPointImpl)proj.latLonToProj(new LatLonPointImpl(this.la1, this.lo1));
            return new GdsHorizCoordSys(this.getNameShort(), this.template, this.getOctet4(7), this.scanMode, proj, start.getX(), this.dX, start.getY(), this.dY, this.getNxRaw(), this.getNyRaw(), this.getNptsInLine());
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            f.format("%s testProjection %s%n", this.getClass().getName(), cs.proj.getClass().getName());
            double endx = cs.startx + (double)(this.getNx() - 1) * cs.dx;
            double endy = cs.starty + (double)(this.getNy() - 1) * cs.dy;
            ProjectionPointImpl endPP = new ProjectionPointImpl(endx, endy);
            f.format("   start at proj coord= %s%n", new ProjectionPointImpl(cs.startx, cs.starty));
            f.format("     end at proj coord= %s%n", endPP);
            LatLonPointImpl startLL = new LatLonPointImpl(this.la1, this.lo1);
            LatLonPoint endLL = cs.proj.projToLatLon(endPP, new LatLonPointImpl());
            f.format("  start at latlon= %s%n", startLL);
            f.format("    end at latlon= %s%n", endLL);
        }
    }

    public static class Mercator
    extends Grib2Gds {
        public float la1 = (float)this.getOctet4(39) * 1.0E-6f;
        public float lo1 = (float)this.getOctet4(43) * 1.0E-6f;
        public float la2;
        public float lo2;
        public float lad;
        public float dX;
        public float dY;
        public int flags = this.getOctet(47);

        Mercator(byte[] data) {
            super(data, 10);
            this.lad = (float)this.getOctet4(48) * 1.0E-6f;
            this.la2 = (float)this.getOctet4(52) * 1.0E-6f;
            this.lo2 = (float)this.getOctet4(56) * 1.0E-6f;
            this.scanMode = this.getOctet(60);
            this.dX = (float)this.getOctet4(65) * 1.0E-6f;
            this.dY = (float)this.getOctet4(69) * 1.0E-6f;
            this.lastOctet = 73;
        }

        @Override
        public void testScanMode(Formatter f) {
            float scale = 1.0E-6f;
            float firstLat = (float)this.getOctet4(39) * scale;
            float lastLat = (float)this.getOctet4(52) * scale;
            float dY = (float)this.getOctet4(69) * scale;
            if (GribUtils.scanModeYisPositive(this.scanMode)) {
                if (firstLat > lastLat) {
                    f.format("  **Mercator scan mode=%d dY=%f lat=(%f,%f)%n", this.scanMode, Float.valueOf(dY), Float.valueOf(firstLat), Float.valueOf(lastLat));
                }
            } else if (firstLat < lastLat) {
                f.format("  **Mercator scan mode=%d dY=%f lat=(%f,%f)%n", this.scanMode, Float.valueOf(dY), Float.valueOf(firstLat), Float.valueOf(lastLat));
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Mercator that = (Mercator)o;
            if (!Misc.nearlyEqualsAbs((double)this.la1, (double)that.la1, 0.01 * (double)this.dY)) {
                return false;
            }
            if (!Misc.nearlyEqualsAbs((double)this.lo1, (double)that.lo1, 0.01 * (double)this.dX)) {
                return false;
            }
            if (!Misc.nearlyEqualsAbs((double)this.lad, (double)that.lad, 0.01 * (double)this.dY)) {
                return false;
            }
            if (!Misc.nearlyEquals(this.dY, that.dY)) {
                return false;
            }
            return Misc.nearlyEquals(this.dX, that.dX);
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int useLat = (int)Math.round((double)this.la1 / (0.01 * (double)this.dY));
                int useLon = (int)Math.round((double)this.lo1 / (0.01 * (double)this.dX));
                int useLad = (int)Math.round((double)this.lad / (0.01 * (double)this.dY));
                int useDeltaLon = Math.round(this.dX / 1.0E-5f);
                int useDeltaLat = Math.round(this.dY / 1.0E-5f);
                int result = super.hashCode();
                result = 31 * result + useLat;
                result = 31 * result + useLon;
                result = 31 * result + useLad;
                result = 31 * result + useDeltaLon;
                this.hashCode = result = 31 * result + useDeltaLat;
            }
            return this.hashCode;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            Earth earth = this.getEarth();
            ucar.unidata.geoloc.projection.Mercator proj = new ucar.unidata.geoloc.projection.Mercator(this.lo1, this.lad, 0.0, 0.0, earth.getEquatorRadius() * 0.001);
            ProjectionPoint startP = proj.latLonToProj(new LatLonPointImpl(this.la1, this.lo1));
            double startx = startP.getX();
            double starty = startP.getY();
            return new GdsHorizCoordSys(this.getNameShort(), this.template, this.getOctet4(7), this.scanMode, proj, startx, this.dX, starty, this.dY, this.getNxRaw(), this.getNyRaw(), this.getNptsInLine());
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            double Lo2 = this.lo2;
            if (Lo2 < (double)this.lo1) {
                Lo2 += 360.0;
            }
            LatLonPointImpl startLL = new LatLonPointImpl(this.la1, this.lo1);
            LatLonPointImpl endLL = new LatLonPointImpl(this.la2, Lo2);
            f.format("%s testProjection%n", this.getClass().getName());
            f.format("  start at latlon= %s%n", startLL);
            f.format("    end at latlon= %s%n", endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)cs.proj.latLonToProj(endLL, new ProjectionPointImpl());
            f.format("   start at proj coord= %s%n", new ProjectionPointImpl(cs.startx, cs.starty));
            f.format("     end at proj coord= %s%n", endPP);
            double endx = cs.startx + (double)(this.getNx() - 1) * cs.dx;
            double endy = cs.starty + (double)(this.getNy() - 1) * cs.dy;
            f.format("   should end at x= (%f,%f)%n", endx, endy);
        }
    }

    public static class RotatedLatLon32769
    extends AbstractRotatedLatLon {
        RotatedLatLon32769(byte[] data) {
            super(data);
            this.template = 32769;
            this.lastOctet = 81;
            float latCentre = this.la2;
            float lonCentre = this.lo2;
            if (latCentre > 0.0f) {
                this.latNorthPole = 90.0 - LatLonPointImpl.latNormal(latCentre);
                this.lonNorthPole = LatLonPointImpl.lonNormal(lonCentre + 180.0f);
            } else {
                this.latNorthPole = 90.0 + LatLonPointImpl.latNormal(latCentre);
                this.lonNorthPole = LatLonPointImpl.lonNormal(lonCentre);
            }
            RotatedPole proj = new RotatedPole(this.latNorthPole, this.lonNorthPole);
            LatLonPointImpl unrotated = new LatLonPointImpl(this.la1, this.lo1);
            ProjectionPointImpl rotated = new ProjectionPointImpl();
            proj.latLonToProj(unrotated, rotated);
            if (rotated.getX() >= 0.0) {
                throw new RuntimeException("Unexpected nonnegative lower left rotated longitude: " + rotated.getX());
            }
            if (rotated.getY() >= 0.0) {
                throw new RuntimeException("Unexpected nonnegative lower left rotated latitude: " + rotated.getY());
            }
            this.la1 = (float)rotated.getY();
            this.lo1 = (float)rotated.getX();
            this.la2 = -this.la1;
            this.lo2 = -this.lo1;
        }
    }

    public static abstract class AbstractRotatedLatLon
    extends LatLon {
        public double latNorthPole;
        public double lonNorthPole;

        AbstractRotatedLatLon(byte[] data) {
            super(data);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractRotatedLatLon other = (AbstractRotatedLatLon)o;
            return this.latNorthPole == other.latNorthPole && this.lonNorthPole == other.lonNorthPole;
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int result = super.hashCode();
                result = 31 * result + new Double(this.latNorthPole).hashCode();
                this.hashCode = result = 31 * result + new Double(this.lonNorthPole).hashCode();
            }
            return this.hashCode;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            RotatedPole proj = new RotatedPole(this.latNorthPole, this.lonNorthPole);
            return new GdsHorizCoordSys(this.getNameShort(), this.template, this.getOctet4(7), this.scanMode, proj, this.lo1, this.deltaLon, this.la1, this.deltaLat, this.getNxRaw(), this.getNyRaw(), this.getNptsInLine());
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            LatLonPoint startLL = cs.proj.projToLatLon(new ProjectionPointImpl(this.lo1, this.la1));
            LatLonPoint endLL = cs.proj.projToLatLon(new ProjectionPointImpl(this.lo2, this.la2));
            f.format("%s testProjection%n", this.getClass().getName());
            f.format("  start at latlon= %s%n", startLL);
            f.format("    end at latlon= %s%n", endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)cs.proj.latLonToProj(endLL, new ProjectionPointImpl());
            f.format("   start at proj coord= %s%n", new ProjectionPointImpl(cs.startx, cs.starty));
            f.format("     end at proj coord= %s%n", endPP);
            double endx = cs.startx + (double)(this.getNx() - 1) * cs.dx;
            double endy = cs.starty + (double)(this.getNy() - 1) * cs.dy;
            f.format("   should end at x= (%f,%f)%n", endx, endy);
        }
    }

    public static class RotatedLatLon
    extends AbstractRotatedLatLon {
        RotatedLatLon(byte[] data) {
            super(data);
            this.template = 1;
            this.lastOctet = 85;
            float scale = this.getScale();
            float latSouthPole = (float)this.getOctet4(73) * scale;
            float lonSouthPole = (float)this.getOctet4(77) * scale;
            float angleRotation = (float)this.getOctet4(81) * scale;
            if (angleRotation != 0.0f) {
                throw new RuntimeException("Unsupported nonzero GRIB2 GDS template 1 angle of rotation: " + angleRotation);
            }
            this.latNorthPole = -LatLonPointImpl.latNormal(latSouthPole);
            this.lonNorthPole = LatLonPointImpl.lonNormal(lonSouthPole + 180.0f);
            this.la1 = (float)LatLonPointImpl.latNormal(this.la1);
            this.lo1 = (float)LatLonPointImpl.lonNormal(this.lo1);
            this.la2 = (float)LatLonPointImpl.latNormal(this.la2);
            this.lo2 = (float)LatLonPointImpl.lonNormal(this.lo2);
            if (this.la1 >= 0.0f) {
                throw new RuntimeException("Unexpected nonnegative lower left rotated latitude: " + this.la1);
            }
            if (this.lo1 >= 0.0f) {
                throw new RuntimeException("Unexpected nonnegative lower left rotated longitude: " + this.lo1);
            }
            if (this.la2 <= 0.0f) {
                throw new RuntimeException("Unexpected nonpositive upper right rotated latitude: " + this.la2);
            }
            if (this.lo2 <= 0.0f) {
                throw new RuntimeException("Unexpected nonpositive upper right rotated longitude: " + this.lo2);
            }
        }
    }

    public static class LatLon
    extends Grib2Gds {
        public float la1;
        public float lo1;
        public float la2;
        public float lo2;
        public float deltaLon;
        public float deltaLat;
        public int basicAngle = this.getOctet4(39);
        public int basicAngleSubdivisions = this.getOctet4(43);
        public int flags;

        LatLon(byte[] data) {
            super(data, 0);
            float scale = this.getScale();
            this.la1 = (float)this.getOctet4(47) * scale;
            this.lo1 = (float)this.getOctet4(51) * scale;
            this.flags = this.getOctet(55);
            this.la2 = (float)this.getOctet4(56) * scale;
            this.lo2 = (float)this.getOctet4(60) * scale;
            this.scanMode = this.getOctet(72);
            this.lastOctet = 73;
        }

        @Override
        public void testScanMode(Formatter f) {
            if (GribUtils.scanModeYisPositive(this.scanMode)) {
                if (this.la1 > this.la2) {
                    f.format("  **latlon scan mode=%d dLat=%f lat=(%f,%f)%n", this.scanMode, Float.valueOf(this.deltaLat), Float.valueOf(this.la1), Float.valueOf(this.la2));
                }
            } else if (this.la1 < this.la2) {
                f.format("  **latlon scan mode=%d dLat=%f lat=(%f,%f)%n", this.scanMode, Float.valueOf(this.deltaLat), Float.valueOf(this.la1), Float.valueOf(this.la2));
            }
        }

        @Override
        protected void finish() {
            super.finish();
            if (this.lo2 < this.lo1) {
                this.lo2 += 360.0f;
            }
            if (Misc.nearlyEquals(this.lo1, this.lo2)) {
                this.lo1 -= 360.0f;
            }
            float scale = this.getScale();
            this.deltaLon = (float)this.getOctet4(64) * scale;
            float calcDelta = (this.lo2 - this.lo1) / (float)(this.getNx() - 1);
            if (!Misc.nearlyEquals(this.deltaLon, calcDelta)) {
                log.debug("deltaLon {} != calcDeltaLon {}", (Object)Float.valueOf(this.deltaLon), (Object)Float.valueOf(calcDelta));
                this.deltaLon = calcDelta;
            }
            this.deltaLat = (float)this.getOctet4(68) * scale;
            if (this.la2 < this.la1) {
                this.deltaLat = -this.deltaLat;
            }
            if (!Misc.nearlyEquals(this.deltaLat, calcDelta = (this.la2 - this.la1) / (float)(this.getNy() - 1))) {
                log.debug("deltaLat {} != calcDeltaLat {}", (Object)Float.valueOf(this.deltaLat), (Object)Float.valueOf(calcDelta));
                this.deltaLat = calcDelta;
            }
        }

        @Override
        public boolean isLatLon() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LatLon other = (LatLon)o;
            if (!Misc.nearlyEqualsAbs((double)this.la1, (double)other.la1, 0.01 * (double)this.deltaLat)) {
                return false;
            }
            if (!Misc.nearlyEqualsAbs((double)this.lo1, (double)other.lo1, 0.01 * (double)this.deltaLon)) {
                return false;
            }
            if (!Misc.nearlyEqualsAbs((double)this.la2, (double)other.la2, 0.01 * (double)this.deltaLat)) {
                return false;
            }
            return Misc.nearlyEqualsAbs((double)this.lo2, (double)other.lo2, 0.01 * (double)this.deltaLon);
        }

        @Override
        public int hashCode() {
            if (this.hashCode == 0) {
                int useLat1 = (int)Math.round((double)this.la1 / (0.01 * (double)this.deltaLat));
                int useLon1 = (int)Math.round((double)this.lo1 / (0.01 * (double)this.deltaLon));
                int useLat2 = (int)Math.round((double)this.la2 / (0.01 * (double)this.deltaLat));
                int useLon2 = (int)Math.round((double)this.lo2 / (0.01 * (double)this.deltaLon));
                int result = super.hashCode();
                result = 31 * result + useLat1;
                result = 31 * result + useLon1;
                result = 31 * result + useLat2;
                this.hashCode = result = 31 * result + useLon2;
            }
            return this.hashCode;
        }

        protected float getScale() {
            if (this.basicAngle == 0 || this.basicAngle == -9999 || this.basicAngleSubdivisions == -9999) {
                return 1.0E-6f;
            }
            return (float)this.basicAngle / (float)this.basicAngleSubdivisions;
        }

        public int[] getOptionalPoints() {
            int[] optionalPoints = null;
            int n = this.getOctet(11);
            if (n > 0) {
                optionalPoints = new int[n / 4];
                for (int i = 0; i < optionalPoints.length; ++i) {
                    optionalPoints[i] = this.getOctet4(this.lastOctet + 4 * n);
                }
            }
            return optionalPoints;
        }

        @Override
        public GdsHorizCoordSys makeHorizCoordSys() {
            LatLonProjection proj = new LatLonProjection(this.getEarth());
            double startx = this.lo1;
            double starty = this.la1;
            return new GdsHorizCoordSys(this.getNameShort(), this.template, this.getOctet4(7), this.scanMode, proj, startx, this.deltaLon, starty, this.deltaLat, this.getNxRaw(), this.getNyRaw(), this.getNptsInLine());
        }

        @Override
        public void testHorizCoordSys(Formatter f) {
            GdsHorizCoordSys cs = this.makeHorizCoordSys();
            double Lo2 = this.lo2;
            if (Lo2 < (double)this.lo1) {
                Lo2 += 360.0;
            }
            LatLonPointImpl startLL = new LatLonPointImpl(this.la1, this.lo1);
            LatLonPointImpl endLL = new LatLonPointImpl(this.la2, Lo2);
            f.format("%s testProjection%n", this.getClass().getName());
            f.format("  start at latlon= %s%n", startLL);
            f.format("    end at latlon= %s%n", endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)cs.proj.latLonToProj(endLL, new ProjectionPointImpl());
            f.format("   start at proj coord= %s%n", new ProjectionPointImpl(cs.startx, cs.starty));
            f.format("     end at proj coord= %s%n", endPP);
            double endx = cs.startx + (double)(this.getNx() - 1) * cs.dx;
            double endy = cs.starty + (double)(this.getNy() - 1) * cs.dy;
            f.format("   should end at x= (%f,%f)%n", endx, endy);
        }
    }
}

