/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.TxnStatDefinition;
import com.sleepycat.je.latch.SharedLatch;
import com.sleepycat.je.txn.DummyLockManager;
import com.sleepycat.je.txn.LatchedLockManager;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.SyncedLockManager;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.ActiveTxnArrayStat;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.xa.Xid;

public class TxnManager {
    static final long NULL_TXN_ID = -1L;
    private static final long FIRST_NEGATIVE_ID = -10L;
    private LockManager lockManager;
    private final EnvironmentImpl envImpl;
    private final SharedLatch allTxnsLatch;
    private final Map<Txn, Txn> allTxns;
    private final Map<Xid, Txn> allXATxns;
    private final Map<Thread, Transaction> thread2Txn;
    private final AtomicLong lastUsedLocalTxnId;
    private final AtomicLong lastUsedReplicatedTxnId;
    private final AtomicInteger nActiveSerializable;
    private StatGroup stats;
    private IntStat nActive;
    private LongStat numBegins;
    private LongStat numCommits;
    private LongStat numAborts;
    private LongStat numXAPrepares;
    private LongStat numXACommits;
    private LongStat numXAAborts;
    private ActiveTxnArrayStat activeTxns;

    public TxnManager(EnvironmentImpl envImpl) {
        this.lockManager = EnvironmentImpl.getFairLatches() ? new LatchedLockManager(envImpl) : new SyncedLockManager(envImpl);
        if (envImpl.isNoLocking()) {
            this.lockManager = new DummyLockManager(envImpl, this.lockManager);
        }
        this.envImpl = envImpl;
        this.allTxnsLatch = new SharedLatch("TxnManager.allTxns");
        this.allTxns = new ConcurrentHashMap<Txn, Txn>();
        this.allXATxns = Collections.synchronizedMap(new HashMap());
        this.thread2Txn = new ConcurrentHashMap<Thread, Transaction>();
        this.lastUsedLocalTxnId = new AtomicLong(0L);
        this.lastUsedReplicatedTxnId = new AtomicLong(-10L);
        this.nActiveSerializable = new AtomicInteger(0);
        this.stats = new StatGroup("Transaction", "Transaction statistics");
        this.nActive = new IntStat(this.stats, TxnStatDefinition.TXN_ACTIVE);
        this.numBegins = new LongStat(this.stats, TxnStatDefinition.TXN_BEGINS);
        this.numCommits = new LongStat(this.stats, TxnStatDefinition.TXN_COMMITS);
        this.numAborts = new LongStat(this.stats, TxnStatDefinition.TXN_ABORTS);
        this.numXAPrepares = new LongStat(this.stats, TxnStatDefinition.TXN_XAPREPARES);
        this.numXACommits = new LongStat(this.stats, TxnStatDefinition.TXN_XACOMMITS);
        this.numXAAborts = new LongStat(this.stats, TxnStatDefinition.TXN_XAABORTS);
        this.activeTxns = new ActiveTxnArrayStat(this.stats, TxnStatDefinition.TXN_ACTIVE_TXNS);
    }

    public void setLastTxnId(long lastReplicatedTxnId, long lastLocalId) {
        this.lastUsedReplicatedTxnId.set(lastReplicatedTxnId);
        this.lastUsedLocalTxnId.set(lastLocalId);
    }

    public long getLastLocalTxnId() {
        return this.lastUsedLocalTxnId.get();
    }

    public long getLastReplicatedTxnId() {
        return this.lastUsedReplicatedTxnId.get();
    }

    public long getNextReplicatedTxnId() {
        return this.lastUsedReplicatedTxnId.decrementAndGet();
    }

    public static boolean isReplicatedTxn(long txnId) {
        return txnId <= -10L;
    }

    long getNextTxnId() {
        return this.lastUsedLocalTxnId.incrementAndGet();
    }

    public void updateFromReplay(long replayTxnId) {
        assert (!this.envImpl.isMaster());
        assert (replayTxnId < 0L) : "replay txn id is unexpectedly positive " + replayTxnId;
        if (replayTxnId < this.lastUsedReplicatedTxnId.get()) {
            this.lastUsedReplicatedTxnId.set(replayTxnId);
        }
    }

    public Txn txnBegin(Transaction parent, TransactionConfig txnConfig) throws DatabaseException {
        return Txn.createUserTxn(this.envImpl, txnConfig);
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerTxn(Txn txn) {
        this.allTxnsLatch.acquireShared();
        try {
            this.allTxns.put(txn, txn);
            if (txn.isSerializableIsolation()) {
                this.nActiveSerializable.incrementAndGet();
            }
            this.numBegins.increment();
        }
        finally {
            this.allTxnsLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unRegisterTxn(Txn txn, boolean isCommit) {
        this.allTxnsLatch.acquireShared();
        try {
            this.allTxns.remove(txn);
            this.envImpl.getMemoryBudget().updateTxnMemoryUsage(0 - txn.getBudgetedMemorySize());
            if (isCommit) {
                this.numCommits.increment();
            } else {
                this.numAborts.increment();
            }
            if (txn.isSerializableIsolation()) {
                this.nActiveSerializable.decrementAndGet();
            }
        }
        finally {
            this.allTxnsLatch.release();
        }
    }

    public void registerXATxn(Xid xid, Txn txn, boolean isPrepare) {
        if (!this.allXATxns.containsKey(xid)) {
            this.allXATxns.put(xid, txn);
            this.envImpl.getMemoryBudget().updateTxnMemoryUsage(MemoryBudget.HASHMAP_ENTRY_OVERHEAD);
        }
        if (isPrepare) {
            this.numXAPrepares.increment();
        }
    }

    public void notePrepare() {
        this.numXAPrepares.increment();
    }

    void unRegisterXATxn(Xid xid, boolean isCommit) throws DatabaseException {
        if (this.allXATxns.remove(xid) == null) {
            throw new IllegalStateException("XA Transaction " + xid + " is not registered.");
        }
        this.envImpl.getMemoryBudget().updateTxnMemoryUsage(0 - MemoryBudget.HASHMAP_ENTRY_OVERHEAD);
        if (isCommit) {
            this.numXACommits.increment();
        } else {
            this.numXAAborts.increment();
        }
    }

    public Txn getTxnFromXid(Xid xid) {
        return this.allXATxns.get(xid);
    }

    public void setTxnForThread(Transaction txn) {
        Thread curThread = Thread.currentThread();
        this.thread2Txn.put(curThread, txn);
    }

    public Transaction unsetTxnForThread() {
        Thread curThread = Thread.currentThread();
        return this.thread2Txn.remove(curThread);
    }

    public Transaction getTxnForThread() {
        return this.thread2Txn.get(Thread.currentThread());
    }

    public Xid[] XARecover() {
        Set<Xid> xidSet = this.allXATxns.keySet();
        Xid[] ret = new Xid[xidSet.size()];
        ret = xidSet.toArray(ret);
        return ret;
    }

    public boolean areOtherSerializableTransactionsActive(Locker excludeLocker) {
        int exclude = excludeLocker != null && excludeLocker.isSerializableIsolation() ? 1 : 0;
        return this.nActiveSerializable.get() - exclude > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFirstActiveLsn() {
        long firstActive = -1L;
        this.allTxnsLatch.acquireExclusive();
        try {
            Iterator<Txn> iter = this.allTxns.keySet().iterator();
            while (iter.hasNext()) {
                long txnFirstActive = iter.next().getFirstActiveLsn();
                if (firstActive == -1L) {
                    firstActive = txnFirstActive;
                    continue;
                }
                if (txnFirstActive == -1L || DbLsn.compareTo(txnFirstActive, firstActive) >= 0) continue;
                firstActive = txnFirstActive;
            }
        }
        finally {
            this.allTxnsLatch.release();
        }
        return firstActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionStats txnStat(StatsConfig config) {
        TransactionStats txnStats = null;
        this.allTxnsLatch.acquireShared();
        try {
            this.nActive.set(this.allTxns.size());
            TransactionStats.Active[] activeSet = new TransactionStats.Active[this.nActive.get().intValue()];
            Iterator<Txn> iter = this.allTxns.keySet().iterator();
            for (int i = 0; iter.hasNext() && i < activeSet.length; ++i) {
                Locker txn = iter.next();
                activeSet[i] = new TransactionStats.Active(txn.toString(), txn.getId(), 0L);
            }
            this.activeTxns.set(activeSet);
            txnStats = new TransactionStats(this.stats.cloneGroup(false));
            if (config.getClear()) {
                this.numCommits.clear();
                this.numAborts.clear();
                this.numXACommits.clear();
                this.numXAAborts.clear();
            }
        }
        finally {
            this.allTxnsLatch.release();
        }
        return txnStats;
    }

    public StatGroup loadStats(StatsConfig config) {
        return this.lockManager.loadStats(config);
    }

    public LockStats lockStat(StatsConfig config) throws DatabaseException {
        return this.lockManager.lockStat(config);
    }
}

