/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.StringTokenizer;
import loci.formats.FormatException;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;

public class SEQReader
extends BaseTiffReader {
    private static final int IMAGE_PRO_TAG_1 = 50288;
    private static final int IMAGE_PRO_TAG_2 = 40105;

    public SEQReader() {
        super("Image-Pro Sequence", "seq");
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.core.sizeZ[0] = 0;
        this.core.sizeT[0] = 0;
        for (int j = 0; j < this.ifds.length; ++j) {
            int tag2;
            short[] tag1 = (short[])TiffTools.getIFDValue(this.ifds[j], 50288);
            if (tag1 != null) {
                String seqId = "";
                for (int i = 0; i < tag1.length; ++i) {
                    seqId = seqId + tag1[i];
                }
                this.addMeta("Image-Pro SEQ ID", seqId);
            }
            if ((tag2 = TiffTools.getIFDIntValue(this.ifds[0], 40105)) != -1) {
                this.core.sizeZ[0] = this.core.sizeZ[0] + 1;
                this.addMeta("Frame Rate", new Integer(tag2));
            }
            this.addMeta("Number of images", new Integer(this.core.sizeZ[0]));
        }
        if (this.core.sizeZ[0] == 0) {
            this.core.sizeZ[0] = 1;
        }
        if (this.core.sizeT[0] == 0) {
            this.core.sizeT[0] = 1;
        }
        if (this.core.sizeZ[0] == 1 && this.core.sizeT[0] == 1) {
            this.core.sizeZ[0] = this.ifds.length;
        }
        this.addMeta("frames", "" + this.core.sizeZ[0]);
        this.addMeta("channels", "" + super.getSizeC());
        this.addMeta("slices", "" + this.core.sizeT[0]);
        String descr = (String)TiffTools.getIFDValue(this.ifds[0], 270);
        this.metadata.remove("Comment");
        if (descr != null) {
            StringTokenizer tokenizer = new StringTokenizer(descr, "\n");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                String label = token.substring(0, token.indexOf("="));
                String data = token.substring(token.indexOf("=") + 1);
                this.addMeta(label, data);
                if (label.equals("channels")) {
                    this.core.sizeC[0] = Integer.parseInt(data);
                    continue;
                }
                if (label.equals("frames")) {
                    this.core.sizeZ[0] = Integer.parseInt(data);
                    continue;
                }
                if (!label.equals("slices")) continue;
                this.core.sizeT[0] = Integer.parseInt(data);
            }
        }
        if (this.isRGB() && this.core.sizeC[0] != 3) {
            this.core.sizeC[0] = this.core.sizeC[0] * 3;
        }
        this.core.currentOrder[0] = "XY";
        int maxNdx = 0;
        int max = 0;
        int[] dims = new int[]{this.core.sizeZ[0], this.core.sizeC[0], this.core.sizeT[0]};
        String[] axes = new String[]{"Z", "C", "T"};
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] <= max) continue;
            max = dims[i];
            maxNdx = i;
        }
        this.core.currentOrder[0] = this.core.currentOrder[0] + axes[maxNdx];
        if (maxNdx != 1) {
            if (this.core.sizeC[0] > 1) {
                this.core.currentOrder[0] = this.core.currentOrder[0] + "C";
                this.core.currentOrder[0] = this.core.currentOrder[0] + (maxNdx == 0 ? axes[2] : axes[0]);
            } else {
                this.core.currentOrder[0] = this.core.currentOrder[0] + (maxNdx == 0 ? axes[2] : axes[0]) + "C";
            }
        } else {
            this.core.currentOrder[0] = this.core.sizeZ[0] > this.core.sizeT[0] ? this.core.currentOrder[0] + "ZT" : this.core.currentOrder[0] + "TZ";
        }
    }
}

