/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;

public class CatalogUtils {
    private CatalogUtils() {
    }

    public static List<InvCatalogRef> findAllCatRefsInDatasetTree(List<InvDataset> datasets, StringBuilder log, boolean onlyRelativeUrls) {
        ArrayList<InvCatalogRef> catRefList = new ArrayList<InvCatalogRef>();
        for (InvDataset invds : datasets) {
            InvDatasetImpl curDs = (InvDatasetImpl)invds;
            if (curDs instanceof InvDatasetScan) continue;
            if (curDs instanceof InvCatalogRef) {
                URI uri;
                InvCatalogRef catRef = (InvCatalogRef)curDs;
                String name = catRef.getName();
                String href = catRef.getXlinkHref();
                try {
                    uri = new URI(href);
                }
                catch (URISyntaxException e) {
                    log.append(log.length() > 0 ? "\n" : "").append("***WARN - CatalogRef [").append(name).append("] with bad HREF [").append(href).append("] ");
                    continue;
                }
                if (onlyRelativeUrls && uri.isAbsolute()) continue;
                catRefList.add(catRef);
                continue;
            }
            if (!curDs.hasNestedDatasets()) continue;
            catRefList.addAll(CatalogUtils.findAllCatRefsInDatasetTree(curDs.getDatasets(), log, onlyRelativeUrls));
        }
        return catRefList;
    }

    public static String escapePathForURL(String path) {
        try {
            return new URI(null, null, path, null).toString();
        }
        catch (URISyntaxException e) {
            return path;
        }
    }
}

