/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.simpgeometry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nonnull;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainerHelper;
import ucar.nc2.Dimension;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.ft2.simpgeometry.GeometryType;
import ucar.nc2.ft2.simpgeometry.Line;
import ucar.nc2.ft2.simpgeometry.Point;
import ucar.nc2.ft2.simpgeometry.Polygon;
import ucar.nc2.ft2.simpgeometry.SimpleGeometry;
import ucar.nc2.ft2.simpgeometry.adapter.SimpleGeometryCS;
import ucar.nc2.util.Indent;

public class SimpleGeometryFeature
implements VariableSimpleIF {
    private final String name;
    private final DataType dataType;
    private final AttributeContainerHelper atts;
    private final String units;
    private final String description;
    private final String coordSysName;
    protected final Object user;
    private int[] shapes;
    private CoordinateAxis xAxis;
    private CoordinateAxis yAxis;
    private CoordinateAxis zAxis;
    private CoordinateAxis IDAxis;
    private final GeometryType geometryType;
    private SimpleGeometryCS coordSys;

    public SimpleGeometryFeature(String name, DataType dataType, List<Attribute> atts, String coordSysName, String units, String description, Object user, GeometryType geometryType) {
        this.name = name;
        this.dataType = dataType;
        this.atts = new AttributeContainerHelper(name, atts);
        this.coordSysName = coordSysName;
        this.units = units;
        this.description = description;
        this.user = user;
        this.geometryType = geometryType;
        this.xAxis = null;
        this.yAxis = null;
        this.zAxis = null;
        this.IDAxis = null;
        this.shapes = null;
    }

    public void setCoordSys(SimpleGeometryCS coordSys) {
        if (this.coordSys != null) {
            throw new RuntimeException("Can't change coordSys once set");
        }
        this.coordSys = coordSys;
        String[] axesStrList = null;
        axesStrList = this.coordSysName.split(" ");
        ArrayList<String> axesStrActualList = new ArrayList<String>();
        int shapeLength = 0;
        if (axesStrList != null) {
            for (int i = 0; i < axesStrList.length; ++i) {
                axesStrActualList.add(axesStrList[i]);
            }
            for (CoordinateAxis xAx : coordSys.getSimpleGeometryX()) {
                if (!axesStrActualList.contains(xAx.getFullNameEscaped())) continue;
                this.xAxis = xAx;
                ++shapeLength;
            }
            for (CoordinateAxis yAx : coordSys.getSimpleGeometryY()) {
                if (!axesStrActualList.contains(yAx.getFullNameEscaped())) continue;
                this.yAxis = yAx;
                ++shapeLength;
            }
            for (CoordinateAxis zAx : coordSys.getSimpleGeometryZ()) {
                if (!axesStrActualList.contains(zAx.getFullNameEscaped())) continue;
                this.zAxis = zAx;
                ++shapeLength;
            }
            for (CoordinateAxis idAx : coordSys.getSimpleGeometryID()) {
                if (!axesStrActualList.contains(idAx.getFullNameEscaped())) continue;
                this.IDAxis = idAx;
                ++shapeLength;
            }
            this.shapes = new int[shapeLength];
            int shapeIndex = 0;
            if (this.xAxis != null) {
                this.shapes[shapeIndex] = (int)this.xAxis.getSize();
                ++shapeIndex;
            }
            if (this.yAxis != null) {
                this.shapes[shapeIndex] = (int)this.yAxis.getSize();
                ++shapeIndex;
            }
            if (this.zAxis != null) {
                this.shapes[shapeIndex] = (int)this.zAxis.getSize();
                ++shapeIndex;
            }
            if (this.IDAxis != null) {
                this.shapes[shapeIndex] = (int)this.IDAxis.getSize();
                ++shapeIndex;
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.atts.getAttributes();
    }

    @Override
    public Attribute findAttributeIgnoreCase(String name) {
        return this.atts.findAttributeIgnoreCase(name);
    }

    @Override
    public String getUnitsString() {
        return this.units;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getCoordSysName() {
        return this.coordSysName;
    }

    public Object getUserObject() {
        return this.user;
    }

    public GeometryType getGeometryType() {
        return this.geometryType;
    }

    public String getGeometryDescription() {
        return this.geometryType.getDescription();
    }

    public String toString() {
        Formatter f = new Formatter();
        Indent indent = new Indent(2);
        this.toString(f, indent);
        return f.toString();
    }

    public void toString(Formatter f, Indent indent) {
        indent.incr();
        f.format("%n%s  %s %s(%s) desc='%s' units='%s' geometry='%s'%n", new Object[]{indent, this.dataType, this.name, this.coordSysName, this.description, this.units, this.getGeometryDescription()});
        f.format("%s    attributes:%n", indent);
        for (Attribute att : this.atts.getAttributes()) {
            f.format("%s     %s%n", indent, att);
        }
        indent.decr();
    }

    @Nonnull
    public SimpleGeometryCS getCoordSys() {
        return this.coordSys;
    }

    public CoordinateAxis getXAxis() {
        return this.xAxis;
    }

    public CoordinateAxis getYAxis() {
        return this.yAxis;
    }

    public CoordinateAxis getZAxis() {
        return this.zAxis;
    }

    public CoordinateAxis getIDAxis() {
        return this.IDAxis;
    }

    public SimpleGeometry readGeometry(int index) throws IOException, InvalidRangeException {
        SimpleGeometry geom = null;
        switch (this.geometryType) {
            case POINT: {
                Point point;
                geom = point = this.coordSys.getPoint(this.name, index);
                break;
            }
            case LINE: {
                Line line = this.coordSys.getLine(this.name, index);
                geom = line;
                break;
            }
            case POLYGON: {
                Polygon poly = this.coordSys.getPolygon(this.name, index);
                geom = poly;
                break;
            }
        }
        return geom;
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public String getShortName() {
        return this.getName();
    }

    @Override
    public int getRank() {
        return this.getShape().length;
    }

    @Override
    public int[] getShape() {
        return this.shapes;
    }

    @Override
    public List<Dimension> getDimensions() {
        return this.coordSys.getDimensions();
    }

    @Override
    public int compareTo(@Nonnull VariableSimpleIF o) {
        return this.getFullName().compareTo(o.getFullName());
    }
}

