/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import javax.annotation.Nullable;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.collection.Grib2Collection;
import ucar.nc2.grib.collection.GribCollectionBuilderFromIndex;
import ucar.nc2.grib.collection.GribCollectionMutable;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.collection.GribHorizCoordSystem;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.table.Grib2Tables;
import ucar.unidata.io.RandomAccessFile;

class Grib2CollectionBuilderFromIndex
extends GribCollectionBuilderFromIndex {
    protected Grib2Tables cust;

    @Nullable
    static Grib2Collection readFromIndex(String name, RandomAccessFile raf, FeatureCollectionConfig config, Logger logger) {
        Grib2CollectionBuilderFromIndex builder = new Grib2CollectionBuilderFromIndex(name, config, logger);
        if (!builder.readIndex(raf)) {
            return null;
        }
        if (builder.gc.getFiles().size() == 0) {
            logger.warn("Grib2CollectionBuilderFromIndex {}: has no files, force recreate ", (Object)builder.gc.getName());
            return null;
        }
        return new Grib2Collection(builder.gc);
    }

    @Nullable
    static GribCollectionMutable openMutableGCFromIndex(String name, RandomAccessFile raf, FeatureCollectionConfig config, Logger logger) {
        Grib2CollectionBuilderFromIndex builder = new Grib2CollectionBuilderFromIndex(name, config, logger);
        if (!builder.readIndex(raf)) {
            return null;
        }
        if (builder.gc.getFiles().size() == 0) {
            logger.warn("Grib2CollectionBuilderFromIndex {}: has no files, force recreate ", (Object)builder.gc.getName());
            return null;
        }
        return builder.gc;
    }

    Grib2CollectionBuilderFromIndex(String name, FeatureCollectionConfig config, Logger logger) {
        super(new GribCollectionMutable(name, null, config, false), config, logger);
    }

    @Override
    protected int getVersion() {
        return 3;
    }

    @Override
    protected int getMinVersion() {
        return 1;
    }

    @Override
    protected String getMagicStart() {
        return "Grib2Collectio2Index";
    }

    @Override
    protected GribTables makeCustomizer() {
        this.cust = Grib2Tables.factory(this.gc.center, this.gc.subcenter, this.gc.master, this.gc.local, this.gc.genProcessId);
        return this.cust;
    }

    @Override
    protected String getLevelNameShort(int levelCode) {
        return this.cust.getLevelNameShort(levelCode);
    }

    @Override
    protected GribHorizCoordSystem readGds(GribCollectionProto.Gds p) {
        byte[] rawGds = p.getGds().toByteArray();
        Grib2SectionGridDefinition gdss = new Grib2SectionGridDefinition(rawGds);
        Grib2Gds gds = gdss.getGDS();
        GdsHorizCoordSys hcs = gds.makeHorizCoordSys();
        String hcsName = this.makeHorizCoordSysName(hcs);
        String desc = null;
        if (this.config.gribConfig.gdsNamer != null) {
            desc = this.config.gribConfig.gdsNamer.get(gds.hashCode());
        }
        if (desc == null) {
            desc = hcs.makeDescription();
        }
        return new GribHorizCoordSystem(hcs, rawGds, gds, hcsName, desc, -1);
    }
}

