/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionConfigBuilder;
import thredds.featurecollection.FeatureCollectionType;
import thredds.filesystem.MFileOS;
import thredds.inventory.CollectionPathMatcher;
import thredds.inventory.CollectionSingleFile;
import thredds.inventory.CollectionSingleIndexFile;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.filter.StreamFilter;
import thredds.inventory.partition.DirectoryCollection;
import thredds.inventory.partition.DirectoryPartition;
import thredds.inventory.partition.FilePartition;
import thredds.inventory.partition.IndexReader;
import thredds.inventory.partition.PartitionManager;
import thredds.inventory.partition.PartitionManagerFromIndexDirectory;
import thredds.inventory.partition.TimePartition;
import ucar.nc2.constants.CDM;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.collection.GcMFile;
import ucar.nc2.grib.collection.Grib1Collection;
import ucar.nc2.grib.collection.Grib1CollectionBuilder;
import ucar.nc2.grib.collection.Grib1CollectionBuilderFromIndex;
import ucar.nc2.grib.collection.Grib1Partition;
import ucar.nc2.grib.collection.Grib1PartitionBuilder;
import ucar.nc2.grib.collection.Grib1PartitionBuilderFromIndex;
import ucar.nc2.grib.collection.Grib2Collection;
import ucar.nc2.grib.collection.Grib2CollectionBuilder;
import ucar.nc2.grib.collection.Grib2CollectionBuilderFromIndex;
import ucar.nc2.grib.collection.Grib2Partition;
import ucar.nc2.grib.collection.Grib2PartitionBuilder;
import ucar.nc2.grib.collection.Grib2PartitionBuilderFromIndex;
import ucar.nc2.grib.collection.GribCollectionBuilder;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribCollectionMutable;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.grib1.Grib1RecordScanner;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.nc2.stream.NcStream;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileCacheGuava;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class GribCdmIndex
implements IndexReader {
    public static final String NCX_SUFFIX = ".ncx4";
    private static final Logger classLogger = LoggerFactory.getLogger(GribCdmIndex.class);
    public static FileCacheIF gribCollectionCache;
    private static final boolean debug = false;
    private GribCollectionProto.GribCollection gribCollectionIndex;
    private final Logger logger;

    public static void initDefaultCollectionCache(int minElementsInMemory, int maxElementsInMemory, int period) {
        gribCollectionCache = new FileCacheGuava("DefaultGribCollectionCache", maxElementsInMemory);
    }

    public static void disableGribCollectionCache() {
        if (null != gribCollectionCache) {
            gribCollectionCache.disable();
        }
        gribCollectionCache = null;
    }

    public static void setGribCollectionCache(FileCacheIF cache) {
        if (null != gribCollectionCache) {
            gribCollectionCache.disable();
        }
        gribCollectionCache = cache;
    }

    static GribCollectionImmutable acquireGribCollection(FileFactory factory, Object hashKey, String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        DatasetUrl durl = new DatasetUrl(null, location);
        FileCacheable result = gribCollectionCache != null ? gribCollectionCache.acquire(factory, hashKey, durl, buffer_size, cancelTask, spiObject) : factory.open(durl, buffer_size, cancelTask, spiObject);
        return (GribCollectionImmutable)result;
    }

    public static void shutdown() {
        if (gribCollectionCache != null) {
            gribCollectionCache.clearCache(true);
        }
    }

    public static File getTopIndexFileFromConfig(FeatureCollectionConfig config) {
        File indexFile = GribCdmIndex.makeTopIndexFileFromConfig(config);
        return GribIndexCache.getExistingFileOrCache(indexFile.getPath());
    }

    private static File makeTopIndexFileFromConfig(FeatureCollectionConfig config) {
        Formatter errlog = new Formatter();
        CollectionSpecParser specp = config.getCollectionSpecParser(errlog);
        String name = StringUtil2.replace(config.collectionName, '\\', "/");
        return GribCdmIndex.makeIndexFile(name, new File(specp.getRootDir()));
    }

    static File makeIndexFile(String collectionName, File directory) {
        String nameNoBlanks = StringUtil2.replace(collectionName, ' ', "_");
        return new File(directory, nameNoBlanks + NCX_SUFFIX);
    }

    private static String makeNameFromIndexFilename(String idxPathname) {
        String idxFilename;
        int pos = (idxPathname = StringUtil2.replace(idxPathname, '\\', "/")).lastIndexOf(47);
        String string = idxFilename = pos < 0 ? idxPathname : idxPathname.substring(pos + 1);
        assert (idxFilename.endsWith(NCX_SUFFIX)) : idxFilename;
        return idxFilename.substring(0, idxFilename.length() - NCX_SUFFIX.length());
    }

    public static GribCollectionType getType(RandomAccessFile raf) throws IOException {
        String magic;
        raf.seek(0L);
        switch (magic = raf.readString("Grib2Collectio2Index".getBytes(CDM.utf8Charset).length)) {
            case "Grib2Collectio2Index": {
                return GribCollectionType.GRIB2;
            }
            case "Grib1Collectio2Index": {
                return GribCollectionType.GRIB1;
            }
            case "Grib2Partition2Index": {
                return GribCollectionType.Partition2;
            }
            case "Grib1Partition2Index": {
                return GribCollectionType.Partition1;
            }
        }
        return GribCollectionType.none;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static GribCollectionImmutable openCdmIndex(String indexFilename, FeatureCollectionConfig config, boolean useCache, Logger logger) throws IOException {
        void var7_12;
        File indexFileInCache;
        File file = indexFileInCache = useCache ? GribIndexCache.getExistingFileOrCache(indexFilename) : new File(indexFilename);
        if (indexFileInCache == null) {
            return null;
        }
        String indexFilenameInCache = indexFileInCache.getPath();
        String name = GribCdmIndex.makeNameFromIndexFilename(indexFilename);
        Object var7_7 = null;
        try (RandomAccessFile raf = RandomAccessFile.acquire(indexFilenameInCache);){
            GribCollectionType type = GribCdmIndex.getType(raf);
            switch (type) {
                case GRIB2: {
                    Grib2Collection grib2Collection = Grib2CollectionBuilderFromIndex.readFromIndex(name, raf, config, logger);
                    return var7_12;
                }
                case Partition2: {
                    Grib2Partition grib2Partition = Grib2PartitionBuilderFromIndex.createTimePartitionFromIndex(name, raf, config, logger);
                    return var7_12;
                }
                case GRIB1: {
                    Grib1Collection grib1Collection = Grib1CollectionBuilderFromIndex.readFromIndex(name, raf, config, logger);
                    return var7_12;
                }
                case Partition1: {
                    Grib1Partition grib1Partition = Grib1PartitionBuilderFromIndex.createTimePartitionFromIndex(name, raf, config, logger);
                    return var7_12;
                }
                default: {
                    logger.warn("GribCdmIndex.openCdmIndex failed on {} type={}", (Object)indexFilenameInCache, (Object)type);
                    return var7_12;
                }
            }
        }
        catch (FileNotFoundException ioe) {
            throw ioe;
        }
        catch (Throwable t) {
            logger.warn("GribCdmIndex.openCdmIndex failed on " + indexFilenameInCache, t);
            RandomAccessFile.eject(indexFilenameInCache);
            if (indexFileInCache.delete()) return var7_12;
            logger.warn("failed to delete {}", (Object)indexFileInCache.getPath());
        }
        return var7_12;
    }

    @Nullable
    public static GribCollectionMutable openMutableGCFromIndex(String indexFilename, FeatureCollectionConfig config, boolean dataOnly, boolean useCache, Logger logger) {
        File indexFileInCache;
        File file = indexFileInCache = useCache ? GribIndexCache.getExistingFileOrCache(indexFilename) : new File(indexFilename);
        if (indexFileInCache == null) {
            return null;
        }
        String indexFilenameInCache = indexFileInCache.getPath();
        String name = GribCdmIndex.makeNameFromIndexFilename(indexFilename);
        GribCollectionMutable result = null;
        try (RandomAccessFile raf = RandomAccessFile.acquire(indexFilenameInCache);){
            GribCollectionType type = GribCdmIndex.getType(raf);
            switch (type) {
                case GRIB2: {
                    result = Grib2CollectionBuilderFromIndex.openMutableGCFromIndex(name, raf, config, logger);
                    break;
                }
                case Partition2: {
                    result = Grib2PartitionBuilderFromIndex.openMutablePCFromIndex(name, raf, config, logger);
                    break;
                }
                case GRIB1: {
                    result = Grib1CollectionBuilderFromIndex.openMutableGCFromIndex(name, raf, config, logger);
                    break;
                }
                case Partition1: {
                    result = Grib1PartitionBuilderFromIndex.openMutablePCFromIndex(name, raf, config, logger);
                    break;
                }
                default: {
                    logger.warn("GribCdmIndex.openMutableGCFromIndex failed on {} type={}", (Object)indexFilenameInCache, (Object)type);
                }
            }
            if (result != null) {
                result.lastModified = raf.getLastModified();
                result.fileSize = raf.length();
            }
        }
        catch (Throwable t) {
            logger.warn("GribCdmIndex.openMutableGCFromIndex failed on " + indexFilenameInCache, t);
        }
        if (result == null) {
            RandomAccessFile.eject(indexFilenameInCache);
            if (!indexFileInCache.delete()) {
                logger.warn("failed to delete {}", (Object)indexFileInCache.getPath());
            }
        }
        return result;
    }

    public static boolean updateGribCollectionFromPCollection(boolean isGrib1, PartitionManager dcm, CollectionUpdateType updateType, Formatter errlog, Logger logger) throws IOException {
        if (updateType == CollectionUpdateType.never || dcm instanceof CollectionSingleIndexFile) {
            return false;
        }
        boolean changed = GribCdmIndex.updatePartition(isGrib1, dcm, updateType, logger, errlog);
        if (errlog != null) {
            errlog.format("PartitionCollection %s was recreated %s%n", dcm.getCollectionName(), changed);
        }
        return changed;
    }

    public static boolean updateGribCollection(FeatureCollectionConfig config, CollectionUpdateType updateType, Logger logger) throws IOException {
        boolean changed;
        boolean isGrib1;
        if (logger == null) {
            logger = classLogger;
        }
        long start = System.currentTimeMillis();
        Formatter errlog = new Formatter();
        CollectionSpecParser specp = config.getCollectionSpecParser(errlog);
        Path rootPath = Paths.get(specp.getRootDir(), new String[0]);
        boolean bl = isGrib1 = config.type == FeatureCollectionType.GRIB1;
        if (config.ptype == FeatureCollectionConfig.PartitionType.none || config.ptype == FeatureCollectionConfig.PartitionType.all) {
            try (CollectionPathMatcher dcm = new CollectionPathMatcher(config, specp, logger);){
                changed = GribCdmIndex.updateGribCollection(isGrib1, dcm, updateType, FeatureCollectionConfig.PartitionType.none, logger, errlog);
            }
        } else if (config.ptype == FeatureCollectionConfig.PartitionType.timePeriod) {
            try (TimePartition tp = new TimePartition(config, specp, logger);){
                changed = GribCdmIndex.updateTimePartition(isGrib1, tp, updateType, logger);
            }
        } else if (specp.wantSubdirs()) {
            try (DirectoryPartition dpart = new DirectoryPartition(config, rootPath, true, new GribCdmIndex(logger), NCX_SUFFIX, logger);){
                dpart.putAuxInfo("fcConfig", config);
                changed = GribCdmIndex.updateDirectoryCollectionRecurse(isGrib1, dpart, config, updateType, logger);
            }
        } else {
            changed = GribCdmIndex.updateLeafCollection(isGrib1, config, updateType, true, logger, rootPath);
        }
        long took = System.currentTimeMillis() - start;
        logger.info("updateGribCollection {} changed {} took {} msecs", config.collectionName, changed, took);
        return changed;
    }

    public static boolean updateGribCollection(boolean isGrib1, MCollection dcm, CollectionUpdateType updateType, FeatureCollectionConfig.PartitionType ptype, Logger logger, Formatter errlog) throws IOException {
        Grib1CollectionBuilder builder;
        logger.debug("GribCdmIndex.updateGribCollection %s %s%n", (Object)dcm.getCollectionName(), (Object)updateType);
        if (!GribCdmIndex.isUpdateNeeded(dcm.getIndexFilename(NCX_SUFFIX), updateType, isGrib1 ? GribCollectionType.GRIB1 : GribCollectionType.GRIB2, logger)) {
            return false;
        }
        boolean changed = isGrib1 ? (builder = new Grib1CollectionBuilder(dcm.getCollectionName(), dcm, logger)).updateNeeded(updateType) && builder.createIndex(ptype, errlog) : (builder = new Grib2CollectionBuilder(dcm.getCollectionName(), dcm, logger)).updateNeeded(updateType) && builder.createIndex(ptype, errlog);
        return changed;
    }

    private static boolean updatePartition(boolean isGrib1, PartitionManager dcm, CollectionUpdateType updateType, Logger logger, Formatter errlog) throws IOException {
        Grib1PartitionBuilder builder;
        boolean changed = isGrib1 ? (builder = new Grib1PartitionBuilder(dcm.getCollectionName(), new File(dcm.getRoot()), dcm, logger)).updateNeeded(updateType) && builder.createPartitionedIndex(updateType, errlog) : (builder = new Grib2PartitionBuilder(dcm.getCollectionName(), new File(dcm.getRoot()), dcm, logger)).updateNeeded(updateType) && builder.createPartitionedIndex(updateType, errlog);
        return changed;
    }

    private static boolean updateTimePartition(boolean isGrib1, TimePartition tp, CollectionUpdateType updateType, Logger logger) throws IOException {
        logger.debug("GribCdmIndex.updateTimePartition %s %s%n", (Object)tp.getRoot(), (Object)updateType);
        if (!GribCdmIndex.isUpdateNeeded(tp.getIndexFilename(NCX_SUFFIX), updateType, isGrib1 ? GribCollectionType.Partition1 : GribCollectionType.Partition2, logger)) {
            return false;
        }
        long start = System.currentTimeMillis();
        Formatter errlog = new Formatter();
        for (MCollection part : tp.makePartitions(updateType)) {
            try {
                GribCdmIndex.updateGribCollection(isGrib1, part, updateType, FeatureCollectionConfig.PartitionType.timePeriod, logger, errlog);
            }
            catch (Throwable t) {
                logger.warn("Error making partition " + part.getRoot(), t);
                tp.removePartition(part);
            }
        }
        try {
            boolean changed = GribCdmIndex.updatePartition(isGrib1, tp, updateType, logger, errlog);
            long took = System.currentTimeMillis() - start;
            errlog.format(" INFO updateTimePartition %s took %d msecs%n", tp.getRoot(), took);
            logger.debug("GribCdmIndex.updateTimePartition complete (%s) on %s errlog=%s%n", changed, tp.getRoot(), errlog);
            return changed;
        }
        catch (IllegalStateException t) {
            logger.warn("Error making partition {} '{}'", (Object)tp.getRoot(), (Object)t.getMessage());
            return false;
        }
        catch (Throwable t) {
            logger.error("Error making partition " + tp.getRoot(), t);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isUpdateNeeded(String idxFilenameOrg, CollectionUpdateType updateType, GribCollectionType wantType, Logger logger) {
        boolean bad;
        if (updateType == CollectionUpdateType.never) {
            return false;
        }
        File collectionIndexFile = GribIndexCache.getExistingFileOrCache(idxFilenameOrg);
        if (collectionIndexFile == null) return true;
        try (RandomAccessFile raf = RandomAccessFile.acquire(collectionIndexFile.getPath());){
            GribCollectionType type = GribCdmIndex.getType(raf);
            boolean bl = bad = type != wantType;
            if (!bad && updateType == CollectionUpdateType.nocheck) {
                boolean bl2 = false;
                return bl2;
            }
        }
        catch (IOException ioe) {
            bad = true;
        }
        if (!bad) return true;
        RandomAccessFile.eject(collectionIndexFile.getPath());
        if (collectionIndexFile.delete()) return true;
        logger.warn("failed to delete {}", (Object)collectionIndexFile.getPath());
        return true;
    }

    private static boolean updateDirectoryCollectionRecurse(boolean isGrib1, DirectoryPartition dpart, FeatureCollectionConfig config, CollectionUpdateType updateType, Logger logger) throws IOException {
        logger.debug("GribCdmIndex.updateDirectoryCollectionRecurse %s %s%n", (Object)dpart.getRoot(), (Object)updateType);
        if (!GribCdmIndex.isUpdateNeeded(dpart.getIndexFilename(NCX_SUFFIX), updateType, isGrib1 ? GribCollectionType.Partition1 : GribCollectionType.Partition2, logger)) {
            return false;
        }
        long start = System.currentTimeMillis();
        if (updateType != CollectionUpdateType.testIndexOnly) {
            for (MCollection part : dpart.makePartitions(updateType)) {
                part.putAuxInfo("fcConfig", config);
                try {
                    if (part instanceof DirectoryPartition) {
                        GribCdmIndex.updateDirectoryCollectionRecurse(isGrib1, (DirectoryPartition)part, config, updateType, logger);
                        continue;
                    }
                    Path partPath = Paths.get(part.getRoot(), new String[0]);
                    GribCdmIndex.updateLeafCollection(isGrib1, config, updateType, false, logger, partPath);
                }
                catch (IllegalStateException t) {
                    logger.warn("Error making partition {} '{}'", (Object)part.getRoot(), (Object)t.getMessage());
                    dpart.removePartition(part);
                }
                catch (Throwable t) {
                    logger.error("Error making partition " + part.getRoot(), t);
                    dpart.removePartition(part);
                }
            }
        }
        try {
            Formatter errlog = new Formatter();
            boolean changed = GribCdmIndex.updatePartition(isGrib1, dpart, updateType, logger, errlog);
            long took = System.currentTimeMillis() - start;
            errlog.format(" INFO updateDirectoryCollectionRecurse %s took %d msecs%n", dpart.getRoot(), took);
            logger.debug("GribCdmIndex.updateDirectoryCollectionRecurse complete (%s) on %s errlog=%s%n", changed, dpart.getRoot(), errlog);
            return changed;
        }
        catch (IllegalStateException t) {
            logger.warn("Error making partition {} '{}'", (Object)dpart.getRoot(), (Object)t.getMessage());
            return false;
        }
        catch (Throwable t) {
            logger.error("Error making partition " + dpart.getRoot(), t);
            return false;
        }
    }

    private static boolean updateLeafCollection(boolean isGrib1, FeatureCollectionConfig config, CollectionUpdateType updateType, boolean isTop, Logger logger, Path dirPath) throws IOException {
        if (config.ptype == FeatureCollectionConfig.PartitionType.file) {
            return GribCdmIndex.updateFilePartition(isGrib1, config, updateType, isTop, logger, dirPath);
        }
        Formatter errlog = new Formatter();
        CollectionSpecParser specp = config.getCollectionSpecParser(errlog);
        try (DirectoryCollection dcm = new DirectoryCollection(config.collectionName, dirPath, isTop, config.olderThan, logger);){
            dcm.putAuxInfo("fcConfig", config);
            if (specp.getFilter() != null) {
                dcm.setStreamFilter(new StreamFilter(specp.getFilter(), specp.getFilterOnName()));
            }
            boolean changed = GribCdmIndex.updateGribCollection(isGrib1, dcm, updateType, FeatureCollectionConfig.PartitionType.directory, logger, errlog);
            logger.debug("  GribCdmIndex.updateDirectoryPartition was updated=%s on %s%n", (Object)changed, (Object)dirPath);
            boolean bl = changed;
            return bl;
        }
    }

    /*
     * Loose catch block
     */
    private static boolean updateFilePartition(boolean isGrib1, FeatureCollectionConfig config, CollectionUpdateType updateType, boolean isTop, Logger logger, Path dirPath) throws IOException {
        long start = System.currentTimeMillis();
        Formatter errlog = new Formatter();
        CollectionSpecParser specp = config.getCollectionSpecParser(errlog);
        Throwable throwable = null;
        try (FilePartition partition = new FilePartition(config.collectionName, dirPath, isTop, config.olderThan, logger);){
            partition.putAuxInfo("fcConfig", config);
            if (specp.getFilter() != null) {
                partition.setStreamFilter(new StreamFilter(specp.getFilter(), specp.getFilterOnName()));
            }
            logger.debug("GribCdmIndex.updateFilePartition %s %s%n", (Object)partition.getCollectionName(), (Object)updateType);
            if (!GribCdmIndex.isUpdateNeeded(partition.getIndexFilename(NCX_SUFFIX), updateType, isGrib1 ? GribCollectionType.Partition1 : GribCollectionType.Partition2, logger)) {
                boolean bl = false;
                return bl;
            }
            AtomicBoolean anyChange = new AtomicBoolean(false);
            if (updateType != CollectionUpdateType.testIndexOnly) {
                partition.iterateOverMFileCollection(mfile -> {
                    CollectionSingleFile part = new CollectionSingleFile(mfile, logger);
                    part.putAuxInfo("fcConfig", config);
                    try {
                        boolean changed = GribCdmIndex.updateGribCollection(isGrib1, part, updateType, FeatureCollectionConfig.PartitionType.file, logger, errlog);
                        if (changed) {
                            anyChange.set(true);
                        }
                    }
                    catch (IllegalStateException t) {
                        logger.warn("Error making partition {} '{}'", (Object)part.getRoot(), (Object)t.getMessage());
                        partition.removePartition(part);
                    }
                    catch (Throwable t) {
                        logger.error("Error making partition " + part.getRoot(), t);
                        partition.removePartition(part);
                    }
                });
            }
            try {
                boolean recreated = GribCdmIndex.updatePartition(isGrib1, partition, updateType, logger, errlog);
                long took = System.currentTimeMillis() - start;
                if (recreated) {
                    logger.info("RewriteFilePartition {} took {} msecs", (Object)partition.getCollectionName(), (Object)took);
                }
                boolean bl = recreated;
                return bl;
            }
            catch (IllegalStateException t) {
                boolean bl;
                block28: {
                    block29: {
                        logger.warn("Error making partition {} '{}'", (Object)partition.getRoot(), (Object)t.getMessage());
                        bl = false;
                        if (partition == null) break block28;
                        if (throwable == null) break block29;
                        try {
                            partition.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block28;
                    }
                    partition.close();
                }
                return bl;
            }
            catch (Throwable t) {
                boolean bl;
                block30: {
                    block31: {
                        logger.error("Error making partition " + partition.getRoot(), t);
                        bl = false;
                        if (partition == null) break block30;
                        if (throwable == null) break block31;
                        try {
                            partition.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block30;
                    }
                    partition.close();
                }
                return bl;
                {
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throw throwable5;
                    }
                }
            }
        }
    }

    public static boolean makeIndex(FeatureCollectionConfig config, Formatter errlog, Path topPath) throws IOException {
        return false;
    }

    public static boolean moveCdmIndex(String indexFilename, Logger logger) throws IOException {
        return false;
    }

    public static GribCollectionImmutable openGribCollection(FeatureCollectionConfig config, CollectionUpdateType updateType, Logger logger) throws IOException {
        boolean changed = GribCdmIndex.updateGribCollection(config, updateType, logger);
        File idxFile = GribCdmIndex.makeTopIndexFileFromConfig(config);
        if (updateType == CollectionUpdateType.never || changed) {
            gribCollectionCache.clearCache(true);
        }
        return GribCdmIndex.openCdmIndex(idxFile.getPath(), config, true, logger);
    }

    public static GribCollectionImmutable openGribCollectionFromRaf(RandomAccessFile raf, FeatureCollectionConfig config, CollectionUpdateType updateType, Logger logger) throws IOException {
        GribCollectionImmutable result;
        boolean isGrib1 = false;
        boolean isGrib2 = Grib2RecordScanner.isValidFile(raf);
        if (!isGrib2) {
            isGrib1 = Grib1RecordScanner.isValidFile(raf);
        }
        if (isGrib1 || isGrib2) {
            result = GribCdmIndex.openGribCollectionFromDataFile(isGrib1, raf, config, updateType, null, logger);
            raf.close();
        } else {
            result = GribCdmIndex.openGribCollectionFromIndexFile(raf, config, logger);
        }
        return result;
    }

    private static GribCollectionImmutable openGribCollectionFromDataFile(boolean isGrib1, RandomAccessFile dataRaf, FeatureCollectionConfig config, CollectionUpdateType updateType, Formatter errlog, Logger logger) throws IOException {
        String filename = dataRaf.getLocation();
        File dataFile = new File(filename);
        MFileOS mfile = new MFileOS(dataFile);
        return GribCdmIndex.openGribCollectionFromDataFile(isGrib1, mfile, updateType, config, errlog, logger);
    }

    @Nullable
    public static GribCollectionImmutable openGribCollectionFromDataFile(boolean isGrib1, MFile mfile, CollectionUpdateType updateType, FeatureCollectionConfig config, Formatter errlog, Logger logger) throws IOException {
        GribCollectionBuilder builder;
        CollectionSingleFile dcm = new CollectionSingleFile(mfile, logger);
        dcm.putAuxInfo("fcConfig", config);
        if (isGrib1) {
            builder = new Grib1CollectionBuilder(dcm.getCollectionName(), dcm, logger);
            boolean bl = builder.updateNeeded(updateType) && builder.createIndex(FeatureCollectionConfig.PartitionType.file, errlog);
        } else {
            builder = new Grib2CollectionBuilder(dcm.getCollectionName(), dcm, logger);
            boolean bl = builder.updateNeeded(updateType) && builder.createIndex(FeatureCollectionConfig.PartitionType.file, errlog);
        }
        GribCollectionImmutable result = GribCdmIndex.openCdmIndex(dcm.getIndexFilename(NCX_SUFFIX), config, true, logger);
        if (result != null) {
            return result;
        }
        if (updateType == CollectionUpdateType.never) {
            return null;
        }
        if (updateType == CollectionUpdateType.always) {
            return null;
        }
        return GribCdmIndex.openGribCollectionFromDataFile(isGrib1, mfile, CollectionUpdateType.always, config, errlog, logger);
    }

    @Nullable
    public static GribCollectionImmutable openGribCollectionFromIndexFile(RandomAccessFile indexRaf, FeatureCollectionConfig config, Logger logger) throws IOException {
        GribCollectionType type = GribCdmIndex.getType(indexRaf);
        String location = indexRaf.getLocation();
        File f = new File(location);
        int pos = f.getName().lastIndexOf(".");
        String name = pos > 0 ? f.getName().substring(0, pos) : f.getName();
        switch (type) {
            case Partition1: {
                return Grib1PartitionBuilderFromIndex.createTimePartitionFromIndex(name, indexRaf, config, logger);
            }
            case GRIB1: {
                return Grib1CollectionBuilderFromIndex.readFromIndex(name, indexRaf, config, logger);
            }
            case Partition2: {
                return Grib2PartitionBuilderFromIndex.createTimePartitionFromIndex(name, indexRaf, config, logger);
            }
            case GRIB2: {
                return Grib2CollectionBuilderFromIndex.readFromIndex(name, indexRaf, config, logger);
            }
        }
        return null;
    }

    public GribCdmIndex(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean readChildren(Path indexFile, IndexReader.AddChildCallback callback) throws IOException {
        this.logger.debug("GribCdmIndex.readChildren %s%n", (Object)indexFile);
        try (RandomAccessFile raf = RandomAccessFile.acquire(indexFile.toString());){
            GribCollectionType type = GribCdmIndex.getType(raf);
            if ((type == GribCollectionType.Partition1 || type == GribCollectionType.Partition2) && this.openIndex(raf, this.logger)) {
                String topDir = this.gribCollectionIndex.getTopDir();
                int n = this.gribCollectionIndex.getMfilesCount();
                for (int i = 0; i < n; ++i) {
                    GribCollectionProto.MFile mfilep = this.gribCollectionIndex.getMfiles(i);
                    callback.addChild(topDir, mfilep.getFilename(), mfilep.getLastModified());
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean isPartition(Path indexFile) throws IOException {
        this.logger.debug("GribCdmIndex.isPartition %s%n", (Object)indexFile);
        try (RandomAccessFile raf = RandomAccessFile.acquire(indexFile.toString());){
            GribCollectionType type = GribCdmIndex.getType(raf);
            boolean bl = type == GribCollectionType.Partition1 || type == GribCollectionType.Partition2;
            return bl;
        }
    }

    @Override
    public boolean readMFiles(Path indexFile, List<MFile> result) throws IOException {
        this.logger.debug("GribCdmIndex.readMFiles %s%n", (Object)indexFile);
        try (RandomAccessFile raf = RandomAccessFile.acquire(indexFile.toString());){
            if (this.openIndex(raf, this.logger)) {
                File protoDir = new File(this.gribCollectionIndex.getTopDir());
                int n = this.gribCollectionIndex.getMfilesCount();
                for (int i = 0; i < n; ++i) {
                    GribCollectionProto.MFile mfilep = this.gribCollectionIndex.getMfiles(i);
                    result.add(new GcMFile(protoDir, mfilep.getFilename(), mfilep.getLastModified(), mfilep.getLength(), mfilep.getIndex()));
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    private boolean openIndex(RandomAccessFile indexRaf, Logger logger) {
        try {
            indexRaf.order(0);
            indexRaf.seek(0L);
            byte[] magic = new byte["Grib2Collectio2Index".getBytes(CDM.utf8Charset).length];
            indexRaf.readFully(magic);
            int version = indexRaf.readInt();
            long recordLength = indexRaf.readLong();
            if (recordLength > Integer.MAX_VALUE) {
                logger.error("Grib2Collection {}: invalid recordLength size {}", (Object)indexRaf.getLocation(), (Object)recordLength);
                return false;
            }
            indexRaf.skipBytes(recordLength);
            int size = NcStream.readVInt(indexRaf);
            if (size < 0 || size > 100000000) {
                logger.warn("GribCdmIndex {}: invalid index size {}", (Object)indexRaf.getLocation(), (Object)size);
                return false;
            }
            byte[] m3 = new byte[size];
            indexRaf.readFully(m3);
            this.gribCollectionIndex = GribCollectionProto.GribCollection.parseFrom(m3);
            return true;
        }
        catch (Throwable t) {
            logger.error("Error reading index " + indexRaf.getLocation(), t);
            return false;
        }
    }

    public static void main2(String[] args) throws IOException {
        Logger logger = LoggerFactory.getLogger("test");
        PartitionManagerFromIndexDirectory partition = new PartitionManagerFromIndexDirectory("NCDC-gfs4_all", new FeatureCollectionConfig(), new File("B:/ncdc/gfs4_all/"), NCX_SUFFIX, logger);
        Grib1PartitionBuilder builder = new Grib1PartitionBuilder("NCDC-gfs4_all", new File(partition.getRoot()), partition, logger);
        builder.createPartitionedIndex(CollectionUpdateType.nocheck, new Formatter());
    }

    public static void main3(String[] args) throws IOException {
        Logger logger = LoggerFactory.getLogger("test");
        FeatureCollectionConfig config = new FeatureCollectionConfig("RFC", "grib/NPVU/RFC", FeatureCollectionType.GRIB1, "B:/motherlode/rfc/**/.*grib1$", null, "yyyyMMdd#.grib1#", null, "directory", null);
        boolean changed = GribCdmIndex.updateGribCollection(config, CollectionUpdateType.test, logger);
    }

    public static void main(String[] args) throws Exception {
        String progName = GribCdmIndex.class.getName();
        try {
            CommandLine cmdLine = new CommandLine(progName, args);
            cmdLine.getClass();
            Formatter errlog = new Formatter();
            try {
                FeatureCollectionConfigBuilder reader = new FeatureCollectionConfigBuilder(errlog);
                String location = cmdLine.inputFile.getAbsolutePath();
                FeatureCollectionConfig config = reader.readConfigFromFile(location);
                boolean changed = GribCdmIndex.updateGribCollection(config, cmdLine.updateType, classLogger);
                System.out.printf("changed = %s%n", changed);
            }
            catch (Exception e) {
                System.out.printf("%s = %s %n", e.getClass().getName(), e.getMessage());
                String err = errlog.toString();
                if (err.length() > 0) {
                    System.out.printf(" errlog=%s%n", err);
                }
                e.printStackTrace();
            }
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage());
            System.err.printf("Try \"%s --help\" for more information.%n", progName);
        }
    }

    private static class CommandLine {
        @Parameter(names={"-fc", "--featureCollection"}, description="Input XML file containing <featureCollection> root element", required=true)
        File inputFile;
        @Parameter(names={"-update", "--CollectionUpdateType"}, description="Collection Update Type")
        final CollectionUpdateType updateType = CollectionUpdateType.always;
        @Parameter(names={"-h", "--help"}, description="Display this help and exit", help=true)
        public final boolean help = false;
        private final JCommander jc;

        public CommandLine(String progName, String[] args) throws ParameterException {
            this.jc = new JCommander((Object)this, args);
            this.jc.setProgramName(progName);
            this.jc.setParameterDescriptionComparator(new ParameterDescriptionComparator());
        }

        public void printUsage() {
            this.jc.usage();
        }

        private static class ParameterDescriptionComparator
        implements Comparator<ParameterDescription> {
            private final List<String> orderedParamNames = Arrays.asList("--featureCollection", "--CollectionUpdateType", "--help");

            private ParameterDescriptionComparator() {
            }

            @Override
            public int compare(ParameterDescription p0, ParameterDescription p1) {
                int index0 = this.orderedParamNames.indexOf(p0.getLongestName());
                int index1 = this.orderedParamNames.indexOf(p1.getLongestName());
                assert (index0 >= 0) : "Unexpected parameter name: " + p0.getLongestName();
                assert (index1 >= 0) : "Unexpected parameter name: " + p1.getLongestName();
                return Integer.compare(index0, index1);
            }
        }

        public class CollectionUpdateTypeConverter
        implements IStringConverter<CollectionUpdateType> {
            @Override
            public CollectionUpdateType convert(String value) {
                return CollectionUpdateType.valueOf(value);
            }
        }
    }

    public static enum GribCollectionType {
        GRIB1,
        GRIB2,
        Partition1,
        Partition2,
        none;

    }
}

