/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.Formatter;
import javax.annotation.Nullable;
import ucar.nc2.grib.GribData;
import ucar.nc2.grib.QuasiRegular;
import ucar.nc2.grib.grib2.Grib2DataReader;
import ucar.nc2.grib.grib2.Grib2Drs;
import ucar.nc2.grib.grib2.Grib2Gds;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.nc2.grib.grib2.Grib2SectionBitMap;
import ucar.nc2.grib.grib2.Grib2SectionData;
import ucar.nc2.grib.grib2.Grib2SectionDataRepresentation;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2SectionIndicator;
import ucar.nc2.grib.grib2.Grib2SectionLocalUse;
import ucar.nc2.grib.grib2.Grib2SectionProductDefinition;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class Grib2Record {
    private final Grib2SectionIndicator is;
    private final Grib2SectionIdentification id;
    private Grib2SectionLocalUse lus;
    private Grib2SectionGridDefinition gdss;
    private Grib2SectionProductDefinition pdss;
    private Grib2SectionDataRepresentation drss;
    private Grib2SectionBitMap bms;
    private Grib2SectionData dataSection;
    private Grib2Pds pds2 = null;
    private final byte[] header;
    private int file;
    private boolean bmsReplaced;
    private int scanMode;
    public int repeat;
    public static boolean getlastRecordRead;
    public static Grib2Record lastRecordRead;

    public Grib2Record(byte[] header, Grib2SectionIndicator is, Grib2SectionIdentification id, Grib2SectionLocalUse lus, Grib2SectionGridDefinition gdss, Grib2SectionProductDefinition pdss, Grib2SectionDataRepresentation drs, Grib2SectionBitMap bms, Grib2SectionData dataSection, boolean bmsReplaced, int scanMode) {
        this.header = header;
        this.is = is;
        this.id = id;
        this.lus = lus;
        this.gdss = gdss;
        this.pdss = pdss;
        this.drss = drs;
        this.bms = bms;
        this.dataSection = dataSection;
        this.bmsReplaced = bmsReplaced;
        this.scanMode = scanMode;
        if (scanMode == 9999 && gdss != null) {
            this.scanMode = gdss.getGDS().getScanMode();
        }
    }

    Grib2Record(Grib2Record from) {
        this.header = from.header;
        this.is = from.is;
        this.id = from.id;
        this.lus = from.lus;
        this.gdss = from.gdss;
        this.pdss = from.pdss;
        this.drss = from.drss;
        this.bms = from.bms;
        this.dataSection = from.dataSection;
        this.repeat = from.repeat;
        this.bmsReplaced = from.bmsReplaced;
        this.scanMode = from.scanMode;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public Grib2SectionIndicator getIs() {
        return this.is;
    }

    public Grib2SectionIdentification getId() {
        return this.id;
    }

    public boolean hasLocalUseSection() {
        return this.lus != null && this.lus.getRawBytes() != null;
    }

    public Grib2SectionLocalUse getLocalUseSection() {
        return this.lus;
    }

    public Grib2SectionGridDefinition getGDSsection() {
        return this.gdss;
    }

    public Grib2SectionProductDefinition getPDSsection() {
        return this.pdss;
    }

    public Grib2SectionDataRepresentation getDataRepresentationSection() {
        return this.drss;
    }

    public Grib2SectionBitMap getBitmapSection() {
        return this.bms;
    }

    public Grib2SectionData getDataSection() {
        return this.dataSection;
    }

    public int getDiscipline() {
        return this.is.getDiscipline();
    }

    public CalendarDate getReferenceDate() {
        return this.id.getReferenceDate();
    }

    public Grib2Pds getPDS() {
        if (this.pds2 == null) {
            this.pds2 = this.pdss.getPDS();
        }
        return this.pds2;
    }

    public synchronized Grib2Gds getGDS() {
        return this.gdss.getGDS();
    }

    public int getScanMode() {
        return this.scanMode;
    }

    public void show(Formatter f) {
        f.format("discipline=%d ", this.is.getDiscipline());
        Grib2Pds pds = this.getPDS();
        pds.show(f);
    }

    public void setLus(Grib2SectionLocalUse lus) {
        this.lus = lus;
    }

    public void setGdss(Grib2SectionGridDefinition gdss) {
        this.gdss = gdss;
    }

    public void setPdss(Grib2SectionProductDefinition pdss) {
        this.pdss = pdss;
    }

    public void setDrs(Grib2SectionDataRepresentation drs) {
        this.drss = drs;
    }

    public void setBms(Grib2SectionBitMap bms, boolean replaced) {
        this.bms = bms;
        this.bmsReplaced = replaced;
    }

    public void setDataSection(Grib2SectionData dataSection) {
        this.dataSection = dataSection;
    }

    public int getFile() {
        return this.file;
    }

    public void setFile(int file) {
        this.file = file;
    }

    public boolean isBmsReplaced() {
        return this.bmsReplaced;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("is", this.is).add("id", this.id).add("lus", this.lus).add("gdss", this.gdss).add("pdss", this.pdss).add("drss", this.drss).add("bms", this.bms).add("dataSection", this.dataSection).add("pds2", this.pds2).add("header", this.header).add("file", this.file).add("bmsReplaced", this.bmsReplaced).add("scanMode", this.scanMode).add("repeat", this.repeat).toString();
    }

    public float[] readData(RandomAccessFile raf) throws IOException {
        Grib2Gds gds = this.getGDS();
        Grib2DataReader reader = new Grib2DataReader(this.drss.getDataTemplate(), this.gdss.getNumberPoints(), this.drss.getDataPoints(), this.getScanMode(), gds.getNxRaw(), this.dataSection.getStartingPosition(), this.dataSection.getMsgLength());
        Grib2Drs gdrs = this.drss.getDrs(raf);
        float[] data = reader.getData(raf, this.bms, gdrs);
        if (gds.isThin()) {
            data = QuasiRegular.convertQuasiGrid(data, gds.getNptsInLine(), gds.getNxRaw(), gds.getNyRaw(), GribData.getInterpolationMethod());
        }
        lastRecordRead = this;
        return data;
    }

    @Nullable
    public int[] readRawData(RandomAccessFile raf) throws IOException {
        Grib2Gds gds = this.getGDS();
        Grib2DataReader reader = new Grib2DataReader(this.drss.getDataTemplate(), this.gdss.getNumberPoints(), this.drss.getDataPoints(), this.getScanMode(), gds.getNxRaw(), this.dataSection.getStartingPosition(), this.dataSection.getMsgLength());
        Grib2Drs gdrs = this.drss.getDrs(raf);
        return reader.getRawData(raf, this.bms, gdrs);
    }

    @Nullable
    public Grib2Drs.Type40 readDataTest(RandomAccessFile raf) throws IOException {
        Grib2Gds gds = this.getGDS();
        Grib2DataReader reader = new Grib2DataReader(this.drss.getDataTemplate(), this.gdss.getNumberPoints(), this.drss.getDataPoints(), this.getScanMode(), gds.getNxRaw(), this.dataSection.getStartingPosition(), this.dataSection.getMsgLength());
        Grib2Drs gdrs = this.drss.getDrs(raf);
        if (gdrs instanceof Grib2Drs.Type40) {
            reader.getData(raf, this.bms, gdrs);
            return (Grib2Drs.Type40)gdrs;
        }
        return null;
    }

    public float[] readData(RandomAccessFile raf, long drsPos) throws IOException {
        raf.seek(drsPos);
        Grib2SectionDataRepresentation drs = new Grib2SectionDataRepresentation(raf);
        Grib2SectionBitMap bms = new Grib2SectionBitMap(raf);
        Grib2SectionData dataSection = new Grib2SectionData(raf);
        Grib2Gds gds = this.getGDS();
        Grib2DataReader reader = new Grib2DataReader(drs.getDataTemplate(), this.gdss.getNumberPoints(), drs.getDataPoints(), this.getScanMode(), gds.getNxRaw(), dataSection.getStartingPosition(), dataSection.getMsgLength());
        Grib2Drs gdrs = drs.getDrs(raf);
        float[] data = reader.getData(raf, bms, gdrs);
        if (gds.isThin()) {
            data = QuasiRegular.convertQuasiGrid(data, gds.getNptsInLine(), gds.getNxRaw(), gds.getNyRaw(), GribData.getInterpolationMethod());
        }
        lastRecordRead = this;
        return data;
    }

    public static float[] readData(RandomAccessFile raf, long drsPos, long bmsPos, int gdsNumberPoints, int scanMode, int nx, int ny, int[] nptsInLine) throws IOException {
        raf.seek(drsPos);
        Grib2SectionDataRepresentation drs = new Grib2SectionDataRepresentation(raf);
        Grib2SectionBitMap bms = new Grib2SectionBitMap(raf);
        Grib2SectionData dataSection = new Grib2SectionData(raf);
        if (bmsPos > 0L) {
            bms = Grib2SectionBitMap.factory(raf, bmsPos);
        }
        Grib2DataReader reader = new Grib2DataReader(drs.getDataTemplate(), gdsNumberPoints, drs.getDataPoints(), scanMode, nx, dataSection.getStartingPosition(), dataSection.getMsgLength());
        Grib2Drs gdrs = drs.getDrs(raf);
        float[] data = reader.getData(raf, bms, gdrs);
        if (nptsInLine != null) {
            data = QuasiRegular.convertQuasiGrid(data, nptsInLine, nx, ny, GribData.getInterpolationMethod());
        }
        if (getlastRecordRead) {
            lastRecordRead = Grib2RecordScanner.findRecordByDrspos(raf, drsPos);
        }
        return data;
    }

    public void check(RandomAccessFile raf, Formatter f) throws IOException {
        long messLen = this.is.getMessageLength();
        long startPos = this.is.getStartPos();
        long endPos = this.is.getEndPos();
        if (endPos > raf.length()) {
            f.format("End of GRIB message (start=%d len=%d) end=%d > file.length=%d for %s%n", startPos, messLen, endPos, raf.length(), raf.getLocation());
            return;
        }
        raf.seek(endPos - 4L);
        for (int i = 0; i < 4; ++i) {
            if (raf.read() == 55) continue;
            String clean = StringUtil2.cleanup(this.header);
            if (clean.length() > 40) {
                clean = clean.substring(0, 40) + "...";
            }
            f.format("Missing End of GRIB message (start=%d len=%d) end=%d header= %s for %s (len=%d)%n", startPos, messLen, endPos, clean, raf.getLocation(), raf.length());
            break;
        }
        long dataLen = this.dataSection.getMsgLength();
        long dataStart = this.dataSection.getStartingPosition();
        long dataEnd = dataStart + dataLen;
        if (dataEnd > raf.length()) {
            f.format("GRIB data section (start=%d len=%d) end=%d > file.length=%d for %s%n", dataStart, dataLen, dataEnd, raf.length(), raf.getLocation());
            return;
        }
        if (dataEnd > endPos) {
            f.format("GRIB data section (start=%d len=%d) end=%d > message end=%d for %s%n", dataStart, dataLen, dataEnd, endPos, raf.getLocation());
        }
    }

    public GribData.Info getBinaryDataInfo(RandomAccessFile raf) throws IOException {
        GribData.Info info = this.drss.getDrs(raf).getBinaryDataInfo(raf);
        info.bitmapLength = this.bms == null ? 0 : this.bms.getLength(raf);
        info.msgLength = this.is.getMessageLength();
        info.dataLength = this.dataSection.getMsgLength();
        info.ndataPoints = this.drss.getDataPoints();
        Grib2Gds gds = this.getGDS();
        info.nPoints = gds.getNx() * gds.getNy();
        return info;
    }
}

