/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.IOException;
import java.io.InputStream;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import ucar.nc2.grib.GribResourceReader;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.table.Grib2TableConfig;
import ucar.nc2.grib.grib2.table.Grib2Tables;
import ucar.nc2.grib.grib2.table.LocalTables;
import ucar.nc2.util.TableParser;

public class GempakLocalTables
extends LocalTables {
    private static boolean debug = false;

    GempakLocalTables(Grib2TableConfig config) {
        super(config);
        Formatter f = new Formatter();
        this.localParams = this.initLocalTable(config.getPath(), f);
    }

    private Map<Integer, Grib2Parameter> initLocalTable(String resourcePath, @Nullable Formatter f) {
        HashMap<Integer, Grib2Parameter> result = new HashMap<Integer, Grib2Parameter>(100);
        try (InputStream is = GribResourceReader.getInputStream(resourcePath);){
            if (f != null) {
                f.format("%s, %-20s, %-20s, %-20s%n", "id", "name", "units", "gname");
            }
            TableParser parser = new TableParser("3i,7i,11i,15i,49,69,74,");
            parser.setComment("!");
            List<TableParser.Record> recs = parser.readAllRecords(is, 50000);
            for (TableParser.Record record : recs) {
                int disc = (Integer)record.get(0);
                int cat = (Integer)record.get(1);
                int id = (Integer)record.get(2);
                int template = (Integer)record.get(3);
                String name = ((String)record.get(4)).trim();
                String units = ((String)record.get(5)).trim();
                String gname = ((String)record.get(6)).trim();
                String ids = disc + "-" + cat + "-" + id;
                if (f != null) {
                    f.format("%s == %-20s, %-20s, %-20s%n", ids, name, units, gname);
                }
                Grib2Parameter gp = new Grib2Parameter(disc, cat, id, gname, units, null, name);
                result.put(Grib2Tables.makeParamId(disc, cat, id), gp);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return result;
    }
}

