/*
 * Decompiled with CFR 0.152.
 */
package opendap.servers.parsers;

import java.util.List;
import opendap.dap.DAP2Exception;
import opendap.dap.DFloat64;
import opendap.dap.DInt32;
import opendap.dap.DString;
import opendap.dap.NoSuchFunctionException;
import opendap.dap.NoSuchVariableException;
import opendap.servers.DAP2ServerSideException;
import opendap.servers.ServerMethods;
import opendap.servers.SubClause;
import opendap.servers.parsers.AST;
import opendap.servers.parsers.ASTvalue;

class ASTconstant
extends ASTvalue {
    int tag = 0;
    String text = null;
    long intvalue = 0L;
    double floatvalue = 0.0;

    public ASTconstant(List<AST> nodes) {
        super(nodes);
    }

    @Override
    SubClause translate() throws DAP2ServerSideException, DAP2Exception, NoSuchFunctionException, NoSuchVariableException {
        SubClause subclause = null;
        switch (this.tag) {
            case 24: {
                String s2 = String.format("%d", this.intvalue);
                DInt32 i = this.getFactory().newDInt32(s2);
                i.setValue((int)this.intvalue);
                ((ServerMethods)((Object)i)).setRead(true);
                ((ServerMethods)((Object)i)).setProject(true);
                subclause = this.getClauseFactory().newValueClause(i, false);
                break;
            }
            case 25: {
                String s3 = String.format("%.1f", this.floatvalue);
                DFloat64 f = this.getFactory().newDFloat64(s3);
                f.setValue(this.floatvalue);
                subclause = this.getClauseFactory().newValueClause(f, false);
                break;
            }
            case 23: {
                DString s4 = this.getFactory().newDString(this.text);
                s4.setValue(this.text);
                ((ServerMethods)((Object)s4)).setRead(true);
                ((ServerMethods)((Object)s4)).setProject(true);
                subclause = this.getClauseFactory().newValueClause(s4, false);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return subclause;
    }
}

