/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.LambertConformal;

public class IFPSConvention
extends CoordSysBuilder {
    private Variable projVar;

    public static boolean isMine(NetcdfFile ncfile) {
        Variable v = ncfile.findVariable("latitude");
        if (null == ncfile.findVariable("longitude") || null == v) {
            return false;
        }
        boolean geoVarsCheck = null != ncfile.findAttValueIgnoreCase(v, "projectionType", null);
        Attribute ff = ncfile.findGlobalAttributeIgnoreCase("fileFormatVersion");
        if (ff == null) {
            return false;
        }
        String ffValue = ff.getStringValue();
        boolean fileFormatCheck = ffValue.equalsIgnoreCase("20030117") || ffValue.equalsIgnoreCase("20010816");
        return geoVarsCheck && fileFormatCheck;
    }

    public IFPSConvention() {
        this.conventionName = "IFPS";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        if (null != ds.findVariable("xCoord")) {
            return;
        }
        this.parseInfo.format("IFPS augmentDataset %n", new Object[0]);
        Variable lonVar = ds.findVariable("longitude");
        lonVar.addAttribute(new Attribute("units", "degrees_east"));
        lonVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        Variable latVar = ds.findVariable("latitude");
        latVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        latVar.addAttribute(new Attribute("units", "degrees_north"));
        this.projVar = latVar;
        String projName = ds.findAttValueIgnoreCase(this.projVar, "projectionType", null);
        if ("LAMBERT_CONFORMAL".equals(projName)) {
            Projection proj = this.makeLCProjection(ds);
            this.makeXYcoords(ds, proj, latVar, lonVar);
        }
        List<Variable> vars = ds.getVariables();
        for (Variable ncvar : vars) {
            if (!(ncvar.getDimension(0).getShortName().equals("DIM_0") || ncvar.getShortName().endsWith("History") || ncvar.getRank() <= 2 || ncvar.getShortName().startsWith("Tool"))) {
                this.createTimeCoordinate(ds, ncvar);
                continue;
            }
            if (!ncvar.getShortName().equals("Topo")) continue;
            ncvar.addAttribute(new Attribute("long_name", "Topography"));
            ncvar.addAttribute(new Attribute("units", "ft"));
        }
        ds.finish();
    }

    private void createTimeCoordinate(NetcdfDataset ds, Variable ncVar) {
        Attribute timesAtt = ncVar.findAttribute("validTimes");
        if (timesAtt == null) {
            return;
        }
        Array timesArray = timesAtt.getValues();
        try {
            int n = (int)timesArray.getSize();
            ArrayList<Range> list = new ArrayList<Range>();
            list.add(new Range(0, n - 1, 2));
            timesArray = timesArray.section(list);
        }
        catch (InvalidRangeException e) {
            throw new IllegalStateException(e);
        }
        DataType dtype = DataType.getType(timesArray);
        int nTimesAtt = (int)timesArray.getSize();
        Dimension dimTime = ncVar.getDimension(0);
        int nTimesDim = dimTime.getLength();
        if (nTimesDim != nTimesAtt) {
            this.parseInfo.format(" **error ntimes in attribute (%d) doesnt match dimension length (%d) for variable %s%n", nTimesAtt, nTimesDim, ncVar.getFullName());
            return;
        }
        String dimName = ncVar.getFullName() + "_timeCoord";
        Dimension newDim = new Dimension(dimName, nTimesDim);
        ds.addDimension(null, newDim);
        String units = "seconds since 1970-1-1 00:00:00";
        String desc = "time coordinate for " + ncVar.getFullName();
        CoordinateAxis1D timeCoord = new CoordinateAxis1D(ds, null, dimName, dtype, dimName, units, desc);
        timeCoord.setCachedData(timesArray, true);
        timeCoord.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        ds.addCoordinateAxis(timeCoord);
        this.parseInfo.format(" added coordinate variable %s%n", dimName);
        List<Dimension> dimsList = ncVar.getDimensions();
        dimsList.set(0, newDim);
        ncVar.setDimensions(dimsList);
        ncVar.addAttribute(new Attribute("_CoordinateAxes", dimName + " yCoord xCoord"));
        Attribute att = ncVar.findAttribute("fillValue");
        if (att != null) {
            ncVar.addAttribute(new Attribute("_FillValue", att.getNumericValue()));
        }
        if (null != (att = ncVar.findAttribute("descriptiveName"))) {
            ncVar.addAttribute(new Attribute("long_name", att.getStringValue()));
        }
    }

    protected String getZisPositive(NetcdfDataset ds, CoordinateAxis v) {
        return "up";
    }

    private Projection makeLCProjection(NetcdfDataset ds) {
        Attribute latLonOrigin = this.projVar.findAttributeIgnoreCase("latLonOrigin");
        if (latLonOrigin == null) {
            throw new IllegalStateException();
        }
        double centralLon = latLonOrigin.getNumericValue(0).doubleValue();
        double centralLat = latLonOrigin.getNumericValue(1).doubleValue();
        double par1 = this.findAttributeDouble("stdParallelOne");
        double par2 = this.findAttributeDouble("stdParallelTwo");
        LambertConformal lc = new LambertConformal(centralLat, centralLon, par1, par2);
        ProjectionCT ct = new ProjectionCT("lambertConformalProjection", "FGDC", lc);
        VariableDS ctVar = this.makeCoordinateTransformVariable(ds, ct);
        ctVar.addAttribute(new Attribute("_CoordinateAxes", "xCoord yCoord"));
        ds.addVariable(null, ctVar);
        return lc;
    }

    private void makeXYcoords(NetcdfDataset ds, Projection proj, Variable latVar, Variable lonVar) throws IOException {
        double lon;
        double lat;
        int i;
        Array latData = latVar.read();
        Array lonData = lonVar.read();
        Dimension y_dim = latVar.getDimension(0);
        Dimension x_dim = latVar.getDimension(1);
        Array xData = Array.factory(DataType.FLOAT, new int[]{x_dim.getLength()});
        Array yData = Array.factory(DataType.FLOAT, new int[]{y_dim.getLength()});
        LatLonPointImpl latlon = new LatLonPointImpl();
        ProjectionPointImpl pp = new ProjectionPointImpl();
        Index latlonIndex = latData.getIndex();
        Index xIndex = xData.getIndex();
        Index yIndex = yData.getIndex();
        for (i = 0; i < x_dim.getLength(); ++i) {
            lat = latData.getDouble(latlonIndex.set1(i));
            lon = lonData.getDouble(latlonIndex);
            latlon.set(lat, lon);
            proj.latLonToProj(latlon, pp);
            xData.setDouble(xIndex.set(i), pp.getX());
        }
        for (i = 0; i < y_dim.getLength(); ++i) {
            lat = latData.getDouble(latlonIndex.set0(i));
            lon = lonData.getDouble(latlonIndex);
            latlon.set(lat, lon);
            proj.latLonToProj(latlon, pp);
            yData.setDouble(yIndex.set(i), pp.getY());
        }
        VariableDS xaxis = new VariableDS(ds, null, null, "xCoord", DataType.FLOAT, x_dim.getShortName(), "km", "x on projection");
        xaxis.addAttribute(new Attribute("units", "km"));
        xaxis.addAttribute(new Attribute("long_name", "x on projection"));
        xaxis.addAttribute(new Attribute("_CoordinateAxisType", "GeoX"));
        VariableDS yaxis = new VariableDS(ds, null, null, "yCoord", DataType.FLOAT, y_dim.getShortName(), "km", "y on projection");
        yaxis.addAttribute(new Attribute("units", "km"));
        yaxis.addAttribute(new Attribute("long_name", "y on projection"));
        yaxis.addAttribute(new Attribute("_CoordinateAxisType", "GeoY"));
        xaxis.setCachedData(xData, true);
        yaxis.setCachedData(yData, true);
        ds.addVariable(null, xaxis);
        ds.addVariable(null, yaxis);
    }

    private double findAttributeDouble(String attname) {
        Attribute att = this.projVar.findAttributeIgnoreCase(attname);
        return att == null ? Double.NaN : att.getNumericValue().doubleValue();
    }
}

