/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.ArrayDouble;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.ma2.RangeIterator;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.HorizCoordSys;
import ucar.nc2.ft2.coverage.LatLonAxis2D;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.util.Optional;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class HorizCoordSys2D
extends HorizCoordSys {
    private static boolean debug;
    private static final Logger log;
    private final int nrows;
    private final int ncols;
    private Edges edges;

    HorizCoordSys2D(LatLonAxis2D latCoord, LatLonAxis2D lonCoord) {
        super(null, null, latCoord, lonCoord, null);
        int[] shape = latCoord.getShape();
        this.nrows = shape[0];
        this.ncols = shape[1];
    }

    @Override
    public boolean isLatLon2D() {
        return true;
    }

    @Override
    public Optional<HorizCoordSys> subset(SubsetParams params) {
        LatLonRect llbb = (LatLonRect)params.get("latlonBB");
        Integer horizStride = (Integer)params.get("horizStride");
        if (horizStride == null || horizStride < 1) {
            horizStride = 1;
        }
        LatLonAxis2D lataxisSubset = null;
        LatLonAxis2D lonaxisSubset = null;
        Formatter errMessages = new Formatter();
        if (llbb != null) {
            Optional<List<RangeIterator>> opt = this.computeBounds(llbb, horizStride);
            if (!opt.isPresent()) {
                errMessages.format("%s;%n", opt.getErrorMessage());
            } else {
                List<RangeIterator> ranges = opt.get();
                lataxisSubset = this.latAxis2D.subset(ranges.get(1), ranges.get(0));
                lonaxisSubset = this.lonAxis2D.subset(ranges.get(1), ranges.get(0));
            }
        } else if (horizStride > 1) {
            try {
                lataxisSubset = this.latAxis2D.subset(new Range(0, this.ncols - 1, (int)horizStride), new Range(0, this.nrows - 1, (int)horizStride));
                lonaxisSubset = this.lonAxis2D.subset(new Range(0, this.ncols - 1, (int)horizStride), new Range(0, this.nrows - 1, (int)horizStride));
            }
            catch (InvalidRangeException e) {
                errMessages.format("%s;%n", e.getMessage());
            }
        }
        String errs = errMessages.toString();
        if (!errs.isEmpty()) {
            return Optional.empty(errs);
        }
        if (lataxisSubset == null) {
            lataxisSubset = (LatLonAxis2D)this.latAxis2D.copy();
        }
        if (lonaxisSubset == null) {
            lonaxisSubset = (LatLonAxis2D)this.lonAxis2D.copy();
        }
        return Optional.of(new HorizCoordSys2D(lataxisSubset, lonaxisSubset));
    }

    @Override
    public LatLonPoint getLatLon(int yindex, int xindex) {
        double lat = this.latAxis2D.getCoord(yindex, xindex);
        double lon = this.lonAxis2D.getCoord(yindex, xindex);
        return new LatLonPointImpl(lat, lon);
    }

    @Override
    public List<RangeIterator> getRanges() {
        return this.latAxis2D.getRanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<HorizCoordSys.CoordReturn> findXYindexFromCoord(double x, double y) {
        HorizCoordSys2D horizCoordSys2D = this;
        synchronized (horizCoordSys2D) {
            if (this.edges == null) {
                this.edges = new Edges();
            }
        }
        HorizCoordSys.CoordReturn result = new HorizCoordSys.CoordReturn();
        int[] index = new int[2];
        boolean ok = this.edges.findCoordElement(y, x, index);
        if (!ok) {
            return Optional.empty("not in grid2D");
        }
        result.x = index[1];
        result.y = index[0];
        result.xcoord = this.getLonAxis2D().getCoord(result.y, result.x);
        result.ycoord = this.getLatAxis2D().getCoord(result.y, result.x);
        return Optional.of(result);
    }

    @Override
    public List<CoverageCoordAxis> getCoordAxes() {
        ArrayList<CoverageCoordAxis> result = new ArrayList<CoverageCoordAxis>();
        result.add(this.latAxis2D);
        result.add(this.lonAxis2D);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<List<RangeIterator>> computeBounds(LatLonRect llbb, int horizStride) {
        HorizCoordSys2D horizCoordSys2D = this;
        synchronized (horizCoordSys2D) {
            if (this.edges == null) {
                this.edges = new Edges();
            }
        }
        return this.edges.computeBoundsExhaustive(llbb, horizStride);
    }

    static {
        log = LoggerFactory.getLogger(HorizCoordSys2D.class);
    }

    private class Edges {
        private ArrayDouble.D2 latEdge;
        private ArrayDouble.D2 lonEdge;
        private MAMath.MinMax latMinMax;
        private MAMath.MinMax lonMinMax;

        Edges() {
            this.latEdge = (ArrayDouble.D2)HorizCoordSys2D.this.latAxis2D.getCoordBoundsAsArray();
            this.lonEdge = (ArrayDouble.D2)HorizCoordSys2D.this.lonAxis2D.getCoordBoundsAsArray();
            this.latMinMax = MAMath.getMinMax(this.latEdge);
            this.lonMinMax = MAMath.getMinMax(this.lonEdge);
            int nlons = (int)this.lonEdge.getSize();
            for (int i = 0; i < nlons; ++i) {
                double nonVal = this.lonEdge.getDouble(i);
                this.lonEdge.setDouble(i, LatLonPointImpl.lonNormalFrom(nonVal, this.lonMinMax.min));
            }
            if (debug) {
                System.out.printf("Bounds (%d %d): lat= (%f,%f) lon = (%f,%f) %n", HorizCoordSys2D.this.nrows, HorizCoordSys2D.this.ncols, this.latMinMax.min, this.latMinMax.max, this.lonMinMax.min, this.lonMinMax.max);
            }
        }

        public boolean findCoordElement(double wantLat, double wantLon, int[] rectIndex) {
            double wantLonNormal = LatLonPointImpl.lonNormalFrom(wantLon, this.lonMinMax.min);
            return this.findCoordElementNoForce(wantLat, wantLonNormal, rectIndex);
        }

        private boolean findCoordElementNoForce(double wantLat, double wantLon, int[] rectIndex) {
            if (wantLat < this.latMinMax.min) {
                return false;
            }
            if (wantLat > this.latMinMax.max) {
                return false;
            }
            if (wantLon < this.lonMinMax.min) {
                return false;
            }
            if (wantLon > this.lonMinMax.max) {
                return false;
            }
            double gradientLat = (this.latMinMax.max - this.latMinMax.min) / (double)HorizCoordSys2D.this.nrows;
            double gradientLon = (this.lonMinMax.max - this.lonMinMax.min) / (double)HorizCoordSys2D.this.ncols;
            double diffLat = wantLat - this.latMinMax.min;
            double diffLon = wantLon - this.lonMinMax.min;
            rectIndex[0] = (int)Math.round(diffLat / gradientLat);
            rectIndex[1] = (int)Math.round(diffLon / gradientLon);
            int count = 0;
            do {
                ++count;
                if (debug) {
                    System.out.printf("%nIteration %d %n", count);
                }
                if (this.contains(wantLat, wantLon, rectIndex)) {
                    return true;
                }
                if (this.jump2(wantLat, wantLon, rectIndex)) continue;
                return false;
            } while (count <= 10);
            return this.incr(wantLat, wantLon, rectIndex);
        }

        private boolean containsOld(double wantLat, double wantLon, int[] rectIndex) {
            rectIndex[0] = Math.max(Math.min(rectIndex[0], HorizCoordSys2D.this.nrows - 1), 0);
            rectIndex[1] = Math.max(Math.min(rectIndex[1], HorizCoordSys2D.this.ncols - 1), 0);
            int row = rectIndex[0];
            int col = rectIndex[1];
            if (debug) {
                System.out.printf(" (%d,%d) contains (%f,%f) in (lat=%f %f) (lon=%f %f) ?%n", rectIndex[0], rectIndex[1], wantLat, wantLon, this.latEdge.get(row, col), this.latEdge.get(row + 1, col), this.lonEdge.get(row, col), this.lonEdge.get(row, col + 1));
            }
            if (wantLat < this.latEdge.get(row, col)) {
                return false;
            }
            if (wantLat > this.latEdge.get(row + 1, col)) {
                return false;
            }
            if (wantLon < this.lonEdge.get(row, col)) {
                return false;
            }
            return !(wantLon > this.lonEdge.get(row, col + 1));
        }

        private boolean contains(double wantLat, double wantLon, int[] rectIndex) {
            rectIndex[0] = Math.max(Math.min(rectIndex[0], HorizCoordSys2D.this.nrows - 1), 0);
            rectIndex[1] = Math.max(Math.min(rectIndex[1], HorizCoordSys2D.this.ncols - 1), 0);
            int row = rectIndex[0];
            int col = rectIndex[1];
            double x1 = this.lonEdge.get(row, col);
            double y1 = this.latEdge.get(row, col);
            double x2 = this.lonEdge.get(row, col + 1);
            double y2 = this.latEdge.get(row, col + 1);
            double x3 = this.lonEdge.get(row + 1, col + 1);
            double y3 = this.latEdge.get(row + 1, col + 1);
            double x4 = this.lonEdge.get(row + 1, col);
            double y4 = this.latEdge.get(row + 1, col);
            boolean sign = this.detIsPositive(x1, y1, x2, y2, wantLon, wantLat);
            if (sign != this.detIsPositive(x2, y2, x3, y3, wantLon, wantLat)) {
                return false;
            }
            if (sign != this.detIsPositive(x3, y3, x4, y4, wantLon, wantLat)) {
                return false;
            }
            return sign == this.detIsPositive(x4, y4, x1, y1, wantLon, wantLat);
        }

        private boolean detIsPositive(double x0, double y0, double x1, double y1, double x2, double y2) {
            double det = x1 * y2 - y1 * x2 - x0 * y2 + y0 * x2 + x0 * y1 - y0 * x1;
            if (det == 0.0) {
                log.warn("determinate = 0 on lat/lon=" + HorizCoordSys2D.this.latAxis2D.getName() + ", " + HorizCoordSys2D.this.lonAxis2D.getName());
            }
            return det > 0.0;
        }

        private boolean jumpOld(double wantLat, double wantLon, int[] rectIndex) {
            int row = Math.max(Math.min(rectIndex[0], HorizCoordSys2D.this.nrows - 1), 0);
            int col = Math.max(Math.min(rectIndex[1], HorizCoordSys2D.this.ncols - 1), 0);
            double gradientLat = this.latEdge.get(row + 1, col) - this.latEdge.get(row, col);
            double gradientLon = this.lonEdge.get(row, col + 1) - this.lonEdge.get(row, col);
            double diffLat = wantLat - this.latEdge.get(row, col);
            double diffLon = wantLon - this.lonEdge.get(row, col);
            int drow = (int)Math.round(diffLat / gradientLat);
            int dcol = (int)Math.round(diffLon / gradientLon);
            if (debug) {
                System.out.printf("   jump from %d %d (grad=%f %f) (diff=%f %f) (delta=%d %d)", row, col, gradientLat, gradientLon, diffLat, diffLon, drow, dcol);
            }
            if (drow == 0 && dcol == 0) {
                if (debug) {
                    System.out.printf("%n   incr:", new Object[0]);
                }
                return this.incr(wantLat, wantLon, rectIndex);
            }
            rectIndex[0] = Math.max(Math.min(row + drow, HorizCoordSys2D.this.nrows - 1), 0);
            rectIndex[1] = Math.max(Math.min(col + dcol, HorizCoordSys2D.this.ncols - 1), 0);
            if (debug) {
                System.out.printf(" to (%d %d)%n", rectIndex[0], rectIndex[1]);
            }
            return row != rectIndex[0] || col != rectIndex[1];
        }

        private boolean jump2(double wantLat, double wantLon, int[] rectIndex) {
            int row = Math.max(Math.min(rectIndex[0], HorizCoordSys2D.this.nrows - 1), 0);
            int col = Math.max(Math.min(rectIndex[1], HorizCoordSys2D.this.ncols - 1), 0);
            double lat = this.latEdge.get(row, col);
            double lon = this.lonEdge.get(row, col);
            double diffLat = wantLat - lat;
            double diffLon = wantLon - lon;
            double dlatdy = this.latEdge.get(row + 1, col) - lat;
            double dlatdx = this.latEdge.get(row, col + 1) - lat;
            double dlondx = this.lonEdge.get(row, col + 1) - lon;
            double dlondy = this.lonEdge.get(row + 1, col) - lon;
            double dx = (diffLon - dlondy * diffLat / dlatdy) / (dlondx - dlatdx * dlondy / dlatdy);
            double dy = (diffLat - dlatdx * dx) / dlatdy;
            if (debug) {
                System.out.printf("   jump from %d %d (dlondx=%f dlondy=%f dlatdx=%f dlatdy=%f) (diffLat,Lon=%f %f) (deltalat,Lon=%f %f)", row, col, dlondx, dlondy, dlatdx, dlatdy, diffLat, diffLon, dy, dx);
            }
            int drow = (int)Math.round(dy);
            int dcol = (int)Math.round(dx);
            if (drow == 0 && dcol == 0) {
                if (debug) {
                    System.out.printf("%n   incr:", new Object[0]);
                }
                return this.incr(wantLat, wantLon, rectIndex);
            }
            rectIndex[0] = Math.max(Math.min(row + drow, HorizCoordSys2D.this.nrows - 1), 0);
            rectIndex[1] = Math.max(Math.min(col + dcol, HorizCoordSys2D.this.ncols - 1), 0);
            if (debug) {
                System.out.printf(" to (%d %d)%n", rectIndex[0], rectIndex[1]);
            }
            return row != rectIndex[0] || col != rectIndex[1];
        }

        private boolean incr(double wantLat, double wantLon, int[] rectIndex) {
            int row = rectIndex[0];
            int col = rectIndex[1];
            double diffLat = wantLat - this.latEdge.get(row, col);
            double diffLon = wantLon - this.lonEdge.get(row, col);
            if (Math.abs(diffLat) > Math.abs(diffLon)) {
                rectIndex[0] = row + (diffLat > 0.0 ? 1 : -1);
                if (this.contains(wantLat, wantLon, rectIndex)) {
                    return true;
                }
                rectIndex[1] = col + (diffLon > 0.0 ? 1 : -1);
                if (this.contains(wantLat, wantLon, rectIndex)) {
                    return true;
                }
            } else {
                rectIndex[1] = col + (diffLon > 0.0 ? 1 : -1);
                if (this.contains(wantLat, wantLon, rectIndex)) {
                    return true;
                }
                rectIndex[0] = row + (diffLat > 0.0 ? 1 : -1);
                if (this.contains(wantLat, wantLon, rectIndex)) {
                    return true;
                }
            }
            rectIndex[0] = row;
            rectIndex[1] = col;
            return this.box9(wantLat, wantLon, rectIndex);
        }

        private boolean box9(double wantLat, double wantLon, int[] rectIndex) {
            int row = rectIndex[0];
            int minrow = Math.max(row - 1, 0);
            int maxrow = Math.min(row + 1, HorizCoordSys2D.this.nrows);
            int col = rectIndex[1];
            int mincol = Math.max(col - 1, 0);
            int maxcol = Math.min(col + 1, HorizCoordSys2D.this.ncols);
            if (debug) {
                System.out.printf("%n   box9:", new Object[0]);
            }
            for (int i = minrow; i <= maxrow; ++i) {
                int j = mincol;
                while (j <= maxcol) {
                    rectIndex[0] = i;
                    rectIndex[1] = j++;
                    if (!this.contains(wantLat, wantLon, rectIndex)) continue;
                    return true;
                }
            }
            return false;
        }

        Optional<List<RangeIterator>> computeBoundsExhaustive(LatLonRect rect, int horizStride) {
            boolean allY;
            LatLonPointImpl llpt = rect.getLowerLeftPoint();
            LatLonPointImpl urpt = rect.getUpperRightPoint();
            double miny = llpt.getLatitude();
            double maxy = urpt.getLatitude();
            double minx = LatLonPointImpl.lonNormalFrom(llpt.getLongitude(), this.lonMinMax.min);
            double maxx = LatLonPointImpl.lonNormalFrom(urpt.getLongitude(), this.lonMinMax.min);
            int[] shape = HorizCoordSys2D.this.lonAxis2D.getShape();
            int ny = shape[0];
            int nx = shape[1];
            int minCol = Integer.MAX_VALUE;
            int minRow = Integer.MAX_VALUE;
            int maxCol = -1;
            int maxRow = -1;
            boolean allX = minx > this.lonMinMax.max && maxx > this.lonMinMax.max && minx > maxx;
            boolean bl = allY = miny <= this.latMinMax.min && maxy >= this.latMinMax.max;
            if (allX && allY) {
                return Optional.of(HorizCoordSys2D.this.getRanges());
            }
            if (minx > this.lonMinMax.max && maxx > this.lonMinMax.max && minx < maxx) {
                return Optional.empty("no intersection");
            }
            if (minx > this.lonMinMax.max && maxx > this.lonMinMax.max && minx > maxx) {
                minCol = 0;
                maxCol = nx;
                minx = this.lonMinMax.min;
            } else if (minx > this.lonMinMax.min && maxx > this.lonMinMax.max) {
                maxCol = nx;
            } else if (minx > this.lonMinMax.max && maxx < this.lonMinMax.max) {
                minCol = 0;
                minx = this.lonMinMax.min;
            }
            if (miny <= this.latMinMax.min) {
                minRow = 0;
            } else if (maxy >= this.latMinMax.max) {
                maxRow = ny;
            }
            for (int row = 0; row <= ny; ++row) {
                for (int col = 0; col <= nx; ++col) {
                    double lat = this.latEdge.get(row, col);
                    double lon = this.lonEdge.get(row, col);
                    if (!(lat >= miny) || !(lat <= maxy) || !(lon >= minx) || !(lon <= maxx)) continue;
                    if (col > maxCol) {
                        maxCol = col;
                    }
                    if (col < minCol) {
                        minCol = col;
                    }
                    if (row > maxRow) {
                        maxRow = row;
                    }
                    if (row >= minRow) continue;
                    minRow = row;
                }
            }
            try {
                ArrayList<Range> list = new ArrayList<Range>();
                list.add(new Range(minRow, maxRow - 1, horizStride));
                list.add(new Range(minCol, maxCol - 1, horizStride));
                return Optional.of(list);
            }
            catch (InvalidRangeException e) {
                throw new RuntimeException(e);
            }
        }

        private double getMinOrMaxLon(double lon1, double lon2, boolean wantMin) {
            double midpoint = (lon1 + lon2) / 2.0;
            lon1 = LatLonPointImpl.lonNormal(lon1, midpoint);
            lon2 = LatLonPointImpl.lonNormal(lon2, midpoint);
            return wantMin ? Math.min(lon1, lon2) : Math.max(lon1, lon2);
        }

        public boolean findCoordElementExhaustive(double wantLat, double wantLon, int[] rectIndex) {
            if (wantLat < this.latMinMax.min) {
                return false;
            }
            if (wantLat > this.latMinMax.max) {
                return false;
            }
            if (wantLon < this.lonMinMax.min) {
                return false;
            }
            if (wantLon > this.lonMinMax.max) {
                return false;
            }
            for (int row = 0; row < HorizCoordSys2D.this.nrows; ++row) {
                int col = 0;
                while (col < HorizCoordSys2D.this.ncols) {
                    rectIndex[0] = row;
                    rectIndex[1] = col++;
                    if (!this.contains(wantLat, wantLon, rectIndex)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

