/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.io.IOException;
import java.util.List;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.GribVariableRenamer;

public class GribConverterUtility {
    public static void main(String[] args) {
        String usage = "usage: ucar.nc2.dataset.GribConverterUtility -grib1|-grib2 <fileIn> <oldGribName> [-matchNCEP]";
        String grbFile = null;
        String grbType = null;
        String oldGribName = null;
        boolean matchNCEP = false;
        if (args.length == 3 || args.length == 4) {
            String s2 = args[0];
            if (s2.equalsIgnoreCase("-grib1")) {
                grbType = "grib1";
            } else if (s2.equalsIgnoreCase("-grib2")) {
                grbType = "grib2";
            } else {
                System.out.println(usage);
                System.exit(0);
            }
            grbFile = args[1];
            oldGribName = args[2];
            if (args.length == 4) {
                matchNCEP = true;
            }
        } else {
            System.out.println(usage);
            System.exit(0);
        }
        try {
            GridDataset gds = GridDataset.open(grbFile);
            GribVariableRenamer r = new GribVariableRenamer();
            List<String> result = grbType.equalsIgnoreCase("grib1") ? (matchNCEP ? r.matchNcepNames(gds, oldGribName) : r.getMappedNamesGrib1(oldGribName)) : (matchNCEP ? r.matchNcepNames(gds, oldGribName) : r.getMappedNamesGrib2(oldGribName));
            if (null == result) {
                System.out.println("Could not find \"" + oldGribName + "\" in " + grbFile);
                System.out.println("-Note that variable names are case sensitive");
            } else {
                System.out.println(result);
            }
        }
        catch (IOException e) {
            System.out.println("oops...");
            System.out.println("Check filename " + grbFile);
        }
        catch (Exception e) {
            System.out.println("oops...");
            e.printStackTrace();
        }
    }
}

