/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.query;

import java.util.ArrayList;
import thredds.catalog.query.Query;
import thredds.catalog.query.Selector;

public class QueryCapability {
    private String createFrom;
    private String name;
    private String version;
    private Query query;
    private ArrayList selectors = new ArrayList();
    private ArrayList uniqueSelectors = new ArrayList();
    private ArrayList userInterfaces = new ArrayList();
    private Selector ss = null;
    private boolean fatalError = false;
    private StringBuffer errLog = new StringBuffer();
    private volatile int hashCode = 0;

    QueryCapability() {
    }

    public QueryCapability(String urlString, String name, String version) {
        this.createFrom = urlString;
        this.name = name;
        this.version = version;
    }

    public void appendErrorMessage(String message, boolean fatal) {
        this.errLog.append(message);
        this.errLog.append("\n");
        this.fatalError = this.fatalError || fatal;
    }

    public String getErrorMessages() {
        return this.errLog.toString();
    }

    public boolean hasFatalError() {
        return this.fatalError;
    }

    public void addSelector(Selector s2) {
        this.selectors.add(s2);
    }

    public void setQuery(Query q) {
        this.query = q;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Query getQuery() {
        return this.query;
    }

    public ArrayList getSelectors() {
        return this.selectors;
    }

    public ArrayList getAllUniqueSelectors() {
        return this.uniqueSelectors;
    }

    public String getCreateFrom() {
        return this.createFrom;
    }

    public Selector getServiceSelector() {
        return this.ss;
    }

    public void setServiceSelector(Selector ss) {
        this.ss = ss;
    }

    public void addUserInterface(Object s2) {
        this.userInterfaces.add(s2);
    }

    public ArrayList getUserInterfaces() {
        return this.userInterfaces;
    }

    public String toString() {
        return "name:<" + this.name + ">";
    }

    public void addUniqueSelector(Selector s2) {
        if (!this.uniqueSelectors.contains(s2)) {
            this.uniqueSelectors.add(s2);
        }
        this.selectors.add(s2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryCapability)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getName().hashCode();
            result = 37 * result + this.getQuery().hashCode();
            this.hashCode = result = 37 * result + this.getSelectors().hashCode();
        }
        return this.hashCode;
    }
}

