/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import ucar.mcidas.AREAnav;
import ucar.mcidas.AreaDirectory;
import ucar.mcidas.AreaFileException;
import ucar.mcidas.AreaFileFactory;
import ucar.mcidas.Calibrator;
import ucar.mcidas.CalibratorException;
import ucar.mcidas.CalibratorFactory;
import ucar.mcidas.McIDASException;
import ucar.mcidas.McIDASUtil;

public class AreaFile
implements Serializable {
    static final long serialVersionUID = 3145724093430859967L;
    public static final int AD_STATUS = 0;
    public static final int AD_VERSION = 1;
    public static final int AD_SENSORID = 2;
    public static final int AD_IMGDATE = 3;
    public static final int AD_IMGTIME = 4;
    public static final int AD_STLINE = 5;
    public static final int AD_STELEM = 6;
    public static final int AD_NUMLINES = 8;
    public static final int AD_NUMELEMS = 9;
    public static final int AD_DATAWIDTH = 10;
    public static final int AD_LINERES = 11;
    public static final int AD_ELEMRES = 12;
    public static final int AD_NUMBANDS = 13;
    public static final int AD_PFXSIZE = 14;
    public static final int AD_PROJNUM = 15;
    public static final int AD_CRDATE = 16;
    public static final int AD_CRTIME = 17;
    public static final int AD_BANDMAP = 18;
    public static final int AD_DATAOFFSET = 33;
    public static final int AD_NAVOFFSET = 34;
    public static final int AD_VALCODE = 35;
    public static final int AD_STARTDATE = 45;
    public static final int AD_STARTTIME = 46;
    public static final int AD_STARTSCAN = 47;
    public static final int AD_DOCLENGTH = 48;
    public static final int AD_CALLENGTH = 49;
    public static final int AD_LEVLENGTH = 50;
    public static final int AD_SRCTYPE = 51;
    public static final int AD_CALTYPE = 52;
    public static final int AD_AVGSMPFLAG = 53;
    public static final int AD_SRCTYPEORIG = 56;
    public static final int AD_CALTYPEUNIT = 57;
    public static final int AD_CALTYPESCALE = 58;
    public static final int AD_AUXOFFSET = 59;
    public static final int AD_CALOFFSET = 62;
    public static final int AD_NUMCOMMENTS = 63;
    public static final int AD_DIRSIZE = 64;
    public static final int VERSION_NUMBER = 4;
    private static boolean handlerLoaded = false;
    private boolean flipwords;
    private boolean fileok;
    private boolean hasReadData;
    private transient DataInputStream af;
    private int navLoc;
    private int calLoc;
    private int auxLoc;
    private int datLoc;
    private int navbytes;
    private int calbytes;
    private int auxbytes;
    private int lineDataLen;
    private int lineLength;
    private int origNumLines;
    private int origNumElements;
    private int origNumBands;
    private int linePrefixLength;
    private long position;
    private int skipByteCount;
    private long newPosition;
    int[] dir;
    int[] nav = null;
    int[] cal = null;
    int[] aux = null;
    int[][][] data;
    private AreaDirectory areaDirectory;
    private String imageSource = null;
    private AREAnav areaNav;
    private int calType = -1;
    private boolean isRemote = false;
    private Subset subset = null;

    public static boolean isURLHandlerLoaded() {
        return handlerLoaded;
    }

    public AreaFile(String source) throws AreaFileException {
        this.imageSource = source;
        try {
            this.af = new DataInputStream(new BufferedInputStream(new FileInputStream(this.imageSource), 2048));
        }
        catch (IOException eIO) {
            URL url;
            try {
                url = new URL(this.imageSource);
                URLConnection urlc = url.openConnection();
                InputStream is = urlc.getInputStream();
                this.af = new DataInputStream(new BufferedInputStream(is));
            }
            catch (IOException e) {
                this.fileok = false;
                throw new AreaFileException("Error opening AreaFile: " + e);
            }
            this.isRemote = url.getProtocol().equalsIgnoreCase("adde");
        }
        this.fileok = true;
        this.position = 0L;
        this.readMetaData();
    }

    public AreaFile(URL url) throws AreaFileException {
        this.imageSource = url.toString();
        try {
            this.af = new DataInputStream(new BufferedInputStream(url.openStream()));
        }
        catch (IOException e) {
            this.fileok = false;
            throw new AreaFileException("Error opening URL for AreaFile:" + e);
        }
        this.isRemote = url.getProtocol().equalsIgnoreCase("adde");
        this.fileok = true;
        this.position = 0L;
        this.readMetaData();
    }

    public AreaFile(String source, int startLine, int numLines, int lineMag, int startElem, int numEles, int eleMag, int band) throws AreaFileException {
        this(source);
        if (this.isSubsetted()) {
            return;
        }
        if (eleMag == 0) {
            eleMag = 1;
        }
        if (lineMag == 0) {
            lineMag = 1;
        }
        if (lineMag > 1 || eleMag > 1) {
            throw new IllegalArgumentException("Magnifications greater that 1 are not currently supported");
        }
        if (startLine + numLines * Math.abs(lineMag) > this.origNumLines || startElem + numEles * Math.abs(eleMag) > this.origNumElements) {
            throw new IllegalArgumentException("Arguments outside of file line/element counts");
        }
        int bandIdx = -1;
        int[] bands = this.getAreaDirectory().getBands();
        if (band == -1) {
            bandIdx = 0;
        } else {
            for (int i = 0; i < bands.length; ++i) {
                if (bands[i] != band) continue;
                bandIdx = i;
            }
        }
        if (bandIdx == -1) {
            throw new IllegalArgumentException("Band not found in band map");
        }
        this.subset = new Subset();
        this.subset.lineNumber = startLine;
        this.subset.numLines = numLines;
        this.subset.lineMag = lineMag;
        this.subset.eleNumber = startElem;
        this.subset.numEles = numEles;
        this.subset.eleMag = eleMag;
        this.subset.bandNumber = band;
        int newDatOffset = startLine * this.lineLength;
        newDatOffset += this.linePrefixLength;
        newDatOffset += startElem * (this.origNumBands * this.dir[10]);
        this.dir[33] = newDatOffset += (band - 1) * this.dir[10];
        this.dir[8] = numLines;
        this.dir[9] = numEles;
        this.dir[13] = 1;
        this.dir[5] = this.dir[5] + startLine * this.dir[11];
        this.dir[6] = this.dir[6] + startElem * this.dir[12];
        this.dir[11] = lineMag < 0 ? this.dir[11] * Math.abs(lineMag) : this.dir[11] / lineMag;
        this.dir[12] = eleMag < 0 ? this.dir[12] * Math.abs(eleMag) : this.dir[12] / eleMag;
        if (band <= 32) {
            this.dir[18] = 1 << band - 1;
        } else {
            this.dir[19] = 1 << band - 32;
        }
        this.areaDirectory = new AreaDirectory(this.dir);
    }

    public boolean isSubsetted() {
        return this.subset != null;
    }

    public boolean isRemote() {
        return this.isRemote;
    }

    private void readMetaData() throws AreaFileException {
        int i;
        this.hasReadData = false;
        if (!this.fileok) {
            throw new AreaFileException("Error reading AreaFile directory");
        }
        this.dir = new int[64];
        for (i = 0; i < 64; ++i) {
            try {
                this.dir[i] = this.af.readInt();
                continue;
            }
            catch (IOException e) {
                throw new AreaFileException("Error reading AreaFile directory:" + e);
            }
        }
        this.position += 256L;
        if (this.dir[1] != 4) {
            McIDASUtil.flip(this.dir, 0, 19);
            if (this.dir[1] != 4) {
                throw new AreaFileException("Invalid version number - probably not an AREA file");
            }
            if ((this.dir[20] & 0xFFFF) == 0) {
                McIDASUtil.flip(this.dir, 20, 20);
            }
            McIDASUtil.flip(this.dir, 21, 23);
            McIDASUtil.flip(this.dir, 32, 50);
            McIDASUtil.flip(this.dir, 53, 55);
            McIDASUtil.flip(this.dir, 57, 63);
            this.flipwords = true;
        }
        this.areaDirectory = new AreaDirectory(this.dir);
        this.navLoc = this.dir[34];
        this.calLoc = this.dir[62];
        this.auxLoc = this.dir[59];
        this.datLoc = this.dir[33];
        this.origNumBands = this.dir[13];
        this.linePrefixLength = this.dir[48] + this.dir[49] + this.dir[50];
        if (this.dir[35] != 0) {
            this.linePrefixLength += 4;
        }
        if (this.linePrefixLength != this.dir[14]) {
            throw new AreaFileException("Invalid line prefix length in AREA file.");
        }
        this.lineDataLen = this.origNumBands * this.dir[9] * this.dir[10];
        this.lineLength = this.linePrefixLength + this.lineDataLen;
        this.origNumLines = this.dir[8];
        this.origNumElements = this.dir[9];
        if (this.datLoc > 0 && this.datLoc != -2139062144) {
            this.navbytes = this.datLoc - this.navLoc;
            this.calbytes = this.datLoc - this.calLoc;
            this.auxbytes = this.datLoc - this.auxLoc;
        }
        if (this.auxLoc > 0 && this.auxLoc != -2139062144) {
            this.navbytes = this.auxLoc - this.navLoc;
            this.calbytes = this.auxLoc - this.calLoc;
        }
        if (this.calLoc > 0 && this.calLoc != -2139062144) {
            this.navbytes = this.calLoc - this.navLoc;
        }
        if (this.navLoc > 0 && this.navbytes > 0) {
            this.nav = new int[this.navbytes / 4];
            this.newPosition = this.navLoc;
            this.skipByteCount = (int)(this.newPosition - this.position);
            try {
                this.af.skipBytes(this.skipByteCount);
            }
            catch (IOException e) {
                throw new AreaFileException("Error skipping AreaFile bytes: " + e);
            }
            for (i = 0; i < this.navbytes / 4; ++i) {
                try {
                    this.nav[i] = this.af.readInt();
                    continue;
                }
                catch (IOException e) {
                    throw new AreaFileException("Error reading AreaFile navigation:" + e);
                }
            }
            if (this.flipwords) {
                this.flipnav(this.nav);
            }
            this.position = this.navLoc + this.navbytes;
        }
        if (this.calLoc > 0 && this.calbytes > 0) {
            this.cal = new int[this.calbytes / 4];
            this.newPosition = this.calLoc;
            this.skipByteCount = (int)(this.newPosition - this.position);
            try {
                this.af.skipBytes(this.skipByteCount);
            }
            catch (IOException e) {
                throw new AreaFileException("Error skipping AreaFile bytes: " + e);
            }
            for (i = 0; i < this.calbytes / 4; ++i) {
                try {
                    this.cal[i] = this.af.readInt();
                    continue;
                }
                catch (IOException e) {
                    throw new AreaFileException("Error reading AreaFile calibration:" + e);
                }
            }
            this.position = this.calLoc + this.calbytes;
        }
        if (this.auxLoc > 0 && this.auxbytes > 0) {
            this.aux = new int[this.auxbytes / 4];
            this.newPosition = this.auxLoc;
            this.skipByteCount = (int)(this.newPosition - this.position);
            try {
                this.af.skipBytes(this.skipByteCount);
            }
            catch (IOException e) {
                throw new AreaFileException("Error skipping AreaFile bytes: " + e);
            }
            for (i = 0; i < this.auxbytes / 4; ++i) {
                try {
                    this.aux[i] = this.af.readInt();
                    continue;
                }
                catch (IOException e) {
                    throw new AreaFileException("Error reading AreaFile aux block:" + e);
                }
            }
            this.position = this.auxLoc + this.auxbytes;
        }
    }

    public String getImageSource() {
        return this.imageSource;
    }

    public int[] getDir() {
        return this.dir;
    }

    public AreaDirectory getAreaDirectory() {
        return this.areaDirectory;
    }

    public int[] getNav() {
        if (this.navLoc <= 0 || this.navLoc == -2139062144) {
            this.nav = null;
        }
        return this.nav;
    }

    public AREAnav getNavigation() throws AreaFileException {
        if (this.areaNav == null) {
            try {
                this.areaNav = AREAnav.makeAreaNav(this.getNav(), this.getAux());
                this.areaNav.setImageStart(this.dir[5], this.dir[6]);
                this.areaNav.setRes(this.dir[11], this.dir[12]);
                this.areaNav.setStart(0, 0);
                this.areaNav.setMag(1, 1);
            }
            catch (McIDASException excp) {
                this.areaNav = null;
            }
        }
        return this.areaNav;
    }

    public int[] getCal() {
        if (this.calLoc <= 0 || this.calLoc == -2139062144) {
            this.cal = null;
        }
        return this.cal;
    }

    public int[] getAux() {
        if (this.auxLoc <= 0 || this.auxLoc == -2139062144) {
            this.aux = null;
        }
        return this.aux;
    }

    public int[][][] getData() throws AreaFileException {
        this.data = new int[this.origNumBands][this.dir[8]][this.dir[9]];
        return this.getData(this.data);
    }

    public int[][][] getData(int[][][] target) throws AreaFileException {
        if (target == null || this.isSubsetted() && target.length != 1 && target[0].length != this.subset.numLines && target[0][0].length != this.subset.numEles || target.length != this.origNumBands && target[0].length != this.dir[8] && target[0][0].length != this.dir[9]) {
            throw new IllegalArgumentException("target array is not dimensioned correctly");
        }
        if (!this.hasReadData) {
            if (this.subset == null) {
                this.readData(target);
            } else {
                this.readData(target, this.subset.lineNumber, this.subset.numLines, this.subset.lineMag, this.subset.eleNumber, this.subset.numEles, this.subset.eleMag, this.subset.bandNumber);
            }
        }
        this.hasReadData = true;
        this.data = target;
        return this.data;
    }

    public void setCalType(int cal) {
        this.calType = cal;
    }

    public int getCalType() {
        return this.calType;
    }

    public float[][][] getFloatData() throws AreaFileException {
        int[][][] inData = this.getData();
        float[][][] outData = new float[this.dir[13]][this.dir[8]][this.dir[9]];
        Calibrator calibrator = null;
        int origType = AreaFileFactory.calStrToInt(this.areaDirectory.getCalibrationType());
        if (!this.isRemote() && this.getCalType() != -1 && origType != this.getCalType()) {
            try {
                calibrator = CalibratorFactory.getCalibrator(this.areaDirectory.getSensorID(), this.cal);
            }
            catch (CalibratorException calibratorException) {
                // empty catch block
            }
        }
        if (this.subset == null) {
            for (int band_idx = 0; band_idx < inData.length; ++band_idx) {
                for (int line = 0; line < inData[0].length; ++line) {
                    for (int elem = 0; elem < inData[0][0].length; ++elem) {
                        outData[band_idx][line][elem] = calibrator != null ? calibrator.calibrate(inData[band_idx][line][elem], band_idx + 1, this.calType) : (float)inData[band_idx][line][elem];
                    }
                }
            }
        } else {
            for (int line = 0; line < inData[0].length; ++line) {
                for (int elem = 0; elem < inData[0][0].length; ++elem) {
                    outData[0][line][elem] = !this.isRemote && this.calType != -1 && calibrator != null ? calibrator.calibrate(inData[0][line][elem], this.subset.bandNumber, this.calType) : (float)inData[0][line][elem];
                }
            }
        }
        return outData;
    }

    public int[][] getData(int lineNumber, int eleNumber, int numLines, int numEles) throws AreaFileException {
        return this.getData(lineNumber, eleNumber, numLines, numEles, 1);
    }

    public int[][] getData(int lineNumber, int eleNumber, int numLines, int numEles, int bandNumber) throws AreaFileException {
        if (!this.hasReadData) {
            this.data = new int[this.origNumBands][this.dir[8]][this.dir[9]];
            this.readData(this.data);
        }
        int[][] subset = new int[numLines][numEles];
        for (int i = 0; i < numLines; ++i) {
            int ii = i + lineNumber;
            for (int j = 0; j < numEles; ++j) {
                int jj = j + eleNumber;
                subset[i][j] = ii < 0 || ii > this.dir[8] - 1 || jj < 0 || jj > this.dir[9] - 1 ? 0 : this.data[bandNumber - 1][ii][jj];
            }
        }
        return subset;
    }

    private int flipShort(short s2) {
        return s2 >> 8 & 0xFF | s2 << 8 & 0xFF00;
    }

    private int flipInt(int i) {
        return i >>> 24 & 0xFF | i >>> 8 & 0xFF00 | (i & 0xFF) << 24 | (i & 0xFF00) << 8;
    }

    private void readData(int[][][] target, int lineNumber, int numLines, int lineMag, int eleNumber, int numEles, int eleMag, int bandNumber) throws AreaFileException {
        if (!this.fileok) {
            throw new AreaFileException("Error reading AreaFile data");
        }
        int lineMagMult = lineMag >= 1 ? 0 : Math.abs(lineMag) - 1;
        int eleMagMult = eleMag >= 1 ? 0 : Math.abs(eleMag) - 1;
        int startLoc = this.dir[33];
        int elementSize = this.origNumBands * this.dir[10];
        int readElements = eleMagMult == 0 ? numEles : numEles * Math.abs(eleMag);
        int lineSkip = lineMagMult * this.lineLength;
        int readSkip = (this.origNumElements - readElements) * elementSize + this.linePrefixLength;
        int elementSkip = eleMagMult * elementSize;
        int bandSkip = elementSize - this.dir[10];
        int nextReadSkip = readSkip + lineSkip;
        int nextElementSkip = bandSkip + elementSkip;
        try {
            DataInputStream df = this.getInputStreamForData();
            if (df != this.af) {
                this.af = df;
            }
        }
        catch (IOException ioe) {
            throw new AreaFileException("Error getting input stream for data");
        }
        try {
            this.af.skipBytes(startLoc);
        }
        catch (IOException e) {
            throw new AreaFileException("Error skipping to start of data");
        }
        for (int i = 0; i < numLines; ++i) {
            for (int j = 0; j < numEles; ++j) {
                try {
                    if (this.dir[10] == 1) {
                        target[0][i][j] = this.af.readByte() & 0xFF;
                    } else if (this.dir[10] == 2) {
                        short shdata = this.af.readShort();
                        target[0][i][j] = this.flipwords ? this.flipShort(shdata) & 0xFFFF : shdata & 0xFFFF;
                    } else if (this.dir[10] == 4) {
                        int intdata = this.af.readInt();
                        target[0][i][j] = this.flipwords ? this.flipInt(intdata) : intdata;
                    }
                    this.af.skipBytes(nextElementSkip);
                    continue;
                }
                catch (IOException e) {
                    throw new AreaFileException("Error reading element " + i + " in line " + j);
                }
            }
            try {
                this.af.skipBytes(nextReadSkip);
                continue;
            }
            catch (IOException e) {
                throw new AreaFileException("Error skipping to next line");
            }
        }
    }

    private void readData(int[][][] target) throws AreaFileException {
        int numLines = this.dir[8];
        int numEles = this.dir[9];
        if (!this.fileok) {
            throw new AreaFileException("Error reading AreaFile data");
        }
        try {
            DataInputStream df = this.getInputStreamForData();
            if (df != this.af) {
                this.datLoc = 0;
                this.position = 0L;
                this.af = df;
            }
        }
        catch (IOException ioe) {
            throw new AreaFileException("Error getting input stream for data");
        }
        for (int i = 0; i < numLines; ++i) {
            int k;
            int j;
            try {
                this.newPosition = this.datLoc + this.linePrefixLength + i * this.lineLength;
                this.skipByteCount = (int)(this.newPosition - this.position);
                this.af.skipBytes(this.skipByteCount);
                this.position = this.newPosition;
            }
            catch (IOException e) {
                for (j = 0; j < numEles; ++j) {
                    for (k = 0; k < this.origNumBands; ++k) {
                        target[k][i][j] = 0;
                    }
                }
                break;
            }
            for (j = 0; j < numEles; ++j) {
                for (k = 0; k < this.origNumBands; ++k) {
                    if (j > this.lineDataLen) {
                        target[k][i][j] = 0;
                        continue;
                    }
                    try {
                        if (this.dir[10] == 1) {
                            target[k][i][j] = this.af.readByte() & 0xFF;
                            ++this.position;
                            continue;
                        }
                        if (this.dir[10] == 2) {
                            short shdata = this.af.readShort();
                            target[k][i][j] = this.flipwords ? this.flipShort(shdata) & 0xFFFF : shdata & 0xFFFF;
                            this.position += 2L;
                            continue;
                        }
                        if (this.dir[10] != 4) continue;
                        int intdata = this.af.readInt();
                        target[k][i][j] = this.flipwords ? this.flipInt(intdata) : intdata;
                        this.position += 4L;
                        continue;
                    }
                    catch (IOException e) {
                        target[k][i][j] = 0;
                    }
                }
            }
        }
        this.hasReadData = true;
        try {
            this.af.close();
        }
        catch (IOException excp) {
            System.out.println("Couldn't close input stream for " + this.imageSource);
        }
    }

    private void flipnav(int[] nav) {
        if (nav[0] == 1196835154) {
            McIDASUtil.flip(nav, 2, 126);
            McIDASUtil.flip(nav, 129, 254);
            McIDASUtil.flip(nav, 257, 382);
            McIDASUtil.flip(nav, 385, 510);
            McIDASUtil.flip(nav, 513, 638);
        } else if (nav[0] == 1145918032) {
            McIDASUtil.flip(nav, 1, 43);
            McIDASUtil.flip(nav, 45, 51);
        } else if (nav[0] == 1414091343) {
            McIDASUtil.flip(nav, 1, 119);
        } else if (nav[0] != 1196249944) {
            McIDASUtil.flip(nav, 1, nav.length - 1);
        }
    }

    public String toString() {
        AreaDirectory dir = this.getAreaDirectory();
        String EOL = "\n";
        StringBuffer buff = new StringBuffer();
        buff.append("Directory values =========" + EOL);
        buff.append("Num Lines: " + dir.getLines() + EOL);
        buff.append("Num Elements: " + dir.getElements() + EOL);
        buff.append("Start Line: " + dir.getDirectoryBlock()[5] + EOL);
        buff.append("Start Element: " + dir.getDirectoryBlock()[6] + EOL);
        buff.append("Line Res: " + dir.getDirectoryBlock()[11] + EOL);
        buff.append("Elem Res: " + dir.getDirectoryBlock()[12] + EOL);
        buff.append("Bands:");
        for (int i = 0; i < dir.getBands().length; ++i) {
            buff.append(" " + dir.getBands()[i]);
        }
        buff.append(EOL);
        buff.append("Source Type: " + dir.getSourceType() + EOL);
        buff.append("Sensor Type: " + dir.getSensorType() + EOL);
        buff.append("Sensor ID: " + dir.getSensorID() + EOL);
        buff.append("Cal Type: " + dir.getCalibrationType() + EOL);
        buff.append("Nominal Time: " + dir.getDirectoryBlock()[3] + " " + dir.getDirectoryBlock()[4] + EOL);
        buff.append("==========================" + EOL);
        try {
            buff.append("Nav: " + this.getNavigation() + EOL);
        }
        catch (AreaFileException areaFileException) {
            // empty catch block
        }
        buff.append("User Cal Type: " + AreaFileFactory.calIntToStr(this.getCalType()).toUpperCase());
        return buff.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            System.out.println();
            System.out.println("USAGE: AreaFile <URL or filepath> <show_vals>");
            System.out.println();
            System.exit(1);
        }
        AreaFile af = AreaFileFactory.getAreaFileInstance(args[0]);
        System.out.println(af);
        System.out.println();
        System.out.println(af.subset);
        System.out.println();
        long time = System.currentTimeMillis();
        System.out.print("Getting data ... ");
        float[][][] data = af.getFloatData();
        System.out.println("" + (System.currentTimeMillis() - time) + "ms to retrieve " + AreaFileFactory.calIntToStr(af.getCalType()).toUpperCase() + " data");
        System.out.println();
        System.out.println("DATA [" + data.length + "][" + data[0].length + "][" + data[0][0].length + "]");
        if (args.length > 1 && !af.isSubsetted()) {
            System.err.println("Sorry, I won't print an unsubsetted file");
            System.exit(0);
        }
        if (args.length > 1) {
            for (int i = 0; i < data[0].length; ++i) {
                for (int j = 0; j < data[0][0].length; ++j) {
                    System.err.print("" + data[0][i][j] + " ");
                }
                System.err.println();
            }
        }
    }

    private DataInputStream getInputStreamForData() throws IOException {
        if (this.af.markSupported()) {
            int numComments = this.dir[63];
            int compressedDataStart = numComments * 80 + this.datLoc;
            this.af.mark((int)((long)compressedDataStart - this.position + 10L));
            this.af.skip((long)compressedDataStart - this.position);
            byte[] test = new byte[8];
            this.af.read(test);
            this.af.reset();
            if (this.isPNG(test)) {
                if (numComments > 0) {
                    byte[] comments = new byte[numComments * 80];
                    this.af.read(comments);
                }
                int available = this.af.available();
                byte[] data = new byte[available];
                this.af.readFully(data);
                this.af.close();
                ByteArrayInputStream ios = new ByteArrayInputStream(data);
                BufferedImage image = ImageIO.read(ios);
                Raster raster = image.getData();
                DataBuffer db = raster.getDataBuffer();
                if (db instanceof DataBufferByte) {
                    DataBufferByte dbb = (DataBufferByte)db;
                    byte[] udata = dbb.getData();
                    ByteArrayInputStream newios = new ByteArrayInputStream(udata);
                    return new DataInputStream(newios);
                }
            } else {
                return this.af;
            }
        }
        return this.af;
    }

    private boolean isPNG(byte[] bytes) {
        if (bytes.length != 8) {
            return false;
        }
        return bytes[0] == -119 && bytes[1] == 80 && bytes[2] == 78 && bytes[3] == 71 && bytes[4] == 13 && bytes[5] == 10 && bytes[6] == 26 && bytes[7] == 10;
    }

    public void close() {
        if (this.af == null) {
            return;
        }
        try {
            this.af.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void save(String outputFile) throws AreaFileException {
        this.save(outputFile, false);
    }

    public void save(String outputFile, boolean verbose) throws AreaFileException {
        int[] aux;
        int[] cal;
        int[] nav;
        int[] dir = this.getDir();
        if (dir == null) {
            System.out.println("No AREA file directory!");
            return;
        }
        if (verbose) {
            System.out.println("Length of directory = " + dir.length);
            for (int i = 0; i < dir.length; ++i) {
                System.out.println(" index " + i + " = " + dir[i]);
            }
        }
        if ((nav = this.getNav()) == null) {
            if (verbose) {
                System.out.println("No navigation block!");
            }
        } else if (verbose) {
            System.out.println("Length of nav block = " + nav.length);
        }
        if ((cal = this.getCal()) == null) {
            if (verbose) {
                System.out.println("No calibration block!");
            }
        } else if (verbose) {
            System.out.println("Length of cal block = " + cal.length);
        }
        if ((aux = this.getAux()) == null) {
            if (verbose) {
                System.out.println("No aux block");
            }
        } else if (verbose) {
            System.out.println("Length of aux block = " + aux.length);
        }
        int NL = dir[8];
        int NE = dir[9];
        if (verbose) {
            System.out.println("Start reading data, num points=" + NL * NE);
        }
        int[][] data = this.getData(0, 0, NL, NE);
        if (verbose) {
            System.out.println("Finished reading data");
        }
        try {
            int i;
            RandomAccessFile raf = new RandomAccessFile(outputFile, "rw");
            if (verbose) {
                System.out.println("Dir to word 0");
            }
            raf.seek(0L);
            dir[0] = 0;
            for (i = 0; i < dir.length; ++i) {
                raf.writeInt(dir[i]);
            }
            if (verbose) {
                System.out.println("Nav to word " + dir[34]);
            }
            if (nav != null && dir[34] > 0) {
                raf.seek(dir[34]);
                for (i = 0; i < nav.length; ++i) {
                    raf.writeInt(nav[i]);
                }
            }
            if (verbose) {
                System.out.println("Cal to word " + dir[62]);
            }
            if (cal != null && dir[34] > 0) {
                raf.seek(dir[62]);
                for (i = 0; i < cal.length; ++i) {
                    raf.writeInt(cal[i]);
                }
            }
            if (verbose) {
                System.out.println("Aux to word " + dir[59]);
            }
            if (aux != null && dir[34] > 0) {
                raf.seek(dir[59]);
                for (i = 0; i < aux.length; ++i) {
                    raf.writeInt(aux[i]);
                }
            }
            if (verbose) {
                System.out.println("Data to word " + dir[33]);
            }
            if (dir[34] > 0) {
                raf.seek(dir[33]);
                for (i = 0; i < data.length; ++i) {
                    for (int j = 0; j < data[i].length; ++j) {
                        if (dir[10] == 1) {
                            raf.writeByte(data[i][j]);
                            continue;
                        }
                        if (dir[10] == 2) {
                            raf.writeShort(data[i][j]);
                            continue;
                        }
                        if (dir[10] != 4) continue;
                        raf.writeInt(data[i][j]);
                    }
                }
            }
            raf.close();
        }
        catch (Exception we) {
            throw new AreaFileException("Unable to save file " + we.getMessage());
        }
        if (verbose) {
            System.out.println("Completed. Data saved to: " + outputFile);
        }
    }

    static {
        try {
            String handlers = System.getProperty("java.protocol.handler.pkgs");
            String newProperty = null;
            if (handlers == null) {
                newProperty = "edu.wisc.ssec.mcidas";
            } else if (handlers.indexOf("edu.wisc.ssec.mcidas") < 0) {
                newProperty = "edu.wisc.ssec.mcidas | " + handlers;
            }
            if (newProperty != null) {
                System.setProperty("java.protocol.handler.pkgs", newProperty);
            }
            handlerLoaded = true;
        }
        catch (Exception e) {
            System.out.println("Unable to set System Property: java.protocol.handler.pkgs");
        }
        handlerLoaded = true;
    }

    private class Subset {
        int lineNumber;
        int numLines;
        int lineMag;
        int eleNumber;
        int numEles;
        int eleMag;
        int bandNumber;

        private Subset() {
        }

        public String toString() {
            return "Start_line:" + this.lineNumber + " Num_lines:" + this.numLines + " Line_mag:" + this.lineMag + " Start_ele:" + this.eleNumber + " Num_ele:" + this.numEles + " Ele_mag:" + this.eleMag + " Band:" + this.bandNumber;
        }
    }
}

