/*
 * Decompiled with CFR 0.152.
 */
package ucar.mcidas;

import java.io.IOException;
import ucar.mcidas.Calibrator;
import ucar.mcidas.CalibratorDefault;

public class CalibratorFY2
extends CalibratorDefault
implements Calibrator {
    private boolean isVis = false;
    private int curCalType = 1;
    private int numFY2Bands = 4;
    private int[] visDetectorId = new int[]{0x6C6C0000, -1263271936, -656932864, -50593792};
    private int[] prefix;
    private int[] calBlock;
    private static final int VIS_BAND_OFFSET = 192;
    private int[][] albedoFromRaw = new int[this.numFY2Bands][256];
    private int[][] britFromAlbedo = new int[this.numFY2Bands][256];
    private int[] tempTable = new int[1024];
    private int[] radTable = new int[1024];
    private int[] britTable = new int[1024];
    private int lastBand = -1;

    public CalibratorFY2(int[] prefix, int[] areaDir, int[] calBlock) throws IOException {
        super(null, null);
        this.prefix = prefix;
        this.calBlock = calBlock;
        int visOffset = 0;
        float albedo = 0.0f;
        for (int i = 0; i < this.numFY2Bands; ++i) {
            visOffset = 192 + i * 64;
            for (int j = 0; j < 256; j += 4) {
                albedo = (float)calBlock[visOffset + (j + 1) / 4] / 10000.0f;
                this.britFromAlbedo[i][j] = (int)Math.round(0.5 + 25.5 * Math.sqrt(albedo));
                this.albedoFromRaw[i][j] = Math.round(albedo * 100.0f);
                this.britFromAlbedo[i][j + 1] = (int)Math.round(0.5 + 25.5 * Math.sqrt(albedo));
                this.albedoFromRaw[i][j + 1] = Math.round(albedo * 100.0f);
                this.britFromAlbedo[i][j + 2] = (int)Math.round(0.5 + 25.5 * Math.sqrt(albedo));
                this.albedoFromRaw[i][j + 2] = Math.round(albedo * 100.0f);
                this.britFromAlbedo[i][j + 3] = (int)Math.round(0.5 + 25.5 * Math.sqrt(albedo));
                this.albedoFromRaw[i][j + 3] = Math.round(albedo * 100.0f);
            }
        }
    }

    @Override
    public float calibrate(float inVal, int band, int calTypeOut) {
        int i;
        int detector = 0;
        int irOffset = 0;
        float radiance = 0.0f;
        float temperature = 0.0f;
        float outVal = 0.0f;
        this.isVis = band == 1;
        if (this.isVis) {
            detector = 1;
            for (i = 0; i < this.numFY2Bands; ++i) {
                if (this.visDetectorId[i] != this.prefix[1]) continue;
                detector = i + 1;
            }
        }
        if (!this.isVis && band != this.lastBand) {
            irOffset = this.calBlock[(band - 2) * 2 + 8] / 4;
            for (i = 0; i < 1024; ++i) {
                temperature = (float)this.calBlock[irOffset] / 1000.0f;
                radiance = this.tempToRad(temperature, band);
                this.tempTable[i] = Math.round(temperature * 100.0f);
                this.radTable[i] = Math.round(radiance * 1000.0f);
                this.britTable[i] = temperature >= 242.0f ? Math.max(660 - (int)(2.0f * temperature), 0) : Math.min(418 - (int)temperature, 255);
            }
        }
        this.lastBand = band;
        if (calTypeOut == this.curCalType) {
            outVal = inVal;
        } else if (this.isVis) {
            if (calTypeOut == 3) {
                outVal = this.albedoFromRaw[detector][(int)inVal];
            }
            if (calTypeOut == 5) {
                outVal = this.britFromAlbedo[detector][(int)inVal];
            }
        } else {
            if (calTypeOut == 2) {
                outVal = this.radTable[(int)inVal];
            }
            if (calTypeOut == 4) {
                outVal = this.tempTable[(int)inVal];
            }
            if (calTypeOut == 5) {
                outVal = this.britTable[(int)inVal];
            }
        }
        return outVal;
    }

    public float tempToRad(float inVal, int band) {
        float outVal = -1.0f;
        float[] fk1 = new float[]{9280.38f, 7136.31f, 37258.2f, 224015.0f};
        float[] fk2 = new float[]{1323.95f, 1212.95f, 2104.22f, 3826.28f};
        float[] tc1 = new float[]{0.72122f, 1.00668f, 3.76883f, 4.00279f};
        float[] tc2 = new float[]{0.9975f, 0.99621f, 0.99108f, 0.99458f};
        float adjustedTemp = tc1[band - 1] + tc2[band - 1] * inVal;
        outVal = (float)((double)fk1[band - 1] / (Math.exp(fk2[band - 1] / adjustedTemp) - 1.0));
        return outVal;
    }
}

