/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dataset.transform.WRFEtaTransformBuilder;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.LambertConformal;

public class ADASConvention
extends CoordSysBuilder {
    private ProjectionCT projCT;
    private static final boolean debugProj = false;

    public ADASConvention() {
        this.conventionName = "ARPS/ADAS";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) throws IOException {
        Variable zsoil;
        if (null != ds.findVariable("x")) {
            return;
        }
        Attribute att = ds.findGlobalAttribute("MAPPROJ");
        int projType = att.getNumericValue().intValue();
        double lat1 = this.findAttributeDouble(ds, "TRUELAT1", Double.NaN);
        double lat2 = this.findAttributeDouble(ds, "TRUELAT2", Double.NaN);
        double lat_origin = lat1;
        double lon_origin = this.findAttributeDouble(ds, "TRUELON", Double.NaN);
        double false_easting = 0.0;
        double false_northing = 0.0;
        String projName = ds.findAttValueIgnoreCase(null, "grid_mapping_name", null);
        if (projName != null) {
            projName = projName.trim();
            lat_origin = this.findAttributeDouble(ds, "latitude_of_projection_origin", Double.NaN);
            lon_origin = this.findAttributeDouble(ds, "longitude_of_central_meridian", Double.NaN);
            false_easting = this.findAttributeDouble(ds, "false_easting", 0.0);
            false_northing = this.findAttributeDouble(ds, "false_northing", 0.0);
            Attribute att2 = ds.findGlobalAttributeIgnoreCase("standard_parallel");
            if (att2 != null) {
                lat1 = att2.getNumericValue().doubleValue();
                lat2 = att2.getLength() > 1 ? att2.getNumericValue(1).doubleValue() : lat1;
            }
        } else if (projType == 2) {
            projName = "lambert_conformal_conic";
        }
        Variable coord_var = ds.findVariable("x_stag");
        if (!Double.isNaN(false_easting) || !Double.isNaN(false_northing)) {
            String units = ds.findAttValueIgnoreCase(coord_var, "units", null);
            double scalef = 1.0;
            try {
                scalef = SimpleUnit.getConversionFactor(units, "km");
            }
            catch (IllegalArgumentException e) {
                log.error(units + " not convertible to km");
            }
            false_easting *= scalef;
            false_northing *= scalef;
        }
        if ("lambert_conformal_conic".equalsIgnoreCase(projName)) {
            LambertConformal proj = new LambertConformal(lat_origin, lon_origin, lat1, lat2, false_easting, false_northing);
            this.projCT = new ProjectionCT("Projection", "FGDC", proj);
            if (false_easting == 0.0) {
                this.calcCenterPoints(ds, proj);
            }
        } else {
            this.parseInfo.format("ERROR: unknown projection type = %s%n", projName);
        }
        if (this.projCT != null) {
            VariableDS v = this.makeCoordinateTransformVariable(ds, this.projCT);
            v.addAttribute(new Attribute("_CoordinateAxisTypes", "GeoX GeoY"));
            ds.addVariable(null, v);
        }
        if (ds.findVariable("x_stag") != null) {
            ds.addCoordinateAxis(this.makeCoordAxis(ds, "x"));
        }
        if (ds.findVariable("y_stag") != null) {
            ds.addCoordinateAxis(this.makeCoordAxis(ds, "y"));
        }
        if (ds.findVariable("z_stag") != null) {
            ds.addCoordinateAxis(this.makeCoordAxis(ds, "z"));
        }
        if ((zsoil = ds.findVariable("ZPSOIL")) != null) {
            zsoil.addAttribute(new Attribute("_CoordinateAxisType", AxisType.GeoZ.toString()));
        }
        ds.finish();
    }

    private void calcCenterPoints(NetcdfDataset ds, Projection proj) throws IOException {
        double lat_check = this.findAttributeDouble(ds, "CTRLAT", Double.NaN);
        double lon_check = this.findAttributeDouble(ds, "CTRLON", Double.NaN);
        LatLonPointImpl lpt0 = new LatLonPointImpl(lat_check, lon_check);
        ProjectionPoint ppt0 = proj.latLonToProj(lpt0, new ProjectionPointImpl());
        Variable xstag = ds.findVariable("x_stag");
        int nxpts = (int)xstag.getSize();
        ArrayFloat.D1 xstagData = (ArrayFloat.D1)xstag.read();
        float center_x = xstagData.get(nxpts - 1);
        double false_easting = (double)(center_x / 2000.0f) - ppt0.getX() * 1000.0;
        Variable ystag = ds.findVariable("y_stag");
        int nypts = (int)ystag.getSize();
        ArrayFloat.D1 ystagData = (ArrayFloat.D1)ystag.read();
        float center_y = ystagData.get(nypts - 1);
        double false_northing = (double)(center_y / 2000.0f) - ppt0.getY() * 1000.0;
        log.debug("false easting/northing= {} {} ", (Object)false_easting, (Object)false_northing);
        double dx = this.findAttributeDouble(ds, "DX", Double.NaN);
        double dy = this.findAttributeDouble(ds, "DY", Double.NaN);
        double w = dx * (double)(nxpts - 1);
        double h2 = dy * (double)(nypts - 1);
        double startx = ppt0.getX() * 1000.0 - w / 2.0;
        double starty = ppt0.getY() * 1000.0 - h2 / 2.0;
        xstag.setValues(nxpts, startx, dx);
        ystag.setValues(nypts, starty, dy);
    }

    @Override
    protected void makeCoordinateTransforms(NetcdfDataset ds) {
        if (this.projCT != null) {
            CoordSysBuilder.VarProcess vp = this.findVarProcess(this.projCT.getName(), null);
            vp.isCoordinateTransform = true;
            vp.ct = this.projCT;
        }
        super.makeCoordinateTransforms(ds);
    }

    @Override
    protected AxisType getAxisType(NetcdfDataset ds, VariableEnhanced ve) {
        Variable v = (Variable)((Object)ve);
        String vname = v.getShortName();
        if (vname.equalsIgnoreCase("x") || vname.equalsIgnoreCase("x_stag")) {
            return AxisType.GeoX;
        }
        if (vname.equalsIgnoreCase("lon")) {
            return AxisType.Lon;
        }
        if (vname.equalsIgnoreCase("y") || vname.equalsIgnoreCase("y_stag")) {
            return AxisType.GeoY;
        }
        if (vname.equalsIgnoreCase("lat")) {
            return AxisType.Lat;
        }
        if (vname.equalsIgnoreCase("z") || vname.equalsIgnoreCase("z_stag")) {
            return AxisType.GeoZ;
        }
        if (vname.equalsIgnoreCase("Z")) {
            return AxisType.Height;
        }
        if (vname.equalsIgnoreCase("time")) {
            return AxisType.Time;
        }
        String unit = ve.getUnitsString();
        if (unit != null) {
            if (SimpleUnit.isCompatible("millibar", unit)) {
                return AxisType.Pressure;
            }
            if (SimpleUnit.isCompatible("m", unit)) {
                return AxisType.Height;
            }
        }
        return null;
    }

    public String getZisPositive(CoordinateAxis v) {
        return "down";
    }

    private CoordinateAxis makeCoordAxis(NetcdfDataset ds, String axisName) throws IOException {
        Variable stagV = ds.findVariable(axisName + "_stag");
        Array data_stag = stagV.read();
        int n = (int)data_stag.getSize() - 1;
        DataType dt = DataType.getType(data_stag);
        Array data = Array.factory(dt, new int[]{n});
        Index stagIndex = data_stag.getIndex();
        Index dataIndex = data.getIndex();
        for (int i = 0; i < n; ++i) {
            double val = data_stag.getDouble(stagIndex.set(i)) + data_stag.getDouble(stagIndex.set(i + 1));
            data.setDouble(dataIndex.set(i), 0.5 * val);
        }
        DataType dtype = DataType.getType(data);
        String units = ds.findAttValueIgnoreCase(stagV, "units", "m");
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, axisName, dtype, axisName, units, "synthesized non-staggered " + axisName + " coordinate");
        v.setCachedData(data, true);
        return v;
    }

    private double findAttributeDouble(NetcdfDataset ds, String attname, double defValue) {
        Attribute att = ds.findGlobalAttributeIgnoreCase(attname);
        if (att == null) {
            return defValue;
        }
        return att.getNumericValue().doubleValue();
    }

    @Override
    protected void assignCoordinateTransforms(NetcdfDataset ncDataset) {
        super.assignCoordinateTransforms(ncDataset);
        List<CoordinateSystem> csys = ncDataset.getCoordinateSystems();
        for (CoordinateSystem cs : csys) {
            VerticalCT vct;
            String units;
            if (cs.getZaxis() == null || (units = cs.getZaxis().getUnitsString()) != null && !units.trim().isEmpty() || (vct = this.makeWRFEtaVerticalCoordinateTransform(ncDataset, cs)) == null) continue;
            cs.addCoordinateTransform(vct);
            this.parseInfo.format("***Added WRFEta verticalCoordinateTransform to %s%n", cs.getName());
        }
    }

    private VerticalCT makeWRFEtaVerticalCoordinateTransform(NetcdfDataset ds, CoordinateSystem cs) {
        if (null == ds.findVariable("PH") || null == ds.findVariable("PHB") || null == ds.findVariable("P") || null == ds.findVariable("PB")) {
            return null;
        }
        WRFEtaTransformBuilder builder = new WRFEtaTransformBuilder(cs);
        return builder.makeCoordinateTransform(ds, null);
    }
}

