/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.lang.reflect.Array;
import ucar.netcdf.AttrVal;
import ucar.netcdf.Attribute;

final class NumericAttrVal
extends AttrVal {
    private final Object data;

    NumericAttrVal(Number nn, Class componentType) {
        this.data = Array.newInstance(componentType, 1);
        Array.set(this.data, 0, nn);
    }

    NumericAttrVal(Object data) {
        this.data = data;
    }

    public int hashCode() {
        int h2 = 0;
        int len = this.getLength();
        for (int ii = 0; ii < len; ++ii) {
            h2 = h2 * 13 + this.get(ii).hashCode();
        }
        return h2;
    }

    public boolean equals(Object oo) {
        if (oo instanceof NumericAttrVal) {
            int length;
            NumericAttrVal aa = (NumericAttrVal)oo;
            if (this.getComponentType() == aa.getComponentType() && (length = this.getLength()) == aa.getLength()) {
                for (int ii = 0; ii < length; ++ii) {
                    if (this.get(ii).equals(aa.get(ii))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    Object getValue() {
        return Attribute.arrayClone(this.data);
    }

    Object get(int index) {
        return Array.get(this.data, index);
    }

    Number getNumericValue(int index) {
        return (Number)Array.get(this.data, index);
    }

    Number getNumericValue() {
        return this.getNumericValue(0);
    }

    Class getComponentType() {
        return this.data.getClass().getComponentType();
    }

    int getLength() {
        return Array.getLength(this.data);
    }

    void toCdl(StringBuffer buf) {
        int last = Array.getLength(this.data) - 1;
        for (int ii = 0; ii <= last; ++ii) {
            buf.append(Array.get(this.data, ii));
            if (ii >= last) continue;
            buf.append(", ");
        }
    }
}

