/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ucar.ma2.ArrayStructure;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.DataIteratorAdapter;
import ucar.nc2.dt.point.PointObsDatatypeImpl;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class SequenceHelper {
    protected NetcdfFile ncfile;
    protected DODSNetcdfFile dodsFile;
    protected StructureDS sequenceOuter;
    protected StructureDS sequenceInner;
    protected Variable latVar;
    protected Variable lonVar;
    protected Variable altVar;
    protected Variable timeVar;
    protected boolean isProfile;
    protected DateUnit timeUnit;
    protected DateFormatter formatter;
    private StructureMembers.Member latMember;
    private StructureMembers.Member lonMember;
    private StructureMembers.Member innerMember;
    private StructureMembers.Member altMember;
    private StructureMembers.Member timeMember;

    public SequenceHelper(NetcdfDataset ncfile, boolean isProfile, StructureDS sequenceOuter, StructureDS sequenceInner, Variable latVar, Variable lonVar, Variable altVar, Variable timeVar, List typedDataVariables, StringBuffer errBuffer) {
        Variable v;
        int i;
        this.ncfile = ncfile;
        this.isProfile = isProfile;
        this.sequenceOuter = sequenceOuter;
        this.sequenceInner = sequenceInner;
        this.latVar = latVar;
        this.lonVar = lonVar;
        this.altVar = altVar;
        this.timeVar = timeVar;
        NetcdfFile refFile = ncfile.getReferencedFile();
        while (this.dodsFile == null) {
            if (refFile instanceof DODSNetcdfFile) {
                this.dodsFile = (DODSNetcdfFile)refFile;
                continue;
            }
            if (refFile instanceof NetcdfDataset) {
                refFile = ((NetcdfDataset)refFile).getReferencedFile();
                continue;
            }
            throw new IllegalArgumentException("Must be a DODSNetcdfFile");
        }
        ImmutableList<Variable> recordMembers = sequenceOuter.getVariables();
        for (i = 0; i < recordMembers.size(); ++i) {
            v = (Variable)recordMembers.get(i);
            typedDataVariables.add(v);
        }
        recordMembers = sequenceInner.getVariables();
        for (i = 0; i < recordMembers.size(); ++i) {
            v = (Variable)recordMembers.get(i);
            typedDataVariables.add(v);
        }
        typedDataVariables.remove(latVar);
        typedDataVariables.remove(lonVar);
        typedDataVariables.remove(altVar);
        typedDataVariables.remove(timeVar);
        typedDataVariables.remove(sequenceInner);
    }

    public void setTimeUnit(DateUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public DateUnit getTimeUnit() {
        return this.timeUnit;
    }

    public List getData(CancelTask cancel) throws IOException {
        String CE = this.sequenceOuter.getShortName();
        ArrayStructure as = (ArrayStructure)this.dodsFile.readWithCE(this.sequenceOuter, CE);
        this.extractMembers(as);
        int n = (int)as.getSize();
        ArrayList<SeqPointObs> dataList = new ArrayList<SeqPointObs>(n);
        for (int i = 0; i < n; ++i) {
            dataList.add(new SeqPointObs(i, as.getStructureData(i)));
        }
        return dataList;
    }

    public List getData(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        String CE = this.sequenceOuter.getShortName() + "&" + this.makeBB(boundingBox);
        ArrayStructure as = (ArrayStructure)this.dodsFile.readWithCE(this.sequenceOuter, CE);
        this.extractMembers(as);
        int n = (int)as.getSize();
        ArrayList<SeqPointObs> dataList = new ArrayList<SeqPointObs>(n);
        for (int i = 0; i < n; ++i) {
            dataList.add(new SeqPointObs(i, as.getStructureData(i)));
        }
        return dataList;
    }

    public List getData(LatLonRect boundingBox, Date start, Date end, CancelTask cancel) throws IOException {
        String CE = this.sequenceOuter.getShortName() + "&" + this.makeBB(boundingBox) + "&" + this.makeTimeRange(start, end);
        ArrayStructure as = (ArrayStructure)this.dodsFile.readWithCE(this.sequenceOuter, CE);
        this.extractMembers(as);
        int n = (int)as.getSize();
        ArrayList<SeqPointObs> dataList = new ArrayList<SeqPointObs>(n);
        for (int i = 0; i < n; ++i) {
            dataList.add(new SeqPointObs(i, as.getStructureData(i)));
        }
        return dataList;
    }

    private String makeBB(LatLonRect bb) {
        return this.latVar.getShortName() + ">=" + bb.getLowerLeftPoint().getLatitude() + "&" + this.latVar.getShortName() + "<=" + bb.getUpperRightPoint().getLatitude() + "&" + this.lonVar.getShortName() + ">=" + bb.getLowerLeftPoint().getLongitude() + "&" + this.lonVar.getShortName() + "<=" + bb.getUpperRightPoint().getLongitude();
    }

    private String makeTimeRange(Date start, Date end) {
        double startValue = this.timeUnit.makeValue(start);
        double endValue = this.timeUnit.makeValue(end);
        return this.timeVar.getShortName() + ">=" + startValue + "&" + this.timeVar.getShortName() + "<=" + endValue;
    }

    private void extractMembers(ArrayStructure as) {
        StructureMembers members = as.getStructureMembers();
        this.latMember = members.findMember(this.latVar.getShortName());
        this.lonMember = members.findMember(this.lonVar.getShortName());
        this.innerMember = members.findMember(this.sequenceInner.getShortName());
        StructureData first = as.getStructureData(0);
        StructureData innerFirst = first.getScalarStructure(this.innerMember);
        StructureMembers innerMembers = innerFirst.getStructureMembers();
        if (this.isProfile) {
            this.timeMember = members.findMember(this.timeVar.getShortName());
            this.altMember = innerMembers.findMember(this.altVar.getShortName());
        } else {
            this.timeMember = innerMembers.findMember(this.timeVar.getShortName());
            this.altMember = members.findMember(this.altVar.getShortName());
        }
    }

    public DataIterator getDataIterator(int bufferSize) throws IOException {
        return new DataIteratorAdapter(this.getData(null).iterator());
    }

    public class SeqPointObs
    extends PointObsDatatypeImpl {
        protected int recno;
        protected LatLonPointImpl llpt;
        protected StructureData sdata;

        protected SeqPointObs(EarthLocation location, double obsTime, double nomTime, int recno) {
            super(location, obsTime, nomTime);
            this.llpt = null;
            this.recno = recno;
        }

        public SeqPointObs(int recno, StructureData sdata) {
            this.llpt = null;
            this.recno = recno;
            this.sdata = sdata;
            double lat = sdata.convertScalarDouble(SequenceHelper.this.latMember);
            double lon = sdata.convertScalarDouble(SequenceHelper.this.lonMember);
            StructureData inner = sdata.getScalarStructure(SequenceHelper.this.innerMember);
            double alt = 0.0;
            if (SequenceHelper.this.isProfile) {
                this.obsTime = sdata.convertScalarDouble(SequenceHelper.this.timeMember);
                alt = inner.convertScalarDouble(SequenceHelper.this.altMember);
            } else {
                this.obsTime = inner.convertScalarDouble(SequenceHelper.this.timeMember);
                alt = sdata.convertScalarDouble(SequenceHelper.this.altMember);
            }
            this.nomTime = this.obsTime;
            this.location = EarthLocation.create(lat, lon, alt);
        }

        public LatLonPoint getLatLon() {
            if (this.llpt == null) {
                this.llpt = new LatLonPointImpl(this.location.getLatitude(), this.location.getLongitude());
            }
            return this.llpt;
        }

        @Override
        public Date getNominalTimeAsDate() {
            return SequenceHelper.this.timeUnit.makeDate(this.getNominalTime());
        }

        @Override
        public Date getObservationTimeAsDate() {
            return SequenceHelper.this.timeUnit.makeDate(this.getObservationTime());
        }

        @Override
        public StructureData getData() throws IOException {
            return this.sdata;
        }
    }
}

