/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import loci.formats.LogTools;
import loci.formats.ReflectException;

public class ReflectedUniverse {
    protected Hashtable variables = new Hashtable();
    protected ClassLoader loader;
    protected boolean force;
    protected boolean debug;

    public ReflectedUniverse() {
        this((ClassLoader)null);
    }

    public ReflectedUniverse(URL[] urls) {
        this(urls == null ? null : new URLClassLoader(urls));
    }

    public ReflectedUniverse(ClassLoader loader) {
        this.loader = loader == null ? this.getClass().getClassLoader() : loader;
        this.debug = false;
    }

    public static boolean isInstance(Class c, Object o) {
        return o == null || c.isInstance(o) || c == Byte.TYPE && o instanceof Byte || c == Short.TYPE && o instanceof Short || c == Integer.TYPE && o instanceof Integer || c == Long.TYPE && o instanceof Long || c == Float.TYPE && o instanceof Float || c == Double.TYPE && o instanceof Double || c == Boolean.TYPE && o instanceof Boolean || c == Character.TYPE && o instanceof Character;
    }

    public Object exec(String command) throws ReflectException {
        if ((command = command.trim()).startsWith("import ")) {
            Class<?> c;
            int dot = (command = command.substring(7).trim()).lastIndexOf(".");
            String varName = dot < 0 ? command : command.substring(dot + 1);
            try {
                c = Class.forName(command, true, this.loader);
            }
            catch (NoClassDefFoundError err) {
                if (this.debug) {
                    LogTools.trace(err);
                }
                throw new ReflectException("No such class: " + command, err);
            }
            catch (ClassNotFoundException exc) {
                if (this.debug) {
                    LogTools.trace(exc);
                }
                throw new ReflectException("No such class: " + command, exc);
            }
            catch (RuntimeException exc) {
                String msg = exc.getMessage();
                if (msg != null && msg.indexOf("ClassNotFound") < 0) {
                    throw exc;
                }
                if (this.debug) {
                    LogTools.trace(exc);
                }
                throw new ReflectException("No such class: " + command, exc);
            }
            this.setVar(varName, c);
            return null;
        }
        int eqIndex = command.indexOf("=");
        String target = null;
        if (eqIndex >= 0) {
            target = command.substring(0, eqIndex).trim();
            command = command.substring(eqIndex + 1).trim();
        }
        Object result = null;
        int leftParen = command.indexOf("(");
        if (leftParen < 0) {
            result = this.getVar(command);
            if (target != null) {
                this.setVar(target, result);
            }
            return result;
        }
        if (leftParen != command.lastIndexOf("(") || command.indexOf(")") != command.length() - 1) {
            throw new ReflectException("Invalid parentheses");
        }
        String arglist = command.substring(leftParen + 1);
        StringTokenizer st = new StringTokenizer(arglist, "(,)");
        int len = st.countTokens();
        Object[] args = new Object[len];
        for (int i = 0; i < len; ++i) {
            String arg = st.nextToken().trim();
            args[i] = this.getVar(arg);
        }
        if ((command = command.substring(0, leftParen)).startsWith("new ")) {
            String className = command.substring(4).trim();
            Object var = this.getVar(className);
            if (var == null) {
                throw new ReflectException("Class not found: " + className);
            }
            if (!(var instanceof Class)) {
                throw new ReflectException("Not a class: " + className);
            }
            Class cl = (Class)var;
            Constructor<?> constructor = null;
            Constructor<?>[] c = cl.getConstructors();
            for (int i = 0; i < c.length; ++i) {
                Class<?>[] params;
                if (this.force) {
                    c[i].setAccessible(true);
                }
                if ((params = c[i].getParameterTypes()).length != args.length) continue;
                boolean match = true;
                for (int j = 0; j < params.length; ++j) {
                    if (ReflectedUniverse.isInstance(params[j], args[j])) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                constructor = c[i];
                break;
            }
            if (constructor == null) {
                StringBuffer sb = new StringBuffer(command);
                for (int i = 0; i < args.length; ++i) {
                    sb.append(i == 0 ? "(" : ", ");
                    sb.append(args[i].getClass().getName());
                }
                sb.append(")");
                throw new ReflectException("No such constructor: " + sb.toString());
            }
            ReflectiveOperationException exc = null;
            try {
                result = constructor.newInstance(args);
            }
            catch (InstantiationException e) {
                exc = e;
            }
            catch (IllegalAccessException e) {
                exc = e;
            }
            catch (InvocationTargetException e) {
                exc = e;
            }
            if (exc != null) {
                if (this.debug) {
                    LogTools.trace(exc);
                }
                throw new ReflectException("Cannot instantiate object", exc);
            }
        } else {
            int dot = command.indexOf(".");
            if (dot < 0) {
                throw new ReflectException("Syntax error");
            }
            String varName = command.substring(0, dot).trim();
            String methodName = command.substring(dot + 1).trim();
            Object var = this.getVar(varName);
            if (var == null) {
                throw new ReflectException("No such variable: " + varName);
            }
            Class<?> varClass = var instanceof Class ? (Class<?>)var : var.getClass();
            Method method = null;
            Method[] m3 = varClass.getMethods();
            for (int i = 0; i < m3.length; ++i) {
                Class<?>[] params;
                if (this.force) {
                    m3[i].setAccessible(true);
                }
                if (!methodName.equals(m3[i].getName()) || (params = m3[i].getParameterTypes()).length != args.length) continue;
                boolean match = true;
                for (int j = 0; j < params.length; ++j) {
                    if (ReflectedUniverse.isInstance(params[j], args[j])) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                method = m3[i];
                break;
            }
            if (method == null) {
                throw new ReflectException("No such method: " + methodName);
            }
            ReflectiveOperationException exc = null;
            try {
                result = method.invoke(var, args);
            }
            catch (IllegalAccessException e) {
                exc = e;
            }
            catch (InvocationTargetException e) {
                exc = e;
            }
            if (exc != null) {
                if (this.debug) {
                    LogTools.trace(exc);
                }
                throw new ReflectException("Cannot execute method: " + methodName, exc);
            }
        }
        if (target != null) {
            this.setVar(target, result);
        }
        return result;
    }

    public void setVar(String varName, Object obj) {
        if (obj == null) {
            this.variables.remove(varName);
        } else {
            this.variables.put(varName, obj);
        }
    }

    public void setVar(String varName, boolean b) {
        this.setVar(varName, new Boolean(b));
    }

    public void setVar(String varName, byte b) {
        this.setVar(varName, new Byte(b));
    }

    public void setVar(String varName, char c) {
        this.setVar(varName, new Character(c));
    }

    public void setVar(String varName, double d) {
        this.setVar(varName, new Double(d));
    }

    public void setVar(String varName, float f) {
        this.setVar(varName, new Float(f));
    }

    public void setVar(String varName, int i) {
        this.setVar(varName, new Integer(i));
    }

    public void setVar(String varName, long l) {
        this.setVar(varName, new Long(l));
    }

    public void setVar(String varName, short s2) {
        this.setVar(varName, new Short(s2));
    }

    public Object getVar(String varName) throws ReflectException {
        if (varName.equals("null")) {
            return null;
        }
        if (varName.equals("true")) {
            return new Boolean(true);
        }
        if (varName.equals("false")) {
            return new Boolean(false);
        }
        if (varName.startsWith("\"") && varName.endsWith("\"")) {
            return varName.substring(1, varName.length() - 1);
        }
        try {
            if (varName.matches("-?\\d+")) {
                return new Integer(varName);
            }
            if (varName.matches("-?\\d+L")) {
                return new Long(varName);
            }
            if (varName.matches("-?\\d*\\.\\d*")) {
                return new Double(varName);
            }
        }
        catch (NumberFormatException exc) {
            throw new ReflectException("Invalid literal: " + varName, exc);
        }
        int dot = varName.indexOf(".");
        if (dot >= 0) {
            Object fieldVal;
            Field field;
            String className = varName.substring(0, dot).trim();
            Object var = this.variables.get(className);
            if (var == null) {
                throw new ReflectException("No such class: " + className);
            }
            Class<?> varClass = var instanceof Class ? (Class<?>)var : var.getClass();
            String fieldName = varName.substring(dot + 1).trim();
            try {
                field = varClass.getField(fieldName);
                if (this.force) {
                    field.setAccessible(true);
                }
            }
            catch (NoSuchFieldException exc) {
                if (this.debug) {
                    LogTools.trace(exc);
                }
                throw new ReflectException("No such field: " + varName, exc);
            }
            try {
                fieldVal = field.get(var);
            }
            catch (IllegalAccessException exc) {
                if (this.debug) {
                    LogTools.trace(exc);
                }
                throw new ReflectException("Cannot get field value: " + varName, exc);
            }
            return fieldVal;
        }
        Object var = this.variables.get(varName);
        return var;
    }

    public void setAccessibilityIgnored(boolean ignore) {
        this.force = ignore;
    }

    public boolean isAccessibilityIgnored() {
        return this.force;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public static void main(String[] args) throws IOException {
        ReflectedUniverse r = new ReflectedUniverse();
        LogTools.println("Reflected universe test environment. Type commands, or press ^D to quit.");
        if (args.length > 0) {
            r.setAccessibilityIgnored(true);
            LogTools.println("Ignoring accessibility modifiers.");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            LogTools.print("> ");
            String line = in.readLine();
            if (line == null) break;
            try {
                r.exec(line);
            }
            catch (ReflectException exc) {
                LogTools.trace(exc);
            }
        }
        LogTools.println();
    }
}

