/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.GribResourceReader;
import ucar.unidata.util.StringUtil2;

@Deprecated
public class GribVariableRenamer {
    private static final Logger logger = LoggerFactory.getLogger(GribVariableRenamer.class);
    private static HashMap<String, Renamer> map1;
    private static HashMap<String, Renamer> map2;

    private void initMap1() {
        List<VariableRenamerBean> beans = this.readVariableRenameFile("resources/grib1/grib1VarMap.xml");
        map1 = this.makeMapBeans(beans);
    }

    private void initMap2() {
        List<VariableRenamerBean> beans = this.readVariableRenameFile("resources/grib2/grib2VarMap.xml");
        map2 = this.makeMapBeans(beans);
    }

    List<String> getMappedNamesGrib2(String oldName) {
        if (map2 == null) {
            this.initMap2();
        }
        ArrayList<String> result = new ArrayList<String>();
        Renamer mbean = map2.get(oldName);
        if (mbean == null) {
            return null;
        }
        for (VariableRenamerBean r : mbean.newVars) {
            result.add(r.newName);
        }
        return result;
    }

    List<String> getMappedNamesGrib1(String oldName) {
        if (map1 == null) {
            this.initMap1();
        }
        ArrayList<String> result = new ArrayList<String>();
        Renamer mbean = map1.get(oldName);
        if (mbean == null) {
            return null;
        }
        for (VariableRenamerBean r : mbean.newVars) {
            result.add(r.newName);
        }
        return result;
    }

    List<String> matchNcepNames(ucar.nc2.dt.GridDataset gds, String oldName) {
        HashMap<String, Renamer> map;
        boolean isGrib2;
        ArrayList<String> result = new ArrayList<String>();
        if (this.contains(gds, oldName)) {
            result.add(oldName);
            return result;
        }
        Attribute att = gds.findGlobalAttributeIgnoreCase("file_format");
        boolean isGrib1 = att != null && att.getStringValue().startsWith("GRIB-1");
        boolean bl = isGrib2 = att != null && att.getStringValue().startsWith("GRIB-2");
        if (isGrib1) {
            if (map1 == null) {
                this.initMap1();
            }
            map = map1;
        } else if (isGrib2) {
            if (map2 == null) {
                this.initMap2();
            }
            map = map2;
        } else {
            return result;
        }
        Renamer mbean = map.get(oldName);
        if (mbean != null && mbean.newName != null && this.contains(gds, mbean.newName)) {
            result.add(mbean.newName);
            return result;
        }
        if (mbean != null) {
            String dataset = GribVariableRenamer.extractDatasetFromLocation(gds.getLocation());
            for (VariableRenamerBean r : mbean.newVars) {
                if (!r.getDatasetType().equals(dataset) || !this.contains(gds, r.newName)) continue;
                result.add(r.newName);
            }
            if (result.size() == 1) {
                return result;
            }
        }
        result.clear();
        if (mbean != null) {
            for (VariableRenamerBean r : mbean.newVarsMap.values()) {
                if (!this.contains(gds, r.newName)) continue;
                result.add(r.newName);
            }
            if (result.size() > 0) {
                return result;
            }
        }
        result.clear();
        String oldMunged = this.munge(oldName);
        for (GridDatatype grid : gds.getGrids()) {
            String newMunged = this.munge(grid.getShortName());
            if (!newMunged.startsWith(oldMunged)) continue;
            result.add(grid.getShortName());
        }
        if (result.size() > 0) {
            return result;
        }
        return result;
    }

    List<String> matchNcepNames(String datasetType, String oldName) {
        HashMap<String, Renamer> map;
        boolean isGrib1 = datasetType.endsWith("grib1");
        ArrayList<String> result = new ArrayList<String>();
        if (isGrib1) {
            if (map1 == null) {
                this.initMap1();
            }
            map = map1;
        } else {
            if (map2 == null) {
                this.initMap2();
            }
            map = map2;
        }
        Renamer mbean = map.get(oldName);
        if (mbean != null && mbean.newName != null) {
            result.add(mbean.newName);
            return result;
        }
        if (mbean != null) {
            for (VariableRenamerBean r : mbean.newVars) {
                if (!r.getDatasetType().equals(datasetType)) continue;
                result.add(r.newName);
            }
        }
        return result;
    }

    private String munge(String old) {
        StringBuilder oldLower = new StringBuilder(old.toLowerCase());
        StringUtil2.removeAll(oldLower, "_-");
        return oldLower.toString();
    }

    private boolean contains(ucar.nc2.dt.GridDataset gds, String name) {
        return gds.findGridByShortName(name) != null;
    }

    private String getNewName(HashMap<String, Renamer> map, String datasetLocation, String oldName) {
        Renamer mbean = map.get(oldName);
        if (mbean == null) {
            return null;
        }
        if (mbean.newName != null) {
            return mbean.newName;
        }
        String dataset = GribVariableRenamer.extractDatasetFromLocation(datasetLocation);
        for (VariableRenamerBean r : mbean.newVars) {
            if (!r.getDatasetType().equals(dataset)) continue;
            return r.getNewName();
        }
        return null;
    }

    private static String extractDatasetFromLocation(String location) {
        int posSuffix;
        int pos;
        if (location.endsWith("/GC")) {
            int locLen = location.length();
            location = location.substring(0, locLen - 3);
        }
        if ((pos = location.lastIndexOf("/")) > 0) {
            location = location.substring(pos + 1);
        }
        if ((posSuffix = location.lastIndexOf(".")) - 14 > 0) {
            return location.substring(0, posSuffix - 14) + location.substring(posSuffix);
        }
        return "";
    }

    List<VariableRenamerBean> readVariableRenamerBeans(String which) {
        if (which.equals("GRIB-1")) {
            return this.readVariableRenameFile("resources/grib1/grib1VarMap.xml");
        }
        return this.readVariableRenameFile("resources/grib2/grib2VarMap.xml");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<VariableRenamerBean> readVariableRenameFile(String path) {
        ArrayList<VariableRenamerBean> beans = new ArrayList<VariableRenamerBean>(1000);
        try (InputStream is = GribResourceReader.getInputStream(path);){
            if (is == null) {
                logger.warn("Cant read file " + path);
                List<VariableRenamerBean> list = null;
                return list;
            }
            SAXBuilder builder = new SAXBuilder();
            builder.setExpandEntities(false);
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            List<Element> dsElems = root.getChildren("dataset");
            for (Element dsElem : dsElems) {
                String dsName = dsElem.getAttributeValue("name");
                List<Element> params = dsElem.getChildren("param");
                for (Element elem : params) {
                    String oldName = elem.getAttributeValue("oldName");
                    String newName = elem.getAttributeValue("newName");
                    String varId = elem.getAttributeValue("varId");
                    beans.add(new VariableRenamerBean(dsName, oldName, newName, varId));
                }
            }
            ArrayList<VariableRenamerBean> arrayList = beans;
            return arrayList;
        }
        catch (IOException | JDOMException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    private HashMap<String, Renamer> makeMapBeans(List<VariableRenamerBean> vbeans) {
        HashMap<String, Renamer> map = new HashMap<String, Renamer>(3000);
        for (VariableRenamerBean vbean : vbeans) {
            Renamer mbean = (Renamer)map.get(vbean.getOldName());
            if (mbean == null) {
                mbean = new Renamer(vbean.getOldName());
                map.put(vbean.getOldName(), mbean);
            }
            mbean.add(vbean);
        }
        for (Renamer rmap : map.values()) {
            rmap.finish();
        }
        return map;
    }

    public static void main(String[] args) throws IOException {
        GridDataset gds = GridDataset.open("Q:/cdmUnitTest/tds/ncep/GFS_CONUS_80km_20100513_0600.grib1");
        GribVariableRenamer r = new GribVariableRenamer();
        List<String> result = r.matchNcepNames(gds, "Precipitable_water");
    }

    @Deprecated
    private static class Renamer {
        String oldName;
        String newName;
        List<VariableRenamerBean> newVars = new ArrayList<VariableRenamerBean>();
        HashMap<String, VariableRenamerBean> newVarsMap = new HashMap();

        public Renamer() {
        }

        public Renamer(String oldName) {
            this.oldName = oldName;
        }

        void add(VariableRenamerBean vbean) {
            this.newVarsMap.put(vbean.getNewName(), vbean);
            this.newVars.add(vbean);
        }

        void finish() {
            if (this.newVarsMap.values().size() == 1) {
                this.newName = this.newVars.get(0).getNewName();
            }
        }

        public int getCount() {
            return this.newVars.size();
        }

        public String getOldName() {
            return this.oldName;
        }
    }

    @Deprecated
    public static class VariableRenamerBean
    implements Comparable<VariableRenamerBean> {
        String dsName;
        String dsType;
        String oldName;
        String newName;
        String varId;

        public VariableRenamerBean() {
        }

        public VariableRenamerBean(String dsName, String oldName, String newName, String varId) {
            this.dsName = dsName;
            this.dsType = GribVariableRenamer.extractDatasetFromLocation(dsName);
            this.oldName = oldName;
            this.newName = newName;
            this.varId = varId;
        }

        public String getDataset() {
            return this.dsName;
        }

        public String getDatasetType() {
            return this.dsType;
        }

        public String getVarId() {
            return this.varId;
        }

        public String getOldName() {
            return this.oldName;
        }

        public String getNewName() {
            return this.newName;
        }

        public String getStatus() {
            if (this.oldName.equals(this.newName)) {
                return "*";
            }
            if (this.oldName.equalsIgnoreCase(this.newName)) {
                return "**";
            }
            return "";
        }

        @Override
        public int compareTo(VariableRenamerBean o) {
            return this.newName.compareTo(o.getNewName());
        }
    }
}

