/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.net.URL;
import java.util.Formatter;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import thredds.client.catalog.Catalog;
import thredds.inventory.CollectionManager;
import thredds.inventory.DateExtractorFromName;
import thredds.inventory.MFileCollectionManager;
import ucar.nc2.util.URLnaming;

public class NcmlCollectionReader {
    private static final boolean debugURL = false;
    private static final boolean debugXML = false;
    private static final boolean showParsedXML = false;
    private MFileCollectionManager datasetManager;
    private boolean hasInner;
    private boolean hasOuter;
    private Element netcdfElem;
    private Element aggElem;

    public static NcmlCollectionReader open(String ncmlLocation, Formatter errlog) throws IOException {
        Document doc;
        if (!ncmlLocation.startsWith("http:") && !ncmlLocation.startsWith("file:")) {
            ncmlLocation = "file:" + ncmlLocation;
        }
        URL url = new URL(ncmlLocation);
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(url);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        Element netcdfElem = doc.getRootElement();
        Namespace use = netcdfElem.getNamespace();
        if (!use.equals(Catalog.ncmlNS)) {
            errlog.format("Incorrect namespace specified in NcML= %s must be %s%n", use.getURI(), Catalog.ncmlNS.getURI());
            return null;
        }
        Element aggElem = netcdfElem.getChild("aggregation", Catalog.ncmlNS);
        if (aggElem == null) {
            errlog.format("NcML must have aggregation element", new Object[0]);
            return null;
        }
        String type = aggElem.getAttributeValue("type");
        if (!(type.equals("forecastModelRunCollection") || type.equals("forecastModelRunSingleCollection") || type.equals("fmrc"))) {
            errlog.format("NcML aggregation must be of type fmrc", new Object[0]);
            return null;
        }
        Element scanElem = aggElem.getChild("scan", Catalog.ncmlNS);
        if (scanElem == null) {
            scanElem = aggElem.getChild("scanFmrc", Catalog.ncmlNS);
        }
        if (scanElem == null) {
            errlog.format("NcML must have aggregation scan or scanFmrc element", new Object[0]);
            return null;
        }
        return new NcmlCollectionReader(ncmlLocation, netcdfElem);
    }

    NcmlCollectionReader(String ncmlLocation, Element netcdfElem) {
        Element aggElem = netcdfElem.getChild("aggregation", Catalog.ncmlNS);
        String recheck = aggElem.getAttributeValue("recheckEvery");
        Element scanElem = aggElem.getChild("scan", Catalog.ncmlNS);
        if (scanElem == null) {
            scanElem = aggElem.getChild("scanFmrc", Catalog.ncmlNS);
        }
        String dirLocation = scanElem.getAttributeValue("location");
        dirLocation = URLnaming.resolve(ncmlLocation, dirLocation);
        String regexpPatternString = scanElem.getAttributeValue("regExp");
        String suffix = scanElem.getAttributeValue("suffix");
        String subdirs = scanElem.getAttributeValue("subdirs");
        String olderThan = scanElem.getAttributeValue("olderThan");
        this.datasetManager = MFileCollectionManager.openWithRecheck(ncmlLocation, recheck);
        this.datasetManager.addDirectoryScan(dirLocation, suffix, regexpPatternString, subdirs, olderThan, null);
        String dateFormatMark = scanElem.getAttributeValue("dateFormatMark");
        DateExtractorFromName dateExtractor = null;
        if (dateFormatMark != null) {
            dateExtractor = new DateExtractorFromName(dateFormatMark, true);
        } else {
            String runDateMatcher = scanElem.getAttributeValue("runDateMatcher");
            if (runDateMatcher != null) {
                dateExtractor = new DateExtractorFromName(runDateMatcher, false);
            }
        }
        this.datasetManager.setDateExtractor(dateExtractor);
        this.hasOuter = this.hasMods(netcdfElem);
        this.hasInner = this.hasMods(aggElem);
        if (this.hasOuter) {
            this.netcdfElem = netcdfElem;
        }
        if (this.hasInner) {
            this.aggElem = aggElem;
        }
    }

    private boolean hasMods(Element elem) {
        if (elem.getChildren("attribute", Catalog.ncmlNS).size() > 0) {
            return true;
        }
        if (elem.getChildren("variable", Catalog.ncmlNS).size() > 0) {
            return true;
        }
        if (elem.getChildren("dimension", Catalog.ncmlNS).size() > 0) {
            return true;
        }
        if (elem.getChildren("group", Catalog.ncmlNS).size() > 0) {
            return true;
        }
        return elem.getChildren("remove", Catalog.ncmlNS).size() > 0;
    }

    public Element getNcmlOuter() {
        return this.netcdfElem;
    }

    public Element getNcmlInner() {
        return this.aggElem;
    }

    public CollectionManager getCollectionManager() {
        return this.datasetManager;
    }
}

