/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxisTimeHelper;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.NamedAnything;
import ucar.nc2.util.NamedObject;

public class CoordinateAxis1DTime
extends CoordinateAxis1D {
    private static final Logger logger = LoggerFactory.getLogger(CoordinateAxis1DTime.class);
    private final CoordinateAxisTimeHelper helper;
    private List<CalendarDate> cdates = null;

    public static CoordinateAxis1DTime factory(NetcdfDataset ncd, VariableDS org, Formatter errMessages) throws IOException {
        if (org instanceof CoordinateAxis1DTime) {
            return (CoordinateAxis1DTime)org;
        }
        if (org.getDataType() == DataType.CHAR) {
            return new CoordinateAxis1DTime(ncd, org, errMessages, org.getDimension(0).getShortName());
        }
        if (org.getDataType() == DataType.STRING) {
            return new CoordinateAxis1DTime(ncd, org, errMessages, org.getDimensionsString());
        }
        return new CoordinateAxis1DTime(ncd, org, errMessages);
    }

    @Override
    protected Variable copy() {
        return new CoordinateAxis1DTime(this.ncd, this);
    }

    private CoordinateAxis1DTime(NetcdfDataset ncd, CoordinateAxis1DTime org) {
        super(ncd, org);
        this.helper = org.helper;
        this.cdates = org.cdates;
    }

    @Override
    public CoordinateAxis1DTime section(Range r) throws InvalidRangeException {
        CoordinateAxis1DTime s = (CoordinateAxis1DTime)super.section(r);
        List<CalendarDate> cdates = this.getCalendarDates();
        ArrayList<CalendarDate> cdateSection = new ArrayList<CalendarDate>(cdates.size());
        for (int idx : r) {
            cdateSection.add(cdates.get(idx));
        }
        s.cdates = cdateSection;
        return s;
    }

    public CalendarDate getCalendarDate(int idx) {
        List<CalendarDate> cdates = this.getCalendarDates();
        return cdates.get(idx);
    }

    public CalendarDateRange getCalendarDateRange() {
        List<CalendarDate> cd = this.getCalendarDates();
        int last = cd.size();
        return last > 0 ? CalendarDateRange.of(cd.get(0), cd.get(last - 1)) : null;
    }

    @Override
    public List<NamedObject> getNames() {
        List<CalendarDate> cdates = this.getCalendarDates();
        ArrayList<NamedObject> names = new ArrayList<NamedObject>(cdates.size());
        for (CalendarDate cd : cdates) {
            names.add(new NamedAnything(CalendarDateFormatter.toDateTimeStringISO(cd), this.getShortName()));
        }
        return names;
    }

    public TimeUnit getTimeResolution() throws Exception {
        String tUnits = this.getUnitsString();
        StringTokenizer stoker = new StringTokenizer(tUnits);
        double tResolution = this.getIncrement();
        return new TimeUnit(tResolution, stoker.nextToken());
    }

    public int findTimeIndexFromCalendarDate(CalendarDate d) {
        int index;
        List<CalendarDate> cdates = this.getCalendarDates();
        for (index = 0; index < cdates.size() && d.compareTo(cdates.get(index)) >= 0; ++index) {
        }
        return Math.max(0, index - 1);
    }

    public boolean hasCalendarDate(CalendarDate date) {
        List<CalendarDate> cdates = this.getCalendarDates();
        for (CalendarDate cd : cdates) {
            if (!date.equals(cd)) continue;
            return true;
        }
        return false;
    }

    public List<CalendarDate> getCalendarDates() {
        return this.cdates;
    }

    public CalendarDate[] getCoordBoundsDate(int i) {
        double[] intv = this.getCoordBounds(i);
        CalendarDate[] e = new CalendarDate[]{this.helper.makeCalendarDateFromOffset(intv[0]), this.helper.makeCalendarDateFromOffset(intv[1])};
        return e;
    }

    public CalendarDate getCoordBoundsMidpointDate(int i) {
        double[] intv = this.getCoordBounds(i);
        double midpoint = (intv[0] + intv[1]) / 2.0;
        return this.helper.makeCalendarDateFromOffset(midpoint);
    }

    private CoordinateAxis1DTime(NetcdfDataset ncd, VariableDS org, Formatter errMessages, String dims) throws IOException {
        super(ncd, org.getParentGroup(), org.getShortName(), DataType.STRING, dims, org.getUnitsString(), org.getDescription());
        this.orgVar = org;
        this.orgName = org.orgName;
        this.helper = new CoordinateAxisTimeHelper(this.getCalendarFromAttribute(), null);
        this.cdates = org.getDataType() == DataType.CHAR ? this.makeTimesFromChar(org, errMessages) : this.makeTimesFromStrings(org, errMessages);
        List<Attribute> atts = org.getAttributes();
        for (Attribute att : atts) {
            this.addAttribute(att);
        }
    }

    private List<CalendarDate> makeTimesFromChar(VariableDS org, Formatter errMessages) throws IOException {
        int ncoords = (int)org.getSize();
        int rank = org.getRank();
        int strlen = org.getShape(rank - 1);
        ArrayList<CalendarDate> result = new ArrayList<CalendarDate>(ncoords /= strlen);
        ArrayChar data = (ArrayChar)org.read();
        ArrayChar.StringIterator ii = data.getStringIterator();
        ArrayObject.D1 sdata = (ArrayObject.D1)Array.factory(DataType.STRING, new int[]{ncoords});
        for (int i = 0; i < ncoords; ++i) {
            String coordValue = ii.next();
            CalendarDate cd = this.makeCalendarDateFromStringCoord(coordValue, org, errMessages);
            sdata.set(i, coordValue);
            result.add(cd);
        }
        this.setCachedData(sdata, true);
        return result;
    }

    private List<CalendarDate> makeTimesFromStrings(VariableDS org, Formatter errMessages) throws IOException {
        int ncoords = (int)org.getSize();
        ArrayList<CalendarDate> result = new ArrayList<CalendarDate>(ncoords);
        ArrayObject data = (ArrayObject)org.read();
        IndexIterator ii = data.getIndexIterator();
        for (int i = 0; i < ncoords; ++i) {
            String coordValue = (String)ii.getObjectNext();
            CalendarDate cd = this.makeCalendarDateFromStringCoord(coordValue, org, errMessages);
            result.add(cd);
        }
        return result;
    }

    private CalendarDate makeCalendarDateFromStringCoord(String coordValue, VariableDS org, Formatter errMessages) throws IOException {
        CalendarDate cd = this.helper.makeCalendarDateFromOffset(coordValue);
        if (cd == null) {
            if (errMessages != null) {
                errMessages.format("String time coordinate must be ISO formatted= %s%n", coordValue);
                logger.info("Char time coordinate must be ISO formatted= {} file = {}", (Object)coordValue, (Object)org.getDatasetLocation());
            }
            throw new IllegalArgumentException();
        }
        return cd;
    }

    private CoordinateAxis1DTime(NetcdfDataset ncd, VariableDS org, Formatter errMessages) throws IOException {
        super(ncd, org);
        this.helper = new CoordinateAxisTimeHelper(this.getCalendarFromAttribute(), this.getUnitsString());
        int ncoords = (int)org.getSize();
        ArrayList<CalendarDate> result = new ArrayList<CalendarDate>(ncoords);
        Array data = org.read();
        int count = 0;
        IndexIterator ii = data.getIndexIterator();
        for (int i = 0; i < ncoords; ++i) {
            double val = ii.getDoubleNext();
            if (Double.isNaN(val)) continue;
            result.add(this.helper.makeCalendarDateFromOffset(val));
            ++count;
        }
        if (count != ncoords) {
            Dimension localDim = new Dimension(this.getShortName(), count, false);
            this.setDimension(0, localDim);
            Array shortData = Array.factory(data.getDataType(), new int[]{count});
            Index ima = shortData.getIndex();
            int count2 = 0;
            ii = data.getIndexIterator();
            for (int i = 0; i < ncoords; ++i) {
                double val = ii.getDoubleNext();
                if (Double.isNaN(val)) continue;
                shortData.setDouble(ima.set0(count2), val);
                ++count2;
            }
            this.cache = new Variable.Cache();
            this.setCachedData(shortData, true);
        }
        this.cdates = result;
    }

    public Date[] getTimeDates() {
        List<CalendarDate> cdates = this.getCalendarDates();
        Date[] timeDates = new Date[cdates.size()];
        int index = 0;
        for (CalendarDate cd : cdates) {
            timeDates[index++] = cd.toDate();
        }
        return timeDates;
    }

    public Date getTimeDate(int idx) {
        return this.getCalendarDate(idx).toDate();
    }

    public DateRange getDateRange() {
        CalendarDateRange cdr = this.getCalendarDateRange();
        return cdr.toDateRange();
    }

    public int findTimeIndexFromDate(Date d) {
        return this.findTimeIndexFromCalendarDate(CalendarDate.of(d));
    }

    public boolean hasTime(Date date) {
        List<CalendarDate> cdates = this.getCalendarDates();
        for (CalendarDate cd : cdates) {
            if (!date.equals(cd.toDate())) continue;
            return true;
        }
        return false;
    }
}

