/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.EarthLocation;

public class WriterCFProfileCollection
extends CFPointWriter {
    private static final String profileDimName = "profile";
    private static final String idName = "profileId";
    private static final String profileIndexName = "profileIndex";
    private static final String zName = "z";
    private static final boolean debug = false;
    private int name_strlen = 1;
    private HashMap<String, Integer> profileMap;
    private int recno = 0;
    private ArrayDouble.D1 timeArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 latArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 lonArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 altArray = new ArrayDouble.D1(1);
    private ArrayInt.D1 parentArray = new ArrayInt.D1(1);
    private int[] origin = new int[1];

    public WriterCFProfileCollection(String fileOut, List<Attribute> atts) throws IOException {
        super(fileOut, atts);
        this.ncfile.addGlobalAttribute("featureType", CF.FeatureType.profile.name());
    }

    public void writeHeader(List<String> profileNames, List<VariableSimpleIF> dataVars, DateUnit timeUnit, String altUnits) throws IOException {
        this.altUnits = altUnits;
        this.createProfiles(profileNames);
        this.createObsVariables(timeUnit);
        this.createDataVariables(dataVars);
        this.ncfile.create();
        System.out.printf("%s%n", this.ncfile);
        this.writeProfileData(profileNames);
        if (!((Boolean)this.ncfile.sendIospMessage("AddRecordStructure")).booleanValue()) {
            throw new IllegalStateException("can't add record variable");
        }
    }

    private void createProfiles(List<String> profileNames) throws IOException {
        int nprofiles = profileNames.size();
        for (String name : profileNames) {
            this.name_strlen = Math.max(this.name_strlen, name.length());
        }
        this.ncfile.addUnlimitedDimension("obs");
        ArrayList<Dimension> profileDims = new ArrayList<Dimension>(1);
        Dimension profileDim = this.ncfile.addDimension(profileDimName, nprofiles);
        profileDims.add(profileDim);
        Variable v = this.ncfile.addStringVariable(idName, profileDims, this.name_strlen);
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "profile identifier"));
        this.ncfile.addVariableAttribute(v, new Attribute("cf_role", "profile_id"));
        v = this.ncfile.addVariable("latitude", DataType.DOUBLE, profileDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("units", "degrees_north"));
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "profile latitude"));
        v = this.ncfile.addVariable("longitude", DataType.DOUBLE, profileDimName);
        this.ncfile.addVariableAttribute(v, new Attribute("units", "degrees_east"));
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "profile longitude"));
        if (this.altUnits != null) {
            v = this.ncfile.addVariable("altitude", DataType.DOUBLE, profileDimName);
            this.ncfile.addVariableAttribute(v, new Attribute("units", this.altUnits));
            this.ncfile.addVariableAttribute(v, new Attribute("long_name", "profile altitude"));
        }
    }

    private void createObsVariables(DateUnit timeUnit) throws IOException {
        Variable timeVar = this.ncfile.addVariable("time", DataType.DOUBLE, "obs");
        this.ncfile.addVariableAttribute(timeVar, new Attribute("units", timeUnit.getUnitsString()));
        this.ncfile.addVariableAttribute(timeVar, new Attribute("long_name", "time of measurement"));
        Variable v = this.ncfile.addVariable(profileIndexName, DataType.INT, "obs");
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "profile index for this observation record"));
        this.ncfile.addVariableAttribute(v, new Attribute("instance_dimension", profileDimName));
    }

    private void createDataVariables(List<VariableSimpleIF> dataVars) throws IOException {
        String coordNames = "latitude longitude time";
        if (this.altUnits != null) {
            coordNames = coordNames + " altitude";
        }
        ArrayList<VariableSimpleIF> useDataVars = new ArrayList<VariableSimpleIF>(dataVars.size());
        for (VariableSimpleIF var : dataVars) {
            if (this.ncfile.findVariable(var.getShortName()) != null) continue;
            useDataVars.add(var);
        }
        for (VariableSimpleIF oldVar : useDataVars) {
            Variable newVar = this.ncfile.addVariable(oldVar.getShortName(), oldVar.getDataType(), "obs");
            List<Attribute> atts = oldVar.getAttributes();
            for (Attribute att : atts) {
                newVar.addAttribute(att);
            }
            newVar.addAttribute(new Attribute("coordinates", coordNames));
        }
    }

    private void writeProfileData(List<String> profiles) throws IOException {
        int nprofiles = profiles.size();
        this.profileMap = new HashMap(2 * nprofiles);
        ArrayObject.D1 idArray = new ArrayObject.D1(String.class, nprofiles);
        for (int i = 0; i < profiles.size(); ++i) {
            String name = profiles.get(i);
            this.profileMap.put(name, i);
            idArray.set(i, name);
        }
        try {
            this.ncfile.writeStringData(idName, idArray);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public void writeRecord(String profileName, PointFeature sobs, StructureData sdata) throws IOException {
        this.writeRecord(profileName, sobs.getObservationTime(), sobs.getObservationTimeAsCalendarDate(), sobs.getLocation(), sdata);
    }

    public void writeRecord(String profileName, double timeCoordValue, CalendarDate obsDate, EarthLocation loc, StructureData sdata) throws IOException {
        this.trackBB(loc, obsDate);
        Integer parentIndex = this.profileMap.get(profileName);
        if (parentIndex == null) {
            throw new RuntimeException("Cant find profile " + profileName);
        }
        ArrayStructureW sArray = new ArrayStructureW(sdata.getStructureMembers(), new int[]{1});
        sArray.setStructureData(sdata, 0);
        this.timeArray.set(0, timeCoordValue);
        this.latArray.set(0, loc.getLatitude());
        this.lonArray.set(0, loc.getLongitude());
        this.altArray.set(0, loc.getAltitude());
        this.parentArray.set(0, (int)parentIndex);
        this.origin[0] = this.recno++;
        try {
            this.ncfile.write("record", this.origin, sArray);
            this.ncfile.write("time", this.origin, this.timeArray);
            this.ncfile.write(profileIndexName, this.origin, this.parentArray);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }
}

