/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class NcStreamIosp
extends AbstractIOServiceProvider {
    private static final boolean debug = false;

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        if (!this.readAndTest(raf, NcStream.MAGIC_START)) {
            return false;
        }
        byte[] b = new byte[4];
        raf.read(b);
        return this.test(b, NcStream.MAGIC_HEADER) || this.test(b, NcStream.MAGIC_DATA);
    }

    @Override
    public String getFileTypeId() {
        return "ncstream";
    }

    @Override
    public String getFileTypeDescription() {
        return "netCDF streaming protocol";
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        try {
            this.raf = raf;
            raf.seek(0L);
            if (!this.readAndTest(raf, NcStream.MAGIC_START)) {
                throw new IOException("Data corrupted on " + ncfile.getLocation());
            }
            if (!this.readAndTest(raf, NcStream.MAGIC_HEADER)) {
                throw new IOException("Data corrupted on " + ncfile.getLocation());
            }
            int msize = this.readVInt(raf);
            byte[] m = new byte[msize];
            raf.read(m);
            NcStreamProto.Header proto = NcStreamProto.Header.parseFrom(m);
            NcStreamProto.Group root = proto.getRoot();
            NcStream.readGroup(root, ncfile, ncfile.getRootGroup());
            ncfile.finish();
            while (!raf.isAtEndOfFile()) {
                byte[] b = new byte[4];
                raf.read(b);
                if (!this.test(b, NcStream.MAGIC_END)) {
                    if (!this.test(b, NcStream.MAGIC_DATA)) {
                        throw new IllegalStateException("bad format");
                    }
                    int psize = this.readVInt(raf);
                    byte[] dp = new byte[psize];
                    raf.read(dp);
                    NcStreamProto.Data dproto = NcStreamProto.Data.parseFrom(dp);
                    int dsize = this.readVInt(raf);
                    DataSection dataSection = new DataSection();
                    dataSection.size = dsize;
                    dataSection.filePos = raf.getFilePointer();
                    dataSection.section = NcStream.decodeSection(dproto.getSection());
                    Variable v = ncfile.getRootGroup().findVariable(dproto.getVarName());
                    v.setSPobject(dataSection);
                    raf.skipBytes(dsize);
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("NcStreamIosp: " + t.getMessage(), t);
        }
    }

    @Override
    public Array readData(Variable v, Section section) throws IOException, InvalidRangeException {
        DataSection dataSection = (DataSection)v.getSPobject();
        this.raf.seek(dataSection.filePos);
        byte[] data = new byte[dataSection.size];
        this.raf.read(data);
        Array dataArray = Array.factory(v.getDataType(), v.getShape(), ByteBuffer.wrap(data));
        return dataArray.section(section.getRanges());
    }

    private int readVInt(RandomAccessFile raf) throws IOException {
        byte b = (byte)raf.read();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = (byte)raf.read();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    private boolean readAndTest(RandomAccessFile raf, byte[] test) throws IOException {
        byte[] b = new byte[test.length];
        raf.read(b);
        return this.test(b, test);
    }

    private boolean test(byte[] bread, byte[] test) throws IOException {
        if (bread.length != test.length) {
            return false;
        }
        for (int i = 0; i < bread.length; ++i) {
            if (bread[i] == test[i]) continue;
            return false;
        }
        return true;
    }

    public List<NcsMess> open(RandomAccessFile raf, NetcdfFile ncfile) throws IOException {
        this.raf = raf;
        raf.seek(0L);
        if (!this.readAndTest(raf, NcStream.MAGIC_START)) {
            throw new IOException("Data corrupted on " + ncfile.getLocation());
        }
        if (!this.readAndTest(raf, NcStream.MAGIC_HEADER)) {
            throw new IOException("Data corrupted on " + ncfile.getLocation());
        }
        int msize = this.readVInt(raf);
        byte[] m = new byte[msize];
        raf.read(m);
        NcStreamProto.Header proto = NcStreamProto.Header.parseFrom(m);
        NcStreamProto.Group root = proto.getRoot();
        NcStream.readGroup(root, ncfile, ncfile.getRootGroup());
        ncfile.finish();
        ArrayList<NcsMess> ncm = new ArrayList<NcsMess>();
        ncm.add(new NcsMess(msize, proto));
        while (!raf.isAtEndOfFile()) {
            byte[] b = new byte[4];
            raf.read(b);
            if (this.test(b, NcStream.MAGIC_END)) break;
            if (!this.test(b, NcStream.MAGIC_DATA)) {
                System.out.println("HEY");
            }
            int psize = this.readVInt(raf);
            byte[] dp = new byte[psize];
            raf.read(dp);
            NcStreamProto.Data dproto = NcStreamProto.Data.parseFrom(dp);
            ncm.add(new NcsMess(psize, dproto));
            int dsize = this.readVInt(raf);
            if (dsize == 1) {
                System.out.println("HEY");
            }
            DataSection dataSection = new DataSection();
            dataSection.size = dsize;
            dataSection.filePos = raf.getFilePointer();
            dataSection.section = NcStream.decodeSection(dproto.getSection());
            ncm.add(new NcsMess(dsize, dataSection));
            Variable v = ncfile.getRootGroup().findVariable(dproto.getVarName());
            v.setSPobject(dataSection);
            raf.skipBytes(dsize);
        }
        return ncm;
    }

    public static class NcsMess {
        public int len;
        public Object what;

        public NcsMess(int len, Object what) {
            this.len = len;
            this.what = what;
        }
    }

    private class DataSection {
        int size;
        long filePos;
        Section section;

        private DataSection() {
        }

        public String toString() {
            return "DataSection{size=" + this.size + ", filePos=" + this.filePos + ", section=" + this.section + '}';
        }
    }
}

