/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.HashMap;
import ucar.nc2.util.log.LogStream;

public class URLStreamHandlerFactory
implements java.net.URLStreamHandlerFactory {
    private static HashMap hash = new HashMap();
    private static boolean installed = false;

    public static void install() {
        try {
            if (!installed) {
                URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory());
                installed = true;
            }
        }
        catch (Error e) {
            LogStream.out.println("Error installing URLStreamHandlerFactory " + e.getMessage());
        }
    }

    public static void register(String protocol, URLStreamHandler sh) {
        hash.put(protocol.toLowerCase(), sh);
    }

    public static URL makeURL(String urlString) throws MalformedURLException {
        return installed ? new URL(urlString) : URLStreamHandlerFactory.makeURL(null, urlString);
    }

    public static URL makeURL(URL parent, String urlString) throws MalformedURLException {
        if (installed) {
            return new URL(parent, urlString);
        }
        try {
            URI uri = new URI(urlString);
            URLStreamHandler h = (URLStreamHandler)hash.get(uri.getScheme().toLowerCase());
            return new URL(parent, urlString, h);
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        return (URLStreamHandler)hash.get(protocol.toLowerCase());
    }
}

