/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.junit.Test;
import ucar.nc2.util.UnitTestCommon;
import ucar.nc2.util.net.EasySSLProtocolSocketFactory;
import ucar.nc2.util.net.HTTPAuthScheme;
import ucar.nc2.util.net.HTTPAuthStore;
import ucar.nc2.util.net.HTTPMethod;
import ucar.nc2.util.net.HTTPSSLProvider;
import ucar.nc2.util.net.HTTPSession;

public class TestAuth
extends UnitTestCommon {
    static boolean motherlode = false;
    static final String KEYDIR = "/cdm/src/test/resources";
    static final String CLIENTKEY = "clientkey.jks";
    static final String CLIENTPWD = "changeit";
    static final boolean MUSTFAIL = true;
    static final boolean MUSTPASS = false;
    int passcount = 0;
    int xfailcount = 0;
    int failcount = 0;
    boolean verbose = true;
    boolean pass = false;
    String datadir = null;
    String threddsroot = null;
    static AuthDataBasic[] basictests;

    public TestAuth(String name, String testdir) {
        super(name);
        this.setTitle("DAP Authorization tests");
    }

    public TestAuth(String name) {
        this(name, null);
    }

    public TestAuth() {
        this("TestAuth", null);
    }

    @Test
    public void testSSH() throws Exception {
        String[] sshurls = new String[]{"https://motherlode.ucar.edu:8444/dts/b31.dds"};
        System.out.println("*** Testing: Simple Https");
        for (String url : sshurls) {
            System.out.println("*** URL: " + url);
            HTTPSession session = new HTTPSession(url);
            HTTPMethod method = HTTPMethod.Get((HTTPSession)session);
            int status = method.execute();
            System.out.printf("\tstatus code = %d\n", status);
            this.pass = status == 200;
            TestAuth.assertTrue((String)"testSSH", (boolean)this.pass);
        }
    }

    @Test
    public void testBasic() throws Exception {
        System.out.println("*** Testing: Http Basic Password Authorization");
        for (AuthDataBasic data : basictests) {
            String msg;
            BasicProvider provider = new BasicProvider(data.user, data.password);
            System.out.println("*** URL: " + data.url);
            HTTPSession session = new HTTPSession(data.url);
            session.setCredentialsProvider((CredentialsProvider)provider);
            HTTPMethod method = HTTPMethod.Get((HTTPSession)session);
            int status = method.execute();
            System.out.printf("\tlocal provider: status code = %d\n", status);
            System.out.flush();
            boolean bl = this.pass = status == 200 || status == 404;
            if (data.xfail) {
                msg = this.pass ? "Local test failed to fail (xfail)" : "Local test passed (xfail)";
                this.pass = !this.pass;
            } else {
                msg = this.pass ? "Local test passed" : "Local test failed";
            }
            System.out.println("\t" + msg);
            if (this.pass) {
                HTTPSession.setGlobalCredentialsProvider((CredentialsProvider)provider);
                session = new HTTPSession(data.url);
                method = HTTPMethod.Get((HTTPSession)session);
                status = method.execute();
                System.out.printf("\tglobal provider test: status code = %d\n", status);
                System.out.flush();
                boolean bl2 = this.pass = status == 200 || status == 404;
                if (data.xfail) {
                    msg = this.pass ? "Local test failed to fail (xfail)" : "Local test passed (xfail)";
                    this.pass = !this.pass;
                } else {
                    msg = this.pass ? "Local test passed" : "Local test failed";
                }
                System.out.println("\t" + msg);
            }
            if (this.pass) {
                TestAuth.assertTrue((String)"testBasic", (boolean)true);
                continue;
            }
            TestAuth.assertTrue((String)"testBasic", (boolean)false);
        }
    }

    @Test
    public void testBasic2() throws Exception {
        System.out.println("*** Testing: Http Basic Password Authorization Using direct credentials");
        for (AuthDataBasic data : basictests) {
            String msg;
            UsernamePasswordCredentials cred = new UsernamePasswordCredentials(data.user, data.password);
            System.out.println("*** URL: " + data.url);
            HTTPSession session = new HTTPSession(data.url);
            session.setCredentials(HTTPAuthScheme.BASIC, (Credentials)cred);
            HTTPMethod method = HTTPMethod.Get((HTTPSession)session);
            int status = method.execute();
            System.out.printf("\tlocal provider: status code = %d\n", status);
            System.out.flush();
            boolean bl = this.pass = status == 200 || status == 404;
            if (data.xfail) {
                msg = this.pass ? "Local test failed to fail (xfail)" : "Local test passed (xfail)";
                this.pass = !this.pass;
            } else {
                msg = this.pass ? "Local test passed" : "Local test failed";
            }
            System.out.println("\t" + msg);
            if (this.pass) {
                HTTPSession.setGlobalCredentials((HTTPAuthScheme)HTTPAuthScheme.BASIC, (Credentials)cred);
                session = new HTTPSession(data.url);
                method = HTTPMethod.Get((HTTPSession)session);
                status = method.execute();
                System.out.printf("\tglobal provider test: status code = %d\n", status);
                System.out.flush();
                boolean bl2 = this.pass = status == 200 || status == 404;
                if (data.xfail) {
                    msg = this.pass ? "Local test failed to fail (xfail)" : "Local test passed (xfail)";
                    this.pass = !this.pass;
                } else {
                    msg = this.pass ? "Local test passed" : "Local test failed";
                }
                System.out.println("\t" + msg);
            }
            if (this.pass) {
                TestAuth.assertTrue((String)"testBasic", (boolean)true);
                continue;
            }
            TestAuth.assertTrue((String)"testBasic", (boolean)false);
        }
    }

    @Test
    public void testKeystore() throws Exception {
    }

    @Test
    public void testSerialize() throws Exception {
        System.out.println("*** Testing: HTTPAuthStore (de-)serialization");
        boolean ok = true;
        BasicProvider creds1 = new BasicProvider("p1", "pwd");
        HTTPSSLProvider creds2 = new HTTPSSLProvider("keystore", "keystorepwd");
        BasicProvider creds3 = new BasicProvider("p3", "pwd3");
        HTTPAuthStore.clear();
        HTTPAuthStore.insert((HTTPAuthStore.Entry)new HTTPAuthStore.Entry(HTTPAuthScheme.BASIC, "http://ceda.ac.uk/dap/neodc/casix/seawifs_plankton/data/monthly/PSC_monthly_1998.nc.dds", (CredentialsProvider)creds1));
        HTTPAuthStore.insert((HTTPAuthStore.Entry)new HTTPAuthStore.Entry(HTTPAuthScheme.SSL, "http://ceda.ac.uk", (CredentialsProvider)creds2));
        HTTPAuthStore.insert((HTTPAuthStore.Entry)new HTTPAuthStore.Entry(HTTPAuthScheme.BASIC, "http://ceda.ac.uk", (CredentialsProvider)creds3));
        File target1 = new File("./serial1");
        target1.delete();
        FileOutputStream ostream = new FileOutputStream(target1);
        HTTPAuthStore.serialize((OutputStream)ostream, (String)"password1");
        FileInputStream istream = new FileInputStream(target1);
        List entries = HTTPAuthStore.getDeserializedEntries((InputStream)istream, (String)"password1");
        List rows = HTTPAuthStore.getAllRows();
        for (HTTPAuthStore.Entry row : rows) {
            HTTPAuthStore.Entry match = null;
            for (HTTPAuthStore.Entry e : entries) {
                if (!HTTPAuthStore.Entry.identical((HTTPAuthStore.Entry)row, (HTTPAuthStore.Entry)e)) continue;
                if (match == null) {
                    match = e;
                    continue;
                }
                System.out.println("ambigous match");
                ok = false;
            }
            if (match != null) continue;
            System.out.println("no match for: " + row.toString());
            ok = false;
        }
        TestAuth.assertTrue((String)"test(De-)Serialize", (boolean)ok);
    }

    @Test
    public void testFirewall() throws Exception {
        Object user = null;
        Object pwd = null;
        Object host = null;
        int port = -1;
        Object url = null;
        System.out.println("*** Testing: Http Firewall Proxy (with authentication)");
        TestAuth.assertTrue((String)"testProxy", (boolean)true);
    }

    static {
        HTTPSession.registerProtocol((String)"https", (int)8843, (Protocol)new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 8843));
        basictests = new AuthDataBasic[]{new AuthDataBasic("http://motherlode.ucar.edu:8080/thredds/dodsC/restrict/testdata/testData.nc.html", "tiggeUser", "tigge", false), new AuthDataBasic("http://motherlode.ucar.edu:8080/thredds/dodsC/restrict/testdata/testData.nc.html", "", "", true)};
    }

    static class AuthDataBasic {
        String url;
        String user = null;
        String password = null;
        boolean xfail = false;

        public AuthDataBasic(String url, String usr, String pwd, boolean xfail) {
            this.url = url;
            this.user = usr;
            this.password = pwd;
            this.xfail = xfail;
        }
    }

    static class BasicProvider
    implements CredentialsProvider,
    Serializable {
        String username = null;
        String password = null;

        public BasicProvider(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public Credentials getCredentials(AuthScheme authscheme, String host, int port, boolean isproxy) throws CredentialsNotAvailableException {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.username, this.password);
            System.out.printf("getCredentials called: creds=|%s| host=%s port=%d isproxy=%b authscheme=%s%n", creds.toString(), host, port, isproxy, authscheme);
            return creds;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeObject(this.username);
            oos.writeObject(this.password);
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            this.username = (String)ois.readObject();
            this.password = (String)ois.readObject();
        }
    }
}

