/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.test.util;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.junit.Assert;

public class TestFileDirUtils {
    private TestFileDirUtils() {
    }

    public static File createTempDirectory(String prefix, File directory) {
        return TestFileDirUtils.createTempDirectory(prefix, directory, -1L);
    }

    public static File createTempDirectory(String prefix, File directory, long lastModTime) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix may not be null.");
        }
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("Prefix must be at least three characters.");
        }
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException("Given directory [" + directory.getPath() + "] must exist and be a directory.");
        }
        File newDir = null;
        Random rand = new Random();
        boolean success = false;
        for (int numTries = 0; numTries < 5; ++numTries) {
            newDir = new File(directory, prefix + "." + rand.nextInt(1000000));
            if (!newDir.mkdir()) continue;
            success = true;
            break;
        }
        if (!success) {
            return null;
        }
        if (lastModTime > 0L) {
            Assert.assertTrue((String)("Failed to set lastModified time on directory [" + newDir.getPath() + "]."), (boolean)newDir.setLastModified(lastModTime));
        }
        newDir.deleteOnExit();
        return newDir;
    }

    public static File createDirectory(String dirPath) {
        return TestFileDirUtils.createDirectory(dirPath, -1L);
    }

    public static File createDirectory(String dirPath, long lastModTime) {
        File dirFile = new File(dirPath);
        Assert.assertFalse((String)("Directory [" + dirFile.getAbsolutePath() + "] already exists."), (boolean)dirFile.exists());
        Assert.assertTrue((String)("Failed to make directory [" + dirFile.getAbsolutePath() + "]."), (boolean)dirFile.mkdirs());
        if (lastModTime > 0L) {
            Assert.assertTrue((String)("Failed to set lastModified time on directory [" + dirFile.getPath() + "]."), (boolean)dirFile.setLastModified(lastModTime));
        }
        return dirFile;
    }

    public static File addDirectory(File parentDir, String dirName) {
        return TestFileDirUtils.addDirectory(parentDir, dirName, -1L);
    }

    public static File addDirectory(File parentDir, String dirName, long lastModTime) {
        Assert.assertTrue((String)("Parent file does not exist <" + parentDir.getPath() + ">."), (boolean)parentDir.exists());
        Assert.assertTrue((String)("Parent file not a directory <" + parentDir.getPath() + ">."), (boolean)parentDir.isDirectory());
        File newDir = new File(parentDir, dirName);
        Assert.assertFalse((String)("New directory already exists [" + newDir.getPath() + "]."), (boolean)newDir.exists());
        Assert.assertTrue((String)("Failed to create the new directory [" + newDir.getAbsolutePath() + "]."), (boolean)newDir.mkdirs());
        if (lastModTime > 0L) {
            Assert.assertTrue((String)("Failed to set lastModified time on directory [" + newDir.getPath() + "]."), (boolean)newDir.setLastModified(lastModTime));
        }
        return newDir;
    }

    public static File addFile(File parentDir, String fileName) {
        return TestFileDirUtils.addFile(parentDir, fileName, -1L);
    }

    public static File addFile(File parentDir, String fileName, long lastModTime) {
        Assert.assertTrue((String)("Parent file does not exist <" + parentDir.getPath() + ">."), (boolean)parentDir.exists());
        Assert.assertTrue((String)("Parent file not a directory <" + parentDir.getPath() + ">."), (boolean)parentDir.isDirectory());
        File newFile = new File(parentDir, fileName);
        Assert.assertFalse((String)("New file [" + newFile.getAbsolutePath() + "] already exists."), (boolean)newFile.exists());
        Assert.assertTrue((String)("Multiple levels not allowed in file name <" + fileName + ">."), (boolean)newFile.getParentFile().equals(parentDir));
        try {
            Assert.assertTrue((String)("Failed to create new file [" + newFile.getAbsolutePath() + "]."), (boolean)newFile.createNewFile());
        }
        catch (IOException e) {
            Assert.fail((String)("Failed to create new file <" + newFile.getAbsolutePath() + ">: " + e.getMessage()));
        }
        if (lastModTime > 0L) {
            Assert.assertTrue((String)("Failed to set lastModified time on file [" + newFile.getPath() + "]."), (boolean)newFile.setLastModified(lastModTime));
        }
        return newFile;
    }

    public static boolean deleteDirectoryAndContent(File directory) {
        if (!directory.exists()) {
            return false;
        }
        if (!directory.isDirectory()) {
            return false;
        }
        boolean removeAll = true;
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File curFile = files[i];
            if (curFile.isDirectory()) {
                removeAll &= TestFileDirUtils.deleteDirectoryAndContent(curFile);
                continue;
            }
            if (curFile.delete()) continue;
            System.out.println("**ERROR: Failed to delete file <" + curFile.getAbsolutePath() + ">");
            removeAll = false;
        }
        if (!directory.delete()) {
            System.out.println("**ERROR: Failed to delete directory <" + directory.getAbsolutePath() + ">");
            removeAll = false;
        }
        return removeAll;
    }
}

