/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.EarthLocation;

public class WriterCFPointCollection
extends CFPointWriter {
    private int recno = 0;
    private ArrayDouble.D1 timeArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 latArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 lonArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 altArray = new ArrayDouble.D1(1);
    private int[] origin = new int[1];

    public WriterCFPointCollection(String fileOut, String title) throws IOException {
        this(fileOut, Arrays.asList(new Attribute("title", title)));
    }

    public WriterCFPointCollection(String fileOut, List<Attribute> atts) throws IOException {
        super(fileOut, atts);
        this.ncfile.addGlobalAttribute("featureType", CF.FeatureType.point.name());
    }

    public void writeHeader(List<VariableSimpleIF> vars, DateUnit timeUnit, String altUnits) throws IOException {
        this.altUnits = altUnits;
        this.createCoordinates(timeUnit);
        this.createDataVariables(vars);
        this.ncfile.create();
        if (!((Boolean)this.ncfile.sendIospMessage("AddRecordStructure")).booleanValue()) {
            throw new IllegalStateException("can't add record variable");
        }
    }

    private void createCoordinates(DateUnit timeUnit) throws IOException {
        this.ncfile.addUnlimitedDimension("obs");
        Variable timeVar = this.ncfile.addVariable("time", DataType.DOUBLE, "obs");
        this.ncfile.addVariableAttribute(timeVar, new Attribute("units", timeUnit.getUnitsString()));
        this.ncfile.addVariableAttribute(timeVar, new Attribute("long_name", "time of measurement"));
        Variable v = this.ncfile.addVariable("latitude", DataType.DOUBLE, "obs");
        this.ncfile.addVariableAttribute(v, new Attribute("units", "degrees_north"));
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station latitude"));
        v = this.ncfile.addVariable("longitude", DataType.DOUBLE, "obs");
        this.ncfile.addVariableAttribute(v, new Attribute("units", "degrees_east"));
        this.ncfile.addVariableAttribute(v, new Attribute("long_name", "station longitude"));
        if (this.altUnits != null) {
            v = this.ncfile.addVariable("altitude", DataType.DOUBLE, "obs");
            this.ncfile.addVariableAttribute(v, new Attribute("units", this.altUnits));
            this.ncfile.addVariableAttribute(v, new Attribute("long_name", "altitude"));
        }
    }

    private void createDataVariables(List<VariableSimpleIF> dataVars) throws IOException {
        List<Dimension> dims;
        String coordNames = "time latitude longitude";
        if (this.altUnits != null) {
            coordNames = coordNames + " " + "altitude";
        }
        for (VariableSimpleIF var : dataVars) {
            dims = var.getDimensions();
            this.dimSet.addAll(dims);
        }
        for (Dimension d : this.dimSet) {
            if (d.isUnlimited()) continue;
            this.ncfile.addDimension(d.getName(), d.getLength(), d.isShared(), false, d.isVariableLength());
        }
        for (VariableSimpleIF oldVar : dataVars) {
            dims = oldVar.getDimensions();
            StringBuilder dimNames = new StringBuilder("obs");
            for (Dimension d : dims) {
                if (d.isUnlimited()) continue;
                dimNames.append(" ").append(d.getName());
            }
            Variable newVar = this.ncfile.addVariable(oldVar.getShortName(), oldVar.getDataType(), dimNames.toString());
            List<Attribute> atts = oldVar.getAttributes();
            for (Attribute att : atts) {
                newVar.addAttribute(att);
            }
            newVar.addAttribute(new Attribute("coordinates", coordNames));
        }
    }

    public void writeRecord(PointFeature sobs, StructureData sdata) throws IOException {
        this.writeRecord(sobs.getObservationTime(), sobs.getObservationTimeAsCalendarDate(), sobs.getLocation(), sdata);
    }

    public void writeRecord(double timeCoordValue, CalendarDate obsDate, EarthLocation loc, StructureData sdata) throws IOException {
        this.trackBB(loc, obsDate);
        ArrayStructureW sArray = new ArrayStructureW(sdata.getStructureMembers(), new int[]{1});
        sArray.setStructureData(sdata, 0);
        this.timeArray.set(0, timeCoordValue);
        this.latArray.set(0, loc.getLatitude());
        this.lonArray.set(0, loc.getLongitude());
        if (this.altUnits != null) {
            this.altArray.set(0, loc.getAltitude());
        }
        this.origin[0] = this.recno;
        try {
            this.ncfile.write("record", this.origin, sArray);
            this.ncfile.write("time", this.origin, this.timeArray);
            this.ncfile.write("latitude", this.origin, this.latArray);
            this.ncfile.write("longitude", this.origin, this.lonArray);
            if (this.altUnits != null) {
                this.ncfile.write("altitude", this.origin, this.altArray);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        ++this.recno;
    }
}

