/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;

public class CompareNetcdf2 {
    private Formatter f;
    private boolean showCompare = false;
    private boolean showEach = false;
    private boolean compareData = false;
    private static final double TOL = 1.0E-5;
    private static final float TOLF = 1.0E-5f;

    public static void compareFiles(NetcdfFile org, NetcdfFile copy, Formatter f) {
        CompareNetcdf2.compareFiles(org, copy, f, false, false, false);
    }

    public static boolean compareFiles(NetcdfFile org, NetcdfFile copy, Formatter f, boolean _compareData, boolean _showCompare, boolean _showEach) {
        CompareNetcdf2 tc = new CompareNetcdf2(f, _showCompare, _showEach, _compareData);
        return tc.compare(org, copy);
    }

    public CompareNetcdf2() {
        this(new Formatter(System.out), false, false, false);
    }

    public CompareNetcdf2(Formatter f, boolean showCompare, boolean showEach, boolean compareData) {
        this.f = f;
        this.compareData = compareData;
        this.showCompare = showCompare;
        this.showEach = showEach;
    }

    public boolean compare(NetcdfFile org, NetcdfFile copy) {
        return this.compare(org, copy, this.showCompare, this.showEach, this.compareData);
    }

    public boolean compare(NetcdfFile org, NetcdfFile copy, boolean showCompare, boolean showEach, boolean compareData) {
        return this.compare(org, copy, null, showCompare, showEach, compareData);
    }

    public boolean compare(NetcdfFile org, NetcdfFile copy, ObjFilter filter, boolean showCompare, boolean showEach, boolean compareData) {
        this.compareData = compareData;
        this.showCompare = showCompare;
        this.showEach = showEach;
        this.f.format("First file = %s%n", org.getLocation());
        this.f.format("Second file= %s%n", copy.getLocation());
        long start = System.currentTimeMillis();
        boolean ok = this.compareGroups(org.getRootGroup(), copy.getRootGroup(), filter);
        this.f.format(" Files are the same = %s%n", ok);
        long took = System.currentTimeMillis() - start;
        this.f.format(" Time to compare = %d msecs%n", took);
        return ok;
    }

    public boolean compareVariables(NetcdfFile org, NetcdfFile copy) {
        Variable copyVar;
        this.f.format("Original = %s%n", org.getLocation());
        this.f.format("CompareTo= %s%n", copy.getLocation());
        boolean ok = true;
        for (Variable orgV : org.getVariables()) {
            List<Dimension> dims2;
            if (orgV.isCoordinateVariable()) continue;
            copyVar = copy.findVariable(orgV.getShortName());
            if (copyVar == null) {
                this.f.format(" MISSING '%s' in 2nd file%n", orgV.getFullName());
                ok = false;
                continue;
            }
            List<Dimension> dims1 = orgV.getDimensions();
            if (this.compare(dims1, dims2 = copyVar.getDimensions())) continue;
            this.f.format(" %s != %s%n", orgV.getNameAndDimensions(), copyVar.getNameAndDimensions());
        }
        this.f.format("%n", new Object[0]);
        for (Variable orgV : copy.getVariables()) {
            if (orgV.isCoordinateVariable() || (copyVar = org.findVariable(orgV.getShortName())) != null) continue;
            this.f.format(" MISSING '%s' in 1st file%n", orgV.getFullName());
            ok = false;
        }
        return ok;
    }

    private boolean compare(List<Dimension> dims1, List<Dimension> dims2) {
        if (dims1.size() != dims2.size()) {
            return false;
        }
        for (int i = 0; i < dims1.size(); ++i) {
            Dimension dim1 = dims1.get(i);
            Dimension dim2 = dims2.get(i);
            if (dim1.getLength() == dim2.getLength()) continue;
            return false;
        }
        return true;
    }

    private boolean compareGroups(Group org, Group copy, ObjFilter filter) {
        if (this.showCompare) {
            this.f.format("compare Group %s to %s %n", org.getName(), copy.getName());
        }
        boolean ok = true;
        if (!org.getName().equals(copy.getName())) {
            this.f.format(" ** names are different %s != %s %n", org.getName(), copy.getName());
            ok = false;
        }
        ok &= this.checkAll(org.getDimensions(), copy.getDimensions(), null);
        ok &= this.checkAttributes(null, org.getAttributes(), copy.getAttributes(), filter);
        ok &= this.checkEnums(org, copy);
        for (Variable orgV : org.getVariables()) {
            Variable copyVar = copy.findVariable(orgV.getShortName());
            if (copyVar == null) {
                this.f.format(" ** cant find variable %s in 2nd file%n", orgV.getFullName());
                ok = false;
                continue;
            }
            ok &= this.compareVariables(orgV, copyVar, filter, this.compareData, true);
        }
        for (Variable copyV : copy.getVariables()) {
            Variable orgV = org.findVariable(copyV.getShortName());
            if (orgV != null) continue;
            this.f.format(" ** cant find variable %s in 1st file%n", copyV.getFullName());
            ok = false;
        }
        ArrayList groups = new ArrayList();
        ok &= this.checkAll(org.getGroups(), copy.getGroups(), groups);
        for (int i = 0; i < groups.size(); i += 2) {
            Group orgGroup = (Group)groups.get(i);
            Group ncmlGroup = (Group)groups.get(i + 1);
            ok &= this.compareGroups(orgGroup, ncmlGroup, filter);
        }
        return ok;
    }

    public boolean compareVariable(Variable org, Variable copy) {
        return this.compareVariables(org, copy, null, this.compareData, true);
    }

    private boolean compareVariables(Variable org, Variable copy, ObjFilter filter, boolean compareData, boolean justOne) {
        boolean ok = true;
        if (this.showCompare) {
            this.f.format("compare Variable %s to %s %n", org.getFullName(), copy.getFullName());
        }
        if (!org.getFullName().equals(copy.getFullName())) {
            this.f.format(" ** names are different %s != %s %n", org.getFullName(), copy.getFullName());
            ok = false;
        }
        if (org.getDataType() != copy.getDataType()) {
            this.f.format(" ** dataTypes are different %s != %s %n", new Object[]{org.getDataType(), copy.getDataType()});
            ok = false;
        }
        ok &= this.checkAll(org.getDimensions(), copy.getDimensions(), null);
        ok &= this.checkAttributes(org, org.getAttributes(), copy.getAttributes(), filter);
        if (org instanceof VariableEnhanced && copy instanceof VariableEnhanced) {
            VariableEnhanced orge = (VariableEnhanced)((Object)org);
            VariableEnhanced copye = (VariableEnhanced)((Object)copy);
            ok &= this.checkAll(orge.getCoordinateSystems(), copye.getCoordinateSystems(), null);
        }
        if (compareData) {
            try {
                this.compareVariableData(org, copy, this.showCompare, justOne);
            }
            catch (IOException e) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                e.printStackTrace(new PrintStream(bos));
                this.f.format("%s", bos.toString());
            }
        }
        if (org instanceof Structure) {
            if (!(copy instanceof Structure)) {
                this.f.format("  ** %s not Structure%n", org);
                ok = false;
            } else {
                Structure orgS = (Structure)org;
                Structure ncmlS = (Structure)copy;
                ArrayList vars = new ArrayList();
                ok &= this.checkAll(orgS.getVariables(), ncmlS.getVariables(), vars);
                for (int i = 0; i < vars.size(); i += 2) {
                    Variable orgV = (Variable)vars.get(i);
                    Variable ncmlV = (Variable)vars.get(i + 1);
                    ok &= this.compareVariables(orgV, ncmlV, filter, false, true);
                }
            }
        }
        return ok;
    }

    private boolean checkContains(List container, List wantList) {
        boolean ok = true;
        for (Object want1 : wantList) {
            int index2 = container.indexOf(want1);
            if (index2 >= 0) continue;
            this.f.format("  ** %s %s missing %n", want1.getClass().getName(), want1);
            ok = false;
        }
        return ok;
    }

    private boolean checkAttributes(Variable v, List<Attribute> list1, List<Attribute> list2, ObjFilter filter) {
        boolean ok = true;
        for (Attribute att1 : list1) {
            if (filter != null && !filter.attOk(v, att1)) continue;
            ok &= this.checkEach(att1, "file1", list1, "file2", list2, null);
        }
        for (Attribute att2 : list2) {
            if (filter != null && !filter.attOk(v, att2)) continue;
            ok &= this.checkEach(att2, "file2", list2, "file1", list1, null);
        }
        return ok;
    }

    private boolean checkEnums(Group org, Group copy) {
        boolean ok = true;
        for (EnumTypedef enum1 : org.getEnumTypedefs()) {
            EnumTypedef enum2 = copy.findEnumeration(enum1.getName());
            if (enum2 == null) {
                this.f.format("  ** Enum %s not in file2 %n", enum1.getName());
                ok = false;
                continue;
            }
            if (enum1.equals(enum2)) continue;
            this.f.format("  ** Enum %s not equal%n  %s%n  %s%n", enum1.getName(), enum1, enum2);
            ok = false;
        }
        for (EnumTypedef enum2 : copy.getEnumTypedefs()) {
            EnumTypedef enum1 = org.findEnumeration(enum2.getName());
            if (enum1 != null) continue;
            this.f.format("  ** Enum %s not in file1 %n", enum2.getName());
            ok = false;
        }
        return ok;
    }

    private boolean checkAll(List list1, List list2, List result) {
        boolean ok = true;
        for (Object aList1 : list1) {
            ok &= this.checkEach(aList1, "file1", list1, "file2", list2, result);
        }
        for (Object aList2 : list2) {
            ok &= this.checkEach(aList2, "file2", list2, "file1", list1, result);
        }
        return ok;
    }

    private boolean checkEach(Object want1, String name1, List list1, String name2, List list2, List result) {
        boolean ok = true;
        try {
            int index2 = list2.indexOf(want1);
            if (index2 < 0) {
                this.f.format("  ** %s %s 0x%x (%s) not in %s %n", want1.getClass().getName(), want1, want1.hashCode(), name1, name2);
                ok = false;
            } else {
                Object want2 = list2.get(index2);
                int index1 = list1.indexOf(want2);
                if (index1 < 0) {
                    this.f.format("  ** %s %s 0x%x (%s) not in %s %n", want2.getClass().getName(), want2, want2.hashCode(), name2, name1);
                    ok = false;
                } else {
                    Object want = list1.get(index1);
                    if (!want.equals(want1)) {
                        this.f.format("  ** %s %s 0x%x (%s) not equal to %s 0x%x (%s) %n", want1.getClass().getName(), want1, want1.hashCode(), name1, want2, want2.hashCode(), name2);
                        ok = false;
                    } else {
                        if (this.showEach) {
                            this.f.format("  OK <%s> equals <%s>%n", want1, want2);
                        }
                        if (result != null) {
                            result.add(want1);
                            result.add(want2);
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.f.format(" *** Throwable= %s %n", t.getMessage());
        }
        return ok;
    }

    private void compareVariableData(Variable var1, Variable var2, boolean showCompare, boolean justOne) throws IOException {
        Array data1 = var1.read();
        Array data2 = var2.read();
        if (showCompare) {
            this.f.format(" compareArrays %s unlimited=%s size=%d%n", var1.getNameAndDimensions(), var1.isUnlimited(), data1.getSize());
        }
        this.compareData(var1.getFullName(), data1, data2, justOne);
        if (showCompare) {
            this.f.format("   ok%n", new Object[0]);
        }
    }

    public boolean compareData(String name, Array data1, Array data2, boolean justOne) {
        return this.compareData(name, data1, data2, 1.0E-5, justOne);
    }

    private boolean compareData(String name, Array data1, Array data2, double tol, boolean justOne) {
        boolean ok;
        block9: {
            IndexIterator iter2;
            IndexIterator iter1;
            DataType dt;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                ok = true;
                                if (data1.getSize() != data2.getSize()) {
                                    this.f.format(" DIFF %s: size %d !== %d%n", name, data1.getSize(), data2.getSize());
                                    ok = false;
                                }
                                if (data1.getElementType() != data2.getElementType()) {
                                    this.f.format(" DIFF %s: element type %s !== %s%n", name, data1.getElementType(), data2.getElementType());
                                    ok = false;
                                }
                                if (!ok) {
                                    return false;
                                }
                                dt = DataType.getType(data1.getElementType());
                                iter1 = data1.getIndexIterator();
                                iter2 = data2.getIndexIterator();
                                if (dt != DataType.DOUBLE) break block10;
                                while (iter1.hasNext() && iter2.hasNext()) {
                                    double v1 = iter1.getDoubleNext();
                                    double v2 = iter2.getDoubleNext();
                                    if (Double.isNaN(v1) && Double.isNaN(v2) || CompareNetcdf2.closeEnough(v1, v2, tol)) continue;
                                    this.f.format(" DIFF %s: %f != %f count=%s diff = %f pdiff = %f %n", name, v1, v2, iter1, CompareNetcdf2.diff(v1, v2), CompareNetcdf2.pdiff(v1, v2));
                                    ok = false;
                                    if (!justOne) continue;
                                    break block9;
                                }
                                break block9;
                            }
                            if (dt != DataType.FLOAT) break block11;
                            while (iter1.hasNext() && iter2.hasNext()) {
                                float v1 = iter1.getFloatNext();
                                float v2 = iter2.getFloatNext();
                                if (Float.isNaN(v1) && Float.isNaN(v2) || CompareNetcdf2.closeEnough(v1, v2, (float)tol)) continue;
                                this.f.format(" DIFF %s: %f != %f count=%s diff = %f pdiff = %f %n", name, Float.valueOf(v1), Float.valueOf(v2), iter1, CompareNetcdf2.diff(v1, v2), CompareNetcdf2.pdiff(v1, v2));
                                ok = false;
                                if (!justOne) continue;
                                break block9;
                            }
                            break block9;
                        }
                        if (dt != DataType.INT) break block12;
                        while (iter1.hasNext() && iter2.hasNext()) {
                            int v2;
                            int v1 = iter1.getIntNext();
                            if (v1 == (v2 = iter2.getIntNext())) continue;
                            this.f.format(" DIFF %s: %d != %d count=%s diff = %f pdiff = %f %n", name, v1, v2, iter1, CompareNetcdf2.diff(v1, v2), CompareNetcdf2.pdiff(v1, v2));
                            ok = false;
                            if (!justOne) continue;
                            break block9;
                        }
                        break block9;
                    }
                    if (dt != DataType.SHORT) break block13;
                    while (iter1.hasNext() && iter2.hasNext()) {
                        short v2;
                        short v1 = iter1.getShortNext();
                        if (v1 == (v2 = iter2.getShortNext())) continue;
                        this.f.format(" DIFF %s: %d != %d count=%s diff = %f pdiff = %f %n", name, v1, v2, iter1, CompareNetcdf2.diff(v1, v2), CompareNetcdf2.pdiff(v1, v2));
                        ok = false;
                        if (!justOne) continue;
                        break block9;
                    }
                    break block9;
                }
                if (dt != DataType.BYTE) break block14;
                while (iter1.hasNext() && iter2.hasNext()) {
                    byte v2;
                    byte v1 = iter1.getByteNext();
                    if (v1 == (v2 = iter2.getByteNext())) continue;
                    this.f.format(" DIFF %s: %d != %d count=%s diff = %f pdiff = %f %n", name, v1, v2, iter1, CompareNetcdf2.diff(v1, v2), CompareNetcdf2.pdiff(v1, v2));
                    ok = false;
                    if (!justOne) continue;
                    break block9;
                }
                break block9;
            }
            if (dt != DataType.STRUCTURE) break block9;
            while (iter1.hasNext() && iter2.hasNext()) {
                this.compareStructureData((StructureData)iter1.next(), (StructureData)iter2.next(), tol, justOne);
            }
        }
        return ok;
    }

    public boolean compareStructureData(StructureData sdata1, StructureData sdata2, double tol, boolean justOne) {
        boolean ok = true;
        StructureMembers sm1 = sdata1.getStructureMembers();
        StructureMembers sm2 = sdata2.getStructureMembers();
        if (sm1.getMembers().size() != sm2.getMembers().size()) {
            this.f.format(" size %d !== %d%n", sm1.getMembers().size(), sm2.getMembers().size());
            ok = false;
        }
        for (StructureMembers.Member m1 : sm1.getMembers()) {
            if (m1.getName().equals("time")) continue;
            StructureMembers.Member m2 = sm2.findMember(m1.getName());
            Array data1 = sdata1.getArray(m1);
            Array data2 = sdata2.getArray(m2);
            ok &= this.compareData(m1.getName(), data1, data2, tol, justOne);
        }
        return ok;
    }

    public static boolean closeEnoughP(double d1, double d2) {
        if (Math.abs(d1) < 1.0E-5) {
            return Math.abs(d1 - d2) < 1.0E-5;
        }
        return Math.abs((d1 - d2) / d1) < 1.0E-5;
    }

    public static boolean closeEnough(double d1, double d2) {
        return Math.abs(d1 - d2) < 1.0E-5;
    }

    public static boolean closeEnough(double d1, double d2, double tol) {
        return Math.abs(d1 - d2) < tol;
    }

    public static boolean closeEnoughP(double d1, double d2, double tol) {
        if (Math.abs(d1) < tol) {
            return Math.abs(d1 - d2) < tol;
        }
        return Math.abs((d1 - d2) / d1) < tol;
    }

    public static double diff(double d1, double d2) {
        return Math.abs(d1 - d2);
    }

    public static double pdiff(double d1, double d2) {
        return Math.abs((d1 - d2) / d1);
    }

    public static boolean closeEnough(float d1, float d2) {
        return Math.abs(d1 - d2) < 1.0E-5f;
    }

    public static boolean closeEnoughP(float d1, float d2) {
        if (Math.abs(d1) < 1.0E-5f) {
            return Math.abs(d1 - d2) < 1.0E-5f;
        }
        return Math.abs((d1 - d2) / d1) < 1.0E-5f;
    }

    public static void main(String[] arg) throws IOException {
        NetcdfFile ncfile1 = NetcdfDataset.openFile("dods://thredds.cise-nsf.gov:8080/thredds/dodsC/satellite/SFC-T/SUPER-NATIONAL_1km/20090516/SUPER-NATIONAL_1km_SFC-T_20090516_2200.gini", null);
        NetcdfFile ncfile2 = NetcdfDataset.openFile("dods://motherlode.ucar.edu:8080/thredds/dodsC/satellite/SFC-T/SUPER-NATIONAL_1km/20090516/SUPER-NATIONAL_1km_SFC-T_20090516_2200.gini", null);
        CompareNetcdf2.compareFiles(ncfile1, ncfile2, new Formatter(System.out), false, true, false);
    }

    public static interface ObjFilter {
        public boolean attOk(Variable var1, Attribute var2);
    }
}

