/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import junit.framework.TestCase;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import ucar.nc2.util.net.HTTPException;
import ucar.nc2.util.net.HTTPMethod;
import ucar.nc2.util.net.HTTPSession;

public class NoTestAuth2
extends TestCase {
    private static Data[] cases = new Data[]{new Data("http://motherlode.ucar.edu:8080/thredds/dodsC/restrict/testdata/testData.nc.html", new CredentialsProvider(){

        public Credentials getCredentials(AuthScheme sch, String h, int p, boolean pr) throws CredentialsNotAvailableException {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials("tiggeUser", "tigge");
            System.out.printf("getCredentials called: creds=|%s| host=%s port=%d isproxy=%b authscheme=%s%n", creds.toString(), h, p, pr, sch);
            return creds;
        }
    }), new Data("https://motherlode.ucar.edu:8443/dts/b31.dds", null)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAuth2() throws Exception {
        boolean pass = true;
        for (Data data : cases) {
            HTTPSession session = new HTTPSession(data.url);
            if (data.provider != null) {
                session.setCredentialsProvider(data.provider);
            }
            session.setUserAgent("tdmRunner");
            HTTPSession.setGlobalUserAgent((String)"TDM v4.3");
            HTTPMethod m = null;
            try {
                System.out.printf("url %s%n", data.url);
                m = HTTPMethod.Get((HTTPSession)session);
                int status = m.execute();
                String s = m.getResponseAsString();
                System.out.printf("Trigger response = %d == %s%n", status, s);
                if (status == 200 || status == 404) continue;
                pass = false;
            }
            catch (HTTPException e) {
                System.err.println("Fail: " + data.url);
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                e.printStackTrace(new PrintStream(bos));
                e.printStackTrace();
                pass = false;
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        if (pass) {
            NoTestAuth2.assertTrue((String)"testAuth2", (boolean)true);
        } else {
            NoTestAuth2.assertTrue((String)"testAuth2", (boolean)false);
        }
    }

    static class Data {
        String url;
        CredentialsProvider provider;

        public Data(String u, CredentialsProvider p) {
            this.url = u;
            this.provider = p;
        }
    }
}

