/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.util.Date;
import thredds.inventory.DateExtractor;
import thredds.inventory.MFile;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateFromString;

public class DateExtractorFromName
implements DateExtractor {
    private String dateFormatMark;
    private boolean useName;

    public DateExtractorFromName(String dateFormatMark, boolean useName) {
        this.dateFormatMark = dateFormatMark;
        this.useName = useName;
    }

    @Override
    public Date getDate(MFile mfile) {
        if (this.useName) {
            return DateFromString.getDateUsingDemarkatedCount(mfile.getName(), this.dateFormatMark, '#');
        }
        return DateFromString.getDateUsingDemarkatedMatch(mfile.getPath(), this.dateFormatMark, '#');
    }

    @Override
    public CalendarDate getCalendarDate(MFile mfile) {
        Date d = this.getDate(mfile);
        return d == null ? null : CalendarDate.of(d);
    }

    public String toString() {
        return "DateExtractorFromName{dateFormatMark='" + this.dateFormatMark + '\'' + ", useName=" + this.useName + '}';
    }

    public CalendarDate getDate(String name) {
        Date d = null;
        d = this.useName ? DateFromString.getDateUsingDemarkatedCount(name, this.dateFormatMark, '#') : DateFromString.getDateUsingDemarkatedMatch(name, this.dateFormatMark, '#');
        return d == null ? null : CalendarDate.of(d);
    }

    public static void doit(String name, String dateFormatMark) {
        DateExtractorFromName de = new DateExtractorFromName(dateFormatMark, false);
        CalendarDate d = de.getDate(name);
        System.out.printf("%s == %s%n", name, d);
    }

    public static void main(String[] args) {
        DateExtractorFromName.doit("/san4/work/jcaron/cfsrr/198507", "#cfsrr/#yyyyMM");
        DateExtractorFromName.doit("/data/ldm/pub/native/grid/NCEP/GFS/Alaska_191km/20111226/Run_1200.grib1", "#Alaska_191km/#yyyyMMdd'/Run_'HHmm");
    }
}

