/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.EarthLocation;

public class WriterCFPointCollection
extends CFPointWriter {
    private Variable time;
    private Variable lat;
    private Variable lon;
    private Variable alt;
    private Variable record;
    private int recno = 0;
    private ArrayDouble.D1 timeArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 latArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 lonArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 altArray = new ArrayDouble.D1(1);
    private int[] origin = new int[1];

    public WriterCFPointCollection(String fileOut, String title) throws IOException {
        this(fileOut, Arrays.asList(new Attribute("title", title)));
    }

    public WriterCFPointCollection(String fileOut, List<Attribute> atts) throws IOException {
        super(fileOut, atts);
        this.writer.addGroupAttribute(null, new Attribute("featureType", CF.FeatureType.point.name()));
    }

    public void writeHeader(List<VariableSimpleIF> vars, DateUnit timeUnit, String altUnits) throws IOException {
        this.altUnits = altUnits;
        this.createCoordinates(timeUnit);
        this.createDataVariables(vars);
        this.writer.create();
        this.record = this.writer.addRecordStructure();
    }

    private void createCoordinates(DateUnit timeUnit) throws IOException {
        this.writer.addUnlimitedDimension("obs");
        this.time = this.writer.addVariable(null, "time", DataType.DOUBLE, "obs");
        this.writer.addVariableAttribute(this.time, new Attribute("units", timeUnit.getUnitsString()));
        this.writer.addVariableAttribute(this.time, new Attribute("long_name", "time of measurement"));
        this.lat = this.writer.addVariable(null, "latitude", DataType.DOUBLE, "obs");
        this.writer.addVariableAttribute(this.lat, new Attribute("units", "degrees_north"));
        this.writer.addVariableAttribute(this.lat, new Attribute("long_name", "station latitude"));
        this.lon = this.writer.addVariable(null, "longitude", DataType.DOUBLE, "obs");
        this.writer.addVariableAttribute(this.lon, new Attribute("units", "degrees_east"));
        this.writer.addVariableAttribute(this.lon, new Attribute("long_name", "station longitude"));
        if (this.altUnits != null) {
            this.alt = this.writer.addVariable(null, "altitude", DataType.DOUBLE, "obs");
            this.writer.addVariableAttribute(this.alt, new Attribute("units", this.altUnits));
            this.writer.addVariableAttribute(this.alt, new Attribute("long_name", "altitude"));
        }
    }

    private void createDataVariables(List<VariableSimpleIF> dataVars) throws IOException {
        List<Dimension> dims;
        String coordNames = "time latitude longitude";
        if (this.altUnits != null) {
            coordNames = coordNames + " " + "altitude";
        }
        for (VariableSimpleIF var : dataVars) {
            dims = var.getDimensions();
            this.dimSet.addAll(dims);
        }
        for (Dimension d : this.dimSet) {
            if (d.isUnlimited()) continue;
            this.writer.addDimension(null, d.getName(), d.getLength(), d.isShared(), false, d.isVariableLength());
        }
        for (VariableSimpleIF oldVar : dataVars) {
            dims = oldVar.getDimensions();
            StringBuilder dimNames = new StringBuilder("obs");
            for (Dimension d : dims) {
                if (d.isUnlimited()) continue;
                dimNames.append(" ").append(d.getName());
            }
            Variable newVar = this.writer.addVariable(null, oldVar.getShortName(), oldVar.getDataType(), dimNames.toString());
            List<Attribute> atts = oldVar.getAttributes();
            for (Attribute att : atts) {
                newVar.addAttribute(att);
            }
            newVar.addAttribute(new Attribute("coordinates", coordNames));
        }
    }

    public void writeRecord(PointFeature sobs, StructureData sdata) throws IOException {
        this.writeRecord(sobs.getObservationTime(), sobs.getObservationTimeAsCalendarDate(), sobs.getLocation(), sdata);
    }

    public void writeRecord(double timeCoordValue, CalendarDate obsDate, EarthLocation loc, StructureData sdata) throws IOException {
        this.trackBB(loc, obsDate);
        ArrayStructureW sArray = new ArrayStructureW(sdata.getStructureMembers(), new int[]{1});
        sArray.setStructureData(sdata, 0);
        this.timeArray.set(0, timeCoordValue);
        this.latArray.set(0, loc.getLatitude());
        this.lonArray.set(0, loc.getLongitude());
        if (this.altUnits != null) {
            this.altArray.set(0, loc.getAltitude());
        }
        this.origin[0] = this.recno;
        try {
            this.writer.write(this.record, this.origin, sArray);
            this.writer.write(this.time, this.origin, this.timeArray);
            this.writer.write(this.lat, this.origin, this.latArray);
            this.writer.write(this.lon, this.origin, this.lonArray);
            if (this.altUnits != null) {
                this.writer.write(this.alt, this.origin, this.altArray);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        ++this.recno;
    }
}

