/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.log;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogStream
extends OutputStream {
    public static Logger log;
    static LogStream outlog;
    static LogStream errlog;
    static LogStream dbglog;
    public static LogPrintStream out;
    public static LogPrintStream err;
    public static LogPrintStream dbg;
    static Class currentlogclass;
    StringBuilder buffer = new StringBuilder();
    Mode mode = null;

    public static void setLogger(Class cl) {
        currentlogclass = cl;
        log = LoggerFactory.getLogger((Class)cl);
        if (outlog == null) {
            outlog = new LogStream(log).setMode(Mode.info);
        } else {
            outlog.setLogger(log);
        }
        if (errlog == null) {
            errlog = new LogStream(log).setMode(Mode.error);
        } else {
            errlog.setLogger(log);
        }
        if (dbglog == null) {
            dbglog = new LogStream(log).setMode(Mode.debug);
        } else {
            dbglog.setLogger(log);
        }
        if (out == null) {
            out = new LogPrintStream(outlog);
        }
        if (err == null) {
            err = new LogPrintStream(errlog);
        }
        if (dbg == null) {
            dbg = new LogPrintStream(dbglog);
        }
    }

    public static Logger getLog() {
        return log;
    }

    public LogStream() {
    }

    public LogStream(Logger logger) {
        this();
        this.setLogger(logger);
    }

    public Logger getLogger() {
        return log;
    }

    LogStream setLogger(Logger logger) {
        log = logger;
        return this;
    }

    public Mode getMode() {
        return this.mode;
    }

    public LogStream setMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public void logflush() {
        String line = this.buffer.toString();
        this.buffer.setLength(0);
        switch (this.mode) {
            case error: {
                log.error(line);
                break;
            }
            case info: {
                log.info(line);
                break;
            }
            case warn: {
                log.warn(line);
                break;
            }
            case debug: {
                log.debug(line);
                break;
            }
            case trace: {
                log.trace(line);
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.append((char)b);
    }

    static {
        LogStream.setLogger(LogStream.class);
    }

    public static class LogPrintStream
    extends PrintStream {
        LogStream logger = null;

        public LogPrintStream(OutputStream os) {
            super(os);
            this.logger = (LogStream)os;
        }

        public void logflush() {
            if (this.logger != null) {
                this.logger.logflush();
            }
        }
    }

    static enum Mode {
        error,
        info,
        warn,
        debug,
        trace;

    }
}

