/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import ucar.nc2.util.net.EscapeStrings;

public class URLnaming {
    @Deprecated
    public static String escapeQuery(String urlString) {
        urlString = urlString.trim();
        String[] split = urlString.split("[?]");
        return (split[0] == null ? "" : split[0]) + (split[1] == null ? "" : '?' + EscapeStrings.escapeURLQuery(split[1]));
    }

    @Deprecated
    private static String escapeQueryNew(String urlString) {
        urlString = urlString.trim();
        URI uri = null;
        try {
            uri = new URI(urlString);
            return uri.toASCIIString();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Deprecated
    private static String escapeQueryURIUtil(String urlString) {
        String query;
        int posQ = (urlString = urlString.trim()).indexOf("?");
        if (posQ > 0 && posQ < urlString.length() - 2 && (query = urlString.substring(posQ + 1)).indexOf("%") < 0) {
            String path = urlString.substring(0, posQ);
            try {
                urlString = path + "?" + URIUtil.encodeQuery((String)query);
            }
            catch (URIException e) {
                e.printStackTrace();
            }
        }
        return urlString;
    }

    @Deprecated
    private static String escapeQueryEncoder(String urlString) {
        String query;
        int posQ = (urlString = urlString.trim()).indexOf("?");
        if (posQ > 0 && posQ < urlString.length() - 2 && !(query = urlString.substring(posQ + 1)).contains("%")) {
            String path = urlString.substring(0, posQ);
            try {
                urlString = path + "?" + URLEncoder.encode(query, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return urlString;
    }

    @Deprecated
    private static String unescapeQueryDODS(String urlString) {
        int posQ = (urlString = urlString.trim()).indexOf("?");
        if (posQ >= 0 && posQ < urlString.length() - 2) {
            String path = urlString.substring(0, posQ);
            String query = urlString.substring(posQ + 1);
            return path + "?" + EscapeStrings.unescapeURLQuery(query);
        }
        return urlString;
    }

    @Deprecated
    private static String unescapeQueryDecoder(String urlString) {
        int posQ = (urlString = urlString.trim()).indexOf("?");
        if (posQ >= 0 && posQ < urlString.length() - 2) {
            String path = urlString.substring(0, posQ);
            String query = urlString.substring(posQ + 1);
            try {
                return path + "?" + URLDecoder.decode(query, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return urlString;
    }

    public static String canonicalizeWrite(String location) {
        try {
            URI refURI = URI.create(location);
            if (refURI.isAbsolute()) {
                return location;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "file:" + location;
    }

    public static String resolve(String baseUri, String relativeUri) {
        URI reletiveURI;
        if (baseUri == null || relativeUri == null) {
            return relativeUri;
        }
        if (relativeUri.startsWith("file:")) {
            return relativeUri;
        }
        if (baseUri.startsWith("file:")) {
            try {
                URI uriRelative = URI.create(relativeUri);
                if (uriRelative.isAbsolute()) {
                    return relativeUri;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (relativeUri.length() > 0 && relativeUri.charAt(0) == '#') {
                return baseUri + relativeUri;
            }
            if (relativeUri.length() > 0 && relativeUri.charAt(0) == '/') {
                return relativeUri;
            }
            int pos = baseUri.lastIndexOf(47);
            if (pos > 0) {
                return baseUri.substring(0, pos + 1) + relativeUri;
            }
        }
        if ((reletiveURI = URI.create(relativeUri)).isAbsolute()) {
            return relativeUri;
        }
        URI baseURI = URI.create(baseUri);
        URI resolvedURI = baseURI.resolve(reletiveURI);
        return resolvedURI.toASCIIString();
    }

    public static String canonicalizeRead(String location) {
        try {
            URI refURI = URI.create(location);
            if (refURI.isAbsolute()) {
                return location;
            }
        }
        catch (Exception e) {
            return "file:" + location;
        }
        return location;
    }

    public static String resolveFile(String baseDir, String filepath) {
        File base;
        if (baseDir == null) {
            return filepath;
        }
        if (filepath == null) {
            return filepath;
        }
        File file = new File(filepath);
        if (file.isAbsolute()) {
            return filepath;
        }
        if (baseDir.startsWith("file:")) {
            baseDir = baseDir.substring(5);
        }
        if (!(base = new File(baseDir)).isDirectory()) {
            base = base.getParentFile();
        }
        return base.getAbsolutePath() + "/" + filepath;
    }

    private static void test(String uriS) {
        System.out.println(uriS);
        URI uri = URI.create(uriS);
        System.out.println(" scheme=" + uri.getScheme());
        System.out.println(" getSchemeSpecificPart=" + uri.getSchemeSpecificPart());
        System.out.println(" getAuthority=" + uri.getAuthority());
        System.out.println(" getPath=" + uri.getPath());
        System.out.println(" getQuery=" + uri.getQuery());
        System.out.println();
    }

    public static void main1(String[] args) {
        URLnaming.testResolve("file:/test/me/", "blank in dir", "file:/test/me/blank in dir");
    }

    public static void main2(String[] args) {
        URLnaming.test("file:test/dir");
        URLnaming.test("file:/test/dir");
        URLnaming.test("file://test/dir");
        URLnaming.test("file:///test/dir");
        URLnaming.test("file:C:/Program Files (x86)/Apache Software Foundation/Tomcat 5.0/content/thredds/cache");
        URLnaming.test("file:C:\\Program Files (x86)\\Apache Software Foundation\\Tomcat 5.0\\content\\thredds\\cache");
        URLnaming.test("http://localhost:8080/thredds/catalog.html?hi=lo");
    }

    private static void testResolve(String base, String rel, String result) {
        System.out.println("\nbase= " + base);
        System.out.println("rel= " + rel);
        System.out.println("resolve= " + URLnaming.resolve(base, rel));
        if (result != null) assert (URLnaming.resolve(base, rel).equals(result));
    }

    public static void main3(String[] args) {
        URLnaming.testResolve("http://test/me/", "wanna", "http://test/me/wanna");
        URLnaming.testResolve("http://test/me/", "/wanna", "http://test/wanna");
        URLnaming.testResolve("file:/test/me/", "wanna", "file:/test/me/wanna");
        URLnaming.testResolve("file:/test/me/", "/wanna", "/wanna");
        URLnaming.testResolve("file://test/me/", "http:/wanna", "http:/wanna");
        URLnaming.testResolve("file://test/me/", "file:/wanna", "file:/wanna");
        URLnaming.testResolve("file://test/me/", "C:/wanna", "C:/wanna");
        URLnaming.testResolve("http://test/me/", "file:wanna", "file:wanna");
    }

    public static void main4(String[] args) {
        try {
            URL url = new URL("file:src/test/data/ncml/nc/");
            URI uri = new URI("file:src/test/data/ncml/nc/");
            File file = new File(uri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main5(String[] args) throws URISyntaxException {
        String uriString = "http://motherlode.ucar.edu:8081/dts/test.53.dods?types[0:1:9]";
        URI uri = new URI(uriString);
    }

    private static void checkEsc(String s) {
        System.out.printf("org =            %s%n", s);
        System.out.printf("escapeQuery    = %s%n", URLnaming.escapeQuery(s));
        System.out.printf("escapeQueryNew = %s%n", URLnaming.escapeQueryNew(s));
        System.out.printf("escQueryURIUtil= %s%n", URLnaming.escapeQueryURIUtil(s));
        System.out.printf("escQueryEncoder= %s%n", URLnaming.escapeQueryEncoder(s));
        System.out.printf("unescQueryDODS = %s%n", URLnaming.unescapeQueryDODS(URLnaming.escapeQuery(s)));
        System.out.printf("%n", new Object[0]);
    }

    private static void checkUnEsc(String esc) {
        System.out.printf("esc =             %s%n", esc);
        System.out.printf("unescQueryDODS  = %s%n", URLnaming.unescapeQueryDODS(esc));
        System.out.printf("unescapeDecoder = %s%n", URLnaming.unescapeQueryDecoder(esc));
        System.out.printf("escapeQuery     = %s%n", URLnaming.escapeQuery(URLnaming.unescapeQueryDODS(esc)));
        System.out.printf("%n", new Object[0]);
    }

    private static void decode(String esc) {
        System.out.printf("esc =               %s%n", esc);
        System.out.printf("URLDecoder.decode = %s%n", URLDecoder.decode(esc));
        System.out.printf("%n", new Object[0]);
    }

    public static void main(String[] args) throws URISyntaxException {
        if (args.length > 0) {
            URLnaming.checkUnEsc(args[0]);
        } else {
            String s = "catalog=http%3A%2F%2Flocalhost%3A8080%2Fthredds%2Fcatalog%2Fgrib%2FNCEP%2FGFS%2FGlobal_0p5deg%2Fcollection%2Fcatalog.html\n  dataset=grib%2FNCEP%2FGFS%2FGlobal_0p5deg%2FGFS-Global_0p5deg%2Fcollection";
            URLnaming.decode(s);
        }
    }
}

