/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.test.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class TestDir {
    public static String cdmUnitTestDir;
    public static String cdmLocalTestDataDir;
    public static String temporaryLocalDataDir;
    private static String testdataDirPropName;
    private static String threddsPropFileName;
    static int max_size;

    public static void showMem(String where) {
        Runtime runtime = Runtime.getRuntime();
        System.out.println(where + " memory free = " + (double)runtime.freeMemory() * 0.001 * 0.001 + " total= " + (double)runtime.totalMemory() * 0.001 * 0.001 + " max= " + (double)runtime.maxMemory() * 0.001 * 0.001 + " MB");
    }

    public static int actOnAll(String dirName, FileFilter ff, Act act) throws IOException {
        return TestDir.actOnAll(dirName, ff, act, true);
    }

    public static int actOnAll(String dirName, FileFilter ff, Act act, boolean recurse) throws IOException {
        int count = 0;
        System.out.println("---------------Reading directory " + dirName);
        File allDir = new File(dirName);
        File[] allFiles = allDir.listFiles();
        if (null == allFiles) {
            System.out.println("---------------INVALID " + dirName);
            return count;
        }
        List<File> flist = Arrays.asList(allFiles);
        Collections.sort(flist);
        for (File f : flist) {
            String name = f.getAbsolutePath();
            if (f.isDirectory() || ff != null && !ff.accept(f) || name.endsWith(".exclude")) continue;
            System.out.println("----acting on file " + name);
            count += act.doAct(name);
        }
        if (!recurse) {
            return count;
        }
        for (File f : allFiles) {
            if (!f.isDirectory() || f.getName().equals("exclude")) continue;
            count += TestDir.actOnAll(f.getAbsolutePath(), ff, act);
        }
        return count;
    }

    public static int readAllDir(String dirName, FileFilter ff) throws IOException {
        return TestDir.actOnAll(dirName, ff, new ReadAllVariables());
    }

    public static void readAll(String filename) throws IOException {
        ReadAllVariables act = new ReadAllVariables();
        act.doAct(filename);
    }

    static Section makeSubset(Variable v) throws InvalidRangeException {
        int[] shape = v.getShape();
        shape[0] = 1;
        Section s = new Section(shape);
        long size = s.computeSize();
        shape[0] = (int)Math.max(1L, (long)max_size / size);
        return new Section(shape);
    }

    public static int readAllData(NetcdfFile ncfile) {
        block4: {
            System.out.println("\n------Reading ncfile " + ncfile.getLocation());
            try {
                for (Variable v : ncfile.getVariables()) {
                    if (v.getSize() > (long)max_size) {
                        Section s = TestDir.makeSubset(v);
                        System.out.println("  Try to read variable " + v.getNameAndDimensions() + " size= " + v.getSize() + " section= " + s);
                        v.read(s);
                        continue;
                    }
                    System.out.println("  Try to read variable " + v.getNameAndDimensions() + " size= " + v.getSize());
                    v.read();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        return 1;
    }

    static {
        File tmpDataDir;
        File file;
        File userHomeDirFile;
        File userThreddsPropsFile;
        cdmUnitTestDir = null;
        cdmLocalTestDataDir = "../cdm/src/test/data/";
        temporaryLocalDataDir = "target/test/tmp/";
        testdataDirPropName = "unidata.testdata.path";
        threddsPropFileName = "thredds.properties";
        String testdataDirPath = System.getProperty(testdataDirPropName);
        if (testdataDirPath == null && (userThreddsPropsFile = new File(userHomeDirFile = new File(System.getProperty("user.home")), threddsPropFileName)).exists() && userThreddsPropsFile.canRead()) {
            Properties userThreddsProps = new Properties();
            try {
                userThreddsProps.load(new FileInputStream(userThreddsPropsFile));
            }
            catch (IOException e) {
                System.out.println("**Failed loading user THREDDS property file: " + e.getMessage());
            }
            if (userThreddsProps != null && !userThreddsProps.isEmpty() && testdataDirPath == null) {
                testdataDirPath = userThreddsProps.getProperty(testdataDirPropName);
            }
        }
        if (testdataDirPath == null) {
            System.out.println("**No \"unidata.testdata.path\"property, defaulting to \"/share/testdata/\".");
            testdataDirPath = "/share/testdata/";
        }
        if (!testdataDirPath.endsWith("/") && !testdataDirPath.endsWith("\\")) {
            testdataDirPath = testdataDirPath + "/";
        }
        if (!(file = new File(cdmUnitTestDir = testdataDirPath + "cdmUnitTest/")).exists() || !file.isDirectory()) {
            System.out.println("**WARN: Non-existence of Level 3 test data directory [" + file.getAbsolutePath() + "].");
        }
        if (!(tmpDataDir = new File(temporaryLocalDataDir)).exists() && !tmpDataDir.mkdirs()) {
            System.out.println("**ERROR: Could not create temporary data dir <" + tmpDataDir.getAbsolutePath() + ">.");
        }
        max_size = 10000000;
    }

    private static class ReadAllVariables
    implements Act {
        private ReadAllVariables() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int doAct(String filename) throws IOException {
            System.out.println("\n------Reading filename " + filename);
            NetcdfFile ncfile = null;
            try {
                ncfile = NetcdfFile.open((String)filename);
                for (Variable v : ncfile.getVariables()) {
                    if (v.getSize() > (long)max_size) {
                        Section s = TestDir.makeSubset(v);
                        System.out.println("  Try to read variable " + v.getNameAndDimensions() + " size= " + v.getSize() + " section= " + s);
                        v.read(s);
                        continue;
                    }
                    System.out.println("  Try to read variable " + v.getNameAndDimensions() + " size= " + v.getSize());
                    v.read();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (ncfile != null) {
                    try {
                        ncfile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return 1;
        }
    }

    public static class FileFilterNoWant
    implements FileFilter {
        String[] suffixes;

        public FileFilterNoWant(String suffixes) {
            this.suffixes = suffixes.split(" ");
        }

        @Override
        public boolean accept(File file) {
            for (String s : this.suffixes) {
                if (!file.getPath().endsWith(s)) continue;
                return false;
            }
            return true;
        }
    }

    public static class FileFilterFromSuffixes
    implements FileFilter {
        String[] suffixes;

        public FileFilterFromSuffixes(String suffixes) {
            this.suffixes = suffixes.split(" ");
        }

        @Override
        public boolean accept(File file) {
            for (String s : this.suffixes) {
                if (!file.getPath().endsWith(s)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface Act {
        public int doAct(String var1) throws IOException;
    }
}

