/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.FileWriter2;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.IOServiceProviderWriter;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.iosp.netcdf3.N3header;
import ucar.nc2.iosp.netcdf3.N3iosp;
import ucar.nc2.iosp.netcdf3.N3raf;
import ucar.nc2.jni.netcdf.Nc4Chunking;
import ucar.nc2.jni.netcdf.Nc4Iosp;
import ucar.unidata.io.RandomAccessFile;

public class NetcdfFileWriter {
    private static Logger log = LoggerFactory.getLogger(NetcdfFileWriter.class);
    private static Set<DataType> valid = EnumSet.of(DataType.BYTE, new DataType[]{DataType.CHAR, DataType.SHORT, DataType.INT, DataType.DOUBLE, DataType.FLOAT});
    private static final boolean debug = false;
    private static final boolean debugWrite = false;
    private final String location;
    private IOServiceProviderWriter spiw;
    private boolean defineMode;
    private NetcdfFile ncfile;
    private Version version;
    private boolean isNewFile;
    private boolean isLargeFile;
    private boolean fill;
    private int extraHeader;
    private long preallocateSize;

    public static NetcdfFileWriter openExisting(String location) throws IOException {
        return new NetcdfFileWriter(null, location, true);
    }

    public static NetcdfFileWriter createNew(Version version, String location) throws IOException {
        return new NetcdfFileWriter(version, null, null, location, false, null);
    }

    public static NetcdfFileWriter createNew(Version version, String location, Nc4Chunking chunker) throws IOException {
        return new NetcdfFileWriter(version, null, null, location, false, chunker);
    }

    private NetcdfFileWriter(Version version, String location, boolean isExisting) throws IOException {
        this(version, null, null, location, isExisting, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected NetcdfFileWriter(Version version, IOServiceProviderWriter iospw, RandomAccessFile raf, String location, boolean isExisting, Nc4Chunking chunker) throws IOException {
        if (version == null) {
            version = Version.netcdf3;
        }
        this.version = version;
        this.location = location;
        if (isExisting) {
            if (raf == null) {
                raf = new RandomAccessFile(location, "rw");
            }
            if (H5header.isValidFile(raf)) {
                if (!version.isNetdf4format()) {
                    throw new IllegalArgumentException(location + " must be netcdf-4 file");
                }
            } else {
                if (!N3header.isValidFile(raf)) throw new IllegalArgumentException(location + " must be netcdf-3 or netcdf-4 file");
                if (version.isNetdf4format()) {
                    throw new IllegalArgumentException(location + " must be netcdf-3 file");
                }
            }
        } else {
            this.isNewFile = true;
        }
        if (iospw == null) {
            if (version.useJniIosp()) {
                Nc4Iosp nc4iosp = new Nc4Iosp(version);
                nc4iosp.setChunker(chunker);
                this.spiw = nc4iosp;
            } else {
                this.spiw = new N3raf();
            }
        } else {
            this.spiw = iospw;
        }
        this.ncfile = new NetcdfFile(this.spiw, location);
        if (isExisting) {
            this.spiw.open(raf, this.ncfile, null);
        }
        this.defineMode = true;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
        this.spiw.setFill(fill);
    }

    public void setLength(long size) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        this.preallocateSize = size;
    }

    public void setLargeFile(boolean isLargeFile) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        this.isLargeFile = isLargeFile;
    }

    public void setExtraHeaderBytes(int extraHeaderBytes) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        this.extraHeader = extraHeaderBytes;
    }

    public boolean isDefineMode() {
        return this.defineMode;
    }

    NetcdfFile getNetcdfFile() {
        return this.ncfile;
    }

    Version getVersion() {
        return this.version;
    }

    public Variable findVariable(String fullNameEscaped) {
        return this.ncfile.findVariable(fullNameEscaped);
    }

    public Dimension addDimension(Group g, String dimName, int length) {
        return this.addDimension(g, dimName, length, true, false, false);
    }

    public Dimension addUnlimitedDimension(String dimName) {
        return this.addDimension(null, dimName, 0, true, true, false);
    }

    public Dimension addDimension(Group g, String dimName, int length, boolean isShared, boolean isUnlimited, boolean isVariableLength) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (!this.isValidObjectName(dimName)) {
            throw new IllegalArgumentException("illegal dimension name " + dimName);
        }
        Dimension dim = new Dimension(dimName, length, isShared, isUnlimited, isVariableLength);
        this.ncfile.addDimension(g, dim);
        return dim;
    }

    private String makeValidObjectName(String name) {
        if (!this.isValidObjectName(name)) {
            String nname = this.createValidObjectName(name);
            log.warn("illegal object name= " + name + " change to " + name);
            return nname;
        }
        return name;
    }

    private boolean isValidObjectName(String name) {
        return N3iosp.isValidNetcdfObjectName(name);
    }

    private boolean isValidDataType(DataType dt) {
        return this.version.isNetdf4format() || valid.contains((Object)dt);
    }

    private String createValidObjectName(String name) {
        return N3iosp.makeValidNetcdfObjectName(name);
    }

    public Dimension renameDimension(Group g, String oldName, String newName) {
        Dimension dim;
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (!this.isValidObjectName(newName)) {
            throw new IllegalArgumentException("illegal dimension name " + newName);
        }
        if (g == null) {
            g = this.ncfile.getRootGroup();
        }
        if (null != (dim = g.findDimension(oldName))) {
            dim.setName(newName);
        }
        return dim;
    }

    public Group addGroup(Group parent, String name) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (parent == null) {
            return this.ncfile.getRootGroup();
        }
        Group result = new Group(this.ncfile, parent, name);
        parent.addGroup(result);
        return result;
    }

    public Attribute addGroupAttribute(Group g, Attribute att) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (!this.isValidObjectName(att.getName())) {
            String attName = this.createValidObjectName(att.getName());
            log.warn("illegal attribute name= " + att.getName() + " change to " + attName);
            att = new Attribute(attName, att.getValues());
        }
        return this.ncfile.addAttribute(g, att);
    }

    public EnumTypedef addTypedef(Group g, EnumTypedef td) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        g.addEnumeration(td);
        return td;
    }

    public Attribute deleteGroupAttribute(Group g, String attName) {
        Attribute att;
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (g == null) {
            g = this.ncfile.getRootGroup();
        }
        if (null == (att = g.findAttribute(attName))) {
            return null;
        }
        g.remove(att);
        return att;
    }

    public Attribute renameGlobalAttribute(Group g, String oldName, String newName) {
        Attribute att;
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (!this.isValidObjectName(newName)) {
            String newnewName = this.createValidObjectName(newName);
            log.warn("illegal attribute name= " + newName + " change to " + newnewName);
            newName = newnewName;
        }
        if (g == null) {
            g = this.ncfile.getRootGroup();
        }
        if (null == (att = g.findAttribute(oldName))) {
            return null;
        }
        g.remove(att);
        att = new Attribute(newName, att.getValues());
        g.addAttribute(att);
        return att;
    }

    public Variable addVariable(Group g, String varName, DataType dataType, String dims) {
        ArrayList<Dimension> list = new ArrayList<Dimension>();
        StringTokenizer stoker = new StringTokenizer(dims);
        while (stoker.hasMoreTokens()) {
            String tok = stoker.nextToken();
            Dimension d = this.ncfile.rootGroup.findDimension(tok);
            if (null == d) {
                throw new IllegalArgumentException("Cant find dimension " + tok);
            }
            list.add(d);
        }
        return this.addVariable(g, varName, dataType, list);
    }

    public Variable addVariable(Group g, String shortName, DataType dataType, List<Dimension> dims) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        shortName = this.makeValidObjectName(shortName);
        if (!this.isValidDataType(dataType)) {
            throw new IllegalArgumentException("illegal dataType: " + (Object)((Object)dataType));
        }
        if (!this.version.isNetdf4format()) {
            for (int i = 0; i < dims.size(); ++i) {
                Dimension d = dims.get(i);
                if (!d.isUnlimited() || i == 0) continue;
                throw new IllegalArgumentException("Unlimited dimension " + d.getName() + " must be first (outermost) in netcdf-3 ");
            }
        }
        Variable v = new Variable(this.ncfile, g, null, shortName);
        v.setDataType(dataType);
        v.setDimensions(dims);
        long size = v.getSize() * (long)v.getElementSize();
        if (!this.version.isNetdf4format() && size > 0xFFFFFFFCL) {
            throw new IllegalArgumentException("Variable size in bytes " + size + " may not exceed " + 0xFFFFFFFCL);
        }
        this.ncfile.addVariable(g, v);
        return v;
    }

    public Variable addStringVariable(Group g, String varName, List<Dimension> dims, int max_strlen) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        varName = this.makeValidObjectName(varName);
        Variable v = new Variable(this.ncfile, g, null, varName);
        v.setDataType(DataType.CHAR);
        Dimension d = this.addDimension(g, varName + "_strlen", max_strlen);
        ArrayList<Dimension> sdims = new ArrayList<Dimension>(dims);
        sdims.add(d);
        v.setDimensions(sdims);
        this.ncfile.addVariable(g, v);
        return v;
    }

    public Variable renameVariable(String oldName, String newName) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Variable v = this.ncfile.findVariable(oldName);
        if (null != v) {
            v.setName(newName);
        }
        return v;
    }

    public void addVariableAttribute(Variable v, Attribute att) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        if (!this.isValidObjectName(att.getName())) {
            String attName = this.createValidObjectName(att.getName());
            log.warn("illegal netCDF-3 attribute name= " + att.getName() + " change to " + attName);
            att = new Attribute(attName, att.getValues());
        }
        v.addAttribute(att);
    }

    public Attribute deleteVariableAttribute(Variable v, String attName) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Attribute att = v.findAttribute(attName);
        if (null == att) {
            return null;
        }
        v.remove(att);
        return att;
    }

    public Attribute renameVariableAttribute(Variable v, String attName, String newName) {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        Attribute att = v.findAttribute(attName);
        if (null == att) {
            return null;
        }
        v.remove(att);
        att = new Attribute(newName, att.getValues());
        v.addAttribute(att);
        return att;
    }

    public void updateAttribute(Variable v2, Attribute att) throws IOException {
        if (this.defineMode) {
            throw new UnsupportedOperationException("in define mode");
        }
        this.spiw.updateAttribute(v2, att);
    }

    public void create() throws IOException {
        if (!this.defineMode) {
            throw new UnsupportedOperationException("not in define mode");
        }
        this.ncfile.finish();
        this.spiw.setFill(this.fill);
        this.spiw.create(this.location, this.ncfile, this.extraHeader, this.preallocateSize, this.isLargeFile);
        this.defineMode = false;
    }

    public boolean setRedefineMode(boolean redefineMode) throws IOException {
        if (redefineMode && !this.defineMode) {
            this.defineMode = true;
        } else if (!redefineMode && this.defineMode) {
            this.defineMode = false;
            this.ncfile.finish();
            boolean ok = this.spiw.rewriteHeader(this.isLargeFile);
            if (!ok) {
                this.rewrite();
            }
            return !ok;
        }
        return false;
    }

    private void rewrite() throws IOException {
        Boolean result;
        this.spiw.flush();
        this.spiw.close();
        File prevFile = new File(this.location);
        File tmpFile = new File(this.location + ".tmp");
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        if (!prevFile.renameTo(tmpFile)) {
            System.out.println(prevFile.getPath() + " prevFile.exists " + prevFile.exists() + " canRead = " + prevFile.canRead());
            System.out.println(tmpFile.getPath() + " tmpFile.exists " + tmpFile.exists() + " canWrite " + tmpFile.canWrite());
            throw new RuntimeException("Cant rename " + prevFile.getAbsolutePath() + " to " + tmpFile.getAbsolutePath());
        }
        NetcdfFile oldFile = NetcdfFile.open(tmpFile.getPath());
        Structure recordVar = null;
        if (oldFile.hasUnlimitedDimension()) {
            oldFile.sendIospMessage("AddRecordStructure");
            recordVar = (Structure)oldFile.findVariable("record");
        }
        this.spiw.create(this.location, this.ncfile, this.extraHeader, this.preallocateSize, this.isLargeFile);
        this.spiw.setFill(this.fill);
        if (recordVar != null && !(result = (Boolean)this.spiw.sendIospMessage("AddRecordStructure")).booleanValue()) {
            recordVar = null;
        }
        ArrayList<Variable> oldList = new ArrayList<Variable>(this.ncfile.getVariables().size());
        for (Variable v : this.ncfile.getVariables()) {
            Variable oldVar = oldFile.findVariable(v.getFullNameEscaped());
            if (oldVar == null) continue;
            oldList.add(oldVar);
        }
        FileWriter2 fileWriter2 = new FileWriter2(oldFile, this.location, this.version, null);
        fileWriter2.copyVarData(oldList, recordVar);
        this.flush();
        oldFile.close();
        if (!tmpFile.delete()) {
            throw new RuntimeException("Cant delete " + this.location);
        }
    }

    public Structure addRecordStructure() {
        if (this.version.isNetdf4format()) {
            return null;
        }
        boolean ok = (Boolean)this.ncfile.sendIospMessage("AddRecordStructure");
        if (!ok) {
            throw new IllegalStateException("can't add record variable");
        }
        return (Structure)this.ncfile.findVariable("record");
    }

    public void write(Variable v, Array values) throws IOException, InvalidRangeException {
        this.write(v, new int[values.getRank()], values);
    }

    public void write(Variable v, int[] origin, Array values) throws IOException, InvalidRangeException {
        if (this.defineMode) {
            throw new UnsupportedOperationException("in define mode");
        }
        this.spiw.writeData(v, new Section(origin, values.getShape()), values);
        v.invalidateCache();
    }

    public void writeStringData(Variable v, Array values) throws IOException, InvalidRangeException {
        this.writeStringData(v, new int[values.getRank()], values);
    }

    public void writeStringData(Variable v, int[] origin, Array values) throws IOException, InvalidRangeException {
        if (values.getElementType() != String.class) {
            throw new IllegalArgumentException("Must be ArrayObject of String ");
        }
        if (v.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("variable " + v.getFullName() + " is not type CHAR");
        }
        int rank = v.getRank();
        int strlen = v.getShape(rank - 1);
        ArrayChar cvalues = ArrayChar.makeFromStringArray((ArrayObject)values, strlen);
        int[] corigin = new int[rank];
        System.arraycopy(origin, 0, corigin, 0, rank - 1);
        this.write(v, corigin, cvalues);
    }

    public void flush() throws IOException {
        this.spiw.flush();
    }

    public synchronized void close() throws IOException {
        if (this.spiw != null) {
            this.flush();
            this.spiw.close();
            this.spiw = null;
        }
    }

    public static enum Version {
        netcdf3(".nc"),
        netcdf4(".nc4"),
        netcdf4_classic(".nc4"),
        netcdf3c(".nc"),
        netcdf3c64(".nc"),
        ncstream(".ncs");

        private String suffix;

        private Version(String suffix) {
            this.suffix = suffix;
        }

        public boolean isNetdf4format() {
            return this == netcdf4 || this == netcdf4_classic;
        }

        public boolean useJniIosp() {
            return this != netcdf3;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

