/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.StructurePseudo;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dt.StationImpl;
import ucar.nc2.dt.StationObsDatatype;
import ucar.nc2.dt.point.PointObsDatasetImpl;
import ucar.nc2.dt.point.PointObsDatatypeImpl;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public class RecordDatasetHelper {
    protected NetcdfDataset ncfile;
    protected String obsTimeVName;
    protected String nomTimeVName;
    protected String stnIdVName;
    protected String stnNameVName;
    protected String stnDescVName;
    protected String latVName;
    protected String lonVName;
    protected String altVName;
    protected DataType stationIdType;
    protected Map<Object, Station> stnHash;
    protected StructureDS recordVar;
    protected Dimension obsDim;
    protected LatLonRect boundingBox;
    protected double minDate;
    protected double maxDate;
    protected DateUnit timeUnit;
    protected double altScaleFactor = 1.0;
    protected StringBuffer errs = null;
    protected boolean showErrors = true;
    private boolean debugBB = false;

    public RecordDatasetHelper(NetcdfDataset ncfile, String obsTimeVName, String nomTimeVName, List typedDataVariables) {
        this(ncfile, obsTimeVName, nomTimeVName, typedDataVariables, null, null);
    }

    public RecordDatasetHelper(NetcdfDataset ncfile, String obsTimeVName, String nomTimeVName, List typedDataVariables, StringBuffer errBuffer) {
        this(ncfile, obsTimeVName, nomTimeVName, typedDataVariables, null, errBuffer);
    }

    public RecordDatasetHelper(NetcdfDataset ncfile, String obsTimeVName, String nomTimeVName, List typedDataVariables, String recDimName, StringBuffer errBuffer) {
        this.ncfile = ncfile;
        this.obsTimeVName = obsTimeVName;
        this.nomTimeVName = nomTimeVName;
        this.errs = errBuffer;
        if (this.ncfile.hasUnlimitedDimension()) {
            this.ncfile.sendIospMessage("AddRecordStructure");
            this.recordVar = (StructureDS)this.ncfile.getRootGroup().findVariable("record");
            this.obsDim = ncfile.getUnlimitedDimension();
        } else {
            if (recDimName == null) {
                throw new IllegalArgumentException("File <" + this.ncfile.getLocation() + "> has no unlimited dimension, specify psuedo record dimension with observationDimension global attribute.");
            }
            this.obsDim = this.ncfile.getRootGroup().findDimension(recDimName);
            this.recordVar = new StructureDS(null, (Structure)new StructurePseudo((NetcdfFile)this.ncfile, null, "record", this.obsDim));
        }
        List<Variable> recordMembers = ncfile.getVariables();
        for (Variable v : recordMembers) {
            if (v == this.recordVar || v.isScalar() || v.getDimension(0) != this.obsDim) continue;
            typedDataVariables.add(v);
        }
        Variable timeVar = ncfile.findVariable(obsTimeVName);
        String timeUnitString = ncfile.findAttValueIgnoreCase(timeVar, "units", "seconds since 1970-01-01");
        try {
            this.timeUnit = new DateUnit(timeUnitString);
        }
        catch (Exception e) {
            if (null != this.errs) {
                this.errs.append("Error on string = " + timeUnitString + " == " + e.getMessage() + "\n");
            }
            try {
                this.timeUnit = new DateUnit("seconds since 1970-01-01");
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    public void setStationInfo(String stnIdVName, String stnDescVName) {
        this.stnIdVName = stnIdVName;
        this.stnDescVName = stnDescVName;
        Variable stationVar = this.ncfile.findVariable(stnIdVName);
        this.stationIdType = stationVar.getDataType();
    }

    public void setLocationInfo(String latVName, String lonVName, String altVName) {
        block3: {
            Variable v;
            String units;
            this.latVName = latVName;
            this.lonVName = lonVName;
            this.altVName = altVName;
            if (altVName != null && (units = this.ncfile.findAttValueIgnoreCase(v = this.ncfile.findVariable(altVName), "units", null)) != null) {
                try {
                    this.altScaleFactor = PointObsDatasetImpl.getMetersConversionFactor(units);
                }
                catch (Exception e) {
                    if (this.errs == null) break block3;
                    this.errs.append(e.getMessage());
                }
            }
        }
    }

    public Structure getRecordVar() {
        return this.recordVar;
    }

    public int getRecordCount() {
        Dimension unlimitedDim = this.ncfile.getUnlimitedDimension();
        return unlimitedDim.getLength();
    }

    public void setTimeUnit(DateUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public DateUnit getTimeUnit() {
        return this.timeUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList readAllCreateObs(CancelTask cancel) throws IOException {
        boolean hasStations;
        boolean bl = hasStations = this.stnIdVName != null;
        if (hasStations) {
            this.stnHash = new HashMap<Object, Station>();
        }
        double minDate = Double.MAX_VALUE;
        double maxDate = -1.7976931348623157E308;
        double minLat = Double.MAX_VALUE;
        double maxLat = -1.7976931348623157E308;
        double minLon = Double.MAX_VALUE;
        double maxLon = -1.7976931348623157E308;
        ArrayList<RecordPointObs> records = new ArrayList<RecordPointObs>();
        int recno = 0;
        StructureDataIterator ii = this.recordVar.getStructureIterator();
        try {
            while (ii.hasNext()) {
                double nomTime;
                StructureData sdata = ii.next();
                StructureMembers members = sdata.getStructureMembers();
                Object stationId = null;
                if (hasStations) {
                    if (this.stationIdType == DataType.INT) {
                        int stationNum = sdata.getScalarInt(this.stnIdVName);
                        stationId = new Integer(stationNum);
                    } else {
                        stationId = sdata.getScalarString(this.stnIdVName).trim();
                    }
                }
                String desc = this.stnDescVName == null ? null : sdata.getScalarString(this.stnDescVName);
                double lat = sdata.convertScalarDouble(this.latVName);
                double lon = sdata.convertScalarDouble(this.lonVName);
                double alt = this.altVName == null ? Double.NaN : this.altScaleFactor * sdata.convertScalarDouble(this.altVName);
                double obsTime = sdata.convertScalarDouble(members.findMember(this.obsTimeVName));
                double d = nomTime = this.nomTimeVName == null ? obsTime : sdata.convertScalarDouble(members.findMember(this.nomTimeVName));
                if (hasStations) {
                    StationImpl stn = (StationImpl)this.stnHash.get(stationId);
                    if (stn == null) {
                        stn = new StationImpl(stationId.toString(), desc, lat, lon, alt);
                        this.stnHash.put(stationId, stn);
                    }
                    RecordStationObs stnObs = new RecordStationObs((Station)stn, obsTime, nomTime, recno);
                    records.add(stnObs);
                    stn.addObs(stnObs);
                } else {
                    records.add(new RecordPointObs(new EarthLocationImpl(lat, lon, alt), obsTime, nomTime, recno));
                }
                minDate = Math.min(minDate, obsTime);
                maxDate = Math.max(maxDate, obsTime);
                minLat = Math.min(minLat, lat);
                maxLat = Math.max(maxLat, lat);
                minLon = Math.min(minLon, lon);
                maxLon = Math.max(maxLon, lon);
                ++recno;
                if (cancel == null || !cancel.isCancel()) continue;
                ArrayList arrayList = null;
                return arrayList;
            }
        }
        finally {
            ii.finish();
        }
        this.boundingBox = new LatLonRect(new LatLonPointImpl(minLat, minLon), new LatLonPointImpl(maxLat, maxLon));
        return records;
    }

    public void setShortNames(String latVName, String lonVName, String altVName, String obsTimeVName, String nomTimeVName) {
        this.latVName = latVName;
        this.lonVName = lonVName;
        this.altVName = altVName;
        this.obsTimeVName = obsTimeVName;
        this.nomTimeVName = nomTimeVName;
    }

    public List getData(ArrayList records, LatLonRect boundingBox, CancelTask cancel) throws IOException {
        if (this.debugBB) {
            System.out.println("Want bb= " + boundingBox);
        }
        ArrayList<RecordPointObs> result = new ArrayList<RecordPointObs>();
        for (int i = 0; i < records.size(); ++i) {
            RecordPointObs r = (RecordPointObs)records.get(i);
            if (boundingBox.contains(r.getLatLon())) {
                if (this.debugBB) {
                    System.out.println(" ok latlon= " + r.getLatLon());
                }
                result.add(r);
            }
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return result;
    }

    public List getData(ArrayList records, LatLonRect boundingBox, double startTime, double endTime, CancelTask cancel) throws IOException {
        if (this.debugBB) {
            System.out.println("Want bb= " + boundingBox);
        }
        ArrayList<RecordPointObs> result = new ArrayList<RecordPointObs>();
        for (int i = 0; i < records.size(); ++i) {
            RecordPointObs r = (RecordPointObs)records.get(i);
            if (boundingBox.contains(r.getLatLon())) {
                double timeValue;
                if (this.debugBB) {
                    System.out.println(" ok latlon= " + r.getLatLon());
                }
                if ((timeValue = r.getObservationTime()) >= startTime && timeValue <= endTime) {
                    result.add(r);
                }
            }
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return result;
    }

    public class RecordStationObs
    extends RecordPointObs
    implements StationObsDatatype {
        private Station station;

        protected RecordStationObs(Station station, double obsTime, double nomTime, int recno) {
            super(station, obsTime, nomTime, recno);
            this.station = station;
        }

        protected RecordStationObs(int recno, StructureData sdata) {
            this.recno = recno;
            this.sdata = sdata;
            StructureMembers members = sdata.getStructureMembers();
            this.obsTime = sdata.convertScalarDouble(members.findMember(RecordDatasetHelper.this.obsTimeVName));
            this.nomTime = RecordDatasetHelper.this.nomTimeVName == null ? this.obsTime : sdata.convertScalarDouble(members.findMember(RecordDatasetHelper.this.nomTimeVName));
            Object stationId = RecordDatasetHelper.this.stationIdType == DataType.INT ? Integer.valueOf(sdata.getScalarInt(RecordDatasetHelper.this.stnIdVName)) : sdata.getScalarString(RecordDatasetHelper.this.stnIdVName).trim();
            this.station = RecordDatasetHelper.this.stnHash.get(stationId);
            this.location = this.station;
            if (this.station == null) {
                if (null != RecordDatasetHelper.this.errs) {
                    RecordDatasetHelper.this.errs.append(" cant find station = <").append(stationId).append(">when reading record ").append(recno).append("\n");
                }
                if (RecordDatasetHelper.this.showErrors) {
                    System.out.println(" cant find station = <" + stationId + ">" + "when reading record " + recno);
                }
            }
        }

        protected RecordStationObs(Station station, double obsTime, double nomTime, StructureData sdata) {
            this.station = station;
            this.location = station;
            this.obsTime = obsTime;
            this.nomTime = nomTime;
            this.sdata = sdata;
        }

        protected RecordStationObs(Station station, StructureData sdata) {
            this.station = station;
            this.location = station;
            this.sdata = sdata;
            StructureMembers members = sdata.getStructureMembers();
            this.obsTime = sdata.convertScalarDouble(members.findMember(RecordDatasetHelper.this.obsTimeVName));
            this.nomTime = RecordDatasetHelper.this.nomTimeVName == null ? this.obsTime : sdata.convertScalarDouble(members.findMember(RecordDatasetHelper.this.nomTimeVName));
        }

        @Override
        public Station getStation() {
            return this.station;
        }

        @Override
        public StructureData getData() throws IOException {
            if (null != this.sdata) {
                return this.sdata;
            }
            try {
                return RecordDatasetHelper.this.recordVar.readStructure(this.recno);
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
    }

    public class RecordPointObs
    extends PointObsDatatypeImpl {
        protected int recno;
        protected LatLonPointImpl llpt;
        protected StructureData sdata;

        protected RecordPointObs() {
            this.llpt = null;
        }

        protected RecordPointObs(EarthLocation location, double obsTime, double nomTime, int recno) {
            super(location, obsTime, nomTime);
            this.llpt = null;
            this.recno = recno;
        }

        public RecordPointObs(int recno, StructureData sdata) {
            this.llpt = null;
            this.recno = recno;
            this.sdata = sdata;
            StructureMembers members = sdata.getStructureMembers();
            this.obsTime = sdata.convertScalarDouble(members.findMember(RecordDatasetHelper.this.obsTimeVName));
            this.nomTime = RecordDatasetHelper.this.nomTimeVName == null ? this.obsTime : sdata.convertScalarDouble(members.findMember(RecordDatasetHelper.this.nomTimeVName));
            double lat = sdata.convertScalarDouble(RecordDatasetHelper.this.latVName);
            double lon = sdata.convertScalarDouble(RecordDatasetHelper.this.lonVName);
            double alt = RecordDatasetHelper.this.altVName == null ? Double.NaN : RecordDatasetHelper.this.altScaleFactor * sdata.convertScalarDouble(RecordDatasetHelper.this.altVName);
            this.location = new EarthLocationImpl(lat, lon, alt);
        }

        public LatLonPoint getLatLon() {
            if (this.llpt == null) {
                this.llpt = new LatLonPointImpl(this.location.getLatitude(), this.location.getLongitude());
            }
            return this.llpt;
        }

        @Override
        public Date getNominalTimeAsDate() {
            return RecordDatasetHelper.this.timeUnit.makeDate(this.getNominalTime());
        }

        @Override
        public Date getObservationTimeAsDate() {
            return RecordDatasetHelper.this.timeUnit.makeDate(this.getObservationTime());
        }

        @Override
        public StructureData getData() throws IOException {
            if (null != this.sdata) {
                return this.sdata;
            }
            try {
                return RecordDatasetHelper.this.recordVar.readStructure(this.recno);
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
    }
}

