/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection.proj4;

import java.awt.geom.Point2D;
import java.util.Formatter;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.proj4.MapMath;

public class StereographicAzimuthalProjection
extends ProjectionImpl {
    double projectionLatitude;
    double projectionLongitude;
    double n;
    double scaleFactor;
    double trueScaleLatitude;
    double falseEasting;
    double falseNorthing;
    private Earth earth;
    private double e;
    private double totalScale;
    private static final int NORTH_POLE = 1;
    private static final int SOUTH_POLE = 2;
    private static final int EQUATOR = 3;
    private static final int OBLIQUE = 4;
    private static final double TOL = 1.0E-8;
    private double akm1;
    private double sinphi0;
    private double cosphi0;
    private int mode;

    public StereographicAzimuthalProjection() {
        this(90.0, 0.0, 0.9330127018922193, 60.0, 0.0, 0.0, new Earth());
    }

    public StereographicAzimuthalProjection(double latt, double lont, double scale, double trueScaleLat, double false_easting, double false_northing, Earth earth) {
        super("StereographicAzimuthalProjection", false);
        this.projectionLatitude = Math.toRadians(latt);
        this.n = Math.sin(this.projectionLatitude);
        this.projectionLongitude = Math.toRadians(lont);
        this.trueScaleLatitude = Math.toRadians(trueScaleLat);
        this.scaleFactor = scale;
        this.falseEasting = false_easting;
        this.falseNorthing = false_northing;
        this.earth = earth;
        this.e = earth.getEccentricity();
        this.totalScale = earth.getMajor();
        this.initialize();
        this.addParameter("grid_mapping_name", "stereographic");
        this.addParameter("longitude_of_projection_origin", lont);
        this.addParameter("latitude_of_projection_origin", latt);
        this.addParameter("scale_factor_at_projection_origin", scale);
        if (false_easting != 0.0 || false_northing != 0.0) {
            this.addParameter("false_easting", false_easting);
            this.addParameter("false_northing", false_northing);
            this.addParameter("units", "km");
        }
        this.addParameter("semi_major_axis", earth.getMajor());
        this.addParameter("inverse_flattening", 1.0 / earth.getFlattening());
    }

    private void initialize() {
        double d;
        double t = Math.abs(this.projectionLatitude);
        this.mode = Math.abs(d - 1.5707963267948966) < 1.0E-10 ? (this.projectionLatitude < 0.0 ? 2 : 1) : (t > 1.0E-10 ? 4 : 3);
        this.trueScaleLatitude = Math.abs(this.trueScaleLatitude);
        if (this.earth.isSpherical()) {
            switch (this.mode) {
                case 4: {
                    this.sinphi0 = Math.sin(this.projectionLatitude);
                    this.cosphi0 = Math.cos(this.projectionLatitude);
                }
                case 3: {
                    this.akm1 = 2.0 * this.scaleFactor;
                    break;
                }
                case 1: 
                case 2: {
                    this.akm1 = Math.abs(this.trueScaleLatitude - 1.5707963267948966) >= 1.0E-10 ? Math.cos(this.trueScaleLatitude) / Math.tan(0.7853981633974483 - 0.5 * this.trueScaleLatitude) : 2.0 * this.scaleFactor;
                }
            }
        } else {
            switch (this.mode) {
                case 1: 
                case 2: {
                    if (Math.abs(this.trueScaleLatitude - 1.5707963267948966) < 1.0E-10) {
                        this.akm1 = 2.0 * this.scaleFactor / Math.sqrt(Math.pow(1.0 + this.e, 1.0 + this.e) * Math.pow(1.0 - this.e, 1.0 - this.e));
                        break;
                    }
                    t = Math.sin(this.trueScaleLatitude);
                    this.akm1 = Math.cos(this.trueScaleLatitude) / MapMath.tsfn(this.trueScaleLatitude, t, this.e);
                    this.akm1 /= Math.sqrt(1.0 - (t *= this.e) * t);
                    break;
                }
                case 3: {
                    this.akm1 = 2.0 * this.scaleFactor;
                    break;
                }
                case 4: {
                    t = Math.sin(this.projectionLatitude);
                    double X = 2.0 * Math.atan(this.ssfn(this.projectionLatitude, t, this.e)) - 1.5707963267948966;
                    this.akm1 = 2.0 * this.scaleFactor * Math.cos(this.projectionLatitude) / Math.sqrt(1.0 - (t *= this.e) * t);
                    this.sinphi0 = Math.sin(X);
                    this.cosphi0 = Math.cos(X);
                }
            }
        }
    }

    public Point2D.Double project(double lam, double phi, Point2D.Double xy) {
        double coslam = Math.cos(lam);
        double sinlam = Math.sin(lam);
        double sinphi = Math.sin(phi);
        if (this.earth.isSpherical()) {
            double cosphi = Math.cos(phi);
            switch (this.mode) {
                case 3: {
                    xy.y = 1.0 + cosphi * coslam;
                    if (xy.y <= 1.0E-10) {
                        throw new RuntimeException("I");
                    }
                    xy.y = this.akm1 / xy.y;
                    xy.x = xy.y * cosphi * sinlam;
                    xy.y *= sinphi;
                    break;
                }
                case 4: {
                    xy.y = 1.0 + this.sinphi0 * sinphi + this.cosphi0 * cosphi * coslam;
                    if (xy.y <= 1.0E-10) {
                        throw new RuntimeException("I");
                    }
                    xy.y = this.akm1 / xy.y;
                    xy.x = xy.y * cosphi * sinlam;
                    xy.y *= this.cosphi0 * sinphi - this.sinphi0 * cosphi * coslam;
                    break;
                }
                case 1: {
                    coslam = -coslam;
                    phi = -phi;
                }
                case 2: {
                    if (Math.abs(phi - 1.5707963267948966) < 1.0E-8) {
                        throw new RuntimeException("I");
                    }
                    xy.y = this.akm1 * Math.tan(0.7853981633974483 + 0.5 * phi);
                    xy.x = sinlam * xy.y;
                    xy.y *= coslam;
                }
            }
        } else {
            double sinX = 0.0;
            double cosX = 0.0;
            if (this.mode == 4 || this.mode == 3) {
                double X = 2.0 * Math.atan(this.ssfn(phi, sinphi, this.e)) - 1.5707963267948966;
                sinX = Math.sin(X);
                cosX = Math.cos(X);
            }
            switch (this.mode) {
                case 4: {
                    double A = this.akm1 / (this.cosphi0 * (1.0 + this.sinphi0 * sinX + this.cosphi0 * cosX * coslam));
                    xy.y = A * (this.cosphi0 * sinX - this.sinphi0 * cosX * coslam);
                    xy.x = A * cosX;
                    break;
                }
                case 3: {
                    double A = 2.0 * this.akm1 / (1.0 + cosX * coslam);
                    xy.y = A * sinX;
                    xy.x = A * cosX;
                    break;
                }
                case 2: {
                    phi = -phi;
                    coslam = -coslam;
                    sinphi = -sinphi;
                }
                case 1: {
                    xy.x = this.akm1 * MapMath.tsfn(phi, sinphi, this.e);
                    xy.y = -xy.x * coslam;
                }
            }
            xy.x *= sinlam;
        }
        return xy;
    }

    public Point2D.Double projectInverse(double x, double y, Point2D.Double lp) {
        if (this.earth.isSpherical()) {
            double rh = MapMath.distance(x, y);
            double c = 2.0 * Math.atan(rh / this.akm1);
            double sinc = Math.sin(c);
            double cosc = Math.cos(c);
            lp.x = 0.0;
            switch (this.mode) {
                case 3: {
                    lp.y = Math.abs(rh) <= 1.0E-10 ? 0.0 : Math.asin(y * sinc / rh);
                    if (cosc == 0.0 && x == 0.0) break;
                    lp.x = Math.atan2(x * sinc, cosc * rh);
                    break;
                }
                case 4: {
                    lp.y = Math.abs(rh) <= 1.0E-10 ? this.projectionLatitude : Math.asin(cosc * this.sinphi0 + y * sinc * this.cosphi0 / rh);
                    c = cosc - this.sinphi0 * Math.sin(lp.y);
                    if (c == 0.0 && x == 0.0) break;
                    lp.x = Math.atan2(x * sinc * this.cosphi0, c * rh);
                    break;
                }
                case 1: {
                    y = -y;
                }
                case 2: {
                    lp.y = Math.abs(rh) <= 1.0E-10 ? this.projectionLatitude : Math.asin(this.mode == 2 ? -cosc : cosc);
                    lp.x = x == 0.0 && y == 0.0 ? 0.0 : Math.atan2(x, y);
                }
            }
        } else {
            double halfe;
            double halfpi;
            double phi_l;
            double sinphi;
            double tp;
            double rho = MapMath.distance(x, y);
            switch (this.mode) {
                default: {
                    tp = 2.0 * Math.atan2(rho * this.cosphi0, this.akm1);
                    double cosphi = Math.cos(tp);
                    sinphi = Math.sin(tp);
                    phi_l = Math.asin(cosphi * this.sinphi0 + y * sinphi * this.cosphi0 / rho);
                    tp = Math.tan(0.5 * (1.5707963267948966 + phi_l));
                    x *= sinphi;
                    y = rho * this.cosphi0 * cosphi - y * this.sinphi0 * sinphi;
                    halfpi = 1.5707963267948966;
                    halfe = 0.5 * this.e;
                    break;
                }
                case 1: {
                    y = -y;
                }
                case 2: {
                    tp = -rho / this.akm1;
                    phi_l = 1.5707963267948966 - 2.0 * Math.atan(tp);
                    halfpi = -1.5707963267948966;
                    halfe = -0.5 * this.e;
                }
            }
            int i = 8;
            while (i-- != 0) {
                sinphi = this.e * Math.sin(phi_l);
                lp.y = 2.0 * Math.atan(tp * Math.pow((1.0 + sinphi) / (1.0 - sinphi), halfe)) - halfpi;
                if (Math.abs(phi_l - lp.y) < 1.0E-10) {
                    if (this.mode == 2) {
                        lp.y = -lp.y;
                    }
                    lp.x = x == 0.0 && y == 0.0 ? 0.0 : Math.atan2(x, y);
                    return lp;
                }
                phi_l = lp.y;
            }
            throw new RuntimeException("Iteration didn't converge");
        }
        return lp;
    }

    private double ssfn(double phit, double sinphi, double eccen) {
        return Math.tan(0.5 * (1.5707963267948966 + phit)) * Math.pow((1.0 - (sinphi *= eccen)) / (1.0 + sinphi), 0.5 * eccen);
    }

    @Override
    public String getProjectionTypeLabel() {
        return "Stereographic Azimuthal Ellipsoidal Earth";
    }

    @Override
    public ProjectionImpl constructCopy() {
        StereographicAzimuthalProjection result = new StereographicAzimuthalProjection(Math.toDegrees(this.projectionLatitude), Math.toDegrees(this.projectionLongitude), this.scaleFactor, Math.toDegrees(this.trueScaleLatitude), this.falseEasting, this.falseNorthing, this.earth);
        result.setDefaultMapArea(this.defaultMapArea);
        return result;
    }

    @Override
    public String paramsToString() {
        Formatter f = new Formatter();
        f.format("origin lat,lon=%f,%f scale,trueScaleLat=%f,%f earth=%s", Math.toDegrees(this.projectionLatitude), Math.toDegrees(this.projectionLongitude), this.scaleFactor, Math.toDegrees(this.trueScaleLatitude), this.earth);
        return f.toString();
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl destPoint) {
        double fromLat = Math.toRadians(latLon.getLatitude());
        double theta = this.computeTheta(latLon.getLongitude());
        Point2D.Double res = this.project(theta, fromLat, new Point2D.Double());
        destPoint.setLocation(this.totalScale * res.x + this.falseEasting, this.totalScale * res.y + this.falseNorthing);
        return destPoint;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double fromX = (world.getX() - this.falseEasting) / this.totalScale;
        double fromY = (world.getY() - this.falseNorthing) / this.totalScale;
        Point2D.Double dst = this.projectInverse(fromX, fromY, new Point2D.Double());
        if (dst.x < -Math.PI) {
            dst.x = -Math.PI;
        } else if (dst.x > Math.PI) {
            dst.x = Math.PI;
        }
        if (this.projectionLongitude != 0.0) {
            dst.x = MapMath.normalizeLongitude(dst.x + this.projectionLongitude);
        }
        result.setLongitude(Math.toDegrees(dst.x));
        result.setLatitude(Math.toDegrees(dst.y));
        return result;
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return false;
    }

    @Override
    public boolean equals(Object proj) {
        if (!(proj instanceof StereographicAzimuthalProjection)) {
            return false;
        }
        StereographicAzimuthalProjection oo = (StereographicAzimuthalProjection)proj;
        if (this.getDefaultMapArea() == null != (oo.defaultMapArea == null)) {
            return false;
        }
        if (this.getDefaultMapArea() != null && !this.defaultMapArea.equals(oo.defaultMapArea)) {
            return false;
        }
        return this.projectionLatitude == oo.projectionLatitude && this.projectionLongitude == oo.projectionLongitude && this.scaleFactor == oo.scaleFactor && this.trueScaleLatitude == oo.trueScaleLatitude && this.falseEasting == oo.falseEasting && this.falseNorthing == oo.falseNorthing && this.earth.equals(oo.earth);
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.projectionLatitude) ^ Double.doubleToLongBits(this.projectionLatitude) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.projectionLongitude) ^ Double.doubleToLongBits(this.projectionLongitude) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.scaleFactor) ^ Double.doubleToLongBits(this.scaleFactor) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.trueScaleLatitude) ^ Double.doubleToLongBits(this.trueScaleLatitude) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.falseEasting) ^ Double.doubleToLongBits(this.falseEasting) >>> 32);
        hash = 67 * hash + (int)(Double.doubleToLongBits(this.falseNorthing) ^ Double.doubleToLongBits(this.falseNorthing) >>> 32);
        hash = 67 * hash + (this.earth != null ? this.earth.hashCode() : 0);
        return hash;
    }

    private double computeTheta(double lon) {
        double dlon = LatLonPointImpl.lonNormal(lon - Math.toDegrees(this.projectionLongitude));
        return this.n * Math.toRadians(dlon);
    }

    private static void test(ProjectionImpl proj, double[] lat, double[] lon) {
        int i;
        double[] x = new double[lat.length];
        double[] y = new double[lat.length];
        for (i = 0; i < lat.length; ++i) {
            LatLonPointImpl lp = new LatLonPointImpl(lat[i], lon[i]);
            ProjectionPointImpl p = (ProjectionPointImpl)proj.latLonToProj(lp, new ProjectionPointImpl());
            System.out.println(lp.getLatitude() + ", " + lp.getLongitude() + ": " + p.x + ", " + p.y);
            x[i] = p.x;
            y[i] = p.y;
        }
        for (i = 0; i < lat.length; ++i) {
            ProjectionPointImpl p = new ProjectionPointImpl(x[i], y[i]);
            LatLonPointImpl lp = (LatLonPointImpl)proj.projToLatLon(p);
            if (!(!(Math.abs(lp.getLatitude() - lat[i]) > 1.0E-5) && !(Math.abs(lp.getLongitude() - lon[i]) > 1.0E-5) || Math.abs(lp.getLatitude()) > 89.99 && Math.abs(lp.getLatitude() - lat[i]) < 1.0E-5)) {
                System.err.print("ERROR:");
            }
            System.out.println("reverse:" + p.x + ", " + p.y + ": " + lp.getLatitude() + ", " + lp.getLongitude());
        }
    }

    public static void main(String[] args) {
        Earth e = new Earth(6378.137, 0.0, 298.257224);
        StereographicAzimuthalProjection proj = new StereographicAzimuthalProjection(90.0, 0.0, 0.93306907, 90.0, 0.0, 0.0, e);
        double[] lat = new double[]{60.0, 90.0, 60.0};
        double[] lon = new double[]{0.0, 0.0, 10.0};
        StereographicAzimuthalProjection.test(proj, lat, lon);
        proj = new StereographicAzimuthalProjection(90.0, -45.0, 0.96985819, 90.0, 0.0, 0.0, e);
        StereographicAzimuthalProjection.test(proj, lat, lon);
    }
}

